% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pifMatch.R
\name{pifMatch}
\alias{pifMatch}
\title{Pseudo-Invariant Features based Image Matching}
\usage{
pifMatch(img, ref, method = "cor", quantile = 0.95, returnPifMap = FALSE,
  returnSimMap = TRUE, returnModels = FALSE)
}
\arguments{
\item{img}{RasterStack or RasterBrick. Image to be adjusted.}

\item{ref}{RasterStack or RasterBruck. Reference image.}

\item{method}{Method to calculate pixel similariry. Options: euclidean distance ('ed'), spectral angle}

\item{quantile}{Numeric. Threshold quantile used to identify PIFs}

\item{returnPifMap}{Logical. Return a binary raster map ot pixels which were identified as pesudo-invariant features.}

\item{returnSimMap}{Logical. Return the similarity map as well}

\item{returnModels}{Logical. Return the linear models along with the adjusted image.}
}
\value{
Returns a RasterStack with the adjusted image (\code{img}) by default.

If further return arguments are specified the following intermediate products will be returned in a list along with the adujsted image:
\itemize{
   \item \code{returnModels = TRUE}: returns the linear models; one for each layer.
   \item \code{returnPifMap = TRUE}: returns binary map of pixels which were selected as pseudo-invariant features.
   \item \code{returnSimMap = TRUE}: returns the pixel-wise similarity.
}
}
\description{
Match one scene to another based on linear regression of pseudo-invariant features (PIF).
}
\details{
The function consists of three main steps:
First, it calculates pixel-wise similarity between the two rasters and identifies pseudo-invariant pixels based on
a similarity threshold.
In the second step the values of the pseudo-invariant pixels are regressed against each other in a linear model for each layer.
Finally the linear models are applied to all pixels in the \code{img}, thereby matching it to the reference scene.

Pixel-wise similarity can be calculated using one of three methods: euclidean distance (\code{method = "ed"}), spectral angle (\code{"sam"}) or pearsons correlation coefficient (\code{"cor"}).
The threshold is defined as a similarity quantile. Setting \code{quantile=0.95} will select all pixels with a similarity above the 95\% quantile as pseudo-invariant features.

Model fitting is performed with simple linear models (\code{\link[stats]{lm}}); fitting one model per layer.
}
\examples{
library(gridExtra)
## Import Landsat example data
data(lsat)

## Create fake example data
## In practice this would be an image from another acquisition date
lsat_b <- log(lsat)
## Run pifMatch
lsat_b_adjusted <- pifMatch(lsat_b, lsat)

## Run pifMatch and return similarity layer and pifMap
lsat_b_adjusted <- pifMatch(lsat_b, lsat, returnPifMap = TRUE, returnSimMap = TRUE)
\donttest{grid.arrange(
ggR(lsat_b_adjusted$simMap, geom_raster = TRUE) ,
ggR(lsat_b_adjusted$pifMap),
ncol=2)}
}

