% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rasterCVA.R
\name{rasterCVA}
\alias{rasterCVA}
\title{Change Vector Analysis}
\usage{
rasterCVA(x, y, ...)
}
\arguments{
\item{x}{RasterBrick or RasterStack with two layers. Both rasters (y and y) need to correspond to each other, i.e. same resolution, extent and origin.}

\item{y}{RasterBrick or RasterStack with two layers. Both rasters (y and y) need to correspond to each other, i.e. same resolution, extent and origin.}

\item{...}{further arguments passed to writeRaster}
}
\value{
Returns a RasterBrick with two layers: change vector angle and change vector magnitude
}
\description{
Calculateds angle and magnitude of change vectors. 
Dimensionality is limited to two bands per image.
}
\details{
Change Vector Analysis (CVA) is used to identify spectral changes between two identical scenes which were acquired at different times. 
CVA is limited to two bands per image. For each pixel it calculates the change in the two-dimensional spectral space. 
For example for a given pixel in image A and B for the red and nir band the change vector is caclulated for the coordinate pairs: (red_A | nir_A) and (red_B | nir_B).
}
\examples{
library(raster)
## Create example data
data(lsat)
pca <- rasterPCA(lsat)$map

## Do change vector analysis 
cva <- rasterCVA(pca[[1:2]], pca[[3:4]])
cva
plot(cva)
}

