% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_api_prj.R
\name{prj_load}
\alias{prj_load}
\title{Loads project into environment so all master scripts can run.}
\usage{
prj_load(path, prj = NULL)
}
\arguments{
\item{path}{if prj is NULL, path will be used to init new project to load.
If passed must be existing folder path. (type: character)}

\item{prj}{project to load or NULL to use path for new project
initialization. If not path passed project will be initialized from working
folder. (type: rsuite_project, default: NULL)}
}
\value{
previously loaded project or NULL if no project have been loaded.
}
\description{
It changes \code{.libPaths()} so project internal environment is visible
for R. Use \code{\link{prj_unload}} to restore your environment.
}
\examples{
# create exemplary project base folder
prj_base <- tempfile("example_")
dir.create(prj_base, recursive = TRUE, showWarnings = FALSE)

# start project
prj <- prj_start("my_project", skip_rc = TRUE, path = prj_base)

cat(.libPaths(), sep = "\\n") # show inital contents of .libPaths()

prj_load(prj = prj) # load project
cat(.libPaths(), sep = "\\n") # show contents of .libPaths()

prj_unload() # restore environment
cat(.libPaths(), sep = "\\n") # show final contents of .libPaths()

}
\seealso{
Other in project management: \code{\link{prj_build}},
  \code{\link{prj_clean_deps}}, \code{\link{prj_init}},
  \code{\link{prj_install_deps}},
  \code{\link{prj_lock_env}}, \code{\link{prj_pack}},
  \code{\link{prj_start_package}}, \code{\link{prj_start}},
  \code{\link{prj_unload}}, \code{\link{prj_zip}}
}
