% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/30_rc_adapter.R
\name{rc_adapter_is_under_control}
\alias{rc_adapter_is_under_control}
\title{Detects if dir is under adapter's managed version control.}
\usage{
rc_adapter_is_under_control(rc_adapter, dir)
}
\arguments{
\item{rc_adapter}{rc adapter object}

\item{dir}{path to the directory to check. The folder must exist (type: character)}
}
\value{
TRUE if dir is under version control.
}
\description{
Detects if dir is under adapter's managed version control.
}
\examples{
# create you own RC adapter
rc_adapter_create_own <- function() {
  result <- rc_adapter_create_base("Own")
  class(result) <- c("rc_adapter_own", class(result))
  return(result)
}

#' @export
rc_adapter_is_under_control.rc_adapter_own <- function(rc_adapter, dir) {
  # ... check ...
  return(TRUE)
}

}
\seealso{
Other in extending RSuite with RC adapter: \code{\link{rc_adapter_create_base}},
  \code{\link{rc_adapter_get_version}},
  \code{\link{rc_adapter_pkg_struct_add}},
  \code{\link{rc_adapter_prj_struct_add}},
  \code{\link{rc_adapter_remove_admins}}
}
\concept{in extending RSuite with RC adapter}
