% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/27_repo_manager.R
\name{repo_manager_remove}
\alias{repo_manager_remove}
\title{Removes specified packages from the repository.}
\usage{
repo_manager_remove(repo_manager, toremove, type)
}
\arguments{
\item{repo_manager}{repo manager object.}

\item{toremove}{data.frame with at lease Package(type:character) and
Version(type: character) columns. (type: data.frame)}

\item{type}{package type to remove}
}
\value{
data.frame containing packages removed with Package and Version columns.
}
\description{
Removes specified packages from the repository.
}
\examples{
# create your own repo adapter
repo_adapter_create_own <- function() {
  result <- repo_adapter_create_base("Own")
  class(result) <- c("repo_adapter_own", class(result))
  return(result)
}

#' create own repo manager
#' @export
repo_adapter_create_manager.repo_adapter_own <- function(repo_adapter, ...) {
  repo_manager <- list() # create you own repo manager
  class(repo_manager) <- c("repo_manager_own", "rsuite_repo_manager")
  return(repo_manager)
}

#' @export
repo_manager_remove.repo_manager_own <- function(repo_manager, toremove, type) {
  # ... remove packages from the repository ...
  # ... update PACKAGES ...
  return(data.frame(Package = c(),   # return packages removed
                    Version = c(),
                    stringsAsFactors = FALSE))
}

}
\seealso{
Other in extending RSuite with Repo adapter: \code{\link{repo_adapter_create_base}},
  \code{\link{repo_adapter_create_manager}},
  \code{\link{repo_adapter_get_info}},
  \code{\link{repo_adapter_get_path}},
  \code{\link{repo_manager_destroy}},
  \code{\link{repo_manager_get_info}},
  \code{\link{repo_manager_init}},
  \code{\link{repo_manager_upload}}
}
\concept{in extending RSuite with Repo adapter}
