% Generated by roxygen2 (4.0.2): do not edit by hand
\name{disc.prior}
\alias{disc.prior}
\title{Discounted prior probability of freedom}
\usage{
disc.prior(prior, p.intro)
}
\arguments{
\item{prior}{prior probability of freedom before surveillance}

\item{p.intro}{probability of introduction
(or of prevalence exceeding the design prevalence) during the time period
(scalar or vector equal length to prior)}
}
\value{
vector of discounted prior probabilities of freedom
}
\description{
Calculates the discounted prior probability of disease freedom,
  after adjusting for the probability of disease exceeding the
  design prevalence during the time period of the surveillance data being analysed
}
\examples{
# examples for disc.prior
disc.prior(0.5, 0.01)
disc.prior(0.95, c(0.001, 0.005, 0.01, 0.02, 0.05))
disc.prior(c(0.5, 0.6, 0.7, 0.8, 0.9, 0.95), 0.01)
}
\keyword{methods}

