% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hooks_rtl.R
\name{hooks_rtl}
\alias{hooks_rtl}
\title{Customize knitr Hooks for Right-to-Left (RTL) Text Formatting}
\usage{
hooks_rtl(fontcolor = "black", backcolor = "gray")
}
\arguments{
\item{fontcolor}{Font color for inline output. Default is "black".}

\item{backcolor}{Background color for inline output. Default is "gray".}
}
\value{
The function returns a list of customized \code{knit_hooks} that handle RTL text formatting.
It modifies the output, messages, warnings, errors, inline expressions, and source code
to include appropriate commands for RTL languages.
}
\description{
This function defines customized \code{knitr} hooks to handle RTL (right-to-left)
text formatting for languages like Persian and Arabic for \code{Sweave}. It allows you to modify
the appearance of output, messages, warnings, and errors when producing RTL documents.
}
\examples{
# Define custom RTL hooks
rtl_hooks <- hooks_rtl()

# Apply custom RTL hooks to `knit_hooks`
knitr::knit_hooks$set(rtl_hooks)

# After setting the hooks, knit your document as usual to produce RTL formatting.

}
\references{
Xie, Y. (2014). Dynamic Documents with R and knitr. Chapman & Hall/CRC. ISBN: 978-1482203530.
}
\seealso{
Use \code{\link{markdown_rtl}} to enable RTL formatting for Markdown documents.
}
