% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.xmlRead.R
\name{xmlReadData_image}
\alias{xmlReadData_image}
\title{Read XML Data From Type 'xmlReadData_image' as R Variable}
\usage{
xmlReadData_image(xmlItem)
}
\arguments{
\item{xmlItem}{(\code{XMLNode}) Object of class \code{XMLNode} that defines the
a simple variable and fullfills XSD definition 'xmlReadData_variable'.}
}
\value{
(\code{vector})
}
\description{
Read XML Data From Type 'xmlReadData_image' as R Variable
}
\examples{
location <- find.package("RTest")
data <- paste0(
     '<variable name="myvar" value="',location,
          '/images/Roche_Logo.png" type="character" image="TRUE"/>'
     )
item <- XML::xmlRoot(XML::xmlParse(data,asText=TRUE))
value <- RTest::xmlReadData_image(item)
stopifnot(grepl("png",value$address))

}
\seealso{
\code{\link[XML]{XMLNode-class}}
}
\author{
Matthias Pfeifer \email{matthias.pfeifer@roche.com}
}
