% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RTestCollection.R
\docType{methods}
\name{show}
\alias{show}
\alias{show,RTestCollection-method}
\title{Show Summary of RTestCollection Instance}
\usage{
\S4method{show}{RTestCollection}(object)
}
\arguments{
\item{object}{(\code{object}) The \code{\link{RTestCollection-class}} object.}
}
\description{
Show Summary of RTestCollection Instance
}
\examples{
location <- find.package("RTest")

testCollection <- new("RTestCollection",
   project.name    = "RTest Vignette",
   project.details = "Example test exectuion",
   tester          = "Example tester",
   test.start      = format(Sys.time(), "\%Y-\%m-\%d \%H:\%M:\%S"))

show(testCollection)

testCollection <- importTCsFromDir(testCollection,
   xml.dPath = paste0(location,"/xml-templates")
)

# Now one test case shall be imported
show(testCollection)

}
\seealso{
\code{\link{RTestCollection-class}}
}
\author{
Matthias Pfeifer \email{matthias.pfeifer@roche.com}
}
