% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.pedigree.R
\name{read.pedigree}
\alias{read.pedigree}
\title{Read pedigree structure from a Plink file}
\usage{
read.pedigree(type, filename)
}
\arguments{
\item{type}{character, \code{'ped'}, \code{'bed'}: format of the
input file (see the \code{filename} parameter) containing the
pedigree data (and usually the genomic data as well).}

\item{filename}{character, path to the input file containing the
pedigree data.}
}
\value{
a data frame containing the columns with pedigree data
taken from the input file (i.e. family ID, individual ID, father
ID, mother ID)
}
\description{
Extract the pedigree data from a Plink file (in \code{.ped} or
\code{.bed} format). For example, in the case of a \code{.ped}
file this simply extracts the first four columns from the file.
}
\author{
Lennart C. Karssen
}
\keyword{internal}

