/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import weka.core.Matrix;
import weka.core.Utils;

public abstract class Optimization {
    protected double m_ALF = 1.0E-4;
    protected double m_BETA = 0.9;
    protected double m_TOLX = 1.0E-6;
    protected double m_STPMX = 100.0;
    protected int m_MAXITS = 200;
    protected static boolean m_Debug = false;
    protected double m_f;
    private double m_Slope;
    private boolean m_IsZeroStep = false;
    private double[] m_X;
    protected static double m_Epsilon = 1.0;
    protected static double m_Zero;

    protected abstract double objectiveFunction(double[] var1) throws Exception;

    protected abstract double[] evaluateGradient(double[] var1) throws Exception;

    protected double[] evaluateHessian(double[] dArray, int n) throws Exception {
        return null;
    }

    public double getMinFunction() {
        return this.m_f;
    }

    public void setMaxIteration(int n) {
        this.m_MAXITS = n;
    }

    public void setDebug(boolean bl) {
        m_Debug = bl;
    }

    public double[] getVarbValues() {
        return this.m_X;
    }

    public double[] lnsrch(double[] dArray, double[] dArray2, double[] dArray3, double d, boolean[] blArray, double[][] dArray4, DynamicIntArray dynamicIntArray) throws Exception {
        double d2;
        double[] dArray5;
        double d3;
        int n;
        int n2 = dArray.length;
        int n3 = -1;
        double d4 = Double.POSITIVE_INFINITY;
        double d5 = this.m_f;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 1.0;
        double[] dArray6 = new double[n2];
        double d9 = 0.0;
        for (n = 0; n < n2; ++n) {
            if (blArray[n]) continue;
            d9 += dArray3[n] * dArray3[n];
        }
        d9 = Math.sqrt(d9);
        if (m_Debug) {
            System.err.println("fold:  " + Utils.doubleToString(d5, 10, 7) + "\n" + "sum:  " + Utils.doubleToString(d9, 10, 7) + "\n" + "stpmax:  " + Utils.doubleToString(d, 10, 7));
        }
        if (d9 > d) {
            for (n = 0; n < n2; ++n) {
                if (blArray[n]) continue;
                int n4 = n;
                dArray3[n4] = dArray3[n4] * (d / d9);
            }
        } else {
            d8 = d / d9;
        }
        this.m_Slope = 0.0;
        for (n = 0; n < n2; ++n) {
            dArray6[n] = dArray[n];
            if (blArray[n]) continue;
            this.m_Slope += dArray2[n] * dArray3[n];
        }
        if (m_Debug) {
            System.err.print("slope:  " + Utils.doubleToString(this.m_Slope, 10, 7) + "\n");
        }
        if (Math.abs(this.m_Slope) <= m_Zero) {
            if (m_Debug) {
                System.err.println("Gradient and direction orthogonal -- Min. found with current fixed variables (or all variables fixed). Try to release some variables now.");
            }
            return dArray6;
        }
        if (this.m_Slope > m_Zero) {
            if (m_Debug) {
                for (int i = 0; i < dArray6.length; ++i) {
                    System.err.println(i + ": isFixed=" + blArray[i] + ", x=" + dArray6[i] + ", grad=" + dArray2[i] + ", direct=" + dArray3[i]);
                }
            }
            throw new Exception("g'*p positive! -- Try to debug from here: line 327.");
        }
        double d10 = 0.0;
        for (n = 0; n < n2; ++n) {
            double d11;
            if (blArray[n] || !((d11 = Math.abs(dArray3[n]) / Math.max(Math.abs(dArray6[n]), 1.0)) > d10)) continue;
            d10 = d11;
        }
        if (!(d10 > m_Zero)) {
            if (m_Debug) {
                System.err.println("Zero directions for all free variables -- Min. found with current fixed variables (or all variables fixed). Try to release some variables now.");
            }
            return dArray6;
        }
        double d12 = this.m_TOLX / d10;
        for (n = 0; n < n2; ++n) {
            if (blArray[n]) continue;
            if (dArray3[n] < -m_Epsilon && !Double.isNaN(dArray4[0][n])) {
                d3 = (dArray4[0][n] - dArray[n]) / dArray3[n];
                if (d3 <= m_Zero) {
                    if (m_Debug) {
                        System.err.println("Fix variable " + n + " to lower bound " + dArray4[0][n] + " from value " + dArray[n]);
                    }
                    dArray6[n] = dArray4[0][n];
                    blArray[n] = true;
                    d4 = 0.0;
                    dArray4[0][n] = Double.NaN;
                    dynamicIntArray.addElement(n);
                    continue;
                }
                if (!(d4 > d3)) continue;
                d4 = d3;
                n3 = n;
                continue;
            }
            if (!(dArray3[n] > m_Epsilon) || Double.isNaN(dArray4[1][n])) continue;
            d3 = (dArray4[1][n] - dArray[n]) / dArray3[n];
            if (d3 <= m_Zero) {
                if (m_Debug) {
                    System.err.println("Fix variable " + n + " to upper bound " + dArray4[1][n] + " from value " + dArray[n]);
                }
                dArray6[n] = dArray4[1][n];
                blArray[n] = true;
                d4 = 0.0;
                dArray4[1][n] = Double.NaN;
                dynamicIntArray.addElement(n);
                continue;
            }
            if (!(d4 > d3)) continue;
            d4 = d3;
            n3 = n;
        }
        if (m_Debug) {
            System.err.println("alamin: " + Utils.doubleToString(d12, 10, 7));
            System.err.println("alpha: " + Utils.doubleToString(d4, 10, 7));
        }
        if (d4 <= m_Zero) {
            this.m_IsZeroStep = true;
            if (m_Debug) {
                System.err.println("Alpha too small, try again");
            }
            return dArray6;
        }
        double d13 = d4;
        if (d13 > 1.0) {
            d13 = 1.0;
        }
        d3 = d5;
        double d14 = d13;
        double d15 = d13;
        double d16 = 0.0;
        double d17 = this.m_f;
        double d18 = this.m_f;
        int n5 = 0;
        while (true) {
            double d19;
            if (m_Debug) {
                System.err.println("\nLine search iteration: " + n5);
            }
            for (n = 0; n < n2; ++n) {
                if (blArray[n]) continue;
                dArray6[n] = dArray[n] + d13 * dArray3[n];
                if (!Double.isNaN(dArray4[0][n]) && dArray6[n] < dArray4[0][n]) {
                    dArray6[n] = dArray4[0][n];
                    continue;
                }
                if (Double.isNaN(dArray4[1][n]) || !(dArray6[n] > dArray4[1][n])) continue;
                dArray6[n] = dArray4[1][n];
            }
            this.m_f = this.objectiveFunction(dArray6);
            if (Double.isNaN(this.m_f)) {
                throw new Exception("Objective function value is NaN!");
            }
            while (Double.isInfinite(this.m_f)) {
                if (m_Debug) {
                    System.err.println("Too large m_f.  Shrink step by half.");
                }
                if ((d13 *= 0.5) <= m_Epsilon) {
                    if (m_Debug) {
                        System.err.println("Wrong starting points, change them!");
                    }
                    return dArray6;
                }
                for (n = 0; n < n2; ++n) {
                    if (blArray[n]) continue;
                    dArray6[n] = dArray[n] + d13 * dArray3[n];
                }
                this.m_f = this.objectiveFunction(dArray6);
                if (Double.isNaN(this.m_f)) {
                    throw new Exception("Objective function value is NaN!");
                }
                d3 = Double.POSITIVE_INFINITY;
            }
            if (m_Debug) {
                System.err.println("obj. function: " + Utils.doubleToString(this.m_f, 10, 7));
                System.err.println("threshold: " + Utils.doubleToString(d5 + this.m_ALF * d13 * this.m_Slope, 10, 7));
            }
            if (this.m_f <= d5 + this.m_ALF * d13 * this.m_Slope) {
                if (m_Debug) {
                    System.err.println("Sufficient function decrease (alpha condition): ");
                }
                dArray5 = this.evaluateGradient(dArray6);
                d16 = 0.0;
                for (n = 0; n < n2; ++n) {
                    if (blArray[n]) continue;
                    d16 += dArray5[n] * dArray3[n];
                }
                if (d16 >= this.m_BETA * this.m_Slope) {
                    if (m_Debug) {
                        System.err.println("Increasing derivatives (beta condition): ");
                    }
                    if (n3 != -1 && d13 >= d4) {
                        if (dArray3[n3] > 0.0) {
                            dArray6[n3] = dArray4[1][n3];
                            dArray4[1][n3] = Double.NaN;
                        } else {
                            dArray6[n3] = dArray4[0][n3];
                            dArray4[0][n3] = Double.NaN;
                        }
                        if (m_Debug) {
                            System.err.println("Fix variable " + n3 + " to bound " + dArray6[n3] + " from value " + dArray[n3]);
                        }
                        blArray[n3] = true;
                        dynamicIntArray.addElement(n3);
                    }
                    return dArray6;
                }
                if (n5 == 0) {
                    d2 = Math.min(d4, d8);
                    if (m_Debug) {
                        System.err.println("Alpha condition holds, increase alpha... ");
                    }
                    while (!(d13 >= d2) && !(this.m_f > d5 + this.m_ALF * d13 * this.m_Slope)) {
                        d15 = d13;
                        d18 = this.m_f;
                        if ((d13 *= 2.0) >= d2) {
                            d13 = d2;
                        }
                        for (n = 0; n < n2; ++n) {
                            if (blArray[n]) continue;
                            dArray6[n] = dArray[n] + d13 * dArray3[n];
                        }
                        this.m_f = this.objectiveFunction(dArray6);
                        if (Double.isNaN(this.m_f)) {
                            throw new Exception("Objective function value is NaN!");
                        }
                        dArray5 = this.evaluateGradient(dArray6);
                        d16 = 0.0;
                        for (n = 0; n < n2; ++n) {
                            if (blArray[n]) continue;
                            d16 += dArray5[n] * dArray3[n];
                        }
                        if (!(d16 >= this.m_BETA * this.m_Slope)) continue;
                        if (m_Debug) {
                            System.err.println("Increasing derivatives (beta condition): \nnewSlope = " + Utils.doubleToString(d16, 10, 7));
                        }
                        if (n3 != -1 && d13 >= d4) {
                            if (dArray3[n3] > 0.0) {
                                dArray6[n3] = dArray4[1][n3];
                                dArray4[1][n3] = Double.NaN;
                            } else {
                                dArray6[n3] = dArray4[0][n3];
                                dArray4[0][n3] = Double.NaN;
                            }
                            if (m_Debug) {
                                System.err.println("Fix variable " + n3 + " to bound " + dArray6[n3] + " from value " + dArray[n3]);
                            }
                            blArray[n3] = true;
                            dynamicIntArray.addElement(n3);
                        }
                        return dArray6;
                    }
                    d14 = d13;
                    d17 = this.m_f;
                    break;
                }
                if (m_Debug) {
                    System.err.println("Alpha condition holds.");
                }
                d14 = d6;
                d15 = d13;
                d18 = this.m_f;
                break;
            }
            if (d13 < d12) {
                if (d3 < d5) {
                    d13 = Math.min(1.0, d4);
                    for (n = 0; n < n2; ++n) {
                        if (blArray[n]) continue;
                        dArray6[n] = dArray[n] + d13 * dArray3[n];
                    }
                    if (m_Debug) {
                        System.err.println("No feasible lambda: still take alpha=" + d13);
                    }
                    if (n3 != -1 && d13 >= d4) {
                        if (dArray3[n3] > 0.0) {
                            dArray6[n3] = dArray4[1][n3];
                            dArray4[1][n3] = Double.NaN;
                        } else {
                            dArray6[n3] = dArray4[0][n3];
                            dArray4[0][n3] = Double.NaN;
                        }
                        if (m_Debug) {
                            System.err.println("Fix variable " + n3 + " to bound " + dArray6[n3] + " from value " + dArray[n3]);
                        }
                        blArray[n3] = true;
                        dynamicIntArray.addElement(n3);
                    }
                } else {
                    for (n = 0; n < n2; ++n) {
                        dArray6[n] = dArray[n];
                    }
                    this.m_f = d5;
                    if (m_Debug) {
                        System.err.println("Cannot find feasible lambda");
                    }
                }
                return dArray6;
            }
            if (n5 == 0) {
                if (!Double.isInfinite(d3)) {
                    d3 = this.m_f;
                }
                d19 = -0.5 * d13 * this.m_Slope / ((this.m_f - d5) / d13 - this.m_Slope);
            } else {
                double d20 = this.m_f - d5 - d13 * this.m_Slope;
                double d21 = d17 - d5 - d6 * this.m_Slope;
                double d22 = (d20 / (d13 * d13) - d21 / (d6 * d6)) / (d13 - d6);
                double d23 = (-d6 * d20 / (d13 * d13) + d13 * d21 / (d6 * d6)) / (d13 - d6);
                if (d22 == 0.0) {
                    d19 = -this.m_Slope / (2.0 * d23);
                } else {
                    d7 = d23 * d23 - 3.0 * d22 * this.m_Slope;
                    if (d7 < 0.0) {
                        d7 = 0.0;
                    }
                    if ((d2 = -d23 + Math.sqrt(d7)) >= Double.MAX_VALUE) {
                        d2 = Double.MAX_VALUE;
                        if (m_Debug) {
                            System.err.print("-b+sqrt(disc) too large! Set it to MAX_VALUE.");
                        }
                    }
                    d19 = d2 / (3.0 * d22);
                }
                if (m_Debug) {
                    System.err.print("Cubic interpolation: \na:   " + Utils.doubleToString(d22, 10, 7) + "\n" + "b:   " + Utils.doubleToString(d23, 10, 7) + "\n" + "disc:   " + Utils.doubleToString(d7, 10, 7) + "\n" + "tmplam:   " + d19 + "\n" + "alam:   " + Utils.doubleToString(d13, 10, 7) + "\n");
                }
                if (d19 > 0.5 * d13) {
                    d19 = 0.5 * d13;
                }
            }
            d6 = d13;
            d17 = this.m_f;
            d13 = Math.max(d19, 0.1 * d13);
            if (d13 > d4) {
                throw new Exception("Sth. wrong in lnsrch:Lambda infeasible!(lambda=" + d13 + ", alpha=" + d4 + ", upper=" + d19 + "|" + -d4 * this.m_Slope / (2.0 * ((this.m_f - d5) / d4 - this.m_Slope)) + ", m_f=" + this.m_f + ", fold=" + d5 + ", slope=" + this.m_Slope);
            }
            ++n5;
        }
        d2 = d14 - d15;
        if (m_Debug) {
            System.err.println("Last stage of searching for beta condition (alam between " + Utils.doubleToString(d15, 10, 7) + " and " + Utils.doubleToString(d14, 10, 7) + ")...\n" + "Quadratic Interpolation(QI):\n" + "Last newSlope = " + Utils.doubleToString(d16, 10, 7));
        }
        while (d16 < this.m_BETA * this.m_Slope && d2 >= d12) {
            double d24 = -0.5 * d16 * d2 * d2 / (d17 - d18 - d16 * d2);
            if (m_Debug) {
                System.err.println("fhi = " + d17 + "\n" + "flo = " + d18 + "\n" + "ldiff = " + d2 + "\n" + "lincr (using QI) = " + d24 + "\n");
            }
            if (d24 < 0.2 * d2) {
                d24 = 0.2 * d2;
            }
            if ((d13 = d15 + d24) >= d14) {
                d13 = d14;
                d24 = d2;
            }
            for (n = 0; n < n2; ++n) {
                if (blArray[n]) continue;
                dArray6[n] = dArray[n] + d13 * dArray3[n];
            }
            this.m_f = this.objectiveFunction(dArray6);
            if (Double.isNaN(this.m_f)) {
                throw new Exception("Objective function value is NaN!");
            }
            if (this.m_f > d5 + this.m_ALF * d13 * this.m_Slope) {
                d2 = d24;
                d17 = this.m_f;
                continue;
            }
            dArray5 = this.evaluateGradient(dArray6);
            d16 = 0.0;
            for (n = 0; n < n2; ++n) {
                if (blArray[n]) continue;
                d16 += dArray5[n] * dArray3[n];
            }
            if (!(d16 < this.m_BETA * this.m_Slope)) continue;
            d15 = d13;
            d2 -= d24;
            d18 = this.m_f;
        }
        if (d16 < this.m_BETA * this.m_Slope) {
            if (m_Debug) {
                System.err.println("Beta condition cannot be satisfied, take alpha condition");
            }
            d13 = d15;
            for (n = 0; n < n2; ++n) {
                if (blArray[n]) continue;
                dArray6[n] = dArray[n] + d13 * dArray3[n];
            }
            this.m_f = d18;
        } else if (m_Debug) {
            System.err.println("Both alpha and beta conditions are satisfied. alam=" + Utils.doubleToString(d13, 10, 7));
        }
        if (n3 != -1 && d13 >= d4) {
            if (dArray3[n3] > 0.0) {
                dArray6[n3] = dArray4[1][n3];
                dArray4[1][n3] = Double.NaN;
            } else {
                dArray6[n3] = dArray4[0][n3];
                dArray4[0][n3] = Double.NaN;
            }
            if (m_Debug) {
                System.err.println("Fix variable " + n3 + " to bound " + dArray6[n3] + " from value " + dArray[n3]);
            }
            blArray[n3] = true;
            dynamicIntArray.addElement(n3);
        }
        return dArray6;
    }

    public double[] findArgmin(double[] dArray, double[][] dArray2) throws Exception {
        int n = dArray.length;
        boolean[] blArray = new boolean[n];
        double[][] dArray3 = new double[2][n];
        DynamicIntArray dynamicIntArray = new DynamicIntArray(dArray2.length);
        DynamicIntArray dynamicIntArray2 = null;
        DynamicIntArray dynamicIntArray3 = null;
        this.m_f = this.objectiveFunction(dArray);
        if (Double.isNaN(this.m_f)) {
            throw new Exception("Objective function value is NaN!");
        }
        double d = 0.0;
        double[] dArray4 = this.evaluateGradient(dArray);
        double[] dArray5 = new double[n];
        double[] dArray6 = new double[n];
        double[] dArray7 = new double[n];
        double[] dArray8 = new double[n];
        Matrix matrix = new Matrix(n, n);
        double[] dArray9 = new double[n];
        for (int i = 0; i < n; ++i) {
            matrix.setRow(i, new double[n]);
            matrix.setElement(i, i, 1.0);
            dArray9[i] = 1.0;
            dArray7[i] = -dArray4[i];
            d += dArray4[i] * dArray4[i];
            dArray8[i] = dArray[i];
            dArray3[0][i] = dArray2[0][i];
            dArray3[1][i] = dArray2[1][i];
            blArray[i] = false;
        }
        double d2 = this.m_STPMX * Math.max(Math.sqrt(d), (double)n);
        for (int i = 0; i < this.m_MAXITS; ++i) {
            int n2;
            int n3;
            if (m_Debug) {
                System.err.println("\nIteration # " + i + ":");
            }
            double[] dArray10 = dArray8;
            double[] dArray11 = dArray4;
            if (m_Debug) {
                System.err.println("Line search ... ");
            }
            this.m_IsZeroStep = false;
            dArray8 = this.lnsrch(dArray8, dArray4, dArray7, d2, blArray, dArray3, dynamicIntArray);
            if (m_Debug) {
                System.err.println("Line search finished.");
            }
            if (this.m_IsZeroStep) {
                for (n3 = 0; n3 < dynamicIntArray.size(); ++n3) {
                    int n4 = dynamicIntArray.elementAt(n3);
                    matrix.setRow(n4, new double[n]);
                    matrix.setColumn(n4, new double[n]);
                    dArray9[n4] = 0.0;
                }
                dArray4 = this.evaluateGradient(dArray8);
                --i;
            } else {
                int n5;
                n3 = 0;
                double d3 = 0.0;
                for (n2 = 0; n2 < n; ++n2) {
                    dArray6[n2] = dArray8[n2] - dArray10[n2];
                    double d4 = Math.abs(dArray6[n2]) / Math.max(Math.abs(dArray8[n2]), 1.0);
                    if (!(d4 > d3)) continue;
                    d3 = d4;
                }
                if (d3 < m_Zero) {
                    if (m_Debug) {
                        System.err.println("\nDeltaX converge: " + d3);
                    }
                    n3 = 1;
                }
                dArray4 = this.evaluateGradient(dArray8);
                d3 = 0.0;
                double d5 = 0.0;
                double d6 = 0.0;
                double d7 = 0.0;
                double d8 = 0.0;
                for (n5 = 0; n5 < n; ++n5) {
                    if (!blArray[n5]) {
                        dArray5[n5] = dArray4[n5] - dArray11[n5];
                        d5 += dArray6[n5] * dArray5[n5];
                        d6 += dArray6[n5] * dArray6[n5];
                        d7 += dArray5[n5] * dArray5[n5];
                    } else {
                        d8 += dArray6[n5] * (dArray4[n5] - dArray11[n5]);
                    }
                    double d9 = Math.abs(dArray4[n5]) * Math.max(Math.abs(dArray7[n5]), 1.0) / Math.max(Math.abs(this.m_f), 1.0);
                    if (!(d9 > d3)) continue;
                    d3 = d9;
                }
                if (d3 < m_Zero) {
                    if (m_Debug) {
                        System.err.println("Gradient converge: " + d3);
                    }
                    n3 = 1;
                }
                if (m_Debug) {
                    System.err.println("dg'*dx=" + (d5 + d8));
                }
                if (Math.abs(d5 + d8) < m_Zero) {
                    n3 = 1;
                }
                n5 = dynamicIntArray.size();
                boolean bl = true;
                if (n3 != 0) {
                    int n6;
                    int n7;
                    if (m_Debug) {
                        System.err.println("Test any release possible ...");
                    }
                    if (dynamicIntArray2 != null) {
                        dynamicIntArray3 = (DynamicIntArray)dynamicIntArray2.copy();
                    }
                    dynamicIntArray2 = new DynamicIntArray(dynamicIntArray.size());
                    for (n7 = n5 - 1; n7 >= 0; --n7) {
                        boolean bl2;
                        double d10;
                        n6 = dynamicIntArray.elementAt(n7);
                        double[] dArray12 = this.evaluateHessian(dArray8, n6);
                        double d11 = 0.0;
                        if (dArray12 != null) {
                            for (int j = 0; j < dArray12.length; ++j) {
                                if (blArray[j]) continue;
                                d11 += dArray12[j] * dArray7[j];
                            }
                        }
                        if (dArray8[n6] >= dArray2[1][n6]) {
                            d10 = -dArray4[n6];
                        } else if (dArray8[n6] <= dArray2[0][n6]) {
                            d10 = dArray4[n6];
                        } else {
                            throw new Exception("x[" + n6 + "] not fixed on the" + " bounds where it should have been!");
                        }
                        double d12 = d10 + d11;
                        if (m_Debug) {
                            System.err.println("Variable " + n6 + ": Lagrangian=" + d10 + "|" + d12);
                        }
                        boolean bl3 = bl2 = 2.0 * Math.abs(d11) < Math.min(Math.abs(d10), Math.abs(d12));
                        if (d10 * d12 > 0.0 && bl2 && d12 < 0.0) {
                            dynamicIntArray2.addElement(n6);
                            dynamicIntArray.removeElementAt(n7);
                            n3 = 0;
                        }
                        if (dArray12 != null || dynamicIntArray2 == null || !dynamicIntArray2.equal(dynamicIntArray3)) continue;
                        n3 = 1;
                    }
                    if (n3 != 0) {
                        if (m_Debug) {
                            System.err.println("Minimum found.");
                        }
                        this.m_f = this.objectiveFunction(dArray8);
                        if (Double.isNaN(this.m_f)) {
                            throw new Exception("Objective function value is NaN!");
                        }
                        return dArray8;
                    }
                    for (n7 = 0; n7 < dynamicIntArray2.size(); ++n7) {
                        n6 = dynamicIntArray2.elementAt(n7);
                        blArray[n6] = false;
                        if (dArray8[n6] <= dArray2[0][n6]) {
                            dArray3[0][n6] = dArray2[0][n6];
                            if (m_Debug) {
                                System.err.println("Free variable " + n6 + " from bound " + dArray3[0][n6]);
                            }
                        } else {
                            dArray3[1][n6] = dArray2[1][n6];
                            if (m_Debug) {
                                System.err.println("Free variable " + n6 + " from bound " + dArray3[1][n6]);
                            }
                        }
                        matrix.setElement(n6, n6, 1.0);
                        dArray9[n6] = 1.0;
                        bl = false;
                    }
                }
                if (d5 < Math.max(m_Zero * Math.sqrt(d6) * Math.sqrt(d7), m_Zero)) {
                    if (m_Debug) {
                        System.err.println("dg'*dx negative!");
                    }
                    bl = false;
                }
                if (bl) {
                    double d13 = 1.0 / d5;
                    this.updateCholeskyFactor(matrix, dArray9, dArray5, d13, blArray);
                    d13 = 1.0 / this.m_Slope;
                    this.updateCholeskyFactor(matrix, dArray9, dArray11, d13, blArray);
                }
            }
            Matrix matrix2 = new Matrix(n, n);
            double[] dArray13 = new double[n];
            for (int j = 0; j < n; ++j) {
                dArray13[j] = !blArray[j] ? -dArray4[j] : 0.0;
                for (int k = j; k < n; ++k) {
                    if (blArray[k] || blArray[j]) continue;
                    matrix2.setElement(k, j, matrix.getElement(k, j) * dArray9[j]);
                }
            }
            double[] dArray14 = Optimization.solveTriangle(matrix2, dArray13, true, blArray);
            matrix2 = null;
            for (n2 = 0; n2 < dArray14.length; ++n2) {
                if (!Double.isNaN(dArray14[n2])) continue;
                throw new Exception("L*direct[" + n2 + "] is NaN!" + "|-g=" + dArray13[n2] + "|" + blArray[n2] + "|diag=" + dArray9[n2]);
            }
            dArray7 = Optimization.solveTriangle(matrix, dArray14, false, blArray);
            for (n2 = 0; n2 < dArray7.length; ++n2) {
                if (!Double.isNaN(dArray7[n2])) continue;
                throw new Exception("direct is NaN!");
            }
        }
        if (m_Debug) {
            System.err.println("Cannot find minimum -- too many interations!");
        }
        this.m_X = dArray8;
        return null;
    }

    public static double[] solveTriangle(Matrix matrix, double[] dArray, boolean bl, boolean[] blArray) {
        double[] dArray2;
        block13: {
            int n;
            int n2;
            block12: {
                int n3;
                n2 = dArray.length;
                dArray2 = new double[n2];
                if (blArray == null) {
                    blArray = new boolean[n2];
                }
                if (!bl) break block12;
                for (n3 = 0; n3 < n2 && blArray[n3]; ++n3) {
                    dArray2[n3] = 0.0;
                }
                if (n3 >= n2) break block13;
                dArray2[n3] = dArray[n3] / matrix.getElement(n3, n3);
                while (n3 < n2) {
                    if (!blArray[n3]) {
                        double d = dArray[n3];
                        for (int i = 0; i < n3; ++i) {
                            d -= matrix.getElement(n3, i) * dArray2[i];
                        }
                        dArray2[n3] = d / matrix.getElement(n3, n3);
                    } else {
                        dArray2[n3] = 0.0;
                    }
                    ++n3;
                }
                break block13;
            }
            for (n = n2 - 1; n >= 0 && blArray[n]; --n) {
                dArray2[n] = 0.0;
            }
            if (n >= 0) {
                dArray2[n] = dArray[n] / matrix.getElement(n, n);
                while (n >= 0) {
                    if (!blArray[n]) {
                        double d = dArray[n];
                        for (int i = n + 1; i < n2; ++i) {
                            d -= matrix.getElement(i, n) * dArray2[i];
                        }
                        dArray2[n] = d / matrix.getElement(n, n);
                    } else {
                        dArray2[n] = 0.0;
                    }
                    --n;
                }
            }
        }
        return dArray2;
    }

    protected void updateCholeskyFactor(Matrix matrix, double[] dArray, double[] dArray2, double d, boolean[] blArray) throws Exception {
        int n;
        int n2 = dArray2.length;
        double[] dArray3 = new double[n2];
        for (n = 0; n < dArray2.length; ++n) {
            dArray3[n] = !blArray[n] ? dArray2[n] : 0.0;
        }
        if (d > 0.0) {
            double d2 = d;
            for (n = 0; n < n2; ++n) {
                double d3;
                if (blArray[n]) continue;
                double d4 = dArray3[n];
                double d5 = dArray[n];
                dArray[n] = d3 = d5 + d2 * d4 * d4;
                double d6 = d4 * d2 / d3;
                d2 *= d5 / d3;
                for (int i = n + 1; i < n2; ++i) {
                    if (!blArray[i]) {
                        double d7 = matrix.getElement(i, n);
                        int n3 = i;
                        dArray3[n3] = dArray3[n3] - d4 * d7;
                        matrix.setElement(i, n, d7 + d6 * dArray3[i]);
                        continue;
                    }
                    matrix.setElement(i, n, 0.0);
                }
            }
        } else {
            double[] dArray4 = Optimization.solveTriangle(matrix, dArray2, true, blArray);
            double d8 = 0.0;
            for (int i = 0; i < n2; ++i) {
                if (blArray[i]) continue;
                d8 += dArray4[i] * dArray4[i] / dArray[i];
            }
            double d9 = 1.0 + d * d8;
            d9 = d9 < 0.0 ? 0.0 : Math.sqrt(d9);
            double d10 = d;
            double d11 = d / (1.0 + d9);
            for (int i = 0; i < n2; ++i) {
                if (blArray[i]) continue;
                double d12 = dArray[i];
                double d13 = dArray4[i] * dArray4[i] / d12;
                double d14 = 1.0 + d11 * d13;
                if ((d8 -= d13) < 0.0) {
                    d8 = 0.0;
                }
                double d15 = d11 * d11 * d13 * d8;
                if (i < n2 - 1 && d15 <= m_Zero) {
                    d15 = m_Zero;
                }
                double d16 = d14 * d14 + d15;
                dArray[i] = d16 * d12;
                if (Double.isNaN(dArray[i])) {
                    throw new Exception("d[" + i + "] NaN! P=" + dArray4[i] + ",d=" + d12 + ",t=" + d8 + ",p=" + d13 + ",sigma=" + d11 + ",sclar=" + d);
                }
                double d17 = d10 * dArray4[i] / (d16 * d12);
                d10 /= d16;
                d16 = Math.sqrt(d16);
                double d18 = d11;
                if (i < n2 - 1 && (Double.isNaN(d11 *= (1.0 + d16) / (d16 * (d14 + d16))) || Double.isInfinite(d11))) {
                    throw new Exception("sigma NaN/Inf! rho=" + d16 + ",theta=" + d14 + ",P[" + i + "]=" + dArray4[i] + ",p=" + d13 + ",d=" + d12 + ",t=" + d8 + ",oldsigma=" + d18);
                }
                for (int j = i + 1; j < n2; ++j) {
                    if (!blArray[j]) {
                        double d19 = matrix.getElement(j, i);
                        int n4 = j;
                        dArray3[n4] = dArray3[n4] - dArray4[i] * d19;
                        matrix.setElement(j, i, d19 + d17 * dArray3[j]);
                        continue;
                    }
                    matrix.setElement(j, i, 0.0);
                }
            }
        }
    }

    static {
        while (1.0 + m_Epsilon > 1.0) {
            m_Epsilon /= 2.0;
        }
        m_Zero = Math.sqrt(m_Epsilon *= 2.0);
        if (m_Debug) {
            System.err.print("Machine precision is " + m_Epsilon + " and zero set to " + m_Zero);
        }
    }

    private class DynamicIntArray {
        private int[] m_Objects;
        private int m_Size = 0;
        private int m_CapacityIncrement = 1;
        private int m_CapacityMultiplier = 2;

        public DynamicIntArray(int n) {
            this.m_Objects = new int[n];
        }

        public final void addElement(int n) {
            if (this.m_Size == this.m_Objects.length) {
                int[] nArray = new int[this.m_CapacityMultiplier * (this.m_Objects.length + this.m_CapacityIncrement)];
                System.arraycopy(this.m_Objects, 0, nArray, 0, this.m_Size);
                this.m_Objects = nArray;
            }
            this.m_Objects[this.m_Size] = n;
            ++this.m_Size;
        }

        public final Object copy() {
            DynamicIntArray dynamicIntArray = new DynamicIntArray(this.m_Objects.length);
            dynamicIntArray.m_Size = this.m_Size;
            dynamicIntArray.m_CapacityIncrement = this.m_CapacityIncrement;
            dynamicIntArray.m_CapacityMultiplier = this.m_CapacityMultiplier;
            System.arraycopy(this.m_Objects, 0, dynamicIntArray.m_Objects, 0, this.m_Size);
            return dynamicIntArray;
        }

        public final int elementAt(int n) {
            return this.m_Objects[n];
        }

        private boolean equal(DynamicIntArray dynamicIntArray) {
            if (dynamicIntArray == null || this.size() != dynamicIntArray.size()) {
                return false;
            }
            int n = this.size();
            int[] nArray = Utils.sort(this.m_Objects);
            int[] nArray2 = Utils.sort(dynamicIntArray.m_Objects);
            for (int i = 0; i < n; ++i) {
                if (this.m_Objects[nArray[i]] == dynamicIntArray.m_Objects[nArray2[i]]) continue;
                return false;
            }
            return true;
        }

        public final void removeElementAt(int n) {
            System.arraycopy(this.m_Objects, n + 1, this.m_Objects, n, this.m_Size - n - 1);
            --this.m_Size;
        }

        public final void removeAllElements() {
            this.m_Objects = new int[this.m_Objects.length];
            this.m_Size = 0;
        }

        public final int size() {
            return this.m_Size;
        }
    }
}

