/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class Obfuscate
extends Filter
implements UnsupervisedFilter,
StreamableFilter {
    public String globalInfo() {
        return "An instance filter that obfuscates all strings in the data";
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        FastVector fastVector = new FastVector();
        for (int i = 0; i < instances.numAttributes(); ++i) {
            Attribute attribute = instances.attribute(i);
            Attribute attribute2 = null;
            switch (attribute.type()) {
                case 0: {
                    attribute2 = new Attribute("A" + (i + 1));
                    break;
                }
                case 1: {
                    FastVector fastVector2 = new FastVector();
                    for (int j = 0; j < attribute.numValues(); ++j) {
                        fastVector2.addElement("V" + (j + 1));
                    }
                    attribute2 = new Attribute("A" + (i + 1), fastVector2);
                    break;
                }
                default: {
                    attribute2 = (Attribute)attribute.copy();
                    System.err.println("Not converting attribute: " + attribute.name());
                }
            }
            fastVector.addElement(attribute2);
        }
        Instances instances2 = new Instances("R", fastVector, 10);
        this.setOutputFormat(instances2);
        return true;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        this.push((Instance)instance.copy());
        return true;
    }

    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new Obfuscate(), stringArray);
            } else {
                Filter.filterFile(new Obfuscate(), stringArray);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

