/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators;

import weka.estimators.ConditionalEstimator;
import weka.estimators.Estimator;
import weka.estimators.NormalEstimator;

public class NDConditionalEstimator
implements ConditionalEstimator {
    private NormalEstimator[] m_Estimators;

    public NDConditionalEstimator(int n, double d) {
        this.m_Estimators = new NormalEstimator[n];
        for (int i = 0; i < n; ++i) {
            this.m_Estimators[i] = new NormalEstimator(d);
        }
    }

    public void addValue(double d, double d2, double d3) {
        this.m_Estimators[(int)d2].addValue(d, d3);
    }

    public Estimator getEstimator(double d) {
        return this.m_Estimators[(int)d];
    }

    public double getProbability(double d, double d2) {
        return this.getEstimator(d2).getProbability(d);
    }

    public String toString() {
        String string = "ND Conditional Estimator. " + this.m_Estimators.length + " sub-estimators:\n";
        for (int i = 0; i < this.m_Estimators.length; ++i) {
            string = string + "Sub-estimator " + i + ": " + this.m_Estimators[i];
        }
        return string;
    }

    public static void main(String[] stringArray) {
        try {
            int n;
            int n2;
            if (stringArray.length == 0) {
                System.out.println("Please specify a set of instances.");
                return;
            }
            int n3 = n2 = Integer.parseInt(stringArray[0]);
            int n4 = n = Integer.parseInt(stringArray[1]);
            for (int i = 2; i < stringArray.length - 1; i += 2) {
                n2 = Integer.parseInt(stringArray[i]);
                n = Integer.parseInt(stringArray[i + 1]);
                if (n2 > n3) {
                    n3 = n2;
                }
                if (n <= n4) continue;
                n4 = n;
            }
            NDConditionalEstimator nDConditionalEstimator = new NDConditionalEstimator(n4 + 1, 1.0);
            for (int i = 0; i < stringArray.length - 1; i += 2) {
                n2 = Integer.parseInt(stringArray[i]);
                n = Integer.parseInt(stringArray[i + 1]);
                System.out.println(nDConditionalEstimator);
                System.out.println("Prediction for " + n2 + '|' + n + " = " + nDConditionalEstimator.getProbability(n2, n));
                nDConditionalEstimator.addValue(n2, n, 1.0);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

