/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.m5;

import java.io.Serializable;
import weka.classifiers.trees.m5.RuleNode;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;

public class Rule
implements Serializable {
    protected static int LEFT = 0;
    protected static int RIGHT = 1;
    private Instances m_instances;
    private int m_classIndex;
    private int m_numAttributes;
    private int m_numInstances;
    private int[] m_splitAtts;
    private double[] m_splitVals;
    private RuleNode[] m_internalNodes;
    private int[] m_relOps;
    private RuleNode m_ruleModel;
    protected RuleNode m_topOfTree;
    private double m_globalStdDev;
    private double m_globalAbsDev;
    private Instances m_covered;
    private int m_numCovered;
    private Instances m_notCovered;
    private boolean m_useTree = false;
    private boolean m_smoothPredictions = false;
    private boolean m_saveInstances;
    private boolean m_regressionTree;
    private boolean m_useUnpruned = false;
    private double m_minNumInstances = 4.0;

    public void buildClassifier(Instances instances) throws Exception {
        this.m_instances = null;
        this.m_topOfTree = null;
        this.m_covered = null;
        this.m_notCovered = null;
        this.m_ruleModel = null;
        this.m_splitAtts = null;
        this.m_splitVals = null;
        this.m_relOps = null;
        this.m_internalNodes = null;
        this.m_instances = instances;
        this.m_classIndex = this.m_instances.classIndex();
        this.m_numAttributes = this.m_instances.numAttributes();
        this.m_numInstances = this.m_instances.numInstances();
        this.m_globalStdDev = Rule.stdDev(this.m_classIndex, this.m_instances);
        this.m_globalAbsDev = Rule.absDev(this.m_classIndex, this.m_instances);
        this.m_topOfTree = new RuleNode(this.m_globalStdDev, this.m_globalAbsDev, null);
        this.m_topOfTree.setSaveInstances(this.m_saveInstances);
        this.m_topOfTree.setRegressionTree(this.m_regressionTree);
        this.m_topOfTree.setMinNumInstances(this.m_minNumInstances);
        this.m_topOfTree.buildClassifier(this.m_instances);
        if (!this.m_useUnpruned) {
            this.m_topOfTree.prune();
        } else {
            this.m_topOfTree.installLinearModels();
        }
        if (this.m_smoothPredictions) {
            this.m_topOfTree.installSmoothedModels();
        }
        this.m_topOfTree.numLeaves(0);
        if (!this.m_useTree) {
            this.makeRule();
        }
        this.m_instances = new Instances(this.m_instances, 0);
    }

    public double classifyInstance(Instance instance) throws Exception {
        if (this.m_useTree) {
            return this.m_topOfTree.classifyInstance(instance);
        }
        if (this.m_splitAtts.length > 0) {
            for (int i = 0; i < this.m_relOps.length; ++i) {
                if (!(this.m_relOps[i] == LEFT ? instance.value(this.m_splitAtts[i]) > this.m_splitVals[i] : instance.value(this.m_splitAtts[i]) <= this.m_splitVals[i])) continue;
                throw new Exception("Rule does not classify instance");
            }
        }
        return this.m_ruleModel.classifyInstance(instance);
    }

    public RuleNode topOfTree() {
        return this.m_topOfTree;
    }

    private void makeRule() throws Exception {
        RuleNode[] ruleNodeArray = new RuleNode[1];
        double[] dArray = new double[1];
        this.m_notCovered = new Instances(this.m_instances, 0);
        this.m_covered = new Instances(this.m_instances, 0);
        dArray[0] = -1.0;
        ruleNodeArray[0] = null;
        this.m_topOfTree.findBestLeaf(dArray, ruleNodeArray);
        RuleNode ruleNode = ruleNodeArray[0];
        if (ruleNode == null) {
            throw new Exception("Unable to generate rule!");
        }
        this.m_ruleModel = ruleNode;
        int n = 0;
        while (ruleNode.parentNode() != null) {
            ++n;
            ruleNode = ruleNode.parentNode();
        }
        ruleNode = ruleNodeArray[0];
        this.m_relOps = new int[n];
        this.m_splitAtts = new int[n];
        this.m_splitVals = new double[n];
        if (this.m_smoothPredictions) {
            this.m_internalNodes = new RuleNode[n];
        }
        int n2 = 0;
        while (ruleNode.parentNode() != null) {
            this.m_splitAtts[n2] = ruleNode.parentNode().splitAtt();
            this.m_splitVals[n2] = ruleNode.parentNode().splitVal();
            this.m_relOps[n2] = ruleNode.parentNode().leftNode() == ruleNode ? LEFT : RIGHT;
            if (this.m_smoothPredictions) {
                this.m_internalNodes[n2] = ruleNode.parentNode();
            }
            ruleNode = ruleNode.parentNode();
            ++n2;
        }
        for (n2 = 0; n2 < this.m_numInstances; ++n2) {
            boolean bl = true;
            for (int i = 0; i < this.m_relOps.length; ++i) {
                if (this.m_relOps[i] == LEFT) {
                    if (!(this.m_instances.instance(n2).value(this.m_splitAtts[i]) > this.m_splitVals[i])) continue;
                    this.m_notCovered.add(this.m_instances.instance(n2));
                    bl = false;
                    break;
                }
                if (!(this.m_instances.instance(n2).value(this.m_splitAtts[i]) <= this.m_splitVals[i])) continue;
                this.m_notCovered.add(this.m_instances.instance(n2));
                bl = false;
                break;
            }
            if (!bl) continue;
            ++this.m_numCovered;
        }
    }

    public String toString() {
        if (this.m_useTree) {
            return this.treeToString();
        }
        return this.ruleToString();
    }

    private String treeToString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_topOfTree == null) {
            return "Tree/Rule has not been built yet!";
        }
        stringBuffer.append("M5 " + (this.m_useUnpruned ? "unpruned " : "pruned ") + (this.m_regressionTree ? "regression " : "model ") + "tree:\n");
        if (this.m_smoothPredictions) {
            stringBuffer.append("(using smoothed linear models)\n");
        }
        stringBuffer.append(this.m_topOfTree.treeToString(0));
        stringBuffer.append(this.m_topOfTree.printLeafModels());
        stringBuffer.append("\nNumber of Rules : " + this.m_topOfTree.numberOfLinearModels());
        return stringBuffer.toString();
    }

    private String ruleToString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_splitAtts.length > 0) {
            stringBuffer.append("IF\n");
            for (int i = this.m_splitAtts.length - 1; i >= 0; --i) {
                stringBuffer.append("\t" + this.m_covered.attribute(this.m_splitAtts[i]).name() + " ");
                if (this.m_relOps[i] == 0) {
                    stringBuffer.append("<= ");
                } else {
                    stringBuffer.append("> ");
                }
                stringBuffer.append(Utils.doubleToString(this.m_splitVals[i], 1, 3) + "\n");
            }
            stringBuffer.append("THEN\n");
        }
        if (this.m_ruleModel != null) {
            try {
                stringBuffer.append(this.m_ruleModel.printNodeLinearModel());
                stringBuffer.append(" [" + this.m_numCovered);
                if (this.m_globalAbsDev > 0.0) {
                    stringBuffer.append("/" + Utils.doubleToString(100.0 * this.m_ruleModel.rootMeanSquaredError() / this.m_globalStdDev, 1, 3) + "%]\n\n");
                } else {
                    stringBuffer.append("]\n\n");
                }
            }
            catch (Exception exception) {
                return "Can't print rule";
            }
        }
        return stringBuffer.toString();
    }

    public void setUnpruned(boolean bl) {
        this.m_useUnpruned = bl;
    }

    public boolean getUnpruned() {
        return this.m_useUnpruned;
    }

    public void setUseTree(boolean bl) {
        this.m_useTree = bl;
    }

    public boolean getUseTree() {
        return this.m_useTree;
    }

    public void setSmoothing(boolean bl) {
        this.m_smoothPredictions = bl;
    }

    public boolean getSmoothing() {
        return this.m_smoothPredictions;
    }

    public Instances notCoveredInstances() {
        return this.m_notCovered;
    }

    protected static final double stdDev(int n, Instances instances) {
        double d;
        int n2 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i <= instances.numInstances() - 1; ++i) {
            ++n2;
            double d4 = instances.instance(i).value(n);
            d2 += d4;
            d3 += d4 * d4;
        }
        if (n2 > 1) {
            double d5 = (d3 - d2 * d2 / (double)n2) / (double)n2;
            d5 = Math.abs(d5);
            d = Math.sqrt(d5);
        } else {
            d = 0.0;
        }
        return d;
    }

    protected static final double absDev(int n, Instances instances) {
        double d;
        int n2;
        double d2 = 0.0;
        double d3 = 0.0;
        for (n2 = 0; n2 <= instances.numInstances() - 1; ++n2) {
            d2 += instances.instance(n2).value(n);
        }
        if (instances.numInstances() > 1) {
            d2 /= (double)instances.numInstances();
            for (n2 = 0; n2 <= instances.numInstances() - 1; ++n2) {
                d3 += Math.abs(instances.instance(n2).value(n) - d2);
            }
            d = d3 / (double)instances.numInstances();
        } else {
            d = 0.0;
        }
        return d;
    }

    protected void setSaveInstances(boolean bl) {
        this.m_saveInstances = bl;
    }

    public boolean getRegressionTree() {
        return this.m_regressionTree;
    }

    public void setRegressionTree(boolean bl) {
        this.m_regressionTree = bl;
    }

    public void setMinNumInstances(double d) {
        this.m_minNumInstances = d;
    }

    public double getMinNumInstances() {
        return this.m_minNumInstances;
    }

    public RuleNode getM5RootNode() {
        return this.m_topOfTree;
    }
}

