/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.treevisualizer;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.Timer;
import weka.core.Instances;
import weka.gui.treevisualizer.Edge;
import weka.gui.treevisualizer.Node;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeBuild;
import weka.gui.treevisualizer.TreeDisplayEvent;
import weka.gui.treevisualizer.TreeDisplayListener;
import weka.gui.visualize.PrintablePanel;
import weka.gui.visualize.VisualizePanel;

public class TreeVisualizer
extends PrintablePanel
implements MouseMotionListener,
MouseListener,
ActionListener,
ItemListener {
    private NodePlace m_placer;
    private Node m_topNode;
    private Dimension m_viewPos;
    private Dimension m_viewSize;
    private Font m_currentFont;
    private FontMetrics m_fontSize;
    private int m_numNodes;
    private int m_numLevels;
    private NodeInfo[] m_nodes;
    private EdgeInfo[] m_edges;
    private Timer m_frameLimiter;
    private int m_mouseState;
    private Dimension m_oldMousePos;
    private Dimension m_newMousePos;
    private boolean m_clickAvailable;
    private Dimension m_nViewPos;
    private Dimension m_nViewSize;
    private int m_scaling;
    private JPopupMenu m_winMenu;
    private JMenuItem m_topN;
    private JMenuItem m_fitToScreen;
    private JMenuItem m_autoScale;
    private JMenu m_selectFont;
    private ButtonGroup m_selectFontGroup;
    private JRadioButtonMenuItem m_size24;
    private JRadioButtonMenuItem m_size22;
    private JRadioButtonMenuItem m_size20;
    private JRadioButtonMenuItem m_size18;
    private JRadioButtonMenuItem m_size16;
    private JRadioButtonMenuItem m_size14;
    private JRadioButtonMenuItem m_size12;
    private JRadioButtonMenuItem m_size10;
    private JRadioButtonMenuItem m_size8;
    private JRadioButtonMenuItem m_size6;
    private JRadioButtonMenuItem m_size4;
    private JRadioButtonMenuItem m_size2;
    private JRadioButtonMenuItem m_size1;
    private JMenuItem m_accept;
    private JPopupMenu m_nodeMenu;
    private JMenuItem m_visualise;
    private JMenuItem m_addChildren;
    private JMenuItem m_remChildren;
    private JMenuItem m_classifyChild;
    private JMenuItem m_sendInstances;
    private int m_focusNode;
    private int m_highlightNode;
    private TreeDisplayListener m_listener;
    private JTextField m_searchString;
    private JDialog m_searchWin;
    private JRadioButton m_caseSen;

    public TreeVisualizer(TreeDisplayListener treeDisplayListener, String string, NodePlace nodePlace) {
        this.setBorder(BorderFactory.createTitledBorder("Tree View"));
        this.m_listener = treeDisplayListener;
        TreeBuild treeBuild = new TreeBuild();
        Node node = null;
        PlaceNode2 placeNode2 = new PlaceNode2();
        node = treeBuild.create(new StringReader(string));
        this.m_highlightNode = 5;
        this.m_topNode = node;
        this.m_placer = nodePlace;
        this.m_placer.place(this.m_topNode);
        this.m_viewPos = new Dimension(0, 0);
        this.m_viewSize = new Dimension(800, 600);
        this.m_nViewPos = new Dimension(0, 0);
        this.m_nViewSize = new Dimension(800, 600);
        this.m_scaling = 0;
        this.m_numNodes = Node.getCount(this.m_topNode, 0);
        this.m_numLevels = Node.getHeight(this.m_topNode, 0);
        this.m_nodes = new NodeInfo[this.m_numNodes];
        this.m_edges = new EdgeInfo[this.m_numNodes - 1];
        this.arrayFill(this.m_topNode, this.m_nodes, this.m_edges);
        this.changeFontSize(12);
        this.m_mouseState = 0;
        this.m_oldMousePos = new Dimension(0, 0);
        this.m_newMousePos = new Dimension(0, 0);
        this.m_frameLimiter = new Timer(120, this);
        this.m_winMenu = new JPopupMenu();
        this.m_topN = new JMenuItem("Center on Top Node");
        this.m_topN.setActionCommand("Center on Top Node");
        this.m_fitToScreen = new JMenuItem("Fit to Screen");
        this.m_fitToScreen.setActionCommand("Fit to Screen");
        this.m_selectFont = new JMenu("Select Font");
        this.m_selectFont.setActionCommand("Select Font");
        this.m_autoScale = new JMenuItem("Auto Scale");
        this.m_autoScale.setActionCommand("Auto Scale");
        this.m_selectFontGroup = new ButtonGroup();
        this.m_accept = new JMenuItem("Accept The Tree");
        this.m_accept.setActionCommand("Accept The Tree");
        this.m_winMenu.add(this.m_topN);
        this.m_winMenu.addSeparator();
        this.m_winMenu.add(this.m_fitToScreen);
        this.m_winMenu.add(this.m_autoScale);
        this.m_winMenu.addSeparator();
        this.m_winMenu.addSeparator();
        this.m_winMenu.add(this.m_selectFont);
        this.m_winMenu.addSeparator();
        if (this.m_listener != null) {
            this.m_winMenu.add(this.m_accept);
        }
        this.m_topN.addActionListener(this);
        this.m_fitToScreen.addActionListener(this);
        this.m_autoScale.addActionListener(this);
        this.m_accept.addActionListener(this);
        this.m_size24 = new JRadioButtonMenuItem("Size 24", false);
        this.m_size22 = new JRadioButtonMenuItem("Size 22", false);
        this.m_size20 = new JRadioButtonMenuItem("Size 20", false);
        this.m_size18 = new JRadioButtonMenuItem("Size 18", false);
        this.m_size16 = new JRadioButtonMenuItem("Size 16", false);
        this.m_size14 = new JRadioButtonMenuItem("Size 14", false);
        this.m_size12 = new JRadioButtonMenuItem("Size 12", true);
        this.m_size10 = new JRadioButtonMenuItem("Size 10", false);
        this.m_size8 = new JRadioButtonMenuItem("Size 8", false);
        this.m_size6 = new JRadioButtonMenuItem("Size 6", false);
        this.m_size4 = new JRadioButtonMenuItem("Size 4", false);
        this.m_size2 = new JRadioButtonMenuItem("Size 2", false);
        this.m_size1 = new JRadioButtonMenuItem("Size 1", false);
        this.m_size24.setActionCommand("Size 24");
        this.m_size22.setActionCommand("Size 22");
        this.m_size20.setActionCommand("Size 20");
        this.m_size18.setActionCommand("Size 18");
        this.m_size16.setActionCommand("Size 16");
        this.m_size14.setActionCommand("Size 14");
        this.m_size12.setActionCommand("Size 12");
        this.m_size10.setActionCommand("Size 10");
        this.m_size8.setActionCommand("Size 8");
        this.m_size6.setActionCommand("Size 6");
        this.m_size4.setActionCommand("Size 4");
        this.m_size2.setActionCommand("Size 2");
        this.m_size1.setActionCommand("Size 1");
        this.m_selectFontGroup.add(this.m_size24);
        this.m_selectFontGroup.add(this.m_size22);
        this.m_selectFontGroup.add(this.m_size20);
        this.m_selectFontGroup.add(this.m_size18);
        this.m_selectFontGroup.add(this.m_size16);
        this.m_selectFontGroup.add(this.m_size14);
        this.m_selectFontGroup.add(this.m_size12);
        this.m_selectFontGroup.add(this.m_size10);
        this.m_selectFontGroup.add(this.m_size8);
        this.m_selectFontGroup.add(this.m_size6);
        this.m_selectFontGroup.add(this.m_size4);
        this.m_selectFontGroup.add(this.m_size2);
        this.m_selectFontGroup.add(this.m_size1);
        this.m_selectFont.add(this.m_size24);
        this.m_selectFont.add(this.m_size22);
        this.m_selectFont.add(this.m_size20);
        this.m_selectFont.add(this.m_size18);
        this.m_selectFont.add(this.m_size16);
        this.m_selectFont.add(this.m_size14);
        this.m_selectFont.add(this.m_size12);
        this.m_selectFont.add(this.m_size10);
        this.m_selectFont.add(this.m_size8);
        this.m_selectFont.add(this.m_size6);
        this.m_selectFont.add(this.m_size4);
        this.m_selectFont.add(this.m_size2);
        this.m_selectFont.add(this.m_size1);
        this.m_size24.addItemListener(this);
        this.m_size22.addItemListener(this);
        this.m_size20.addItemListener(this);
        this.m_size18.addItemListener(this);
        this.m_size16.addItemListener(this);
        this.m_size14.addItemListener(this);
        this.m_size12.addItemListener(this);
        this.m_size10.addItemListener(this);
        this.m_size8.addItemListener(this);
        this.m_size6.addItemListener(this);
        this.m_size4.addItemListener(this);
        this.m_size2.addItemListener(this);
        this.m_size1.addItemListener(this);
        this.m_nodeMenu = new JPopupMenu();
        this.m_visualise = new JMenuItem("Visualize The Node");
        this.m_visualise.setActionCommand("Visualize The Node");
        this.m_visualise.addActionListener(this);
        this.m_nodeMenu.add(this.m_visualise);
        if (this.m_listener != null) {
            this.m_remChildren = new JMenuItem("Remove Child Nodes");
            this.m_remChildren.setActionCommand("Remove Child Nodes");
            this.m_remChildren.addActionListener(this);
            this.m_nodeMenu.add(this.m_remChildren);
            this.m_classifyChild = new JMenuItem("Use Classifier...");
            this.m_classifyChild.setActionCommand("classify_child");
            this.m_classifyChild.addActionListener(this);
            this.m_nodeMenu.add(this.m_classifyChild);
        }
        this.m_focusNode = -1;
        this.m_highlightNode = -1;
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.m_frameLimiter.setRepeats(false);
        this.m_frameLimiter.start();
    }

    public TreeVisualizer(TreeDisplayListener treeDisplayListener, Node node, NodePlace nodePlace) {
        this.setBorder(BorderFactory.createTitledBorder("Tree View"));
        this.m_listener = treeDisplayListener;
        this.m_topNode = node;
        this.m_placer = nodePlace;
        this.m_placer.place(this.m_topNode);
        this.m_viewPos = new Dimension(0, 0);
        this.m_viewSize = new Dimension(800, 600);
        this.m_nViewPos = new Dimension(0, 0);
        this.m_nViewSize = new Dimension(800, 600);
        this.m_scaling = 0;
        this.m_numNodes = Node.getCount(this.m_topNode, 0);
        this.m_numLevels = Node.getHeight(this.m_topNode, 0);
        this.m_nodes = new NodeInfo[this.m_numNodes];
        this.m_edges = new EdgeInfo[this.m_numNodes - 1];
        this.arrayFill(this.m_topNode, this.m_nodes, this.m_edges);
        this.changeFontSize(12);
        this.m_mouseState = 0;
        this.m_oldMousePos = new Dimension(0, 0);
        this.m_newMousePos = new Dimension(0, 0);
        this.m_frameLimiter = new Timer(120, this);
        this.m_winMenu = new JPopupMenu();
        this.m_topN = new JMenuItem("Center on Top Node");
        this.m_topN.setActionCommand("Center on Top Node");
        this.m_fitToScreen = new JMenuItem("Fit to Screen");
        this.m_fitToScreen.setActionCommand("Fit to Screen");
        this.m_selectFont = new JMenu("Select Font");
        this.m_selectFont.setActionCommand("Select Font");
        this.m_autoScale = new JMenuItem("Auto Scale");
        this.m_autoScale.setActionCommand("Auto Scale");
        this.m_selectFontGroup = new ButtonGroup();
        this.m_accept = new JMenuItem("Accept The Tree");
        this.m_accept.setActionCommand("Accept The Tree");
        this.m_winMenu.add(this.m_topN);
        this.m_winMenu.addSeparator();
        this.m_winMenu.add(this.m_fitToScreen);
        this.m_winMenu.add(this.m_autoScale);
        this.m_winMenu.addSeparator();
        this.m_winMenu.addSeparator();
        this.m_winMenu.add(this.m_selectFont);
        this.m_winMenu.addSeparator();
        if (this.m_listener != null) {
            this.m_winMenu.add(this.m_accept);
        }
        this.m_topN.addActionListener(this);
        this.m_fitToScreen.addActionListener(this);
        this.m_autoScale.addActionListener(this);
        this.m_accept.addActionListener(this);
        this.m_size24 = new JRadioButtonMenuItem("Size 24", false);
        this.m_size22 = new JRadioButtonMenuItem("Size 22", false);
        this.m_size20 = new JRadioButtonMenuItem("Size 20", false);
        this.m_size18 = new JRadioButtonMenuItem("Size 18", false);
        this.m_size16 = new JRadioButtonMenuItem("Size 16", false);
        this.m_size14 = new JRadioButtonMenuItem("Size 14", false);
        this.m_size12 = new JRadioButtonMenuItem("Size 12", true);
        this.m_size10 = new JRadioButtonMenuItem("Size 10", false);
        this.m_size8 = new JRadioButtonMenuItem("Size 8", false);
        this.m_size6 = new JRadioButtonMenuItem("Size 6", false);
        this.m_size4 = new JRadioButtonMenuItem("Size 4", false);
        this.m_size2 = new JRadioButtonMenuItem("Size 2", false);
        this.m_size1 = new JRadioButtonMenuItem("Size 1", false);
        this.m_size24.setActionCommand("Size 24");
        this.m_size22.setActionCommand("Size 22");
        this.m_size20.setActionCommand("Size 20");
        this.m_size18.setActionCommand("Size 18");
        this.m_size16.setActionCommand("Size 16");
        this.m_size14.setActionCommand("Size 14");
        this.m_size12.setActionCommand("Size 12");
        this.m_size10.setActionCommand("Size 10");
        this.m_size8.setActionCommand("Size 8");
        this.m_size6.setActionCommand("Size 6");
        this.m_size4.setActionCommand("Size 4");
        this.m_size2.setActionCommand("Size 2");
        this.m_size1.setActionCommand("Size 1");
        this.m_selectFontGroup.add(this.m_size24);
        this.m_selectFontGroup.add(this.m_size22);
        this.m_selectFontGroup.add(this.m_size20);
        this.m_selectFontGroup.add(this.m_size18);
        this.m_selectFontGroup.add(this.m_size16);
        this.m_selectFontGroup.add(this.m_size14);
        this.m_selectFontGroup.add(this.m_size12);
        this.m_selectFontGroup.add(this.m_size10);
        this.m_selectFontGroup.add(this.m_size8);
        this.m_selectFontGroup.add(this.m_size6);
        this.m_selectFontGroup.add(this.m_size4);
        this.m_selectFontGroup.add(this.m_size2);
        this.m_selectFontGroup.add(this.m_size1);
        this.m_selectFont.add(this.m_size24);
        this.m_selectFont.add(this.m_size22);
        this.m_selectFont.add(this.m_size20);
        this.m_selectFont.add(this.m_size18);
        this.m_selectFont.add(this.m_size16);
        this.m_selectFont.add(this.m_size14);
        this.m_selectFont.add(this.m_size12);
        this.m_selectFont.add(this.m_size10);
        this.m_selectFont.add(this.m_size8);
        this.m_selectFont.add(this.m_size6);
        this.m_selectFont.add(this.m_size4);
        this.m_selectFont.add(this.m_size2);
        this.m_selectFont.add(this.m_size1);
        this.m_size24.addItemListener(this);
        this.m_size22.addItemListener(this);
        this.m_size20.addItemListener(this);
        this.m_size18.addItemListener(this);
        this.m_size16.addItemListener(this);
        this.m_size14.addItemListener(this);
        this.m_size12.addItemListener(this);
        this.m_size10.addItemListener(this);
        this.m_size8.addItemListener(this);
        this.m_size6.addItemListener(this);
        this.m_size4.addItemListener(this);
        this.m_size2.addItemListener(this);
        this.m_size1.addItemListener(this);
        this.m_nodeMenu = new JPopupMenu();
        this.m_visualise = new JMenuItem("Visualize The Node");
        this.m_visualise.setActionCommand("Visualize The Node");
        this.m_visualise.addActionListener(this);
        this.m_nodeMenu.add(this.m_visualise);
        if (this.m_listener != null) {
            this.m_remChildren = new JMenuItem("Remove Child Nodes");
            this.m_remChildren.setActionCommand("Remove Child Nodes");
            this.m_remChildren.addActionListener(this);
            this.m_nodeMenu.add(this.m_remChildren);
            this.m_classifyChild = new JMenuItem("Use Classifier...");
            this.m_classifyChild.setActionCommand("classify_child");
            this.m_classifyChild.addActionListener(this);
            this.m_nodeMenu.add(this.m_classifyChild);
            this.m_sendInstances = new JMenuItem("Add Instances To Viewer");
            this.m_sendInstances.setActionCommand("send_instances");
            this.m_sendInstances.addActionListener(this);
            this.m_nodeMenu.add(this.m_sendInstances);
        }
        this.m_focusNode = -1;
        this.m_highlightNode = -1;
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.m_frameLimiter.setRepeats(false);
        this.m_frameLimiter.start();
    }

    public void fitToScreen() {
        this.getScreenFit(this.m_viewPos, this.m_viewSize);
        this.repaint();
    }

    private void getScreenFit(Dimension dimension, Dimension dimension2) {
        int n = 1000000;
        int n2 = -1000000;
        int n3 = 1000000;
        int n4 = -1000000;
        int n5 = 0;
        int n6 = -1000000;
        int n7 = -1000000;
        for (int i = 0; i < this.m_numNodes; ++i) {
            this.calcScreenCoords(i);
            if (this.m_nodes[i].m_center - this.m_nodes[i].m_side < n) {
                n = this.m_nodes[i].m_center - this.m_nodes[i].m_side;
            }
            if (this.m_nodes[i].m_center < n3) {
                n3 = this.m_nodes[i].m_center;
            }
            if (this.m_nodes[i].m_center + this.m_nodes[i].m_side > n2) {
                n2 = this.m_nodes[i].m_center + this.m_nodes[i].m_side;
            }
            if (this.m_nodes[i].m_center > n4) {
                n4 = this.m_nodes[i].m_center;
                n5 = i;
            }
            if (this.m_nodes[i].m_top + this.m_nodes[i].m_height > n6) {
                n6 = this.m_nodes[i].m_top + this.m_nodes[i].m_height;
            }
            if (this.m_nodes[i].m_top <= n7) continue;
            n7 = this.m_nodes[i].m_top;
        }
        dimension2.width = this.getWidth();
        dimension2.width -= n3 - n + n2 - n4 + 30;
        dimension2.height = this.getHeight() - n6 + n7 - 40;
        if (this.m_nodes[n5].m_node.getCenter() != 0.0 && n3 != n4) {
            dimension2.width = (int)((double)dimension2.width / this.m_nodes[n5].m_node.getCenter());
        }
        if (dimension2.width < 10) {
            dimension2.width = 10;
        }
        if (dimension2.height < 10) {
            dimension2.height = 10;
        }
        dimension.width = (n3 - n + n2 - n4) / 2 + 15;
        dimension.height = (n6 - n7) / 2 + 20;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand() == null) {
            if (this.m_scaling == 0) {
                this.repaint();
            } else {
                this.animateScaling(this.m_nViewPos, this.m_nViewSize, this.m_scaling);
            }
        } else if (actionEvent.getActionCommand().equals("Fit to Screen")) {
            Dimension dimension = new Dimension();
            Dimension dimension2 = new Dimension();
            this.getScreenFit(dimension, dimension2);
            this.animateScaling(dimension, dimension2, 10);
        } else if (actionEvent.getActionCommand().equals("Center on Top Node")) {
            int n = (int)(this.m_topNode.getCenter() * (double)this.m_viewSize.width);
            int n2 = (int)(this.m_topNode.getTop() * (double)this.m_viewSize.height);
            Dimension dimension = new Dimension(this.getSize().width / 2 - n, this.getSize().width / 6 - n2);
            this.animateScaling(dimension, this.m_viewSize, 10);
        } else if (actionEvent.getActionCommand().equals("Auto Scale")) {
            this.autoScale();
        } else if (actionEvent.getActionCommand().equals("Visualize The Node")) {
            if (this.m_focusNode >= 0) {
                Instances instances = this.m_nodes[this.m_focusNode].m_node.getInstances();
                if (instances != null) {
                    VisualizePanel visualizePanel = new VisualizePanel();
                    visualizePanel.setInstances(instances);
                    JFrame jFrame = new JFrame();
                    jFrame.setSize(400, 300);
                    jFrame.getContentPane().add(visualizePanel);
                    jFrame.setVisible(true);
                } else {
                    JOptionPane.showMessageDialog(this, "Sorry, there is no available Instances data for this Node.", "Sorry!", 2);
                }
            } else {
                JOptionPane.showMessageDialog(this, "Error, there is no selected Node to perform this operation on.", "Error!", 0);
            }
        } else if (actionEvent.getActionCommand().equals("Create Child Nodes")) {
            if (this.m_focusNode >= 0) {
                if (this.m_listener != null) {
                    this.m_listener.userCommand(new TreeDisplayEvent(1, this.m_nodes[this.m_focusNode].m_node.getRefer()));
                } else {
                    JOptionPane.showMessageDialog(this, "Sorry, there is no available Decision Tree to perform this operation on.", "Sorry!", 2);
                }
            } else {
                JOptionPane.showMessageDialog(this, "Error, there is no selected Node to perform this operation on.", "Error!", 0);
            }
        } else if (actionEvent.getActionCommand().equals("Remove Child Nodes")) {
            if (this.m_focusNode >= 0) {
                if (this.m_listener != null) {
                    this.m_listener.userCommand(new TreeDisplayEvent(2, this.m_nodes[this.m_focusNode].m_node.getRefer()));
                } else {
                    JOptionPane.showMessageDialog(this, "Sorry, there is no available Decsion Tree to perform this operation on.", "Sorry!", 2);
                }
            } else {
                JOptionPane.showMessageDialog(this, "Error, there is no selected Node to perform this operation on.", "Error!", 0);
            }
        } else if (actionEvent.getActionCommand().equals("classify_child")) {
            if (this.m_focusNode >= 0) {
                if (this.m_listener != null) {
                    this.m_listener.userCommand(new TreeDisplayEvent(4, this.m_nodes[this.m_focusNode].m_node.getRefer()));
                } else {
                    JOptionPane.showMessageDialog(this, "Sorry, there is no available Decsion Tree to perform this operation on.", "Sorry!", 2);
                }
            } else {
                JOptionPane.showMessageDialog(this, "Error, there is no selected Node to perform this operation on.", "Error!", 0);
            }
        } else if (actionEvent.getActionCommand().equals("send_instances")) {
            if (this.m_focusNode >= 0) {
                if (this.m_listener != null) {
                    this.m_listener.userCommand(new TreeDisplayEvent(5, this.m_nodes[this.m_focusNode].m_node.getRefer()));
                } else {
                    JOptionPane.showMessageDialog(this, "Sorry, there is no available Decsion Tree to perform this operation on.", "Sorry!", 2);
                }
            } else {
                JOptionPane.showMessageDialog(this, "Error, there is no selected Node to perform this operation on.", "Error!", 0);
            }
        } else if (actionEvent.getActionCommand().equals("Accept The Tree")) {
            if (this.m_listener != null) {
                this.m_listener.userCommand(new TreeDisplayEvent(3, null));
            } else {
                JOptionPane.showMessageDialog(this, "Sorry, there is no available Decision Tree to perform this operation on.", "Sorry!", 2);
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)itemEvent.getSource();
        if (jRadioButtonMenuItem.getActionCommand().equals("Size 24")) {
            this.changeFontSize(24);
        } else if (jRadioButtonMenuItem.getActionCommand().equals("Size 22")) {
            this.changeFontSize(22);
        } else if (jRadioButtonMenuItem.getActionCommand().equals("Size 20")) {
            this.changeFontSize(20);
        } else if (jRadioButtonMenuItem.getActionCommand().equals("Size 18")) {
            this.changeFontSize(18);
        } else if (jRadioButtonMenuItem.getActionCommand().equals("Size 16")) {
            this.changeFontSize(16);
        } else if (jRadioButtonMenuItem.getActionCommand().equals("Size 14")) {
            this.changeFontSize(14);
        } else if (jRadioButtonMenuItem.getActionCommand().equals("Size 12")) {
            this.changeFontSize(12);
        } else if (jRadioButtonMenuItem.getActionCommand().equals("Size 10")) {
            this.changeFontSize(10);
        } else if (jRadioButtonMenuItem.getActionCommand().equals("Size 8")) {
            this.changeFontSize(8);
        } else if (jRadioButtonMenuItem.getActionCommand().equals("Size 6")) {
            this.changeFontSize(6);
        } else if (jRadioButtonMenuItem.getActionCommand().equals("Size 4")) {
            this.changeFontSize(4);
        } else if (jRadioButtonMenuItem.getActionCommand().equals("Size 2")) {
            this.changeFontSize(2);
        } else if (jRadioButtonMenuItem.getActionCommand().equals("Size 1")) {
            this.changeFontSize(1);
        } else if (jRadioButtonMenuItem.getActionCommand().equals("Hide Descendants")) {
            // empty if block
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.m_clickAvailable) {
            int n = -1;
            for (int i = 0; i < this.m_numNodes; ++i) {
                if (this.m_nodes[i].m_quad != 18) continue;
                this.calcScreenCoords(i);
                if (mouseEvent.getX() <= this.m_nodes[i].m_center + this.m_nodes[i].m_side && mouseEvent.getX() >= this.m_nodes[i].m_center - this.m_nodes[i].m_side && mouseEvent.getY() >= this.m_nodes[i].m_top && mouseEvent.getY() <= this.m_nodes[i].m_top + this.m_nodes[i].m_height) {
                    n = i;
                }
                this.m_nodes[i].m_top = 32000;
            }
            this.m_focusNode = n;
            if (this.m_focusNode != -1) {
                if (this.m_listener != null) {
                    this.actionPerformed(new ActionEvent(this, 32000, "Create Child Nodes"));
                } else {
                    this.actionPerformed(new ActionEvent(this, 32000, "Visualize The Node"));
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void mousePressed(MouseEvent mouseEvent) {
        this.m_frameLimiter.setRepeats(true);
        if ((mouseEvent.getModifiers() & 0x10) != 0 && !mouseEvent.isAltDown() && this.m_mouseState == 0 && this.m_scaling == 0) {
            if ((mouseEvent.getModifiers() & 2) != 0) {
                if ((mouseEvent.getModifiers() & 1) == 0) {
                    this.m_mouseState = 2;
                    return;
                }
            }
            if ((mouseEvent.getModifiers() & 1) != 0) {
                if ((mouseEvent.getModifiers() & 2) == 0) {
                    this.m_oldMousePos.width = mouseEvent.getX();
                    this.m_oldMousePos.height = mouseEvent.getY();
                    this.m_newMousePos.width = mouseEvent.getX();
                    this.m_newMousePos.height = mouseEvent.getY();
                    this.m_mouseState = 3;
                    Graphics graphics = this.getGraphics();
                    graphics.setColor(Color.black);
                    graphics.setXORMode(Color.white);
                    graphics.drawRect(this.m_oldMousePos.width, this.m_oldMousePos.height, this.m_newMousePos.width - this.m_oldMousePos.width, this.m_newMousePos.height - this.m_oldMousePos.height);
                    graphics.dispose();
                    return;
                }
            }
            this.m_oldMousePos.width = mouseEvent.getX();
            this.m_oldMousePos.height = mouseEvent.getY();
            this.m_newMousePos.width = mouseEvent.getX();
            this.m_newMousePos.height = mouseEvent.getY();
            this.m_mouseState = 1;
            this.m_frameLimiter.start();
            return;
        }
        if (mouseEvent.getButton() == 1 && mouseEvent.isAltDown() && mouseEvent.isShiftDown() && !mouseEvent.isControlDown()) {
            this.saveComponent();
            return;
        }
        if (this.m_mouseState != 0) return;
        if (this.m_scaling != 0) return;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.m_clickAvailable = this.m_mouseState == 1;
        if (this.m_mouseState == 2 && this.mouseInBounds(mouseEvent)) {
            this.m_mouseState = 0;
            Dimension dimension = new Dimension(this.m_viewSize.width / 2, this.m_viewSize.height / 2);
            if (dimension.width < 10) {
                dimension.width = 10;
            }
            if (dimension.height < 10) {
                dimension.height = 10;
            }
            Dimension dimension2 = this.getSize();
            Dimension dimension3 = new Dimension((int)((double)(dimension2.width / 2) - ((double)dimension2.width / 2.0 - (double)this.m_viewPos.width) / 2.0), (int)((double)(dimension2.height / 2) - ((double)dimension2.height / 2.0 - (double)this.m_viewPos.height) / 2.0));
            this.animateScaling(dimension3, dimension, 10);
        } else if (this.m_mouseState == 3) {
            this.m_mouseState = 0;
            Graphics graphics = this.getGraphics();
            graphics.setColor(Color.black);
            graphics.setXORMode(Color.white);
            graphics.drawRect(this.m_oldMousePos.width, this.m_oldMousePos.height, this.m_newMousePos.width - this.m_oldMousePos.width, this.m_newMousePos.height - this.m_oldMousePos.height);
            graphics.dispose();
            int n = this.m_newMousePos.width - this.m_oldMousePos.width;
            int n2 = this.m_newMousePos.height - this.m_oldMousePos.height;
            if (n >= 1 && n2 >= 1 && this.mouseInBounds(mouseEvent) && this.getSize().width / n <= 6 && this.getSize().height / n2 <= 6) {
                Dimension dimension = new Dimension();
                Dimension dimension4 = new Dimension();
                double d = (double)this.getSize().width / (double)n;
                double d2 = (double)this.getSize().height / (double)n2;
                dimension4.width = (int)((double)(this.m_oldMousePos.width - this.m_viewPos.width) * -d);
                dimension4.height = (int)((double)(this.m_oldMousePos.height - this.m_viewPos.height) * -d2);
                dimension.width = (int)((double)this.m_viewSize.width * d);
                dimension.height = (int)((double)this.m_viewSize.height * d2);
                this.animateScaling(dimension4, dimension, 10);
            }
        } else if (this.m_mouseState == 0 && this.m_scaling == 0) {
            this.m_mouseState = 0;
            this.setFont(new Font("A Name", 0, 12));
            int n = -1;
            for (int i = 0; i < this.m_numNodes; ++i) {
                if (this.m_nodes[i].m_quad != 18) continue;
                this.calcScreenCoords(i);
                if (mouseEvent.getX() <= this.m_nodes[i].m_center + this.m_nodes[i].m_side && mouseEvent.getX() >= this.m_nodes[i].m_center - this.m_nodes[i].m_side && mouseEvent.getY() >= this.m_nodes[i].m_top && mouseEvent.getY() <= this.m_nodes[i].m_top + this.m_nodes[i].m_height) {
                    n = i;
                }
                this.m_nodes[i].m_top = 32000;
            }
            if (n == -1) {
                this.m_winMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
            } else {
                this.m_focusNode = n;
                this.m_nodeMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
            }
            this.setFont(this.m_currentFont);
        } else if (this.m_mouseState == 1) {
            this.m_mouseState = 0;
            this.m_frameLimiter.stop();
            this.repaint();
        }
    }

    private boolean mouseInBounds(MouseEvent mouseEvent) {
        return mouseEvent.getX() >= 0 && mouseEvent.getY() >= 0 && mouseEvent.getX() <= this.getSize().width && mouseEvent.getY() <= this.getSize().height;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.m_mouseState == 1) {
            this.m_oldMousePos.width = this.m_newMousePos.width;
            this.m_oldMousePos.height = this.m_newMousePos.height;
            this.m_newMousePos.width = mouseEvent.getX();
            this.m_newMousePos.height = mouseEvent.getY();
            this.m_viewPos.width += this.m_newMousePos.width - this.m_oldMousePos.width;
            this.m_viewPos.height += this.m_newMousePos.height - this.m_oldMousePos.height;
        } else if (this.m_mouseState == 3) {
            Graphics graphics = this.getGraphics();
            graphics.setColor(Color.black);
            graphics.setXORMode(Color.white);
            graphics.drawRect(this.m_oldMousePos.width, this.m_oldMousePos.height, this.m_newMousePos.width - this.m_oldMousePos.width, this.m_newMousePos.height - this.m_oldMousePos.height);
            this.m_newMousePos.width = mouseEvent.getX();
            this.m_newMousePos.height = mouseEvent.getY();
            graphics.drawRect(this.m_oldMousePos.width, this.m_oldMousePos.height, this.m_newMousePos.width - this.m_oldMousePos.width, this.m_newMousePos.height - this.m_oldMousePos.height);
            graphics.dispose();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void setHighlight(String string) {
        for (int i = 0; i < this.m_numNodes; ++i) {
            if (!string.equals(this.m_nodes[i].m_node.getRefer())) continue;
            this.m_highlightNode = i;
        }
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        graphics.clearRect(0, 0, this.getSize().width, this.getSize().height);
        graphics.setClip(3, 7, this.getWidth() - 6, this.getHeight() - 10);
        this.painter(graphics);
        graphics.setClip(0, 0, this.getWidth(), this.getHeight());
    }

    private void painter(Graphics graphics) {
        int n;
        double d = (double)(-this.m_viewPos.width - 50) / (double)this.m_viewSize.width;
        double d2 = (double)(this.getSize().width - this.m_viewPos.width + 50) / (double)this.m_viewSize.width;
        double d3 = (double)(-this.m_viewPos.height - 50) / (double)this.m_viewSize.height;
        double d4 = (double)(this.getSize().height - this.m_viewPos.height + 50) / (double)this.m_viewSize.height;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < this.m_numNodes; ++n) {
            double d5;
            Node node = this.m_nodes[n].m_node;
            if (this.m_nodes[n].m_change) {
                double d6 = node.getTop();
                n2 = d6 < d3 ? 8 : (d6 > d4 ? 32 : 16);
            }
            n3 = (d5 = node.getCenter()) < d ? 4 : (d5 > d2 ? 1 : 2);
            this.m_nodes[n].m_quad = n2 | n3;
            if (this.m_nodes[n].m_parent < 0) continue;
            int n4 = this.m_nodes[this.m_edges[this.m_nodes[n].m_parent].m_parent].m_quad;
            int n5 = this.m_nodes[n].m_quad;
            if ((n5 & 8) == 8 || (n4 & 0x20) == 32 || (n5 & 4) == 4 && (n4 & 4) == 4 || (n5 & 1) == 1 && (n4 & 1) == 1) continue;
            this.drawLine(this.m_nodes[n].m_parent, graphics);
        }
        for (n = 0; n < this.m_numNodes; ++n) {
            if (this.m_nodes[n].m_quad != 18) continue;
            this.drawNode(n, graphics);
        }
        if (this.m_highlightNode >= 0 && this.m_highlightNode < this.m_numNodes && this.m_nodes[this.m_highlightNode].m_quad == 18) {
            Color color = this.m_nodes[this.m_highlightNode].m_node.getColor();
            graphics.setColor(new Color((color.getRed() + 125) % 256, (color.getGreen() + 125) % 256, (color.getBlue() + 125) % 256));
            if (this.m_nodes[this.m_highlightNode].m_node.getShape() == 1) {
                graphics.drawRect(this.m_nodes[this.m_highlightNode].m_center - this.m_nodes[this.m_highlightNode].m_side, this.m_nodes[this.m_highlightNode].m_top, this.m_nodes[this.m_highlightNode].m_width, this.m_nodes[this.m_highlightNode].m_height);
                graphics.drawRect(this.m_nodes[this.m_highlightNode].m_center - this.m_nodes[this.m_highlightNode].m_side + 1, this.m_nodes[this.m_highlightNode].m_top + 1, this.m_nodes[this.m_highlightNode].m_width - 2, this.m_nodes[this.m_highlightNode].m_height - 2);
            } else if (this.m_nodes[this.m_highlightNode].m_node.getShape() == 2) {
                graphics.drawOval(this.m_nodes[this.m_highlightNode].m_center - this.m_nodes[this.m_highlightNode].m_side, this.m_nodes[this.m_highlightNode].m_top, this.m_nodes[this.m_highlightNode].m_width, this.m_nodes[this.m_highlightNode].m_height);
                graphics.drawOval(this.m_nodes[this.m_highlightNode].m_center - this.m_nodes[this.m_highlightNode].m_side + 1, this.m_nodes[this.m_highlightNode].m_top + 1, this.m_nodes[this.m_highlightNode].m_width - 2, this.m_nodes[this.m_highlightNode].m_height - 2);
            }
        }
        for (int i = 0; i < this.m_numNodes; ++i) {
            this.m_nodes[i].m_top = 32000;
        }
    }

    private void drawNode(int n, Graphics graphics) {
        graphics.setColor(this.m_nodes[n].m_node.getColor());
        graphics.setPaintMode();
        this.calcScreenCoords(n);
        int n2 = this.m_nodes[n].m_center - this.m_nodes[n].m_side;
        int n3 = this.m_nodes[n].m_top;
        if (this.m_nodes[n].m_node.getShape() == 1) {
            graphics.fill3DRect(n2, n3, this.m_nodes[n].m_width, this.m_nodes[n].m_height, true);
            this.drawText(n2, n3, n, false, graphics);
        } else if (this.m_nodes[n].m_node.getShape() == 2) {
            graphics.fillOval(n2, n3, this.m_nodes[n].m_width, this.m_nodes[n].m_height);
            this.drawText(n2, n3 + (int)((double)this.m_nodes[n].m_height * 0.15), n, false, graphics);
        }
    }

    private void drawLine(int n, Graphics graphics) {
        int n2 = this.m_edges[n].m_parent;
        int n3 = this.m_edges[n].m_child;
        this.calcScreenCoords(n3);
        this.calcScreenCoords(n2);
        graphics.setColor(Color.black);
        graphics.setPaintMode();
        if (this.m_currentFont.getSize() < 2) {
            graphics.drawLine(this.m_nodes[n2].m_center, this.m_nodes[n2].m_top + this.m_nodes[n2].m_height, this.m_nodes[n3].m_center, this.m_nodes[n3].m_top);
        } else {
            int n4 = this.m_nodes[n3].m_center - this.m_nodes[n2].m_center;
            int n5 = this.m_nodes[n3].m_top - (this.m_nodes[n2].m_top + this.m_nodes[n2].m_height);
            int n6 = n4 / 2;
            int n7 = n5 / 2;
            int n8 = this.m_nodes[n2].m_center + n6;
            int n9 = this.m_nodes[n2].m_top + this.m_nodes[n2].m_height + n7;
            int n10 = this.m_edges[n].m_tb;
            int n11 = (int)((double)n4 / (double)n5 * (double)(n7 - n10)) + this.m_nodes[n2].m_center;
            this.drawText(n8 - this.m_edges[n].m_side, n9 - n10, n, true, graphics);
            if (n11 > n8 - this.m_edges[n].m_side && n11 < n8 + this.m_edges[n].m_side) {
                graphics.drawLine(this.m_nodes[n2].m_center, this.m_nodes[n2].m_top + this.m_nodes[n2].m_height, n11, n9 - n10);
                graphics.drawLine(n8 * 2 - n11, n9 + n10, this.m_nodes[n3].m_center, this.m_nodes[n3].m_top);
            } else {
                n10 = this.m_edges[n].m_side;
                if (n4 < 0) {
                    n10 *= -1;
                }
                n11 = (int)((double)n5 / (double)n4 * (double)(n6 - n10)) + this.m_nodes[n2].m_top + this.m_nodes[n2].m_height;
                graphics.drawLine(this.m_nodes[n2].m_center, this.m_nodes[n2].m_top + this.m_nodes[n2].m_height, n8 - n10, n11);
                graphics.drawLine(n8 + n10, n9 * 2 - n11, this.m_nodes[n3].m_center, this.m_nodes[n3].m_top);
            }
        }
    }

    private void drawText(int n, int n2, int n3, boolean bl, Graphics graphics) {
        graphics.setPaintMode();
        graphics.setColor(Color.black);
        if (bl) {
            String string;
            Edge edge = this.m_edges[n3].m_edge;
            int n4 = 0;
            while ((string = edge.getLine(n4)) != null) {
                graphics.drawString(string, (this.m_edges[n3].m_width - this.m_fontSize.stringWidth(string)) / 2 + n, n2 + (n4 + 1) * this.m_fontSize.getHeight());
                ++n4;
            }
        } else {
            String string;
            Node node = this.m_nodes[n3].m_node;
            int n5 = 0;
            while ((string = node.getLine(n5)) != null) {
                graphics.drawString(string, (this.m_nodes[n3].m_width - this.m_fontSize.stringWidth(string)) / 2 + n, n2 + (n5 + 1) * this.m_fontSize.getHeight());
                ++n5;
            }
        }
    }

    private void calcScreenCoords(int n) {
        if (this.m_nodes[n].m_top == 32000) {
            this.m_nodes[n].m_top = (int)(this.m_nodes[n].m_node.getTop() * (double)this.m_viewSize.height) + this.m_viewPos.height;
            this.m_nodes[n].m_center = (int)(this.m_nodes[n].m_node.getCenter() * (double)this.m_viewSize.width) + this.m_viewPos.width;
        }
    }

    private void autoScale() {
        int n;
        Dimension dimension = new Dimension(10, 10);
        if (this.m_numNodes <= 1) {
            return;
        }
        int n2 = (this.m_nodes[0].m_height + 40) * this.m_numLevels;
        if (n2 > dimension.height) {
            dimension.height = n2;
        }
        for (n = 0; n < this.m_numNodes - 1; ++n) {
            this.calcScreenCoords(n);
            this.calcScreenCoords(n + 1);
            if (!this.m_nodes[n + 1].m_change) {
                n2 = this.m_nodes[n + 1].m_center - this.m_nodes[n].m_center;
                if (n2 <= 0) {
                    n2 = 1;
                }
                if ((n2 = (6 + this.m_nodes[n].m_side + this.m_nodes[n + 1].m_side) * this.m_viewSize.width / n2) > dimension.width) {
                    dimension.width = n2;
                }
            }
            if ((n2 = (this.m_nodes[n + 1].m_height + 40) * this.m_numLevels) <= dimension.height) continue;
            dimension.height = n2;
        }
        int n3 = this.m_nodes[this.m_edges[0].m_child].m_top;
        n = this.m_nodes[this.m_edges[0].m_parent].m_top;
        n2 = n3 - n;
        if (n2 <= 0) {
            n2 = 1;
        }
        if ((n2 = (60 + this.m_edges[0].m_height + this.m_nodes[this.m_edges[0].m_parent].m_height) * this.m_viewSize.height / n2) > dimension.height) {
            dimension.height = n2;
        }
        for (int i = 0; i < this.m_numNodes - 2; ++i) {
            if (!this.m_nodes[this.m_edges[i + 1].m_child].m_change) {
                int n4 = this.m_nodes[this.m_edges[i].m_child].m_center - this.m_nodes[this.m_edges[i].m_parent].m_center;
                n4 /= 2;
                int n5 = this.m_nodes[this.m_edges[i + 1].m_child].m_center - this.m_nodes[this.m_edges[i + 1].m_parent].m_center;
                n5 /= 2;
                n2 = (n5 += this.m_nodes[this.m_edges[i + 1].m_parent].m_center) - (n4 += this.m_nodes[this.m_edges[i].m_parent].m_center);
                if (n2 <= 0) {
                    n2 = 1;
                }
                if ((n2 = (12 + this.m_edges[i].m_side + this.m_edges[i + 1].m_side) * this.m_viewSize.width / n2) > dimension.width) {
                    dimension.width = n2;
                }
            }
            n = this.m_nodes[this.m_edges[i + 1].m_parent].m_top;
            n3 = this.m_nodes[this.m_edges[i + 1].m_child].m_top;
            n2 = n3 - n;
            if (n2 <= 0) {
                n2 = 1;
            }
            if ((n2 = (60 + this.m_edges[i + 1].m_height + this.m_nodes[this.m_edges[i + 1].m_parent].m_height) * this.m_viewSize.height / n2) <= dimension.height) continue;
            dimension.height = n2;
        }
        Dimension dimension2 = this.getSize();
        Dimension dimension3 = new Dimension();
        dimension3.width = (int)((double)(dimension2.width / 2) - ((double)dimension2.width / 2.0 - (double)this.m_viewPos.width) / (double)this.m_viewSize.width * (double)dimension.width);
        dimension3.height = (int)((double)(dimension2.height / 2) - ((double)dimension2.height / 2.0 - (double)this.m_viewPos.height) / (double)this.m_viewSize.height * (double)dimension.height);
        for (int i = 0; i < this.m_numNodes; ++i) {
            this.m_nodes[i].m_top = 32000;
        }
        this.animateScaling(dimension3, dimension, 10);
    }

    private void animateScaling(Dimension dimension, Dimension dimension2, int n) {
        if (n == 0) {
            System.out.println("the timer didn't end in time");
            this.m_scaling = 0;
        } else {
            if (this.m_scaling == 0) {
                this.m_frameLimiter.start();
                this.m_nViewPos.width = dimension.width;
                this.m_nViewPos.height = dimension.height;
                this.m_nViewSize.width = dimension2.width;
                this.m_nViewSize.height = dimension2.height;
                this.m_scaling = n;
            }
            int n2 = (dimension2.width - this.m_viewSize.width) / n;
            int n3 = (dimension2.height - this.m_viewSize.height) / n;
            int n4 = (dimension.width - this.m_viewPos.width) / n;
            int n5 = (dimension.height - this.m_viewPos.height) / n;
            this.m_viewSize.width += n2;
            this.m_viewSize.height += n3;
            this.m_viewPos.width += n4;
            this.m_viewPos.height += n5;
            this.repaint();
            --this.m_scaling;
            if (this.m_scaling == 0) {
                this.m_frameLimiter.stop();
            }
        }
    }

    private void changeFontSize(int n) {
        this.m_currentFont = new Font("A Name", 0, n);
        this.setFont(this.m_currentFont);
        this.m_fontSize = this.getFontMetrics(this.getFont());
        for (int i = 0; i < this.m_numNodes; ++i) {
            Dimension dimension = this.m_nodes[i].m_node.stringSize(this.m_fontSize);
            if (this.m_nodes[i].m_node.getShape() == 1) {
                this.m_nodes[i].m_height = dimension.height + 10;
                this.m_nodes[i].m_width = dimension.width + 8;
                this.m_nodes[i].m_side = this.m_nodes[i].m_width / 2;
            } else if (this.m_nodes[i].m_node.getShape() == 2) {
                this.m_nodes[i].m_height = (int)((double)(dimension.height + 2) * 1.6);
                this.m_nodes[i].m_width = (int)((double)(dimension.width + 2) * 1.6);
                this.m_nodes[i].m_side = this.m_nodes[i].m_width / 2;
            }
            if (i >= this.m_numNodes - 1) continue;
            dimension = this.m_edges[i].m_edge.stringSize(this.m_fontSize);
            this.m_edges[i].m_height = dimension.height + 8;
            this.m_edges[i].m_width = dimension.width + 8;
            this.m_edges[i].m_side = this.m_edges[i].m_width / 2;
            this.m_edges[i].m_tb = this.m_edges[i].m_height / 2;
        }
    }

    private void arrayFill(Node node, NodeInfo[] nodeInfoArray, EdgeInfo[] edgeInfoArray) {
        if (node == null || nodeInfoArray == null) {
            System.exit(1);
        }
        nodeInfoArray[0] = new NodeInfo();
        nodeInfoArray[0].m_node = node;
        nodeInfoArray[0].m_parent = -1;
        nodeInfoArray[0].m_change = true;
        int n = 1;
        double d = node.getTop();
        for (int i = 0; i < n; ++i) {
            Edge edge;
            Node node2 = nodeInfoArray[i].m_node;
            int n2 = 0;
            while ((edge = node2.getChild(n2)) != null) {
                Node node3 = edge.getTarget();
                nodeInfoArray[n] = new NodeInfo();
                nodeInfoArray[n].m_node = node3;
                nodeInfoArray[n].m_parent = n - 1;
                edgeInfoArray[n - 1] = new EdgeInfo();
                edgeInfoArray[n - 1].m_edge = edge;
                edgeInfoArray[n - 1].m_parent = i;
                edgeInfoArray[n - 1].m_child = n;
                if (d != node3.getTop()) {
                    nodeInfoArray[n].m_change = true;
                    d = node3.getTop();
                } else {
                    nodeInfoArray[n].m_change = false;
                }
                ++n;
                ++n2;
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            TreeBuild treeBuild = new TreeBuild();
            Node node = null;
            PlaceNode2 placeNode2 = new PlaceNode2();
            node = treeBuild.create(new FileReader(stringArray[0]));
            int n = Node.getCount(node, 0);
            TreeVisualizer treeVisualizer = new TreeVisualizer(null, node, (NodePlace)placeNode2);
            treeVisualizer.setSize(800, 600);
            JFrame jFrame = new JFrame();
            Container container = jFrame.getContentPane();
            container.add(treeVisualizer);
            jFrame.setDefaultCloseOperation(2);
            jFrame.setSize(800, 600);
            jFrame.setVisible(true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class EdgeInfo {
        int m_parent;
        int m_child;
        int m_side;
        int m_tb;
        int m_width;
        int m_height;
        Edge m_edge;

        private EdgeInfo() {
        }
    }

    private class NodeInfo {
        int m_top = 32000;
        int m_center;
        int m_side;
        int m_width;
        int m_height;
        boolean m_change;
        int m_parent;
        int m_quad;
        Node m_node;

        private NodeInfo() {
        }
    }
}

