/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.io.BufferedReader;
import java.io.FileReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.Utils;
import weka.experiment.PairedStats;
import weka.experiment.ResultMatrix;
import weka.experiment.ResultMatrixCSV;
import weka.experiment.ResultMatrixHTML;
import weka.experiment.ResultMatrixLatex;
import weka.experiment.ResultMatrixPlainText;
import weka.experiment.ResultMatrixSignificance;
import weka.experiment.Tester;

public class PairedTTester
implements OptionHandler,
Tester {
    protected Instances m_Instances;
    protected int m_RunColumn = 0;
    protected int m_RunColumnSet = -1;
    protected int m_FoldColumn = -1;
    protected int m_SortColumn = -1;
    protected int[] m_SortOrder = null;
    protected int[] m_ColOrder = null;
    protected double m_SignificanceLevel = 0.05;
    protected Range m_DatasetKeyColumnsRange = new Range();
    protected int[] m_DatasetKeyColumns;
    protected DatasetSpecifiers m_DatasetSpecifiers = new DatasetSpecifiers();
    protected Range m_ResultsetKeyColumnsRange = new Range();
    protected int[] m_ResultsetKeyColumns;
    protected int[] m_DisplayedResultsets = null;
    protected FastVector m_Resultsets = new FastVector();
    protected boolean m_ResultsetsValid;
    protected boolean m_ShowStdDevs = false;
    protected ResultMatrix m_ResultMatrix = new ResultMatrixPlainText();
    static /* synthetic */ Class class$weka$experiment$ResultMatrixLatex;
    static /* synthetic */ Class class$weka$experiment$ResultMatrixCSV;
    static /* synthetic */ Class class$weka$experiment$ResultMatrixHTML;
    static /* synthetic */ Class class$weka$experiment$ResultMatrixSignificance;

    protected String templateString(Instance instance) {
        String string = "";
        for (int i = 0; i < this.m_DatasetKeyColumns.length; ++i) {
            string = string + instance.toString(this.m_DatasetKeyColumns[i]) + ' ';
        }
        if (string.startsWith("weka.classifiers.")) {
            string = string.substring("weka.classifiers.".length());
        }
        return string.trim();
    }

    public void setResultMatrix(ResultMatrix resultMatrix) {
        this.m_ResultMatrix = resultMatrix;
    }

    public ResultMatrix getResultMatrix() {
        return this.m_ResultMatrix;
    }

    public void setShowStdDevs(boolean bl) {
        this.m_ShowStdDevs = bl;
    }

    public boolean getShowStdDevs() {
        return this.m_ShowStdDevs;
    }

    protected void prepareData() throws Exception {
        Object object;
        int n;
        if (this.m_Instances == null) {
            throw new Exception("No instances have been set");
        }
        this.m_RunColumn = this.m_RunColumnSet == -1 ? this.m_Instances.numAttributes() - 1 : this.m_RunColumnSet;
        if (this.m_ResultsetKeyColumnsRange == null) {
            throw new Exception("No result specifier columns have been set");
        }
        this.m_ResultsetKeyColumnsRange.setUpper(this.m_Instances.numAttributes() - 1);
        this.m_ResultsetKeyColumns = this.m_ResultsetKeyColumnsRange.getSelection();
        if (this.m_DatasetKeyColumnsRange == null) {
            throw new Exception("No dataset specifier columns have been set");
        }
        this.m_DatasetKeyColumnsRange.setUpper(this.m_Instances.numAttributes() - 1);
        this.m_DatasetKeyColumns = this.m_DatasetKeyColumnsRange.getSelection();
        this.m_Resultsets.removeAllElements();
        this.m_DatasetSpecifiers.removeAllSpecifiers();
        for (n = 0; n < this.m_Instances.numInstances(); ++n) {
            int n2;
            object = this.m_Instances.instance(n);
            if (((Instance)object).isMissing(this.m_RunColumn)) {
                throw new Exception("Instance has missing value in run column!\n" + object);
            }
            for (n2 = 0; n2 < this.m_ResultsetKeyColumns.length; ++n2) {
                if (!((Instance)object).isMissing(this.m_ResultsetKeyColumns[n2])) continue;
                throw new Exception("Instance has missing value in resultset key column " + (this.m_ResultsetKeyColumns[n2] + 1) + "!\n" + object);
            }
            for (n2 = 0; n2 < this.m_DatasetKeyColumns.length; ++n2) {
                if (!((Instance)object).isMissing(this.m_DatasetKeyColumns[n2])) continue;
                throw new Exception("Instance has missing value in dataset key column " + (this.m_DatasetKeyColumns[n2] + 1) + "!\n" + object);
            }
            n2 = 0;
            for (int i = 0; i < this.m_Resultsets.size(); ++i) {
                Resultset resultset = (Resultset)this.m_Resultsets.elementAt(i);
                if (!resultset.matchesTemplate((Instance)object)) continue;
                resultset.add((Instance)object);
                n2 = 1;
                break;
            }
            if (n2 == 0) {
                Resultset resultset = new Resultset((Instance)object);
                this.m_Resultsets.addElement(resultset);
            }
            this.m_DatasetSpecifiers.add((Instance)object);
        }
        for (n = 0; n < this.m_Resultsets.size(); ++n) {
            object = (Resultset)this.m_Resultsets.elementAt(n);
            if (this.m_FoldColumn >= 0) {
                ((Resultset)object).sort(this.m_FoldColumn);
            }
            ((Resultset)object).sort(this.m_RunColumn);
        }
        this.m_ResultsetsValid = true;
    }

    public int getNumDatasets() {
        if (!this.m_ResultsetsValid) {
            try {
                this.prepareData();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return 0;
            }
        }
        return this.m_DatasetSpecifiers.numSpecifiers();
    }

    public int getNumResultsets() {
        if (!this.m_ResultsetsValid) {
            try {
                this.prepareData();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return 0;
            }
        }
        return this.m_Resultsets.size();
    }

    public String getResultsetName(int n) {
        if (!this.m_ResultsetsValid) {
            try {
                this.prepareData();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        return ((Resultset)this.m_Resultsets.elementAt(n)).templateString();
    }

    public boolean displayResultset(int n) {
        boolean bl = true;
        if (this.m_DisplayedResultsets != null) {
            bl = false;
            for (int i = 0; i < this.m_DisplayedResultsets.length; ++i) {
                if (this.m_DisplayedResultsets[i] != n) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public PairedStats calculateStatistics(Instance instance, int n, int n2, int n3) throws Exception {
        if (this.m_Instances.attribute(n3).type() != 0) {
            throw new Exception("Comparison column " + (n3 + 1) + " (" + this.m_Instances.attribute(n3).name() + ") is not numeric");
        }
        if (!this.m_ResultsetsValid) {
            this.prepareData();
        }
        Resultset resultset = (Resultset)this.m_Resultsets.elementAt(n);
        Resultset resultset2 = (Resultset)this.m_Resultsets.elementAt(n2);
        FastVector fastVector = resultset.dataset(instance);
        FastVector fastVector2 = resultset2.dataset(instance);
        String string = this.templateString(instance);
        if (fastVector == null) {
            throw new Exception("No results for dataset=" + string + " for resultset=" + resultset.templateString());
        }
        if (fastVector2 == null) {
            throw new Exception("No results for dataset=" + string + " for resultset=" + resultset2.templateString());
        }
        if (fastVector.size() != fastVector2.size()) {
            throw new Exception("Results for dataset=" + string + " differ in size for resultset=" + resultset.templateString() + " and resultset=" + resultset2.templateString());
        }
        PairedStats pairedStats = new PairedStats(this.m_SignificanceLevel);
        for (int i = 0; i < fastVector.size(); ++i) {
            Instance instance2 = (Instance)fastVector.elementAt(i);
            Instance instance3 = (Instance)fastVector2.elementAt(i);
            if (instance2.isMissing(n3)) {
                System.err.println("Instance has missing value in comparison column!\n" + instance2);
                continue;
            }
            if (instance3.isMissing(n3)) {
                System.err.println("Instance has missing value in comparison column!\n" + instance3);
                continue;
            }
            if (instance2.value(this.m_RunColumn) != instance3.value(this.m_RunColumn)) {
                System.err.println("Run numbers do not match!\n" + instance2 + instance3);
            }
            if (this.m_FoldColumn != -1 && instance2.value(this.m_FoldColumn) != instance3.value(this.m_FoldColumn)) {
                System.err.println("Fold numbers do not match!\n" + instance2 + instance3);
            }
            double d = instance2.value(n3);
            double d2 = instance3.value(n3);
            pairedStats.add(d, d2);
        }
        pairedStats.calculateDerived();
        return pairedStats;
    }

    public String resultsetKey() {
        if (!this.m_ResultsetsValid) {
            try {
                this.prepareData();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return exception.getMessage();
            }
        }
        String string = "";
        for (int i = 0; i < this.getNumResultsets(); ++i) {
            string = string + "(" + (i + 1) + ") " + this.getResultsetName(i) + '\n';
        }
        return string + '\n';
    }

    public String header(int n) {
        if (!this.m_ResultsetsValid) {
            try {
                this.prepareData();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return exception.getMessage();
            }
        }
        this.initResultMatrix();
        this.m_ResultMatrix.addHeader("Tester", this.getClass().getName());
        this.m_ResultMatrix.addHeader("Analysing", this.m_Instances.attribute(n).name());
        this.m_ResultMatrix.addHeader("Datasets", Integer.toString(this.getNumDatasets()));
        this.m_ResultMatrix.addHeader("Resultsets", Integer.toString(this.getNumResultsets()));
        this.m_ResultMatrix.addHeader("Confidence", this.getSignificanceLevel() + " (two tailed)");
        this.m_ResultMatrix.addHeader("Sorted by", this.getSortColumnName());
        this.m_ResultMatrix.addHeader("Date", new SimpleDateFormat().format(new Date()));
        return this.m_ResultMatrix.toStringHeader() + "\n";
    }

    public int[][] multiResultsetWins(int n, int[][] nArray) throws Exception {
        int n2 = this.getNumResultsets();
        int[][] nArray2 = new int[n2][n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = i + 1; j < n2; ++j) {
                System.err.print("Comparing (" + (i + 1) + ") with (" + (j + 1) + ")\r");
                System.err.flush();
                for (int k = 0; k < this.getNumDatasets(); ++k) {
                    try {
                        PairedStats pairedStats = this.calculateStatistics(this.m_DatasetSpecifiers.specifier(k), i, j, n);
                        if (pairedStats.differencesSignificance < 0) {
                            int[] nArray3 = nArray2[i];
                            int n3 = j;
                            nArray3[n3] = nArray3[n3] + 1;
                        } else if (pairedStats.differencesSignificance > 0) {
                            int[] nArray4 = nArray2[j];
                            int n4 = i;
                            nArray4[n4] = nArray4[n4] + 1;
                        }
                        if (pairedStats.differencesStats.mean < 0.0) {
                            int[] nArray5 = nArray[i];
                            int n5 = j;
                            nArray5[n5] = nArray5[n5] + 1;
                            continue;
                        }
                        if (!(pairedStats.differencesStats.mean > 0.0)) continue;
                        int[] nArray6 = nArray[j];
                        int n6 = i;
                        nArray6[n6] = nArray6[n6] + 1;
                        continue;
                    }
                    catch (Exception exception) {
                        System.err.println(exception.getMessage());
                    }
                }
            }
        }
        return nArray2;
    }

    protected void initResultMatrix() {
        int n;
        this.m_ResultMatrix.setSize(this.getNumResultsets(), this.getNumDatasets());
        this.m_ResultMatrix.setShowStdDev(this.m_ShowStdDevs);
        for (n = 0; n < this.getNumDatasets(); ++n) {
            this.m_ResultMatrix.setRowName(n, this.templateString(this.m_DatasetSpecifiers.specifier(n)));
        }
        for (n = 0; n < this.getNumResultsets(); ++n) {
            this.m_ResultMatrix.setColName(n, this.getResultsetName(n));
            this.m_ResultMatrix.setColHidden(n, !this.displayResultset(n));
        }
    }

    public String multiResultsetSummary(int n) throws Exception {
        int[][] nArray = new int[this.getNumResultsets()][this.getNumResultsets()];
        int[][] nArray2 = this.multiResultsetWins(n, nArray);
        this.initResultMatrix();
        this.m_ResultMatrix.setSummary(nArray, nArray2);
        return this.m_ResultMatrix.toStringSummary();
    }

    public String multiResultsetRanking(int n) throws Exception {
        int[][] nArray = new int[this.getNumResultsets()][this.getNumResultsets()];
        int[][] nArray2 = this.multiResultsetWins(n, nArray);
        this.initResultMatrix();
        this.m_ResultMatrix.setRanking(nArray2);
        return this.m_ResultMatrix.toStringRanking();
    }

    public String multiResultsetFull(int n, int n2) throws Exception {
        int n3;
        int n4;
        int n5 = 2;
        int n6 = 2;
        double[] dArray = new double[this.getNumDatasets()];
        for (n4 = 0; n4 < this.getNumDatasets(); ++n4) {
            dArray[n4] = Double.POSITIVE_INFINITY;
            for (n3 = 0; n3 < this.getNumResultsets(); ++n3) {
                if (!this.displayResultset(n3)) continue;
                try {
                    double d;
                    PairedStats pairedStats = this.calculateStatistics(this.m_DatasetSpecifiers.specifier(n4), n, n3, n2);
                    if (!Double.isInfinite(pairedStats.yStats.mean) && !Double.isNaN(pairedStats.yStats.mean) && (d = Math.log(Math.abs(pairedStats.yStats.mean)) / Math.log(10.0) + 1.0) > (double)n5) {
                        n5 = (int)d;
                    }
                    if (n3 == n) {
                        dArray[n4] = this.getSortColumn() != -1 ? this.calculateStatistics((Instance)this.m_DatasetSpecifiers.specifier((int)n4), (int)n, (int)n3, (int)this.getSortColumn()).xStats.mean : (double)n4;
                    }
                    if (!this.m_ShowStdDevs || Double.isInfinite(pairedStats.yStats.stdDev) || Double.isNaN(pairedStats.yStats.stdDev) || !((d = Math.log(Math.abs(pairedStats.yStats.stdDev)) / Math.log(10.0) + 1.0) > (double)n6)) continue;
                    n6 = (int)d;
                    continue;
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            }
        }
        this.m_SortOrder = Utils.sort(dArray);
        this.m_ColOrder = new int[this.getNumResultsets()];
        this.m_ColOrder[0] = n;
        n4 = 1;
        for (n3 = 0; n3 < this.getNumResultsets(); ++n3) {
            if (n3 == n) continue;
            this.m_ColOrder[n4] = n3;
            ++n4;
        }
        this.initResultMatrix();
        this.m_ResultMatrix.setRowOrder(this.m_SortOrder);
        this.m_ResultMatrix.setColOrder(this.m_ColOrder);
        this.m_ResultMatrix.setMeanWidth(n5);
        this.m_ResultMatrix.setStdDevWidth(n6);
        this.m_ResultMatrix.setSignificanceWidth(1);
        for (n3 = 0; n3 < this.m_ResultMatrix.getColCount(); ++n3) {
            if (n3 != n || !this.m_ResultMatrix.getColHidden(n3)) continue;
            this.m_ResultMatrix.setColHidden(n3, false);
            System.err.println("Note: test base was hidden - set visible!");
        }
        for (n3 = 0; n3 < this.getNumDatasets(); ++n3) {
            this.m_ResultMatrix.setRowName(n3, this.templateString(this.m_DatasetSpecifiers.specifier(n3)));
            for (int i = 0; i < this.getNumResultsets(); ++i) {
                try {
                    PairedStats pairedStats = this.calculateStatistics(this.m_DatasetSpecifiers.specifier(n3), n, i, n2);
                    this.m_ResultMatrix.setCount(n3, pairedStats.count);
                    this.m_ResultMatrix.setMean(i, n3, pairedStats.yStats.mean);
                    this.m_ResultMatrix.setStdDev(i, n3, pairedStats.yStats.stdDev);
                    if (pairedStats.differencesSignificance < 0) {
                        this.m_ResultMatrix.setSignificance(i, n3, 1);
                        continue;
                    }
                    if (pairedStats.differencesSignificance > 0) {
                        this.m_ResultMatrix.setSignificance(i, n3, 2);
                        continue;
                    }
                    this.m_ResultMatrix.setSignificance(i, n3, 0);
                    continue;
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            }
        }
        StringBuffer stringBuffer = new StringBuffer(1000);
        try {
            stringBuffer.append(this.m_ResultMatrix.toStringMatrix());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        stringBuffer.append("\n\n" + this.m_ResultMatrix.toStringKey());
        return stringBuffer.toString();
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tSpecify list of columns that specify a unique\n\tdataset.\n\tFirst and last are valid indexes. (default none)", "D", 1, "-D <index,index2-index4,...>"));
        vector.addElement(new Option("\tSet the index of the column containing the run number", "R", 1, "-R <index>"));
        vector.addElement(new Option("\tSet the index of the column containing the fold number", "F", 1, "-F <index>"));
        vector.addElement(new Option("\tSpecify list of columns that specify a unique\n\t'result generator' (eg: classifier name and options).\n\tFirst and last are valid indexes. (default none)", "G", 1, "-G <index1,index2-index4,...>"));
        vector.addElement(new Option("\tSet the significance level for comparisons (default 0.05)", "S", 1, "-S <significance level>"));
        vector.addElement(new Option("\tShow standard deviations", "V", 0, "-V"));
        vector.addElement(new Option("\tProduce table comparisons in Latex table format", "L", 0, "-L"));
        vector.addElement(new Option("\tProduce table comparisons in CSV table format", "csv", 0, "-csv"));
        vector.addElement(new Option("\tProduce table comparisons in HTML table format", "html", 0, "-html"));
        vector.addElement(new Option("\tProduce table comparisons with only the significance values", "significance", 0, "-significance"));
        vector.addElement(new Option("\tProduce table comparisons output suitable for GNUPlot", "gnuplot", 0, "-gnuplot"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setShowStdDevs(Utils.getFlag('V', stringArray));
        if (Utils.getFlag('L', stringArray)) {
            this.setResultMatrix(new ResultMatrixLatex());
        }
        if (Utils.getFlag("csv", stringArray)) {
            this.setResultMatrix(new ResultMatrixCSV());
        }
        if (Utils.getFlag("html", stringArray)) {
            this.setResultMatrix(new ResultMatrixHTML());
        }
        if (Utils.getFlag("significance", stringArray)) {
            this.setResultMatrix(new ResultMatrixSignificance());
        }
        String string = Utils.getOption('D', stringArray);
        Range range = new Range();
        if (string.length() != 0) {
            range.setRanges(string);
        }
        this.setDatasetKeyColumns(range);
        String string2 = Utils.getOption('R', stringArray);
        if (string2.length() != 0) {
            if (string2.equals("first")) {
                this.setRunColumn(0);
            } else if (string2.equals("last")) {
                this.setRunColumn(-1);
            } else {
                this.setRunColumn(Integer.parseInt(string2) - 1);
            }
        } else {
            this.setRunColumn(-1);
        }
        String string3 = Utils.getOption('F', stringArray);
        if (string3.length() != 0) {
            this.setFoldColumn(Integer.parseInt(string3) - 1);
        } else {
            this.setFoldColumn(-1);
        }
        String string4 = Utils.getOption('S', stringArray);
        if (string4.length() != 0) {
            this.setSignificanceLevel(new Double(string4));
        } else {
            this.setSignificanceLevel(0.05);
        }
        String string5 = Utils.getOption('G', stringArray);
        Range range2 = new Range();
        if (string5.length() != 0) {
            range2.setRanges(string5);
        }
        this.setResultsetKeyColumns(range2);
    }

    public String[] getOptions() {
        String[] stringArray = new String[11];
        int n = 0;
        if (!this.getResultsetKeyColumns().getRanges().equals("")) {
            stringArray[n++] = "-G";
            stringArray[n++] = this.getResultsetKeyColumns().getRanges();
        }
        if (!this.getDatasetKeyColumns().getRanges().equals("")) {
            stringArray[n++] = "-D";
            stringArray[n++] = this.getDatasetKeyColumns().getRanges();
        }
        stringArray[n++] = "-R";
        stringArray[n++] = "" + (this.getRunColumn() + 1);
        stringArray[n++] = "-S";
        stringArray[n++] = "" + this.getSignificanceLevel();
        if (this.getShowStdDevs()) {
            stringArray[n++] = "-V";
        }
        if (this.getResultMatrix().equals(class$weka$experiment$ResultMatrixLatex == null ? (class$weka$experiment$ResultMatrixLatex = PairedTTester.class$("weka.experiment.ResultMatrixLatex")) : class$weka$experiment$ResultMatrixLatex)) {
            stringArray[n++] = "-L";
        }
        if (this.getResultMatrix().equals(class$weka$experiment$ResultMatrixCSV == null ? (class$weka$experiment$ResultMatrixCSV = PairedTTester.class$("weka.experiment.ResultMatrixCSV")) : class$weka$experiment$ResultMatrixCSV)) {
            stringArray[n++] = "-csv";
        }
        if (this.getResultMatrix().equals(class$weka$experiment$ResultMatrixHTML == null ? (class$weka$experiment$ResultMatrixHTML = PairedTTester.class$("weka.experiment.ResultMatrixHTML")) : class$weka$experiment$ResultMatrixHTML)) {
            stringArray[n++] = "-html";
        }
        if (this.getResultMatrix().equals(class$weka$experiment$ResultMatrixSignificance == null ? (class$weka$experiment$ResultMatrixSignificance = PairedTTester.class$("weka.experiment.ResultMatrixSignificance")) : class$weka$experiment$ResultMatrixSignificance)) {
            stringArray[n++] = "-significance";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public Range getResultsetKeyColumns() {
        return this.m_ResultsetKeyColumnsRange;
    }

    public void setResultsetKeyColumns(Range range) {
        this.m_ResultsetKeyColumnsRange = range;
        this.m_ResultsetsValid = false;
    }

    public int[] getDisplayedResultsets() {
        return this.m_DisplayedResultsets;
    }

    public void setDisplayedResultsets(int[] nArray) {
        this.m_DisplayedResultsets = nArray;
    }

    public double getSignificanceLevel() {
        return this.m_SignificanceLevel;
    }

    public void setSignificanceLevel(double d) {
        this.m_SignificanceLevel = d;
    }

    public Range getDatasetKeyColumns() {
        return this.m_DatasetKeyColumnsRange;
    }

    public void setDatasetKeyColumns(Range range) {
        this.m_DatasetKeyColumnsRange = range;
        this.m_ResultsetsValid = false;
    }

    public int getRunColumn() {
        return this.m_RunColumnSet;
    }

    public void setRunColumn(int n) {
        this.m_RunColumnSet = n;
        this.m_ResultsetsValid = false;
    }

    public int getFoldColumn() {
        return this.m_FoldColumn;
    }

    public void setFoldColumn(int n) {
        this.m_FoldColumn = n;
        this.m_ResultsetsValid = false;
    }

    public String getSortColumnName() {
        if (this.getSortColumn() == -1) {
            return "-";
        }
        return this.m_Instances.attribute(this.getSortColumn()).name();
    }

    public int getSortColumn() {
        return this.m_SortColumn;
    }

    public void setSortColumn(int n) {
        if (n >= -1) {
            this.m_SortColumn = n;
        }
    }

    public Instances getInstances() {
        return this.m_Instances;
    }

    public void setInstances(Instances instances) {
        this.m_Instances = instances;
        this.m_ResultsetsValid = false;
    }

    public void assign(Tester tester) {
        this.setInstances(tester.getInstances());
        this.setResultMatrix(tester.getResultMatrix());
        this.setShowStdDevs(tester.getShowStdDevs());
        this.setResultsetKeyColumns(tester.getResultsetKeyColumns());
        this.setDisplayedResultsets(tester.getDisplayedResultsets());
        this.setSignificanceLevel(tester.getSignificanceLevel());
        this.setDatasetKeyColumns(tester.getDatasetKeyColumns());
        this.setRunColumn(tester.getRunColumn());
        this.setFoldColumn(tester.getFoldColumn());
        this.setSortColumn(tester.getSortColumn());
    }

    public String getToolTipText() {
        return "Performs test using t-test statistic";
    }

    public String getDisplayName() {
        return "Paired T-Tester";
    }

    public static void main(String[] stringArray) {
        try {
            PairedTTester pairedTTester = new PairedTTester();
            String string = Utils.getOption('t', stringArray);
            String string2 = Utils.getOption('c', stringArray);
            String string3 = Utils.getOption('b', stringArray);
            boolean bl = Utils.getFlag('s', stringArray);
            boolean bl2 = Utils.getFlag('r', stringArray);
            try {
                if (string.length() == 0 || string2.length() == 0) {
                    throw new Exception("-t and -c options are required");
                }
                pairedTTester.setOptions(stringArray);
                Utils.checkForRemainingOptions(stringArray);
            }
            catch (Exception exception) {
                String string4 = "";
                Enumeration enumeration = pairedTTester.listOptions();
                while (enumeration.hasMoreElements()) {
                    Option option = (Option)enumeration.nextElement();
                    string4 = string4 + option.synopsis() + '\n' + option.description() + '\n';
                }
                throw new Exception("Usage:\n\n-t <file>\n\tSet the dataset containing data to evaluate\n-b <index>\n\tSet the resultset to base comparisons against (optional)\n-c <index>\n\tSet the column to perform a comparison on\n-s\n\tSummarize wins over all resultset pairs\n\n-r\n\tGenerate a resultset ranking\n\n" + string4);
            }
            Instances instances = new Instances(new BufferedReader(new FileReader(string)));
            pairedTTester.setInstances(instances);
            int n = Integer.parseInt(string2) - 1;
            System.out.println(pairedTTester.header(n));
            if (bl2) {
                System.out.println(pairedTTester.multiResultsetRanking(n));
            } else if (bl) {
                System.out.println(pairedTTester.multiResultsetSummary(n));
            } else {
                System.out.println(pairedTTester.resultsetKey());
                if (string3.length() == 0) {
                    for (int i = 0; i < pairedTTester.getNumResultsets(); ++i) {
                        if (!pairedTTester.displayResultset(i)) continue;
                        System.out.println(pairedTTester.multiResultsetFull(i, n));
                    }
                } else {
                    int n2 = Integer.parseInt(string3) - 1;
                    System.out.println(pairedTTester.multiResultsetFull(n2, n));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class Resultset {
        Instance m_Template;
        FastVector m_Datasets;

        public Resultset(Instance instance) {
            this.m_Template = instance;
            this.m_Datasets = new FastVector();
            this.add(instance);
        }

        protected boolean matchesTemplate(Instance instance) {
            for (int i = 0; i < PairedTTester.this.m_ResultsetKeyColumns.length; ++i) {
                if (instance.value(PairedTTester.this.m_ResultsetKeyColumns[i]) == this.m_Template.value(PairedTTester.this.m_ResultsetKeyColumns[i])) continue;
                return false;
            }
            return true;
        }

        protected String templateString() {
            String string = "";
            String string2 = "";
            for (int i = 0; i < PairedTTester.this.m_ResultsetKeyColumns.length; ++i) {
                string2 = this.m_Template.toString(PairedTTester.this.m_ResultsetKeyColumns[i]) + ' ';
                string2 = Utils.removeSubstring(string2, "weka.classifiers.");
                string2 = Utils.removeSubstring(string2, "weka.filters.");
                string2 = Utils.removeSubstring(string2, "weka.attributeSelection.");
                string = string + string2;
            }
            return string.trim();
        }

        public FastVector dataset(Instance instance) {
            for (int i = 0; i < this.m_Datasets.size(); ++i) {
                if (!((Dataset)this.m_Datasets.elementAt(i)).matchesTemplate(instance)) continue;
                return ((Dataset)this.m_Datasets.elementAt(i)).contents();
            }
            return null;
        }

        public void add(Instance instance) {
            for (int i = 0; i < this.m_Datasets.size(); ++i) {
                if (!((Dataset)this.m_Datasets.elementAt(i)).matchesTemplate(instance)) continue;
                ((Dataset)this.m_Datasets.elementAt(i)).add(instance);
                return;
            }
            Dataset dataset = new Dataset(instance);
            this.m_Datasets.addElement(dataset);
        }

        public void sort(int n) {
            for (int i = 0; i < this.m_Datasets.size(); ++i) {
                ((Dataset)this.m_Datasets.elementAt(i)).sort(n);
            }
        }
    }

    protected class Dataset {
        Instance m_Template;
        FastVector m_Dataset;

        public Dataset(Instance instance) {
            this.m_Template = instance;
            this.m_Dataset = new FastVector();
            this.add(instance);
        }

        protected boolean matchesTemplate(Instance instance) {
            for (int i = 0; i < PairedTTester.this.m_DatasetKeyColumns.length; ++i) {
                if (instance.value(PairedTTester.this.m_DatasetKeyColumns[i]) == this.m_Template.value(PairedTTester.this.m_DatasetKeyColumns[i])) continue;
                return false;
            }
            return true;
        }

        protected void add(Instance instance) {
            this.m_Dataset.addElement(instance);
        }

        protected FastVector contents() {
            return this.m_Dataset;
        }

        public void sort(int n) {
            double[] dArray = new double[this.m_Dataset.size()];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = ((Instance)this.m_Dataset.elementAt(i)).value(n);
            }
            int[] nArray = Utils.stableSort(dArray);
            FastVector fastVector = new FastVector(dArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                fastVector.addElement(this.m_Dataset.elementAt(nArray[i]));
            }
            this.m_Dataset = fastVector;
        }
    }

    protected class DatasetSpecifiers {
        FastVector m_Specifiers = new FastVector();

        protected DatasetSpecifiers() {
        }

        protected void removeAllSpecifiers() {
            this.m_Specifiers.removeAllElements();
        }

        protected void add(Instance instance) {
            for (int i = 0; i < this.m_Specifiers.size(); ++i) {
                Instance instance2 = (Instance)this.m_Specifiers.elementAt(i);
                boolean bl = true;
                for (int j = 0; j < PairedTTester.this.m_DatasetKeyColumns.length; ++j) {
                    if (instance.value(PairedTTester.this.m_DatasetKeyColumns[j]) == instance2.value(PairedTTester.this.m_DatasetKeyColumns[j])) continue;
                    bl = false;
                }
                if (!bl) continue;
                return;
            }
            this.m_Specifiers.addElement(instance);
        }

        protected Instance specifier(int n) {
            return (Instance)this.m_Specifiers.elementAt(n);
        }

        protected int numSpecifiers() {
            return this.m_Specifiers.size();
        }
    }
}

