/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.ensembleLibraryEditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import weka.classifiers.EnsembleLibraryModel;
import weka.classifiers.meta.ensembleSelection.EnsembleSelectionLibrary;
import weka.classifiers.meta.ensembleSelection.EnsembleSelectionLibraryModel;
import weka.gui.EnsembleSelectionLibraryEditor;
import weka.gui.ensembleLibraryEditor.ListModelsPanel;
import weka.gui.ensembleLibraryEditor.ModelList;

public class LoadModelsPanel
extends JPanel
implements ActionListener,
PropertyChangeListener,
ChangeListener {
    private static final long serialVersionUID = -6961209378227736515L;
    private ListModelsPanel m_ListModelsPanel;
    private JLabel m_LoadingLabel;
    private JLabel m_DirectoryLabel;
    private JButton m_RefreshListButton;
    private JButton m_RemoveSelectedButton;
    private JButton m_AddAllButton;
    private JButton m_AddSelectedButton;
    private ModelList m_ModelList;
    private EnsembleSelectionLibrary m_Library;
    private EnsembleSelectionLibraryEditor m_EnsembleLibraryEditor;
    private boolean m_workingDirectoryChanged = false;

    public LoadModelsPanel(ListModelsPanel listModelsPanel, EnsembleSelectionLibraryEditor ensembleSelectionLibraryEditor) {
        this.m_ListModelsPanel = listModelsPanel;
        this.m_EnsembleLibraryEditor = ensembleSelectionLibraryEditor;
        this.createLoadModelsPanel();
    }

    private void createLoadModelsPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.m_RefreshListButton = new JButton("Reload List");
        this.m_RefreshListButton.setToolTipText("Discover the set of models existing in the current working directory");
        this.m_RefreshListButton.addActionListener(this);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)this.m_RefreshListButton, gridBagConstraints);
        this.m_DirectoryLabel = new JLabel("");
        this.updateDirectoryLabel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 3;
        this.add((Component)this.m_DirectoryLabel, gridBagConstraints);
        this.m_LoadingLabel = new JLabel("");
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 3;
        this.add((Component)this.m_LoadingLabel, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Working Set of Loadable Models"));
        this.m_ModelList = new ModelList();
        this.m_ModelList.getInputMap().put(KeyStroke.getKeyStroke("released DELETE"), "deleteSelected");
        this.m_ModelList.getActionMap().put("deleteSelected", new AbstractAction("deleteSelected"){
            private static final long serialVersionUID = 4557836979081722983L;

            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = LoadModelsPanel.this.m_ModelList.getSelectedValues();
                ModelList.SortedListModel sortedListModel = (ModelList.SortedListModel)LoadModelsPanel.this.m_ModelList.getModel();
                for (int i = 0; i < objectArray.length; ++i) {
                    sortedListModel.removeElement((EnsembleLibraryModel)objectArray[i]);
                }
                int[] nArray = new int[]{LoadModelsPanel.this.m_ModelList.getSelectedIndices()[0]};
                LoadModelsPanel.this.m_ModelList.setSelectedIndices(nArray);
            }
        });
        this.m_ModelList.setSelectionMode(2);
        this.m_ModelList.setLayoutOrientation(0);
        ToolTipManager.sharedInstance().registerComponent(this.m_ModelList);
        JScrollPane jScrollPane = new JScrollPane(this.m_ModelList);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setPreferredSize(new Dimension(150, 50));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        this.add((Component)jPanel, gridBagConstraints);
        this.m_RemoveSelectedButton = new JButton("Remove Selected");
        this.m_RemoveSelectedButton.setToolTipText("Remove all selected models from the above list");
        this.m_RemoveSelectedButton.addActionListener(this);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)this.m_RemoveSelectedButton, gridBagConstraints);
        this.m_AddSelectedButton = new JButton("Add Selected");
        this.m_AddSelectedButton.setToolTipText("Add selected models in the above list to the model library");
        this.m_AddSelectedButton.addActionListener(this);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)this.m_AddSelectedButton, gridBagConstraints);
        this.m_AddAllButton = new JButton("Add All");
        this.m_AddAllButton.setToolTipText("Add all models in the above list to the model library");
        this.m_AddAllButton.addActionListener(this);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)this.m_AddAllButton, gridBagConstraints);
    }

    public void setLibrary(EnsembleSelectionLibrary ensembleSelectionLibrary) {
        this.m_Library = ensembleSelectionLibrary;
        this.updateDirectoryLabel();
        this.loadModels();
    }

    public void loadModels() {
        ModelList.SortedListModel sortedListModel = (ModelList.SortedListModel)this.m_ModelList.getModel();
        int n = 0;
        int n2 = 0;
        sortedListModel.clear();
        File file = this.m_Library.getWorkingDirectory();
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isDirectory() || !fileArray[i].getName().matches(".*_instances_.*")) continue;
                ++n;
                File[] fileArray2 = fileArray[i].listFiles();
                for (int j = 0; j < fileArray2.length; ++j) {
                    if (!fileArray2[j].getName().matches(".*.elm")) continue;
                    EnsembleSelectionLibraryModel ensembleSelectionLibraryModel = EnsembleSelectionLibraryModel.loadModel(fileArray2[j].getPath());
                    ensembleSelectionLibraryModel.releaseModel();
                    if (sortedListModel.contains(ensembleSelectionLibraryModel)) continue;
                    ++n2;
                    sortedListModel.add(ensembleSelectionLibraryModel);
                }
            }
        }
        this.updateLoadingLabel(n2, n);
    }

    public void updateDirectoryLabel() {
        if (this.m_Library != null) {
            this.m_DirectoryLabel.setText("Directory: " + this.m_Library.getWorkingDirectory());
        }
    }

    public void updateLoadingLabel(int n, int n2) {
        this.m_LoadingLabel.setText(" " + n + " unique model descriptions found in " + n2 + " directories");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ModelList.SortedListModel sortedListModel = (ModelList.SortedListModel)this.m_ModelList.getModel();
        if (actionEvent.getSource() == this.m_RefreshListButton) {
            this.updateDirectoryLabel();
            this.loadModels();
        } else if (actionEvent.getSource() == this.m_RemoveSelectedButton) {
            Object[] objectArray = this.m_ModelList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                sortedListModel.removeElement(objectArray[i]);
            }
            if (this.m_ModelList.getSelectedIndices().length > 0) {
                int[] nArray = new int[]{this.m_ModelList.getSelectedIndices()[0]};
                this.m_ModelList.setSelectedIndices(nArray);
            }
        } else if (actionEvent.getSource() == this.m_AddAllButton) {
            Iterator iterator = sortedListModel.iterator();
            while (iterator.hasNext()) {
                EnsembleLibraryModel ensembleLibraryModel = (EnsembleLibraryModel)iterator.next();
                this.m_ListModelsPanel.addModel(ensembleLibraryModel);
            }
            sortedListModel.clear();
        } else if (actionEvent.getSource() == this.m_AddSelectedButton) {
            Object[] objectArray = this.m_ModelList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                this.m_ListModelsPanel.addModel((EnsembleLibraryModel)objectArray[i]);
                sortedListModel.removeElement(objectArray[i]);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.m_EnsembleLibraryEditor.isLoadModelsPanelSelected()) {
            this.updateDirectoryLabel();
            this.loadModels();
        } else {
            this.m_workingDirectoryChanged = true;
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
        if (jTabbedPane.getSelectedComponent().equals(this) && this.m_workingDirectoryChanged) {
            this.updateDirectoryLabel();
            this.loadModels();
            this.m_workingDirectoryChanged = false;
        }
    }
}

