/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.IntervalEstimator;
import weka.classifiers.functions.supportVector.Kernel;
import weka.classifiers.functions.supportVector.PolyKernel;
import weka.classifiers.functions.supportVector.RBFKernel;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SelectedTag;
import weka.core.Statistics;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.matrix.LUDecomposition;
import weka.core.matrix.Matrix;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.Normalize;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;
import weka.filters.unsupervised.attribute.Standardize;

public class GaussianProcesses
extends Classifier
implements OptionHandler,
IntervalEstimator,
TechnicalInformationHandler {
    static final long serialVersionUID = -8620066949967678545L;
    protected NominalToBinary m_NominalToBinary;
    public static final int FILTER_NORMALIZE = 0;
    public static final int FILTER_STANDARDIZE = 1;
    public static final int FILTER_NONE = 2;
    public static final Tag[] TAGS_FILTER = new Tag[]{new Tag(0, "Normalize training data"), new Tag(1, "Standardize training data"), new Tag(2, "No normalization/standardization")};
    protected Filter m_Filter = null;
    protected int m_filterType = 0;
    protected ReplaceMissingValues m_Missing;
    protected boolean m_checksTurnedOff = false;
    protected double m_delta = 1.0;
    protected int m_classIndex = -1;
    protected double m_Alin;
    protected double m_Blin;
    protected Kernel m_kernel = new RBFKernel();
    protected int m_NumTrain = 0;
    protected double m_avg_target;
    protected Matrix m_C;
    protected Matrix m_t;
    protected boolean m_KernelIsLinear = false;

    public GaussianProcesses() {
        ((RBFKernel)this.m_kernel).setGamma(1.0);
    }

    public String globalInfo() {
        return "Implements Gaussian Processes for regression without hyperparameter-tuning. For more information see\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.MISC);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "David J.C. Mackay");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1998");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Introduction to Gaussian Processes");
        technicalInformation.setValue(TechnicalInformation.Field.ADDRESS, "Dept. of Physics, Cambridge University, UK");
        technicalInformation.setValue(TechnicalInformation.Field.PS, "http://wol.ra.phy.cam.ac.uk/mackay/gpB.ps.gz");
        return technicalInformation;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = this.getKernel().getCapabilities();
        capabilities.setOwner(this);
        capabilities.enableAllAttributeDependencies();
        if (capabilities.handles(Capabilities.Capability.NUMERIC_ATTRIBUTES)) {
            capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        }
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.disableAllClasses();
        capabilities.disableAllClassDependencies();
        capabilities.enable(Capabilities.Capability.NUMERIC_CLASS);
        capabilities.enable(Capabilities.Capability.DATE_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        if (!this.m_checksTurnedOff) {
            this.getCapabilities().testWithFail(instances);
            instances = new Instances(instances);
            instances.deleteWithMissingClass();
        }
        if (!this.m_checksTurnedOff) {
            this.m_Missing = new ReplaceMissingValues();
            this.m_Missing.setInputFormat(instances);
            instances = Filter.useFilter(instances, this.m_Missing);
        } else {
            this.m_Missing = null;
        }
        if (this.getCapabilities().handles(Capabilities.Capability.NUMERIC_ATTRIBUTES)) {
            boolean bl = true;
            if (!this.m_checksTurnedOff) {
                for (int i = 0; i < instances.numAttributes(); ++i) {
                    if (i == instances.classIndex() || instances.attribute(i).isNumeric()) continue;
                    bl = false;
                    break;
                }
            }
            if (!bl) {
                this.m_NominalToBinary = new NominalToBinary();
                this.m_NominalToBinary.setInputFormat(instances);
                instances = Filter.useFilter(instances, this.m_NominalToBinary);
            } else {
                this.m_NominalToBinary = null;
            }
        } else {
            this.m_NominalToBinary = null;
        }
        this.m_classIndex = instances.classIndex();
        if (this.m_filterType == 1) {
            this.m_Filter = new Standardize();
            this.m_Filter.setInputFormat(instances);
            instances = Filter.useFilter(instances, this.m_Filter);
        } else if (this.m_filterType == 0) {
            this.m_Filter = new Normalize();
            this.m_Filter.setInputFormat(instances);
            instances = Filter.useFilter(instances, this.m_Filter);
        } else {
            this.m_Filter = null;
        }
        this.m_NumTrain = instances.numInstances();
        if (this.m_Filter != null) {
            Instance instance = (Instance)instances.instance(0).copy();
            instance.setValue(this.m_classIndex, 0.0);
            this.m_Filter.input(instance);
            this.m_Filter.batchFinished();
            Instance instance2 = this.m_Filter.output();
            this.m_Blin = instance2.value(this.m_classIndex);
            instance.setValue(this.m_classIndex, 1.0);
            this.m_Filter.input(instance);
            this.m_Filter.batchFinished();
            instance2 = this.m_Filter.output();
            this.m_Alin = instance2.value(this.m_classIndex) - this.m_Blin;
        } else {
            this.m_Alin = 1.0;
            this.m_Blin = 0.0;
        }
        this.m_kernel.buildKernel(instances);
        this.m_KernelIsLinear = this.m_kernel instanceof PolyKernel && ((PolyKernel)this.m_kernel).getExponent() == 1.0;
        this.m_C = new Matrix(instances.numInstances(), instances.numInstances());
        double d = 0.0;
        for (int i = 0; i < instances.numInstances(); ++i) {
            d += instances.instance(i).classValue();
            for (int j = 0; j < i; ++j) {
                double d2 = this.m_kernel.eval(i, j, instances.instance(i));
                this.m_C.set(i, j, d2);
                this.m_C.set(j, i, d2);
            }
            double d3 = this.m_kernel.eval(i, i, instances.instance(i));
            this.m_C.set(i, i, d3 + this.m_delta * this.m_delta);
        }
        this.m_avg_target = d / (double)instances.numInstances();
        LUDecomposition lUDecomposition = new LUDecomposition(this.m_C);
        if (!lUDecomposition.isNonsingular()) {
            throw new Exception("Singular Matrix?!?");
        }
        Matrix matrix = Matrix.identity(instances.numInstances(), instances.numInstances());
        this.m_C = lUDecomposition.solve(matrix);
        this.m_t = new Matrix(instances.numInstances(), 1);
        for (int i = 0; i < instances.numInstances(); ++i) {
            this.m_t.set(i, 0, instances.instance(i).classValue() - this.m_avg_target);
        }
        this.m_t = this.m_C.times(this.m_t);
    }

    public double classifyInstance(Instance instance) throws Exception {
        if (!this.m_checksTurnedOff) {
            this.m_Missing.input(instance);
            this.m_Missing.batchFinished();
            instance = this.m_Missing.output();
        }
        if (this.m_NominalToBinary != null) {
            this.m_NominalToBinary.input(instance);
            this.m_NominalToBinary.batchFinished();
            instance = this.m_NominalToBinary.output();
        }
        if (this.m_Filter != null) {
            this.m_Filter.input(instance);
            this.m_Filter.batchFinished();
            instance = this.m_Filter.output();
        }
        Matrix matrix = new Matrix(this.m_NumTrain, 1);
        for (int i = 0; i < this.m_NumTrain; ++i) {
            matrix.set(i, 0, this.m_kernel.eval(-1, i, instance));
        }
        double d = matrix.transpose().times(this.m_t).get(0, 0) + this.m_avg_target;
        return d;
    }

    public double[][] predictInterval(Instance instance, double d) throws Exception {
        if (!this.m_checksTurnedOff) {
            this.m_Missing.input(instance);
            this.m_Missing.batchFinished();
            instance = this.m_Missing.output();
        }
        if (this.m_NominalToBinary != null) {
            this.m_NominalToBinary.input(instance);
            this.m_NominalToBinary.batchFinished();
            instance = this.m_NominalToBinary.output();
        }
        if (this.m_Filter != null) {
            this.m_Filter.input(instance);
            this.m_Filter.batchFinished();
            instance = this.m_Filter.output();
        }
        Matrix matrix = new Matrix(this.m_NumTrain, 1);
        for (int i = 0; i < this.m_NumTrain; ++i) {
            matrix.set(i, 0, this.m_kernel.eval(-1, i, instance));
        }
        double d2 = this.m_kernel.eval(-1, -1, instance) + this.m_delta * this.m_delta;
        double d3 = matrix.transpose().times(this.m_t).get(0, 0) + this.m_avg_target;
        double d4 = Math.sqrt(d2 - matrix.transpose().times(this.m_C).times(matrix).get(0, 0));
        d = 1.0 - (1.0 - d) / 2.0;
        double d5 = Statistics.normalInverse(d);
        double[][] dArray = new double[1][2];
        dArray[0][0] = d3 - d5 * d4;
        dArray[0][1] = d3 + d5 * d4;
        return dArray;
    }

    public double getStandardDeviation(Instance instance) throws Exception {
        if (!this.m_checksTurnedOff) {
            this.m_Missing.input(instance);
            this.m_Missing.batchFinished();
            instance = this.m_Missing.output();
        }
        if (this.m_NominalToBinary != null) {
            this.m_NominalToBinary.input(instance);
            this.m_Alin = 1.0;
            this.m_Blin = 0.0;
            this.m_NominalToBinary.batchFinished();
            instance = this.m_NominalToBinary.output();
        }
        if (this.m_Filter != null) {
            this.m_Filter.input(instance);
            this.m_Filter.batchFinished();
            instance = this.m_Filter.output();
        }
        Matrix matrix = new Matrix(this.m_NumTrain, 1);
        for (int i = 0; i < this.m_NumTrain; ++i) {
            matrix.set(i, 0, this.m_kernel.eval(-1, i, instance));
        }
        double d = this.m_kernel.eval(-1, -1, instance) + this.m_delta * this.m_delta;
        double d2 = d - matrix.transpose().times(this.m_C).times(matrix).get(0, 0);
        if (d2 < 0.0) {
            System.out.println("Aiaiai: variance is negative (" + d2 + ")!!!");
        }
        double d3 = Math.sqrt(d2);
        return d3;
    }

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        vector.addElement(new Option("\tLevel of Gaussian Noise.\n\t(default: 1.0)", "L", 1, "-L <double>"));
        vector.addElement(new Option("\tWhether to 0=normalize/1=standardize/2=neither.\n\t(default: 0=normalize)", "N", 1, "-N"));
        vector.addElement(new Option("\tThe Kernel to use.\n\t(default: weka.classifiers.functions.supportVector.PolyKernel)", "K", 1, "-K <classname and parameters>"));
        vector.addElement(new Option("", "", 0, "\nOptions specific to kernel " + this.getKernel().getClass().getName() + ":"));
        enumeration = this.getKernel().listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('L', stringArray);
        if (string.length() != 0) {
            this.setNoise(Double.parseDouble(string));
        } else {
            this.setNoise(1.0);
        }
        string = Utils.getOption('N', stringArray);
        if (string.length() != 0) {
            this.setFilterType(new SelectedTag(Integer.parseInt(string), TAGS_FILTER));
        } else {
            this.setFilterType(new SelectedTag(0, TAGS_FILTER));
        }
        string = Utils.getOption('K', stringArray);
        String[] stringArray2 = Utils.splitOptions(string);
        if (stringArray2.length != 0) {
            string = stringArray2[0];
            stringArray2[0] = "";
            this.setKernel(Kernel.forName(string, stringArray2));
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-L");
        vector.add("" + this.getNoise());
        vector.add("-N");
        vector.add("" + this.m_filterType);
        vector.add("-K");
        vector.add("" + this.m_kernel.getClass().getName() + " " + Utils.joinOptions(this.m_kernel.getOptions()));
        return vector.toArray(new String[vector.size()]);
    }

    public String kernelTipText() {
        return "The kernel to use.";
    }

    public Kernel getKernel() {
        return this.m_kernel;
    }

    public void setKernel(Kernel kernel) {
        this.m_kernel = kernel;
    }

    public String filterTypeTipText() {
        return "Determines how/if the data will be transformed.";
    }

    public SelectedTag getFilterType() {
        return new SelectedTag(this.m_filterType, TAGS_FILTER);
    }

    public void setFilterType(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_FILTER) {
            this.m_filterType = selectedTag.getSelectedTag().getID();
        }
    }

    public String noiseTipText() {
        return "The level of Gaussian Noise (added to the diagonal of the Covariance Matrix).";
    }

    public double getNoise() {
        return this.m_delta;
    }

    public void setNoise(double d) {
        this.m_delta = d;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_t == null) {
            return "Gaussian Processes: No model built yet.";
        }
        try {
            int n;
            stringBuffer.append("Gaussian Processes\n\n");
            stringBuffer.append("Kernel used:\n  " + this.m_kernel.toString() + "\n\n");
            stringBuffer.append("Average Target Value : " + this.m_avg_target + "\n");
            stringBuffer.append("Inverted Covariance Matrix:\n");
            double d = this.m_C.get(0, 0);
            double d2 = this.m_C.get(0, 0);
            for (n = 0; n < this.m_NumTrain; ++n) {
                for (int i = 0; i < this.m_NumTrain; ++i) {
                    if (this.m_C.get(n, i) < d) {
                        d = this.m_C.get(n, i);
                        continue;
                    }
                    if (!(this.m_C.get(n, i) > d2)) continue;
                    d2 = this.m_C.get(n, i);
                }
            }
            stringBuffer.append("    Lowest Value = " + d + "\n");
            stringBuffer.append("    Highest Value = " + d2 + "\n");
            stringBuffer.append("Inverted Covariance Matrix * Target-value Vector:\n");
            d = this.m_t.get(0, 0);
            d2 = this.m_t.get(0, 0);
            for (n = 0; n < this.m_NumTrain; ++n) {
                if (this.m_t.get(n, 0) < d) {
                    d = this.m_t.get(n, 0);
                    continue;
                }
                if (!(this.m_t.get(n, 0) > d2)) continue;
                d2 = this.m_t.get(n, 0);
            }
            stringBuffer.append("    Lowest Value = " + d + "\n");
            stringBuffer.append("    Highest Value = " + d2 + "\n \n");
        }
        catch (Exception exception) {
            return "Can't print the classifier.";
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        GaussianProcesses.runClassifier(new GaussianProcesses(), stringArray);
    }
}

