/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class ListOptions
implements OptionHandler,
RevisionHandler {
    protected String m_Classname = ListOptions.class.getName();

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tThe class to load.", "W", 1, "-W <classname>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('W', stringArray);
        if (string.length() > 0) {
            this.setClassname(string);
        } else {
            this.setClassname(this.getClass().getName());
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add("-W");
        vector.add(this.getClassname());
        return vector.toArray(new String[vector.size()]);
    }

    public void setClassname(String string) {
        this.m_Classname = string;
    }

    public String getClassname() {
        return this.m_Classname;
    }

    public String generateHelp() {
        String string = this.getClass().getName().replaceAll(".*\\.", "") + " Options:\n\n";
        Enumeration enumeration = this.listOptions();
        while (enumeration.hasMoreElements()) {
            Option option = (Option)enumeration.nextElement();
            string = string + option.synopsis() + "\n" + option.description() + "\n";
        }
        return string;
    }

    public String generate() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        OptionHandler optionHandler = (OptionHandler)Class.forName(this.getClassname()).newInstance();
        Enumeration enumeration = optionHandler.listOptions();
        while (enumeration.hasMoreElements()) {
            Option option = (Option)enumeration.nextElement();
            stringBuffer.append(option.synopsis() + '\n');
            stringBuffer.append(option.description() + "\n");
        }
        return stringBuffer.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.2 $");
    }

    public static void main(String[] stringArray) {
        ListOptions listOptions = new ListOptions();
        try {
            try {
                if (Utils.getFlag('h', stringArray)) {
                    throw new Exception("Help requested");
                }
                listOptions.setOptions(stringArray);
                Utils.checkForRemainingOptions(stringArray);
            }
            catch (Exception exception) {
                String string = "\n" + exception.getMessage() + "\n\n" + listOptions.generateHelp();
                throw new Exception(string);
            }
            System.out.println("\n" + listOptions.generate());
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }
}

