/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.IOException;
import java.io.PrintWriter;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.BatchConverter;
import weka.core.converters.IncrementalConverter;

public class ArffSaver
extends AbstractFileSaver
implements BatchConverter,
IncrementalConverter {
    static final long serialVersionUID = 2223634248900042228L;

    public ArffSaver() {
        this.resetOptions();
    }

    public String globalInfo() {
        return "Writes to a destination that is in arff (attribute relation file format) format. ";
    }

    public String getFileDescription() {
        return "Arff data files";
    }

    public void resetOptions() {
        super.resetOptions();
        this.setFileExtension(".arff");
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enableAllAttributes();
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enableAllClasses();
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    public void writeIncremental(Instance instance) throws IOException {
        int n = this.getWriteMode();
        Instances instances = this.getInstances();
        PrintWriter printWriter = null;
        if (this.getRetrieval() == 1 || this.getRetrieval() == 0) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        if (this.getWriter() != null) {
            printWriter = new PrintWriter(this.getWriter());
        }
        if (n == 1) {
            if (instances == null) {
                this.setWriteMode(2);
                if (instance != null) {
                    System.err.println("Structure(Header Information) has to be set in advance");
                }
            } else {
                this.setWriteMode(3);
            }
            n = this.getWriteMode();
        }
        if (n == 2) {
            if (printWriter != null) {
                printWriter.close();
            }
            this.cancel();
        }
        if (n == 3) {
            this.setWriteMode(0);
            Instances instances2 = new Instances(instances, 0);
            if (this.retrieveFile() == null || printWriter == null) {
                System.out.println(instances2.toString());
            } else {
                printWriter.print(instances2.toString());
                printWriter.print("\n");
                printWriter.flush();
            }
            n = this.getWriteMode();
        }
        if (n == 0) {
            if (instances == null) {
                throw new IOException("No instances information available.");
            }
            if (instance != null) {
                if (this.retrieveFile() == null || printWriter == null) {
                    System.out.println(instance);
                } else {
                    printWriter.println(instance);
                    ++this.m_incrementalCounter;
                    if (this.m_incrementalCounter > 100) {
                        this.m_incrementalCounter = 0;
                        printWriter.flush();
                    }
                }
            } else {
                if (printWriter != null) {
                    printWriter.flush();
                    printWriter.close();
                }
                this.m_incrementalCounter = 0;
                this.resetStructure();
                printWriter = null;
                this.resetWriter();
            }
        }
    }

    public void writeBatch() throws IOException {
        if (this.getInstances() == null) {
            throw new IOException("No instances to save");
        }
        if (this.getRetrieval() == 2) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        this.setRetrieval(1);
        this.setWriteMode(0);
        if (this.retrieveFile() == null && this.getWriter() == null) {
            System.out.println(this.getInstances().toString());
            this.setWriteMode(1);
            return;
        }
        PrintWriter printWriter = new PrintWriter(this.getWriter());
        printWriter.print(this.getInstances().toString());
        printWriter.flush();
        printWriter.close();
        this.setWriteMode(1);
        printWriter = null;
        this.resetWriter();
        this.setWriteMode(2);
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.8 $");
    }

    public static void main(String[] stringArray) {
        ArffSaver.runFileSaver(new ArffSaver(), stringArray);
    }
}

