/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.EuclideanDistance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.neighboursearch.NearestNeighbourSearch;
import weka.core.neighboursearch.TreePerformanceStats;
import weka.core.neighboursearch.balltrees.BallNode;
import weka.core.neighboursearch.balltrees.BallTreeConstructor;
import weka.core.neighboursearch.balltrees.TopDownConstructor;

public class BallTree
extends NearestNeighbourSearch
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 728763855952698328L;
    protected int[] m_InstList;
    protected int m_MaxInstancesInLeaf = 40;
    protected TreePerformanceStats m_TreeStats = null;
    protected BallNode m_Root;
    protected BallTreeConstructor m_TreeConstructor = new TopDownConstructor();
    protected double[] m_Distances;

    public BallTree() {
        if (this.getMeasurePerformance()) {
            this.m_TreeStats = new TreePerformanceStats();
            this.m_Stats = this.m_TreeStats;
        }
    }

    public BallTree(Instances instances) {
        super(instances);
        if (this.getMeasurePerformance()) {
            this.m_TreeStats = new TreePerformanceStats();
            this.m_Stats = this.m_TreeStats;
        }
    }

    public String globalInfo() {
        return "Class implementing the BallTree/Metric Tree algorithm for nearest neighbour search.\nThe connection to dataset is only a reference. For the tree structure the indexes are stored in an array.\nSee the implementing classes of different construction methods of the trees for details on its construction.\n\nFor more information see also:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.TECHREPORT);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Stephen M. Omohundro");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1989");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Five Balltree Construction Algorithms");
        technicalInformation.setValue(TechnicalInformation.Field.MONTH, "December");
        technicalInformation.setValue(TechnicalInformation.Field.NUMBER, "TR-89-063");
        technicalInformation.setValue(TechnicalInformation.Field.INSTITUTION, "International Computer Science Institute");
        TechnicalInformation technicalInformation2 = technicalInformation.add(TechnicalInformation.Type.ARTICLE);
        technicalInformation2.setValue(TechnicalInformation.Field.AUTHOR, "Jeffrey K. Uhlmann");
        technicalInformation2.setValue(TechnicalInformation.Field.TITLE, "Satisfying general proximity/similarity queries with metric trees");
        technicalInformation2.setValue(TechnicalInformation.Field.JOURNAL, "Information Processing Letters");
        technicalInformation2.setValue(TechnicalInformation.Field.MONTH, "November");
        technicalInformation2.setValue(TechnicalInformation.Field.YEAR, "1991");
        technicalInformation2.setValue(TechnicalInformation.Field.NUMBER, "4");
        technicalInformation2.setValue(TechnicalInformation.Field.VOLUME, "40");
        technicalInformation2.setValue(TechnicalInformation.Field.PAGES, "175-179");
        return technicalInformation;
    }

    protected void buildTree() throws Exception {
        if (this.m_Instances == null) {
            throw new Exception("No instances supplied yet. Have to call setInstances(instances) with a set of Instances first.");
        }
        this.m_InstList = new int[this.m_Instances.numInstances()];
        for (int i = 0; i < this.m_InstList.length; ++i) {
            this.m_InstList[i] = i;
        }
        this.m_DistanceFunction.setInstances(this.m_Instances);
        this.m_TreeConstructor.setInstances(this.m_Instances);
        this.m_TreeConstructor.setInstanceList(this.m_InstList);
        this.m_TreeConstructor.setEuclideanDistanceFunction((EuclideanDistance)this.m_DistanceFunction);
        this.m_Root = this.m_TreeConstructor.buildTree();
    }

    public Instances kNearestNeighbours(Instance instance, int n) throws Exception {
        NearestNeighbourSearch.MyHeapElement myHeapElement;
        NearestNeighbourSearch.MyHeap myHeap = new NearestNeighbourSearch.MyHeap(this, n);
        if (this.m_Stats != null) {
            this.m_Stats.searchStart();
        }
        this.nearestNeighbours(myHeap, this.m_Root, instance, n);
        if (this.m_Stats != null) {
            this.m_Stats.searchFinish();
        }
        Instances instances = new Instances(this.m_Instances, myHeap.totalSize());
        this.m_Distances = new double[myHeap.totalSize()];
        int[] nArray = new int[myHeap.totalSize()];
        int n2 = 1;
        while (myHeap.noOfKthNearest() > 0) {
            myHeapElement = myHeap.getKthNearest();
            nArray[nArray.length - n2] = myHeapElement.index;
            this.m_Distances[nArray.length - n2] = myHeapElement.distance;
            ++n2;
        }
        while (myHeap.size() > 0) {
            myHeapElement = myHeap.get();
            nArray[nArray.length - n2] = myHeapElement.index;
            this.m_Distances[nArray.length - n2] = myHeapElement.distance;
            ++n2;
        }
        this.m_DistanceFunction.postProcessDistances(this.m_Distances);
        for (n2 = 0; n2 < nArray.length; ++n2) {
            instances.add(this.m_Instances.instance(nArray[n2]));
        }
        return instances;
    }

    protected void nearestNeighbours(NearestNeighbourSearch.MyHeap myHeap, BallNode ballNode, Instance instance, int n) throws Exception {
        double d = Double.NEGATIVE_INFINITY;
        if (myHeap.totalSize() >= n) {
            d = this.m_DistanceFunction.distance(instance, ballNode.getPivot());
        }
        if (d > -1.0E-6 && Math.sqrt(myHeap.peek().distance) < d - ballNode.getRadius()) {
            return;
        }
        if (ballNode.m_Left != null && ballNode.m_Right != null) {
            if (this.m_TreeStats != null) {
                this.m_TreeStats.incrIntNodeCount();
            }
            double d2 = Math.sqrt(this.m_DistanceFunction.distance(instance, ballNode.m_Left.getPivot(), Double.POSITIVE_INFINITY));
            double d3 = Math.sqrt(this.m_DistanceFunction.distance(instance, ballNode.m_Right.getPivot(), Double.POSITIVE_INFINITY));
            double d4 = d2 - ballNode.m_Left.getRadius();
            double d5 = d3 - ballNode.m_Right.getRadius();
            if (d4 < 0.0 && d5 < 0.0) {
                if (d2 < d3) {
                    this.nearestNeighbours(myHeap, ballNode.m_Left, instance, n);
                    this.nearestNeighbours(myHeap, ballNode.m_Right, instance, n);
                } else {
                    this.nearestNeighbours(myHeap, ballNode.m_Right, instance, n);
                    this.nearestNeighbours(myHeap, ballNode.m_Left, instance, n);
                }
            } else if (d4 < d5) {
                this.nearestNeighbours(myHeap, ballNode.m_Left, instance, n);
                this.nearestNeighbours(myHeap, ballNode.m_Right, instance, n);
            } else {
                this.nearestNeighbours(myHeap, ballNode.m_Right, instance, n);
                this.nearestNeighbours(myHeap, ballNode.m_Left, instance, n);
            }
        } else {
            if (ballNode.m_Left != null || ballNode.m_Right != null) {
                throw new Exception("Error: Only one leaf of the built ball tree is assigned. Please check code.");
            }
            if (ballNode.m_Left == null && ballNode.m_Right == null) {
                if (this.m_TreeStats != null) {
                    this.m_TreeStats.updatePointCount(ballNode.numInstances());
                    this.m_TreeStats.incrLeafCount();
                }
                for (int i = ballNode.m_Start; i <= ballNode.m_End; ++i) {
                    if (instance == this.m_Instances.instance(this.m_InstList[i])) continue;
                    if (myHeap.totalSize() < n) {
                        d = this.m_DistanceFunction.distance(instance, this.m_Instances.instance(this.m_InstList[i]), Double.POSITIVE_INFINITY, this.m_Stats);
                        myHeap.put(this.m_InstList[i], d);
                        continue;
                    }
                    NearestNeighbourSearch.MyHeapElement myHeapElement = myHeap.peek();
                    d = this.m_DistanceFunction.distance(instance, this.m_Instances.instance(this.m_InstList[i]), myHeapElement.distance, this.m_Stats);
                    if (d < myHeapElement.distance) {
                        myHeap.putBySubstitute(this.m_InstList[i], d);
                        continue;
                    }
                    if (d != myHeapElement.distance) continue;
                    myHeap.putKthNearest(this.m_InstList[i], d);
                }
            }
        }
    }

    public Instance nearestNeighbour(Instance instance) throws Exception {
        return this.kNearestNeighbours(instance, 1).instance(0);
    }

    public double[] getDistances() throws Exception {
        if (this.m_Distances == null) {
            throw new Exception("No distances available. Please call either kNearestNeighbours or nearestNeighbours first.");
        }
        return this.m_Distances;
    }

    public void update(Instance instance) throws Exception {
        this.addInstanceInfo(instance);
        this.m_InstList = this.m_TreeConstructor.addInstance(this.m_Root, instance);
    }

    public void addInstanceInfo(Instance instance) {
        if (this.m_Instances != null) {
            this.m_DistanceFunction.update(instance);
        }
    }

    public void setInstances(Instances instances) throws Exception {
        super.setInstances(instances);
        this.buildTree();
    }

    public String ballTreeConstructorTipText() {
        return "The tree constructor being used.";
    }

    public BallTreeConstructor getBallTreeConstructor() {
        return this.m_TreeConstructor;
    }

    public void setBallTreeConstructor(BallTreeConstructor ballTreeConstructor) {
        this.m_TreeConstructor = ballTreeConstructor;
    }

    public double measureTreeSize() {
        return this.m_TreeConstructor.getNumNodes();
    }

    public double measureNumLeaves() {
        return this.m_TreeConstructor.getNumLeaves();
    }

    public double measureMaxDepth() {
        return this.m_TreeConstructor.getMaxDepth();
    }

    public Enumeration enumerateMeasures() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("measureTreeSize");
        vector.addElement("measureNumLeaves");
        vector.addElement("measureMaxDepth");
        if (this.m_Stats != null) {
            Enumeration enumeration = this.m_Stats.enumerateMeasures();
            while (enumeration.hasMoreElements()) {
                vector.addElement((String)enumeration.nextElement());
            }
        }
        return vector.elements();
    }

    public double getMeasure(String string) {
        if (string.compareToIgnoreCase("measureMaxDepth") == 0) {
            return this.measureMaxDepth();
        }
        if (string.compareToIgnoreCase("measureTreeSize") == 0) {
            return this.measureTreeSize();
        }
        if (string.compareToIgnoreCase("measureNumLeaves") == 0) {
            return this.measureNumLeaves();
        }
        if (this.m_Stats != null) {
            return this.m_Stats.getMeasure(string);
        }
        throw new IllegalArgumentException(string + " not supported (BallTree)");
    }

    public void setMeasurePerformance(boolean bl) {
        this.m_MeasurePerformance = bl;
        if (this.m_MeasurePerformance) {
            if (this.m_Stats == null) {
                this.m_TreeStats = new TreePerformanceStats();
                this.m_Stats = this.m_TreeStats;
            }
        } else {
            this.m_TreeStats = null;
            this.m_Stats = null;
        }
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tThe construction method to employ. Either TopDown or BottomUp\n\t(default: weka.core.TopDownConstructor)", "C", 1, "-C <classname and options>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        String string = Utils.getOption('C', stringArray);
        if (string.length() != 0) {
            String[] stringArray2 = Utils.splitOptions(string);
            if (stringArray2.length == 0) {
                throw new Exception("Invalid BallTreeConstructor specification string.");
            }
            String string2 = stringArray2[0];
            stringArray2[0] = "";
            this.setBallTreeConstructor((BallTreeConstructor)Utils.forName(BallTreeConstructor.class, string2, stringArray2));
        } else {
            this.setBallTreeConstructor(new TopDownConstructor());
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-C");
        vector.add((this.m_TreeConstructor.getClass().getName() + " " + Utils.joinOptions(this.m_TreeConstructor.getOptions())).trim());
        return vector.toArray(new String[vector.size()]);
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.2 $");
    }
}

