/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.evaluation;

import java.io.InputStreamReader;
import weka.classifiers.evaluation.EvaluationUtils;
import weka.classifiers.evaluation.NominalPrediction;
import weka.classifiers.meta.LogitBoost;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class MarginCurve
implements RevisionHandler {
    public Instances getCurve(FastVector fastVector) {
        if (fastVector.size() == 0) {
            return null;
        }
        Instances instances = this.makeHeader();
        double[] dArray = this.getMargins(fastVector);
        int[] nArray = Utils.sort(dArray);
        int n = 0;
        int n2 = 0;
        instances.add(this.makeInstance(-1.0, n, n2));
        for (int i = 0; i < nArray.length; ++i) {
            double d = dArray[nArray[i]];
            double d2 = ((NominalPrediction)fastVector.elementAt(nArray[i])).weight();
            n2 = (int)((double)n2 + d2);
            n = (int)((double)n + d2);
            instances.add(this.makeInstance(d, n, n2));
            n = 0;
        }
        return instances;
    }

    private double[] getMargins(FastVector fastVector) {
        double[] dArray = new double[fastVector.size()];
        for (int i = 0; i < dArray.length; ++i) {
            NominalPrediction nominalPrediction = (NominalPrediction)fastVector.elementAt(i);
            dArray[i] = nominalPrediction.margin();
        }
        return dArray;
    }

    private Instances makeHeader() {
        FastVector fastVector = new FastVector();
        fastVector.addElement(new Attribute("Margin"));
        fastVector.addElement(new Attribute("Current"));
        fastVector.addElement(new Attribute("Cumulative"));
        return new Instances("MarginCurve", fastVector, 100);
    }

    private Instance makeInstance(double d, int n, int n2) {
        int n3 = 0;
        double[] dArray = new double[3];
        dArray[n3++] = d;
        dArray[n3++] = n;
        dArray[n3++] = n2;
        return new Instance(1.0, dArray);
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.11 $");
    }

    public static void main(String[] stringArray) {
        try {
            Utils.SMALL = 0.0;
            Instances instances = new Instances(new InputStreamReader(System.in));
            instances.setClassIndex(instances.numAttributes() - 1);
            MarginCurve marginCurve = new MarginCurve();
            EvaluationUtils evaluationUtils = new EvaluationUtils();
            LogitBoost logitBoost = new LogitBoost();
            logitBoost.setNumIterations(20);
            FastVector fastVector = evaluationUtils.getTrainTestPredictions(logitBoost, instances, instances);
            Instances instances2 = marginCurve.getCurve(fastVector);
            System.out.println(instances2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

