/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.io.Serializable;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weka.core.Attribute;
import weka.core.pmml.Expression;
import weka.core.pmml.FieldMetaInfo;
import weka.core.pmml.TransformationDictionary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerivedFieldMetaInfo
extends FieldMetaInfo
implements Serializable {
    protected String m_displayName = null;
    protected ArrayList<FieldMetaInfo.Value> m_values = new ArrayList();
    protected Expression m_expression;

    public DerivedFieldMetaInfo(Element element, ArrayList<Attribute> arrayList, TransformationDictionary transformationDictionary) throws Exception {
        super(element);
        NodeList nodeList;
        String string = element.getAttribute("displayName");
        if (string != null && string.length() > 0) {
            this.m_displayName = string;
        }
        if ((nodeList = element.getElementsByTagName("Value")).getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                FieldMetaInfo.Value value = new FieldMetaInfo.Value((Element)node);
                this.m_values.add(value);
            }
        }
        this.m_expression = Expression.getExpression(element, this.m_optype, arrayList, transformationDictionary);
    }

    public void setFieldDefs(ArrayList<Attribute> arrayList) throws Exception {
        this.m_expression.setFieldDefs(arrayList);
    }

    @Override
    public Attribute getFieldAsAttribute() {
        return this.m_expression.getOutputDef().copy(this.m_fieldName);
    }

    public double getDerivedValue(double[] dArray) throws Exception {
        return this.m_expression.getResult(dArray);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getFieldAsAttribute() + "\nexpression:\n");
        stringBuffer.append(this.m_expression + "\n");
        return stringBuffer.toString();
    }
}

