/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import weka.core.Tag;
import weka.gui.GenericObjectEditor;
import weka.gui.PropertySheetPanel;
import weka.gui.beans.CustomizerCloseRequester;
import weka.gui.beans.SerializedModelSaver;

public class SerializedModelSaverCustomizer
extends JPanel
implements Customizer,
CustomizerCloseRequester {
    private static final long serialVersionUID = -4874208115942078471L;
    private PropertyChangeSupport m_pcSupport = new PropertyChangeSupport(this);
    private SerializedModelSaver m_smSaver;
    private PropertySheetPanel m_SaverEditor = new PropertySheetPanel();
    private JFileChooser m_fileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
    private JFrame m_parentFrame;
    private JTextField m_prefixText;
    private JComboBox m_fileFormatBox;
    private JCheckBox m_relativeFilePath;

    public SerializedModelSaverCustomizer() {
        try {
            this.m_SaverEditor.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    SerializedModelSaverCustomizer.this.repaint();
                    if (SerializedModelSaverCustomizer.this.m_smSaver != null) {
                        System.err.println("Property change!!");
                    }
                }
            });
            this.repaint();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setLayout(new BorderLayout());
        this.m_fileChooser.setDialogType(1);
        this.m_fileChooser.setFileSelectionMode(1);
        this.m_fileChooser.setApproveButtonText("Select directory and prefix");
        this.m_fileChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("ApproveSelection")) {
                    try {
                        SerializedModelSaverCustomizer.this.m_smSaver.setPrefix(SerializedModelSaverCustomizer.this.m_prefixText.getText());
                        SerializedModelSaverCustomizer.this.m_smSaver.setDirectory(SerializedModelSaverCustomizer.this.m_fileChooser.getSelectedFile());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (SerializedModelSaverCustomizer.this.m_parentFrame != null) {
                    SerializedModelSaverCustomizer.this.m_parentFrame.dispose();
                }
            }
        });
    }

    public void setParentFrame(JFrame jFrame) {
        this.m_parentFrame = jFrame;
    }

    private void setUpOther() {
        this.removeAll();
        this.add((Component)this.m_SaverEditor, "Center");
        this.validate();
        this.repaint();
    }

    public void setUpFile() {
        JPanel jPanel;
        JComponent jComponent;
        Serializable serializable;
        this.removeAll();
        this.m_fileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }

            public String getDescription() {
                return "Directory";
            }
        });
        this.m_fileChooser.setAcceptAllFileFilterUsed(false);
        try {
            if (!this.m_smSaver.getDirectory().getPath().equals("")) {
                serializable = this.m_smSaver.getDirectory();
                serializable = new File(((File)serializable).getAbsolutePath());
                this.m_fileChooser.setCurrentDirectory((File)serializable);
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        serializable = new JPanel();
        ((Container)serializable).setLayout(new BorderLayout());
        try {
            this.m_prefixText = new JTextField(this.m_smSaver.getPrefix(), 25);
            jComponent = new JLabel("Prefix for file name:", 2);
            jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)jComponent, "West");
            jPanel.add((Component)this.m_prefixText, "Center");
            ((Container)serializable).add(jPanel, "South");
            JPanel jPanel2 = new JPanel();
            jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            jPanel2.setLayout(new BorderLayout());
            jPanel2.add((Component)new JLabel(" File format:"), "West");
            this.setUpFileFormatComboBox();
            jPanel2.add((Component)this.m_fileFormatBox, "Center");
            ((Container)serializable).add(jPanel2, "Center");
        }
        catch (Exception exception) {
            // empty catch block
        }
        jComponent = this.m_SaverEditor.getAboutPanel();
        if (jComponent != null) {
            ((Container)serializable).add(jComponent, "North");
        }
        this.add((Component)serializable, "North");
        this.add((Component)this.m_fileChooser, "Center");
        this.m_relativeFilePath = new JCheckBox("Use relative file paths");
        this.m_relativeFilePath.setSelected(this.m_smSaver.getUseRelativePath());
        this.m_relativeFilePath.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SerializedModelSaverCustomizer.this.m_smSaver.setUseRelativePath(SerializedModelSaverCustomizer.this.m_relativeFilePath.isSelected());
            }
        });
        jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.add(this.m_relativeFilePath);
        this.add((Component)jPanel, "South");
    }

    public void setObject(Object object) {
        this.m_smSaver = (SerializedModelSaver)object;
        this.m_SaverEditor.setTarget(this.m_smSaver);
        this.setUpFile();
    }

    private void setUpFileFormatComboBox() {
        this.m_fileFormatBox = new JComboBox();
        for (int i = 0; i < SerializedModelSaver.s_fileFormatsAvailable.size(); ++i) {
            Tag tag = SerializedModelSaver.s_fileFormatsAvailable.get(i);
            this.m_fileFormatBox.addItem(tag);
        }
        Tag tag = this.m_smSaver.validateFileFormat(this.m_smSaver.getFileFormat());
        if (tag == null) {
            this.m_fileFormatBox.setSelectedIndex(0);
        } else {
            this.m_fileFormatBox.setSelectedItem(tag);
        }
        this.m_fileFormatBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Tag tag = (Tag)SerializedModelSaverCustomizer.this.m_fileFormatBox.getSelectedItem();
                if (tag != null) {
                    SerializedModelSaverCustomizer.this.m_smSaver.setFileFormat(tag);
                }
            }
        });
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_pcSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_pcSupport.removePropertyChangeListener(propertyChangeListener);
    }

    static {
        GenericObjectEditor.registerEditors();
    }
}

