/*
 * Decompiled with CFR 0.152.
 */
package weka.associations.gsp;

import java.io.Serializable;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class Element
implements Cloneable,
Serializable,
RevisionHandler {
    private static final long serialVersionUID = -7900701276019516371L;
    protected int[] m_Events;

    public Element() {
    }

    public Element(int n) {
        this.m_Events = new int[n];
    }

    public static FastVector getOneElements(Instances instances) {
        FastVector fastVector = new FastVector();
        for (int i = 0; i < instances.numAttributes(); ++i) {
            int n = 0;
            while (n < instances.attribute(i).numValues()) {
                Element element = new Element();
                element.setEvents(new int[instances.numAttributes()]);
                for (int j = 0; j < instances.numAttributes(); ++j) {
                    element.getEvents()[j] = -1;
                }
                element.getEvents()[i] = n++;
                fastVector.addElement(element);
            }
        }
        return fastVector;
    }

    public static Element merge(Element element, Element element2) {
        int[] nArray = element.getEvents();
        int[] nArray2 = element2.getEvents();
        Element element3 = new Element(nArray.length);
        int[] nArray3 = element3.getEvents();
        for (int i = 0; i < nArray.length; ++i) {
            nArray3[i] = nArray2[i] > -1 ? nArray2[i] : nArray[i];
        }
        element3.setEvents(nArray3);
        return element3;
    }

    public Element clone() {
        try {
            Element element = (Element)super.clone();
            int[] nArray = new int[this.m_Events.length];
            for (int i = 0; i < this.m_Events.length; ++i) {
                nArray[i] = this.m_Events[i];
            }
            element.setEvents(nArray);
            return element;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
    }

    public boolean containsOverOneEvent() {
        int n = 0;
        for (int i = 0; i < this.m_Events.length; ++i) {
            if (this.m_Events[i] > -1) {
                ++n;
            }
            if (n != 2) continue;
            return true;
        }
        return false;
    }

    public void deleteEvent(String string) {
        int n;
        if (string.equals("first")) {
            for (n = 0; n < this.m_Events.length; ++n) {
                if (this.m_Events[n] <= -1) continue;
                this.m_Events[n] = -1;
                break;
            }
        }
        if (string.equals("last")) {
            for (n = this.m_Events.length - 1; n >= 0; --n) {
                if (this.m_Events[n] <= -1) continue;
                this.m_Events[n] = -1;
                break;
            }
        }
    }

    public boolean equals(Object object) {
        Element element = (Element)object;
        for (int i = 0; i < this.m_Events.length; ++i) {
            if (this.m_Events[i] == element.getEvents()[i]) continue;
            return false;
        }
        return true;
    }

    public int[] getEvents() {
        return this.m_Events;
    }

    public boolean isContainedBy(Instance instance) {
        for (int i = 0; i < instance.numAttributes(); ++i) {
            if (this.m_Events[i] <= -1) continue;
            if (instance.isMissing(i)) {
                return false;
            }
            if (this.m_Events[i] == (int)instance.value(i)) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.m_Events.length; ++i) {
            if (this.m_Events[i] <= -1) continue;
            return false;
        }
        return true;
    }

    protected void setEvents(int[] nArray) {
        this.m_Events = nArray;
    }

    public String toNominalString(Instances instances) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        stringBuffer.append("{");
        for (int i = 0; i < this.m_Events.length; ++i) {
            if (this.m_Events[i] <= -1) continue;
            stringBuffer.append(instances.attribute(i).value(this.m_Events[i]) + ",");
            ++n;
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public String toString() {
        String string = "";
        string = string + "{";
        for (int i = 0; i < this.m_Events.length; ++i) {
            string = string + this.m_Events[i];
            if (i + 1 >= this.m_Events.length) continue;
            string = string + ",";
        }
        string = string + "}";
        return string;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.2 $");
    }
}

