/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers.forOPTICSAndDBScan.Databases;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import weka.clusterers.forOPTICSAndDBScan.DataObjects.DataObject;
import weka.clusterers.forOPTICSAndDBScan.Databases.Database;
import weka.clusterers.forOPTICSAndDBScan.Utils.EpsilonRange_ListElement;
import weka.clusterers.forOPTICSAndDBScan.Utils.PriorityQueue;
import weka.clusterers.forOPTICSAndDBScan.Utils.PriorityQueueElement;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class SequentialDatabase
implements Database,
Serializable,
RevisionHandler {
    private static final long serialVersionUID = 787245523118665778L;
    private TreeMap treeMap;
    private Instances instances;
    private double[] attributeMinValues;
    private double[] attributeMaxValues;

    public SequentialDatabase(Instances instances) {
        this.instances = instances;
        this.treeMap = new TreeMap();
    }

    public DataObject getDataObject(String string) {
        return (DataObject)this.treeMap.get(string);
    }

    public void setMinMaxValues() {
        this.attributeMinValues = new double[this.getInstances().numAttributes()];
        this.attributeMaxValues = new double[this.getInstances().numAttributes()];
        for (int i = 0; i < this.getInstances().numAttributes(); ++i) {
            this.attributeMaxValues[i] = Double.NaN;
            this.attributeMinValues[i] = Double.NaN;
        }
        Iterator iterator = this.dataObjectIterator();
        while (iterator.hasNext()) {
            DataObject dataObject = (DataObject)iterator.next();
            for (int i = 0; i < this.getInstances().numAttributes(); ++i) {
                if (Double.isNaN(this.attributeMinValues[i])) {
                    this.attributeMinValues[i] = dataObject.getInstance().value(i);
                    this.attributeMaxValues[i] = dataObject.getInstance().value(i);
                    continue;
                }
                if (dataObject.getInstance().value(i) < this.attributeMinValues[i]) {
                    this.attributeMinValues[i] = dataObject.getInstance().value(i);
                }
                if (!(dataObject.getInstance().value(i) > this.attributeMaxValues[i])) continue;
                this.attributeMaxValues[i] = dataObject.getInstance().value(i);
            }
        }
    }

    public double[] getAttributeMinValues() {
        return this.attributeMinValues;
    }

    public double[] getAttributeMaxValues() {
        return this.attributeMaxValues;
    }

    public List epsilonRangeQuery(double d, DataObject dataObject) {
        ArrayList<DataObject> arrayList = new ArrayList<DataObject>();
        Iterator iterator = this.dataObjectIterator();
        while (iterator.hasNext()) {
            DataObject dataObject2 = (DataObject)iterator.next();
            double d2 = dataObject.distance(dataObject2);
            if (!(d2 < d)) continue;
            arrayList.add(dataObject2);
        }
        return arrayList;
    }

    public List k_nextNeighbourQuery(int n, double d, DataObject dataObject) {
        Iterator iterator = this.dataObjectIterator();
        ArrayList arrayList = new ArrayList();
        ArrayList<PriorityQueueElement> arrayList2 = new ArrayList<PriorityQueueElement>();
        ArrayList<EpsilonRange_ListElement> arrayList3 = new ArrayList<EpsilonRange_ListElement>();
        PriorityQueue priorityQueue = new PriorityQueue();
        while (iterator.hasNext()) {
            DataObject dataObject2 = (DataObject)iterator.next();
            double d2 = dataObject.distance(dataObject2);
            if (d2 <= d) {
                arrayList3.add(new EpsilonRange_ListElement(d2, dataObject2));
            }
            if (priorityQueue.size() < n) {
                priorityQueue.add(d2, dataObject2);
                continue;
            }
            if (!(d2 < priorityQueue.getPriority(0))) continue;
            priorityQueue.next();
            priorityQueue.add(d2, dataObject2);
        }
        while (priorityQueue.hasNext()) {
            arrayList2.add(0, priorityQueue.next());
        }
        arrayList.add(arrayList2);
        arrayList.add(arrayList3);
        return arrayList;
    }

    public List coreDistance(int n, double d, DataObject dataObject) {
        List list = this.k_nextNeighbourQuery(n, d, dataObject);
        if (((List)list.get(1)).size() < n) {
            list.add(new Double(2.147483647E9));
            return list;
        }
        List list2 = (List)list.get(0);
        PriorityQueueElement priorityQueueElement = (PriorityQueueElement)list2.get(list2.size() - 1);
        if (priorityQueueElement.getPriority() <= d) {
            list.add(new Double(priorityQueueElement.getPriority()));
            return list;
        }
        list.add(new Double(2.147483647E9));
        return list;
    }

    public int size() {
        return this.treeMap.size();
    }

    public Iterator keyIterator() {
        return this.treeMap.keySet().iterator();
    }

    public Iterator dataObjectIterator() {
        return this.treeMap.values().iterator();
    }

    public boolean contains(DataObject dataObject) {
        Iterator iterator = this.dataObjectIterator();
        while (iterator.hasNext()) {
            DataObject dataObject2 = (DataObject)iterator.next();
            if (!dataObject2.equals(dataObject)) continue;
            return true;
        }
        return false;
    }

    public void insert(DataObject dataObject) {
        this.treeMap.put(dataObject.getKey(), dataObject);
    }

    public Instances getInstances() {
        return this.instances;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.4 $");
    }
}

