/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.neighboursearch.NearestNeighbourSearch;

public class LinearNNSearch
extends NearestNeighbourSearch {
    private static final long serialVersionUID = 1915484723703917241L;
    protected double[] m_Distances;
    protected boolean m_SkipIdentical = false;

    public LinearNNSearch() {
    }

    public LinearNNSearch(Instances instances) {
        super(instances);
        this.m_DistanceFunction.setInstances(instances);
    }

    public String globalInfo() {
        return "Class implementing the brute force search algorithm for nearest neighbour search.";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.add(new Option("\tSkip identical instances (distances equal to zero).\n", "S", 1, "-S"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        this.setSkipIdentical(Utils.getFlag('S', stringArray));
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        if (this.getSkipIdentical()) {
            vector.add("-S");
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String skipIdenticalTipText() {
        return "Whether to skip identical instances (with distance 0 to the target)";
    }

    public void setSkipIdentical(boolean bl) {
        this.m_SkipIdentical = bl;
    }

    public boolean getSkipIdentical() {
        return this.m_SkipIdentical;
    }

    public Instance nearestNeighbour(Instance instance) throws Exception {
        return this.kNearestNeighbours(instance, 1).instance(0);
    }

    public Instances kNearestNeighbours(Instance instance, int n) throws Exception {
        NearestNeighbourSearch.MyHeapElement myHeapElement;
        Object object;
        boolean bl = false;
        if (this.m_Stats != null) {
            this.m_Stats.searchStart();
        }
        NearestNeighbourSearch.MyHeap myHeap = new NearestNeighbourSearch.MyHeap(this, n);
        int n2 = 0;
        for (int i = 0; i < this.m_Instances.numInstances(); ++i) {
            double d;
            if (instance == this.m_Instances.instance(i)) continue;
            if (this.m_Stats != null) {
                this.m_Stats.incrPointCount();
            }
            if (n2 < n) {
                if (bl) {
                    System.out.println("K(a): " + (myHeap.size() + myHeap.noOfKthNearest()));
                }
                if ((d = this.m_DistanceFunction.distance(instance, this.m_Instances.instance(i), Double.POSITIVE_INFINITY, this.m_Stats)) == 0.0 && this.m_SkipIdentical) {
                    if (i < this.m_Instances.numInstances() - 1) continue;
                    myHeap.put(i, d);
                }
                myHeap.put(i, d);
                ++n2;
                continue;
            }
            object = myHeap.peek();
            if (bl) {
                System.out.println("K(b): " + (myHeap.size() + myHeap.noOfKthNearest()));
            }
            if ((d = this.m_DistanceFunction.distance(instance, this.m_Instances.instance(i), ((NearestNeighbourSearch.MyHeapElement)object).distance, this.m_Stats)) == 0.0 && this.m_SkipIdentical) continue;
            if (d < ((NearestNeighbourSearch.MyHeapElement)object).distance) {
                myHeap.putBySubstitute(i, d);
                continue;
            }
            if (d != ((NearestNeighbourSearch.MyHeapElement)object).distance) continue;
            myHeap.putKthNearest(i, d);
        }
        Instances instances = new Instances(this.m_Instances, myHeap.size() + myHeap.noOfKthNearest());
        this.m_Distances = new double[myHeap.size() + myHeap.noOfKthNearest()];
        object = new int[myHeap.size() + myHeap.noOfKthNearest()];
        int n3 = 1;
        while (myHeap.noOfKthNearest() > 0) {
            myHeapElement = myHeap.getKthNearest();
            object[((Object)object).length - n3] = myHeapElement.index;
            this.m_Distances[((Object)object).length - n3] = myHeapElement.distance;
            ++n3;
        }
        while (myHeap.size() > 0) {
            myHeapElement = myHeap.get();
            object[((Object)object).length - n3] = myHeapElement.index;
            this.m_Distances[((Object)object).length - n3] = myHeapElement.distance;
            ++n3;
        }
        this.m_DistanceFunction.postProcessDistances(this.m_Distances);
        for (int i = 0; i < ((Object)object).length; ++i) {
            instances.add(this.m_Instances.instance((int)object[i]));
        }
        if (this.m_Stats != null) {
            this.m_Stats.searchFinish();
        }
        return instances;
    }

    public double[] getDistances() throws Exception {
        if (this.m_Distances == null) {
            throw new Exception("No distances available. Please call either kNearestNeighbours or nearestNeighbours first.");
        }
        return this.m_Distances;
    }

    public void setInstances(Instances instances) throws Exception {
        this.m_Instances = instances;
        this.m_DistanceFunction.setInstances(instances);
    }

    public void update(Instance instance) throws Exception {
        if (this.m_Instances == null) {
            throw new Exception("No instances supplied yet. Cannot update withoutsupplying a set of instances first.");
        }
        this.m_DistanceFunction.update(instance);
    }

    public void addInstanceInfo(Instance instance) {
        if (this.m_Instances != null) {
            try {
                this.update(instance);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.2 $");
    }
}

