/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48;

import java.util.Enumeration;
import weka.classifiers.trees.j48.ClassifierSplitModel;
import weka.classifiers.trees.j48.Distribution;
import weka.classifiers.trees.j48.ModelSelection;
import weka.classifiers.trees.j48.NBTreeNoSplit;
import weka.classifiers.trees.j48.NBTreeSplit;
import weka.core.Attribute;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class NBTreeModelSelection
extends ModelSelection {
    private static final long serialVersionUID = 990097748931976704L;
    private int m_minNoObj;
    private Instances m_allData;

    public NBTreeModelSelection(int n, Instances instances) {
        this.m_minNoObj = n;
        this.m_allData = instances;
    }

    public void cleanup() {
        this.m_allData = null;
    }

    public final ClassifierSplitModel selectModel(Instances instances) {
        double d = 0.0;
        NBTreeSplit nBTreeSplit = null;
        NBTreeNoSplit nBTreeNoSplit = null;
        int n = 0;
        boolean bl = true;
        try {
            int n2;
            nBTreeNoSplit = new NBTreeNoSplit();
            nBTreeNoSplit.buildClassifier(instances);
            if (instances.numInstances() < 5) {
                return nBTreeNoSplit;
            }
            d = nBTreeNoSplit.getErrors();
            if (d == 0.0) {
                return nBTreeNoSplit;
            }
            Distribution distribution = new Distribution(instances);
            if (Utils.sm(distribution.total(), this.m_minNoObj) || Utils.eq(distribution.total(), distribution.perClass(distribution.maxClass()))) {
                return nBTreeNoSplit;
            }
            if (this.m_allData != null) {
                Enumeration enumeration = instances.enumerateAttributes();
                while (enumeration.hasMoreElements()) {
                    Attribute attribute = (Attribute)enumeration.nextElement();
                    if (!attribute.isNumeric() && !Utils.sm(attribute.numValues(), 0.3 * (double)this.m_allData.numInstances())) continue;
                    bl = false;
                    break;
                }
            }
            NBTreeSplit[] nBTreeSplitArray = new NBTreeSplit[instances.numAttributes()];
            double d2 = instances.sumOfWeights();
            for (n2 = 0; n2 < instances.numAttributes(); ++n2) {
                if (n2 != instances.classIndex()) {
                    nBTreeSplitArray[n2] = new NBTreeSplit(n2, this.m_minNoObj, d2);
                    nBTreeSplitArray[n2].setGlobalModel(nBTreeNoSplit);
                    nBTreeSplitArray[n2].buildClassifier(instances);
                    if (!nBTreeSplitArray[n2].checkModel()) continue;
                    ++n;
                    continue;
                }
                nBTreeSplitArray[n2] = null;
            }
            if (n == 0) {
                return nBTreeNoSplit;
            }
            double d3 = d;
            for (n2 = 0; n2 < instances.numAttributes(); ++n2) {
                if (n2 == instances.classIndex() || !nBTreeSplitArray[n2].checkModel() || !(nBTreeSplitArray[n2].getErrors() < d3)) continue;
                nBTreeSplit = nBTreeSplitArray[n2];
                d3 = nBTreeSplitArray[n2].getErrors();
            }
            if ((d - d3) / d < 0.05) {
                return nBTreeNoSplit;
            }
            return nBTreeSplit;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public final ClassifierSplitModel selectModel(Instances instances, Instances instances2) {
        return this.selectModel(instances);
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.5 $");
    }
}

