/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch.balltrees;

import java.io.Serializable;
import weka.core.DistanceFunction;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class BallNode
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = -8289151861759883510L;
    public int m_Start;
    public int m_End;
    public int m_NumInstances;
    public int m_NodeNumber;
    public int m_SplitAttrib = -1;
    public double m_SplitVal = -1.0;
    public BallNode m_Left = null;
    public BallNode m_Right = null;
    protected Instance m_Pivot;
    protected double m_Radius;

    public BallNode(int n) {
        this.m_NodeNumber = n;
    }

    public BallNode(int n, int n2, int n3) {
        this.m_Start = n;
        this.m_End = n2;
        this.m_NodeNumber = n3;
        this.m_NumInstances = n2 - n + 1;
    }

    public BallNode(int n, int n2, int n3, Instance instance, double d) {
        this.m_Start = n;
        this.m_End = n2;
        this.m_NodeNumber = n3;
        this.m_Pivot = instance;
        this.m_Radius = d;
        this.m_NumInstances = n2 - n + 1;
    }

    public boolean isALeaf() {
        return this.m_Left == null && this.m_Right == null;
    }

    public void setStartEndIndices(int n, int n2) {
        this.m_Start = n;
        this.m_End = n2;
        this.m_NumInstances = n2 - n + 1;
    }

    public void setPivot(Instance instance) {
        this.m_Pivot = instance;
    }

    public Instance getPivot() {
        return this.m_Pivot;
    }

    public void setRadius(double d) {
        this.m_Radius = d;
    }

    public double getRadius() {
        return this.m_Radius;
    }

    public int numInstances() {
        return this.m_End - this.m_Start + 1;
    }

    public static Instance calcCentroidPivot(int[] nArray, Instances instances) {
        int n;
        Instance instance;
        int n2;
        double[] dArray = new double[instances.numAttributes()];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            instance = instances.instance(nArray[n2]);
            for (n = 0; n < instance.numValues(); ++n) {
                int n3 = n;
                dArray[n3] = dArray[n3] + instance.valueSparse(n);
            }
        }
        n2 = 0;
        n = nArray.length;
        while (n2 < dArray.length) {
            int n4 = n2++;
            dArray[n4] = dArray[n4] / (double)n;
        }
        instance = new Instance(1.0, dArray);
        return instance;
    }

    public static Instance calcCentroidPivot(int n, int n2, int[] nArray, Instances instances) {
        int n3;
        Instance instance;
        int n4;
        double[] dArray = new double[instances.numAttributes()];
        for (n4 = n; n4 <= n2; ++n4) {
            instance = instances.instance(nArray[n4]);
            for (n3 = 0; n3 < instance.numValues(); ++n3) {
                int n5 = n3;
                dArray[n5] = dArray[n5] + instance.valueSparse(n3);
            }
        }
        n4 = 0;
        n3 = n2 - n + 1;
        while (n4 < dArray.length) {
            int n6 = n4++;
            dArray[n6] = dArray[n6] / (double)n3;
        }
        instance = new Instance(1.0, dArray);
        return instance;
    }

    public static double calcRadius(int[] nArray, Instances instances, Instance instance, DistanceFunction distanceFunction) throws Exception {
        return BallNode.calcRadius(0, nArray.length - 1, nArray, instances, instance, distanceFunction);
    }

    public static double calcRadius(int n, int n2, int[] nArray, Instances instances, Instance instance, DistanceFunction distanceFunction) throws Exception {
        double d = Double.NEGATIVE_INFINITY;
        for (int i = n; i <= n2; ++i) {
            double d2 = distanceFunction.distance(instance, instances.instance(nArray[i]), Double.POSITIVE_INFINITY);
            if (!(d2 > d)) continue;
            d = d2;
        }
        return Math.sqrt(d);
    }

    public static Instance calcPivot(BallNode ballNode, BallNode ballNode2, Instances instances) throws Exception {
        Instance instance = ballNode.getPivot();
        Instance instance2 = ballNode2.getPivot();
        double[] dArray = new double[instance.numAttributes()];
        int n = 0;
        while (n < dArray.length) {
            int n2 = n;
            dArray[n2] = dArray[n2] + instance.value(n);
            int n3 = n;
            dArray[n3] = dArray[n3] + instance2.value(n);
            int n4 = n++;
            dArray[n4] = dArray[n4] / 2.0;
        }
        instance = new Instance(1.0, dArray);
        return instance;
    }

    public static double calcRadius(BallNode ballNode, BallNode ballNode2, Instance instance, DistanceFunction distanceFunction) throws Exception {
        Instance instance2 = ballNode.getPivot();
        Instance instance3 = ballNode2.getPivot();
        double d = ballNode.getRadius() + distanceFunction.distance(instance2, instance3) + ballNode2.getRadius();
        return d / 2.0;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.2 $");
    }
}

