/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.supportVector;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Enumeration;
import weka.classifiers.functions.supportVector.CachedKernel;
import weka.classifiers.functions.supportVector.Kernel;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;

public class KernelEvaluation {
    protected StringBuffer m_Result = new StringBuffer();
    protected double[][] m_Evaluations = new double[0][0];
    protected int m_NumEvals = 0;
    protected int m_NumCacheHits = 0;
    protected String[] m_Options = new String[0];

    public void setUserOptions(String[] stringArray) {
        this.m_Options = (String[])stringArray.clone();
    }

    public String[] getUserOptions() {
        return (String[])this.m_Options.clone();
    }

    protected static String makeOptionString(Kernel kernel) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nGeneral options:\n\n");
        stringBuffer.append("-t <training file>\n");
        stringBuffer.append("\tThe name of the training file.\n");
        stringBuffer.append("-c <class index>\n");
        stringBuffer.append("\tSets index of class attribute (default: last).\n");
        if (kernel instanceof OptionHandler) {
            stringBuffer.append("\nOptions specific to " + kernel.getClass().getName().replaceAll(".*\\.", "") + ":\n\n");
            Enumeration enumeration = kernel.listOptions();
            while (enumeration.hasMoreElements()) {
                Option option = (Option)enumeration.nextElement();
                stringBuffer.append(option.synopsis() + "\n");
                stringBuffer.append(option.description() + "\n");
            }
        }
        return stringBuffer.toString();
    }

    public static String evaluate(Kernel kernel, String[] stringArray) throws Exception {
        String[] stringArray2;
        BufferedReader bufferedReader;
        String string = "";
        int n = -1;
        if (Utils.getFlag('h', stringArray)) {
            throw new Exception("\nHelp requested.\n" + KernelEvaluation.makeOptionString(kernel));
        }
        try {
            string = Utils.getOption('t', stringArray);
            if (string.length() == 0) {
                throw new Exception("No training file given!");
            }
            bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = Utils.getOption('c', stringArray);
            if (string2.length() != 0) {
                n = string2.equals("first") ? 1 : (string2.equals("last") ? -1 : Integer.parseInt(string2));
            }
            stringArray2 = (String[])stringArray.clone();
            if (kernel instanceof OptionHandler) {
                kernel.setOptions(stringArray);
            }
            Utils.checkForRemainingOptions(stringArray);
        }
        catch (Exception exception) {
            throw new Exception("\nWeka exception: " + exception.getMessage() + "\n" + KernelEvaluation.makeOptionString(kernel));
        }
        KernelEvaluation kernelEvaluation = new KernelEvaluation();
        kernelEvaluation.setUserOptions(stringArray2);
        Instances instances = new Instances(bufferedReader);
        if (n == -1) {
            instances.setClassIndex(instances.numAttributes() - 1);
        } else {
            instances.setClassIndex(n);
        }
        return kernelEvaluation.evaluate(kernel, instances);
    }

    public static String evaluate(String string, String[] stringArray) throws Exception {
        Kernel kernel;
        try {
            kernel = (Kernel)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new Exception("Can't find class with name " + string + '.');
        }
        return KernelEvaluation.evaluate(kernel, stringArray);
    }

    public String evaluate(Kernel kernel, Instances instances) throws Exception {
        int n;
        int n2;
        this.m_Result = new StringBuffer();
        long l = System.currentTimeMillis();
        kernel.buildKernel(instances);
        long l2 = System.currentTimeMillis();
        this.m_Result.append("\n=== Model ===\n\n");
        if (Utils.joinOptions(this.getUserOptions()).trim().length() != 0) {
            this.m_Result.append("Options: " + Utils.joinOptions(this.getUserOptions()) + "\n\n");
        }
        this.m_Result.append(kernel.toString() + "\n");
        this.m_Evaluations = new double[instances.numInstances()][instances.numInstances()];
        for (n2 = 0; n2 < instances.numInstances(); ++n2) {
            for (n = n2; n < instances.numInstances(); ++n) {
                this.m_Evaluations[n2][n] = kernel.eval(n2, n, instances.instance(n2));
            }
        }
        if (kernel instanceof CachedKernel) {
            for (n2 = 0; n2 < instances.numInstances(); ++n2) {
                for (n = n2; n < instances.numInstances(); ++n) {
                    this.m_Evaluations[n2][n] = kernel.eval(n2, n, instances.instance(n2));
                }
            }
        }
        this.m_NumEvals = kernel.numEvals();
        this.m_NumCacheHits = kernel.numCacheHits();
        this.m_Result.append("\n=== Evaluation ===\n\n");
        if (kernel instanceof CachedKernel) {
            this.m_Result.append("Cache size   : " + ((CachedKernel)kernel).getCacheSize() + "\n");
        }
        this.m_Result.append("# Evaluations: " + this.m_NumEvals + "\n");
        this.m_Result.append("# Cache hits : " + this.m_NumCacheHits + "\n");
        this.m_Result.append("Elapsed time : " + (double)(l2 - l) / 1000.0 + "s\n");
        return this.m_Result.toString();
    }

    public boolean equals(Object object) {
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        KernelEvaluation kernelEvaluation = (KernelEvaluation)object;
        if (this.m_NumEvals != kernelEvaluation.m_NumEvals) {
            return false;
        }
        if (this.m_NumCacheHits != kernelEvaluation.m_NumCacheHits) {
            return false;
        }
        if (this.m_Evaluations.length != kernelEvaluation.m_Evaluations.length) {
            return false;
        }
        for (int i = 0; i < this.m_Evaluations.length; ++i) {
            for (int j = 0; j < this.m_Evaluations[i].length; ++j) {
                if (Double.isNaN(this.m_Evaluations[i][j]) && Double.isNaN(kernelEvaluation.m_Evaluations[i][j]) || this.m_Evaluations[i][j] == kernelEvaluation.m_Evaluations[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    public String toSummaryString() {
        return this.toSummaryString("");
    }

    public String toSummaryString(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (string.length() != 0) {
            stringBuffer.append("\n");
        }
        stringBuffer.append(this.m_Result);
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toSummaryString();
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 0) {
                throw new Exception("The first argument must be the class name of a kernel");
            }
            String string = stringArray[0];
            stringArray[0] = "";
            System.out.println(KernelEvaluation.evaluate(string, stringArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

