/*
 * Decompiled with CFR 0.152.
 */
package weka.associations.gsp;

import java.io.Serializable;
import java.util.Enumeration;
import weka.associations.gsp.Element;
import weka.core.FastVector;
import weka.core.Instances;

public class Sequence
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -5001018056339156390L;
    protected int m_SupportCount;
    protected FastVector m_Elements;

    public Sequence() {
        this.m_SupportCount = 0;
        this.m_Elements = new FastVector();
    }

    public Sequence(FastVector fastVector) {
        this.m_SupportCount = 0;
        this.m_Elements = fastVector;
    }

    public Sequence(int n) {
        this.m_SupportCount = n;
        this.m_Elements = new FastVector();
    }

    public static FastVector aprioriGen(FastVector fastVector) throws CloneNotSupportedException {
        FastVector fastVector2 = Sequence.generateKCandidates(fastVector);
        FastVector fastVector3 = Sequence.pruneCadidates(fastVector2, fastVector);
        return fastVector3;
    }

    public static FastVector deleteInfrequentSequences(FastVector fastVector, long l) {
        FastVector fastVector2 = new FastVector();
        Enumeration enumeration = fastVector.elements();
        while (enumeration.hasMoreElements()) {
            Sequence sequence = (Sequence)enumeration.nextElement();
            long l2 = sequence.getSupportCount();
            if (l2 < l) continue;
            fastVector2.addElement(sequence);
        }
        return fastVector2;
    }

    protected static FastVector generateKCandidates(FastVector fastVector) throws CloneNotSupportedException {
        FastVector fastVector2 = new FastVector();
        FastVector fastVector3 = new FastVector();
        for (int i = 0; i < fastVector.size(); ++i) {
            for (int j = 0; j < fastVector.size(); ++j) {
                Sequence sequence;
                Sequence sequence2 = (Sequence)fastVector.elementAt(i);
                Sequence sequence3 = sequence2.clone();
                Sequence sequence4 = (Sequence)fastVector.elementAt(j);
                Sequence sequence5 = sequence4.clone();
                Sequence sequence6 = sequence3.deleteEvent("first");
                if (!sequence6.equals(sequence = sequence5.deleteEvent("last"))) continue;
                fastVector3 = sequence6.getElements().size() == 0 && sequence.getElements().size() == 0 ? (i >= j ? Sequence.merge(sequence3, sequence5, true, true) : Sequence.merge(sequence3, sequence5, true, false)) : Sequence.merge(sequence3, sequence5, false, false);
                fastVector2.appendElements(fastVector3);
            }
        }
        return fastVector2;
    }

    protected static FastVector merge(Sequence sequence, Sequence sequence2, boolean bl, boolean bl2) {
        FastVector fastVector = new FastVector();
        if (bl) {
            Element element = (Element)sequence.getElements().firstElement();
            Element element2 = (Element)sequence2.getElements().firstElement();
            Element element3 = null;
            if (bl2) {
                for (int i = 0; i < element.getEvents().length; ++i) {
                    if (element.getEvents()[i] <= -1) continue;
                    if (element2.getEvents()[i] > -1) break;
                    element3 = Element.merge(element, element2);
                }
            }
            FastVector fastVector2 = new FastVector();
            fastVector2.addElement(element);
            fastVector2.addElement(element2);
            fastVector.addElement(new Sequence(fastVector2));
            if (element3 != null) {
                FastVector fastVector3 = new FastVector();
                fastVector3.addElement(element3);
                fastVector.addElement(new Sequence(fastVector3));
            }
            return fastVector;
        }
        Element element = (Element)sequence.getElements().lastElement();
        Element element4 = (Element)sequence2.getElements().lastElement();
        Sequence sequence3 = new Sequence();
        FastVector fastVector4 = sequence3.getElements();
        if (element4.containsOverOneEvent()) {
            for (int i = 0; i < sequence.getElements().size() - 1; ++i) {
                fastVector4.addElement(sequence.getElements().elementAt(i));
            }
            fastVector4.addElement(Element.merge(element, element4));
            fastVector.addElement(sequence3);
            return fastVector;
        }
        for (int i = 0; i < sequence.getElements().size(); ++i) {
            fastVector4.addElement(sequence.getElements().elementAt(i));
        }
        fastVector4.addElement(element4);
        fastVector.addElement(sequence3);
        return fastVector;
    }

    public static FastVector oneElementsToSequences(FastVector fastVector) {
        FastVector fastVector2 = new FastVector();
        Enumeration enumeration = fastVector.elements();
        while (enumeration.hasMoreElements()) {
            Sequence sequence = new Sequence();
            FastVector fastVector3 = sequence.getElements();
            fastVector3.addElement(enumeration.nextElement());
            fastVector2.addElement(sequence);
        }
        return fastVector2;
    }

    public static void printSetOfSequences(FastVector fastVector) {
        Enumeration enumeration = fastVector.elements();
        int n = 1;
        while (enumeration.hasMoreElements()) {
            Sequence sequence = (Sequence)enumeration.nextElement();
            System.out.print("[" + n++ + "]" + " " + sequence.toString());
        }
    }

    protected static FastVector pruneCadidates(FastVector fastVector, FastVector fastVector2) {
        FastVector fastVector3 = new FastVector();
        for (int i = 0; i < fastVector.size(); ++i) {
            Sequence sequence = (Sequence)fastVector.elementAt(i);
            boolean bl = true;
            FastVector fastVector4 = sequence.getElements();
            block1: for (int j = 0; j < fastVector4.size() && bl; ++j) {
                Element element = (Element)fastVector4.elementAt(j);
                int[] nArray = element.getEvents();
                for (int k = 0; k < nArray.length; ++k) {
                    int n;
                    if (nArray[k] <= -1) continue;
                    int n2 = nArray[k];
                    nArray[k] = -1;
                    if (element.isEmpty()) {
                        fastVector4.removeElementAt(j);
                        n = fastVector2.indexOf(sequence);
                        if (n != -1) {
                            nArray[k] = n2;
                            fastVector4.insertElementAt(element, j);
                            continue block1;
                        }
                        bl = false;
                        continue block1;
                    }
                    n = fastVector2.indexOf(sequence);
                    if (n != -1) {
                        nArray[k] = n2;
                        continue;
                    }
                    bl = false;
                    continue block1;
                }
            }
            if (!bl) continue;
            fastVector3.addElement(sequence);
        }
        return fastVector3;
    }

    public static String setOfSequencesToString(FastVector fastVector, Instances instances, FastVector fastVector2) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = fastVector.elements();
        int n = 1;
        while (enumeration.hasMoreElements()) {
            Sequence sequence = (Sequence)enumeration.nextElement();
            Integer n2 = (Integer)fastVector2.elementAt(0);
            boolean bl = true;
            if (n2 != -1) {
                block1: for (int i = 0; i < fastVector2.size(); ++i) {
                    n2 = (Integer)fastVector2.elementAt(i);
                    FastVector fastVector3 = sequence.getElements();
                    if (!bl) continue;
                    for (int j = 0; j < fastVector3.size(); ++j) {
                        Element element = (Element)fastVector3.elementAt(j);
                        int[] nArray = element.getEvents();
                        if (nArray[n2] != -1) continue;
                        bl = false;
                        continue block1;
                    }
                }
            }
            if (!bl) continue;
            stringBuffer.append("[" + n++ + "]" + " " + sequence.toNominalString(instances));
        }
        return stringBuffer.toString();
    }

    public static void updateSupportCount(FastVector fastVector, FastVector fastVector2) {
        Enumeration enumeration = fastVector.elements();
        while (enumeration.hasMoreElements()) {
            Enumeration enumeration2 = fastVector2.elements();
            Sequence sequence = (Sequence)enumeration.nextElement();
            while (enumeration2.hasMoreElements()) {
                Instances instances = (Instances)enumeration2.nextElement();
                if (!sequence.isSubsequenceOf(instances)) continue;
                sequence.setSupportCount(sequence.getSupportCount() + 1);
            }
        }
    }

    public Sequence clone() {
        try {
            Sequence sequence = (Sequence)super.clone();
            sequence.setSupportCount(this.m_SupportCount);
            FastVector fastVector = new FastVector(this.m_Elements.size());
            for (int i = 0; i < this.m_Elements.size(); ++i) {
                Element element = (Element)this.m_Elements.elementAt(i);
                fastVector.addElement(element.clone());
            }
            sequence.setElements(fastVector);
            return sequence;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
    }

    protected Sequence deleteEvent(String string) {
        Sequence sequence = this.clone();
        if (string.equals("first")) {
            Element element = (Element)sequence.getElements().firstElement();
            element.deleteEvent("first");
            if (element.isEmpty()) {
                sequence.getElements().removeElementAt(0);
            }
            return sequence;
        }
        if (string.equals("last")) {
            Element element = (Element)sequence.getElements().lastElement();
            element.deleteEvent("last");
            if (element.isEmpty()) {
                sequence.getElements().removeElementAt(this.m_Elements.size() - 1);
            }
            return sequence;
        }
        return null;
    }

    public boolean equals(Object object) {
        Sequence sequence = (Sequence)object;
        FastVector fastVector = sequence.getElements();
        for (int i = 0; i < this.m_Elements.size(); ++i) {
            Element element;
            Element element2 = (Element)this.m_Elements.elementAt(i);
            if (element2.equals(element = (Element)fastVector.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    protected FastVector getElements() {
        return this.m_Elements;
    }

    protected int getSupportCount() {
        return this.m_SupportCount;
    }

    protected boolean isSubsequenceOf(Instances instances) {
        FastVector fastVector = this.getElements();
        Enumeration enumeration = fastVector.elements();
        Element element = (Element)enumeration.nextElement();
        for (int i = 0; i < instances.numInstances(); ++i) {
            if (!element.isContainedBy(instances.instance(i))) continue;
            if (!enumeration.hasMoreElements()) {
                return true;
            }
            element = (Element)enumeration.nextElement();
        }
        return false;
    }

    protected void setElements(FastVector fastVector) {
        this.m_Elements = fastVector;
    }

    protected void setSupportCount(int n) {
        this.m_SupportCount = n;
    }

    public String toNominalString(Instances instances) {
        String string = "";
        string = string + "<";
        for (int i = 0; i < this.m_Elements.size(); ++i) {
            Element element = (Element)this.m_Elements.elementAt(i);
            string = string + element.toNominalString(instances);
        }
        string = string + "> (" + this.getSupportCount() + ")\n";
        return string;
    }

    public String toString() {
        String string = "";
        string = string + "Sequence Output\n";
        string = string + "------------------------------\n";
        string = string + "Support Count: " + this.getSupportCount() + "\n";
        string = string + "contained elements/itemsets:\n";
        for (int i = 0; i < this.m_Elements.size(); ++i) {
            Element element = (Element)this.m_Elements.elementAt(i);
            string = string + element.toString();
        }
        string = string + "\n\n";
        return string;
    }
}

