/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.Serializable;
import java.util.Random;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class AlgVector
implements Cloneable,
Serializable,
RevisionHandler {
    private static final long serialVersionUID = -4023736016850256591L;
    protected double[] m_Elements;

    public AlgVector(int n) {
        this.m_Elements = new double[n];
        this.initialize();
    }

    public AlgVector(double[] array) {
        this.m_Elements = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            this.m_Elements[i] = array[i];
        }
    }

    public AlgVector(Instances format, Random random) throws Exception {
        int len = format.numAttributes();
        for (int i = 0; i < format.numAttributes(); ++i) {
            if (format.attribute(i).isNumeric()) continue;
            --len;
        }
        if (len > 0) {
            this.m_Elements = new double[len];
            this.initialize(random);
        }
    }

    public AlgVector(Instance instance) throws Exception {
        int len = instance.numAttributes();
        for (int i = 0; i < instance.numAttributes(); ++i) {
            if (instance.attribute(i).isNumeric()) continue;
            --len;
        }
        if (len > 0) {
            this.m_Elements = new double[len];
            int n = 0;
            for (int i = 0; i < instance.numAttributes(); ++i) {
                if (!instance.attribute(i).isNumeric()) continue;
                this.m_Elements[n] = instance.value(i);
                ++n;
            }
        } else {
            throw new IllegalArgumentException("No numeric attributes in data!");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        AlgVector v = (AlgVector)super.clone();
        v.m_Elements = new double[this.numElements()];
        for (int i = 0; i < this.numElements(); ++i) {
            v.m_Elements[i] = this.m_Elements[i];
        }
        return v;
    }

    protected void initialize() {
        for (int i = 0; i < this.m_Elements.length; ++i) {
            this.m_Elements[i] = 0.0;
        }
    }

    protected void initialize(Random random) {
        for (int i = 0; i < this.m_Elements.length; ++i) {
            this.m_Elements[i] = random.nextDouble();
        }
    }

    public final double getElement(int index) {
        return this.m_Elements[index];
    }

    public final int numElements() {
        return this.m_Elements.length;
    }

    public final void setElement(int index, double value) {
        this.m_Elements[index] = value;
    }

    public final void setElements(double[] elements) {
        for (int i = 0; i < elements.length; ++i) {
            this.m_Elements[i] = elements[i];
        }
    }

    public double[] getElements() {
        double[] elements = new double[this.numElements()];
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = this.m_Elements[i];
        }
        return elements;
    }

    public Instance getAsInstance(Instances model, Random random) throws Exception {
        DenseInstance newInst = null;
        if (this.m_Elements != null) {
            newInst = new DenseInstance(model.numAttributes());
            newInst.setDataset(model);
            int j = 0;
            for (int i = 0; i < model.numAttributes(); ++i) {
                if (model.attribute(i).isNumeric()) {
                    if (j >= this.m_Elements.length) {
                        throw new Exception("Datatypes are not compatible.");
                    }
                    newInst.setValue(i, this.m_Elements[j++]);
                }
                if (!model.attribute(i).isNominal()) continue;
                int newVal = (int)(random.nextDouble() * (double)model.attribute(i).numValues());
                if (newVal == model.attribute(i).numValues()) {
                    --newVal;
                }
                newInst.setValue(i, (double)newVal);
            }
        }
        return newInst;
    }

    public final AlgVector add(AlgVector other) {
        AlgVector b = null;
        if (this.m_Elements != null) {
            int n = this.m_Elements.length;
            try {
                b = (AlgVector)this.clone();
            }
            catch (CloneNotSupportedException ex) {
                b = new AlgVector(n);
            }
            for (int i = 0; i < n; ++i) {
                b.m_Elements[i] = this.m_Elements[i] + other.m_Elements[i];
            }
        }
        return b;
    }

    public final AlgVector substract(AlgVector other) {
        AlgVector b;
        int n = this.m_Elements.length;
        try {
            b = (AlgVector)this.clone();
        }
        catch (CloneNotSupportedException ex) {
            b = new AlgVector(n);
        }
        for (int i = 0; i < n; ++i) {
            b.m_Elements[i] = this.m_Elements[i] - other.m_Elements[i];
        }
        return b;
    }

    public final double dotMultiply(AlgVector b) {
        double sum = 0.0;
        if (this.m_Elements != null) {
            int n = this.m_Elements.length;
            for (int i = 0; i < n; ++i) {
                sum += this.m_Elements[i] * b.m_Elements[i];
            }
        }
        return sum;
    }

    public final void scalarMultiply(double s) {
        if (this.m_Elements != null) {
            int n = this.m_Elements.length;
            for (int i = 0; i < n; ++i) {
                this.m_Elements[i] = s * this.m_Elements[i];
            }
        }
    }

    public void changeLength(double len) {
        double factor = this.norm();
        factor = len / factor;
        this.scalarMultiply(factor);
    }

    public double norm() {
        if (this.m_Elements != null) {
            int n = this.m_Elements.length;
            double sum = 0.0;
            for (int i = 0; i < n; ++i) {
                sum += this.m_Elements[i] * this.m_Elements[i];
            }
            return Math.pow(sum, 0.5);
        }
        return 0.0;
    }

    public final void normVector() {
        double len = this.norm();
        this.scalarMultiply(1.0 / len);
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        for (int i = 0; i < this.m_Elements.length; ++i) {
            if (i > 0) {
                text.append(",");
            }
            text.append(Utils.doubleToString(this.m_Elements[i], 6));
        }
        text.append("\n");
        return text.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5987 $");
    }

    public static void main(String[] args) throws Exception {
        double[] first = new double[]{2.3, 1.2, 5.0};
        try {
            AlgVector test = new AlgVector(first);
            System.out.println("test:\n " + test);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

