/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.boundaryvisualizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.ObjectInputStream;
import java.rmi.Naming;
import java.util.Vector;
import javax.swing.JFrame;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.Queue;
import weka.core.Utils;
import weka.experiment.Compute;
import weka.experiment.RemoteExperimentEvent;
import weka.experiment.RemoteExperimentListener;
import weka.experiment.TaskStatusInfo;
import weka.gui.boundaryvisualizer.BoundaryPanel;
import weka.gui.boundaryvisualizer.KDDataGenerator;
import weka.gui.boundaryvisualizer.RemoteBoundaryVisualizerSubTask;
import weka.gui.boundaryvisualizer.RemoteResult;

public class BoundaryPanelDistributed
extends BoundaryPanel {
    private static final long serialVersionUID = -1743284397893937776L;
    protected Vector m_listeners = new Vector();
    protected Vector m_remoteHosts = new Vector();
    private Queue m_remoteHostsQueue = new Queue();
    private int[] m_remoteHostsStatus;
    private int[] m_remoteHostFailureCounts;
    protected static final int AVAILABLE = 0;
    protected static final int IN_USE = 1;
    protected static final int CONNECTION_FAILED = 2;
    protected static final int SOME_OTHER_FAILURE = 3;
    protected static final int MAX_FAILURES = 3;
    private boolean m_plottingAborted = false;
    private int m_removedHosts;
    private int m_failedCount;
    private int m_finishedCount;
    private Queue m_subExpQueue = new Queue();
    private int m_minTaskPollTime = 1000;
    private int[] m_hostPollingTime;

    public BoundaryPanelDistributed(int panelWidth, int panelHeight) {
        super(panelWidth, panelHeight);
    }

    public void setRemoteHosts(Vector remHosts) {
        this.m_remoteHosts = remHosts;
    }

    public void addRemoteExperimentListener(RemoteExperimentListener r) {
        this.m_listeners.addElement(r);
    }

    protected void initialize() {
        int i;
        super.initialize();
        this.m_plottingAborted = false;
        this.m_finishedCount = 0;
        this.m_failedCount = 0;
        this.m_remoteHostsStatus = new int[this.m_remoteHosts.size()];
        this.m_remoteHostFailureCounts = new int[this.m_remoteHosts.size()];
        this.m_remoteHostsQueue = new Queue();
        if (this.m_remoteHosts.size() == 0) {
            System.err.println("No hosts specified!");
            System.exit(1);
        }
        this.m_hostPollingTime = new int[this.m_remoteHosts.size()];
        for (i = 0; i < this.m_remoteHosts.size(); ++i) {
            this.m_remoteHostsQueue.push(new Integer(i));
            this.m_hostPollingTime[i] = this.m_minTaskPollTime;
        }
        this.m_subExpQueue = new Queue();
        for (i = 0; i < this.m_panelHeight; ++i) {
            this.m_subExpQueue.push(new Integer(i));
        }
        try {
            this.m_classifier.buildClassifier(this.m_trainingData);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        boolean[] attsToWeightOn = new boolean[this.m_trainingData.numAttributes()];
        attsToWeightOn[this.m_xAttribute] = true;
        attsToWeightOn[this.m_yAttribute] = true;
        this.m_dataGenerator.setWeightingDimensions(attsToWeightOn);
        try {
            this.m_dataGenerator.buildGenerator(this.m_trainingData);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    public void start() throws Exception {
        this.m_stopReplotting = true;
        if (this.m_trainingData == null) {
            throw new Exception("No training data set (BoundaryPanel)");
        }
        if (this.m_classifier == null) {
            throw new Exception("No classifier set (BoundaryPanel)");
        }
        if (this.m_dataGenerator == null) {
            throw new Exception("No data generator set (BoundaryPanel)");
        }
        if (this.m_trainingData.attribute(this.m_xAttribute).isNominal() || this.m_trainingData.attribute(this.m_yAttribute).isNominal()) {
            throw new Exception("Visualization dimensions must be numeric (BoundaryPanel)");
        }
        this.computeMinMaxAtts();
        this.initialize();
        int totalHosts = this.m_remoteHostsQueue.size();
        for (int i = 0; i < totalHosts; ++i) {
            this.availableHost(-1);
            Thread.sleep(70L);
        }
    }

    protected synchronized void availableHost(int hostNum) {
        if (hostNum >= 0) {
            if (this.m_remoteHostFailureCounts[hostNum] < 3) {
                this.m_remoteHostsQueue.push(new Integer(hostNum));
            } else {
                this.notifyListeners(false, true, false, "Max failures exceeded for host " + (String)this.m_remoteHosts.elementAt(hostNum) + ". Removed from host list.");
                ++this.m_removedHosts;
            }
        }
        if (this.m_failedCount == 3 * this.m_remoteHosts.size()) {
            this.m_plottingAborted = true;
            this.notifyListeners(false, true, true, "Plotting aborted! Max failures exceeded on all remote hosts.");
            return;
        }
        if (this.m_subExpQueue.size() == 0 && this.m_remoteHosts.size() == this.m_remoteHostsQueue.size() + this.m_removedHosts) {
            if (this.m_plotTrainingData) {
                this.plotTrainingData();
            }
            this.notifyListeners(false, true, true, "Plotting completed successfully.");
            return;
        }
        if (this.checkForAllFailedHosts()) {
            return;
        }
        if (this.m_plottingAborted && this.m_remoteHostsQueue.size() + this.m_removedHosts == this.m_remoteHosts.size()) {
            this.notifyListeners(false, true, true, "Plotting aborted. All remote tasks finished.");
        }
        if (!(this.m_subExpQueue.empty() || this.m_plottingAborted || this.m_remoteHostsQueue.empty())) {
            try {
                int availHost = (Integer)this.m_remoteHostsQueue.pop();
                int waitingTask = (Integer)this.m_subExpQueue.pop();
                this.launchNext(waitingTask, availHost);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private synchronized void notifyListeners(boolean status, boolean log, boolean finished, String message) {
        if (this.m_listeners.size() > 0) {
            for (int i = 0; i < this.m_listeners.size(); ++i) {
                RemoteExperimentListener r = (RemoteExperimentListener)this.m_listeners.elementAt(i);
                r.remoteExperimentStatus(new RemoteExperimentEvent(status, log, finished, message));
            }
        } else {
            System.err.println(message);
        }
    }

    private boolean checkForAllFailedHosts() {
        boolean allbad = true;
        for (int i = 0; i < this.m_remoteHostsStatus.length; ++i) {
            if (this.m_remoteHostsStatus[i] == 2) continue;
            allbad = false;
            break;
        }
        if (allbad) {
            this.m_plottingAborted = true;
            this.notifyListeners(false, true, true, "Plotting aborted! All connections to remote hosts failed.");
        }
        return allbad;
    }

    protected synchronized void incrementFinished() {
        ++this.m_finishedCount;
    }

    protected synchronized void incrementFailed(int hostNum) {
        ++this.m_failedCount;
        int n = hostNum;
        this.m_remoteHostFailureCounts[n] = this.m_remoteHostFailureCounts[n] + 1;
    }

    protected synchronized void waitingTask(int expNum) {
        this.m_subExpQueue.push(new Integer(expNum));
    }

    protected void launchNext(final int wtask, final int ah) {
        Thread subTaskThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                ((BoundaryPanelDistributed)BoundaryPanelDistributed.this).m_remoteHostsStatus[ah] = 1;
                RemoteBoundaryVisualizerSubTask vSubTask = new RemoteBoundaryVisualizerSubTask();
                vSubTask.setXAttribute(BoundaryPanelDistributed.this.m_xAttribute);
                vSubTask.setYAttribute(BoundaryPanelDistributed.this.m_yAttribute);
                vSubTask.setRowNumber(wtask);
                vSubTask.setPanelWidth(BoundaryPanelDistributed.this.m_panelWidth);
                vSubTask.setPanelHeight(BoundaryPanelDistributed.this.m_panelHeight);
                vSubTask.setPixHeight(BoundaryPanelDistributed.this.m_pixHeight);
                vSubTask.setPixWidth(BoundaryPanelDistributed.this.m_pixWidth);
                vSubTask.setClassifier(BoundaryPanelDistributed.this.m_classifier);
                vSubTask.setDataGenerator(BoundaryPanelDistributed.this.m_dataGenerator);
                vSubTask.setInstances(BoundaryPanelDistributed.this.m_trainingData);
                vSubTask.setMinMaxX(BoundaryPanelDistributed.this.m_minX, BoundaryPanelDistributed.this.m_maxX);
                vSubTask.setMinMaxY(BoundaryPanelDistributed.this.m_minY, BoundaryPanelDistributed.this.m_maxY);
                vSubTask.setNumSamplesPerRegion(BoundaryPanelDistributed.this.m_numOfSamplesPerRegion);
                vSubTask.setGeneratorSamplesBase(BoundaryPanelDistributed.this.m_samplesBase);
                try {
                    try {
                        String name = "//" + (String)BoundaryPanelDistributed.this.m_remoteHosts.elementAt(ah) + "/RemoteEngine";
                        Compute comp = (Compute)Naming.lookup(name);
                        BoundaryPanelDistributed.this.notifyListeners(false, true, false, "Starting row " + wtask + " on host " + (String)BoundaryPanelDistributed.this.m_remoteHosts.elementAt(ah));
                        Object subTaskId = comp.executeTask(vSubTask);
                        boolean finished = false;
                        TaskStatusInfo is = null;
                        long startTime = System.currentTimeMillis();
                        while (!finished) {
                            try {
                                Thread.sleep(Math.max(BoundaryPanelDistributed.this.m_minTaskPollTime, BoundaryPanelDistributed.this.m_hostPollingTime[ah]));
                                TaskStatusInfo cs = (TaskStatusInfo)comp.checkStatus(subTaskId);
                                if (cs.getExecutionStatus() == 3) {
                                    long runTime = System.currentTimeMillis() - startTime;
                                    if ((runTime /= 4L) < 1000L) {
                                        runTime = 1000L;
                                    }
                                    ((BoundaryPanelDistributed)BoundaryPanelDistributed.this).m_hostPollingTime[ah] = (int)runTime;
                                    RemoteResult rr = (RemoteResult)cs.getTaskResult();
                                    double[][] probs = rr.getProbabilities();
                                    for (int i = 0; i < BoundaryPanelDistributed.this.m_panelWidth; ++i) {
                                        BoundaryPanelDistributed.this.m_probabilityCache[wtask][i] = probs[i];
                                        if (i < BoundaryPanelDistributed.this.m_panelWidth - 1) {
                                            BoundaryPanelDistributed.this.plotPoint(i, wtask, probs[i], false);
                                            continue;
                                        }
                                        BoundaryPanelDistributed.this.plotPoint(i, wtask, probs[i], true);
                                    }
                                    BoundaryPanelDistributed.this.notifyListeners(false, true, false, cs.getStatusMessage());
                                    ((BoundaryPanelDistributed)BoundaryPanelDistributed.this).m_remoteHostsStatus[ah] = 0;
                                    BoundaryPanelDistributed.this.incrementFinished();
                                    BoundaryPanelDistributed.this.availableHost(ah);
                                    finished = true;
                                    continue;
                                }
                                if (cs.getExecutionStatus() == 2) {
                                    BoundaryPanelDistributed.this.notifyListeners(false, true, false, cs.getStatusMessage());
                                    ((BoundaryPanelDistributed)BoundaryPanelDistributed.this).m_remoteHostsStatus[ah] = 3;
                                    BoundaryPanelDistributed.this.notifyListeners(false, true, false, "Row " + wtask + " " + cs.getStatusMessage() + ". Scheduling for execution on another host.");
                                    BoundaryPanelDistributed.this.incrementFailed(ah);
                                    BoundaryPanelDistributed.this.waitingTask(wtask);
                                    BoundaryPanelDistributed.this.availableHost(ah);
                                    finished = true;
                                    continue;
                                }
                                if (is == null) {
                                    is = cs;
                                    BoundaryPanelDistributed.this.notifyListeners(false, true, false, cs.getStatusMessage());
                                    continue;
                                }
                                RemoteResult rr = (RemoteResult)cs.getTaskResult();
                                if (rr != null) {
                                    int percentComplete = rr.getPercentCompleted();
                                    String timeRemaining = "";
                                    if (percentComplete > 0 && percentComplete < 100) {
                                        double timeSoFar = (double)System.currentTimeMillis() - (double)startTime;
                                        double timeToGo = (100.0 - (double)percentComplete) / (double)percentComplete * timeSoFar;
                                        if (timeToGo < (double)BoundaryPanelDistributed.this.m_hostPollingTime[ah]) {
                                            ((BoundaryPanelDistributed)BoundaryPanelDistributed.this).m_hostPollingTime[ah] = (int)timeToGo;
                                        }
                                        String units = "seconds";
                                        if ((timeToGo /= 1000.0) > 60.0) {
                                            units = "minutes";
                                            timeToGo /= 60.0;
                                        }
                                        if (timeToGo > 60.0) {
                                            units = "hours";
                                            timeToGo /= 60.0;
                                        }
                                        timeRemaining = " (approx. time remaining " + Utils.doubleToString(timeToGo, 1) + " " + units + ")";
                                    }
                                    if (percentComplete < 25) {
                                        if (percentComplete > 0) {
                                            ((BoundaryPanelDistributed)BoundaryPanelDistributed.this).m_hostPollingTime[ah] = (int)(25.0 / (double)percentComplete * (double)BoundaryPanelDistributed.this.m_hostPollingTime[ah]);
                                        } else {
                                            int[] nArray = BoundaryPanelDistributed.this.m_hostPollingTime;
                                            int n = ah;
                                            nArray[n] = nArray[n] * 2;
                                        }
                                        if (BoundaryPanelDistributed.this.m_hostPollingTime[ah] > 60000) {
                                            ((BoundaryPanelDistributed)BoundaryPanelDistributed.this).m_hostPollingTime[ah] = 60000;
                                        }
                                    }
                                    BoundaryPanelDistributed.this.notifyListeners(false, true, false, "Row " + wtask + " " + percentComplete + "% complete" + timeRemaining + ".");
                                } else {
                                    BoundaryPanelDistributed.this.notifyListeners(false, true, false, "Row " + wtask + " queued on " + (String)BoundaryPanelDistributed.this.m_remoteHosts.elementAt(ah));
                                    if (BoundaryPanelDistributed.this.m_hostPollingTime[ah] < 60000) {
                                        int[] nArray = BoundaryPanelDistributed.this.m_hostPollingTime;
                                        int n = ah;
                                        nArray[n] = nArray[n] * 2;
                                    }
                                }
                                is = cs;
                            }
                            catch (InterruptedException ie) {
                                ie.printStackTrace();
                            }
                        }
                        Object var19_20 = null;
                    }
                    catch (Exception ce) {
                        ((BoundaryPanelDistributed)BoundaryPanelDistributed.this).m_remoteHostsStatus[ah] = 2;
                        BoundaryPanelDistributed.this.m_removedHosts++;
                        System.err.println(ce);
                        ce.printStackTrace();
                        BoundaryPanelDistributed.this.notifyListeners(false, true, false, "Connection to " + (String)BoundaryPanelDistributed.this.m_remoteHosts.elementAt(ah) + " failed. Scheduling row " + wtask + " for execution on another host.");
                        BoundaryPanelDistributed.this.checkForAllFailedHosts();
                        BoundaryPanelDistributed.this.waitingTask(wtask);
                        Object var19_21 = null;
                        if (!this.isInterrupted()) return;
                        System.err.println("Sub exp Interupted!");
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var19_22 = null;
                    if (!this.isInterrupted()) throw throwable;
                    System.err.println("Sub exp Interupted!");
                    throw throwable;
                }
                if (!this.isInterrupted()) return;
                System.err.println("Sub exp Interupted!");
            }
        };
        subTaskThread.setPriority(1);
        subTaskThread.start();
    }

    public static void main(String[] args) {
        try {
            if (args.length < 8) {
                System.err.println("Usage : BoundaryPanelDistributed <dataset> <class col> <xAtt> <yAtt> <base> <# loc/pixel> <kernel bandwidth> <display width> <display height> <classifier [classifier options]>");
                System.exit(1);
            }
            Vector<String> hostNames = new Vector<String>();
            try {
                BufferedReader br = new BufferedReader(new FileReader("hosts.vis"));
                String hostName = br.readLine();
                while (hostName != null) {
                    System.out.println("Adding host " + hostName);
                    hostNames.add(hostName);
                    hostName = br.readLine();
                }
                br.close();
            }
            catch (Exception ex) {
                System.err.println("No hosts.vis file - create this file in the current directory with one host name per line, or use BoundaryPanel instead.");
                System.exit(1);
            }
            final JFrame jf = new JFrame("Weka classification boundary visualizer");
            jf.getContentPane().setLayout(new BorderLayout());
            System.err.println("Loading instances from : " + args[0]);
            BufferedReader r = new BufferedReader(new FileReader(args[0]));
            final Instances i = new Instances(r);
            i.setClassIndex(Integer.parseInt(args[1]));
            final int xatt = Integer.parseInt(args[2]);
            final int yatt = Integer.parseInt(args[3]);
            int base = Integer.parseInt(args[4]);
            int loc = Integer.parseInt(args[5]);
            int bandWidth = Integer.parseInt(args[6]);
            int panelWidth = Integer.parseInt(args[7]);
            int panelHeight = Integer.parseInt(args[8]);
            final String classifierName = args[9];
            final BoundaryPanelDistributed bv = new BoundaryPanelDistributed(panelWidth, panelHeight);
            bv.addRemoteExperimentListener(new RemoteExperimentListener(){

                public void remoteExperimentStatus(RemoteExperimentEvent e) {
                    if (e.m_experimentFinished) {
                        String classifierNameNew = classifierName.substring(classifierName.lastIndexOf(46) + 1, classifierName.length());
                        bv.saveImage(classifierNameNew + "_" + i.relationName() + "_X" + xatt + "_Y" + yatt + ".jpg");
                    } else {
                        System.err.println(e.m_messageString);
                    }
                }
            });
            bv.setRemoteHosts(hostNames);
            jf.getContentPane().add((Component)bv, "Center");
            jf.setSize(bv.getMinimumSize());
            jf.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setVisible(true);
            bv.repaint();
            String[] argsR = null;
            if (args.length > 10) {
                argsR = new String[args.length - 10];
                for (int j = 10; j < args.length; ++j) {
                    argsR[j - 10] = args[j];
                }
            }
            Classifier c = AbstractClassifier.forName(args[9], argsR);
            KDDataGenerator dataGen = new KDDataGenerator();
            dataGen.setKernelBandwidth(bandWidth);
            bv.setDataGenerator(dataGen);
            bv.setNumSamplesPerRegion(loc);
            bv.setGeneratorSamplesBase(base);
            bv.setClassifier(c);
            bv.setTrainingData(i);
            bv.setXAttribute(xatt);
            bv.setYAttribute(yatt);
            try {
                FileInputStream fis = new FileInputStream("colors.ser");
                ObjectInputStream ois = new ObjectInputStream(fis);
                FastVector colors = (FastVector)ois.readObject();
                bv.setColors(colors);
            }
            catch (Exception ex) {
                System.err.println("No color map file");
            }
            bv.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

