/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48;

import weka.classifiers.trees.j48.Distribution;
import weka.classifiers.trees.j48.SplitCriterion;

public abstract class EntropyBasedSplitCrit
extends SplitCriterion {
    private static final long serialVersionUID = -2618691439791653056L;
    protected static double log2 = Math.log(2.0);

    public final double logFunc(double num) {
        if (num < 1.0E-6) {
            return 0.0;
        }
        return num * Math.log(num) / log2;
    }

    public final double oldEnt(Distribution bags) {
        double returnValue = 0.0;
        for (int j = 0; j < bags.numClasses(); ++j) {
            returnValue += this.logFunc(bags.perClass(j));
        }
        return this.logFunc(bags.total()) - returnValue;
    }

    public final double newEnt(Distribution bags) {
        double returnValue = 0.0;
        for (int i = 0; i < bags.numBags(); ++i) {
            for (int j = 0; j < bags.numClasses(); ++j) {
                returnValue += this.logFunc(bags.perClassPerBag(i, j));
            }
            returnValue -= this.logFunc(bags.perBag(i));
        }
        return -returnValue;
    }

    public final double splitEnt(Distribution bags) {
        double returnValue = 0.0;
        for (int i = 0; i < bags.numBags(); ++i) {
            returnValue += this.logFunc(bags.perBag(i));
        }
        return this.logFunc(bags.total()) - returnValue;
    }
}

