/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginManager {
    protected static Map<String, Map<String, String>> PLUGINS = new HashMap<String, Map<String, String>>();

    public static Set<String> getPluginNamesOfType(String interfaceName) {
        if (PLUGINS.get(interfaceName) != null) {
            return PLUGINS.get(interfaceName).keySet();
        }
        return null;
    }

    public static void addPlugin(String interfaceName, String name, String concreteType) {
        if (PLUGINS.get(interfaceName) == null) {
            TreeMap<String, String> pluginsOfInterfaceType = new TreeMap<String, String>();
            pluginsOfInterfaceType.put(name, concreteType);
            PLUGINS.put(interfaceName, pluginsOfInterfaceType);
        } else {
            PLUGINS.get(interfaceName).put(name, concreteType);
        }
    }

    public static Object getPluginInstance(String interfaceType, String name) throws Exception {
        if (PLUGINS.get(interfaceType) == null || PLUGINS.get(interfaceType).size() == 0) {
            throw new Exception("No plugins of interface type: " + interfaceType + " available!!");
        }
        Map<String, String> pluginsOfInterfaceType = PLUGINS.get(interfaceType);
        if (pluginsOfInterfaceType.get(name) == null) {
            throw new Exception("Can't find named plugin '" + name + "' of type '" + interfaceType + "'!");
        }
        String concreteImpl = pluginsOfInterfaceType.get(name);
        Object plugin = Class.forName(concreteImpl).newInstance();
        return plugin;
    }
}

