/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.packageManagement;

import org.pentaho.packageManagement.Package;
import org.pentaho.packageManagement.PackageConstraint;
import org.pentaho.packageManagement.VersionPackageConstraint;

public class VersionRangePackageConstraint
extends PackageConstraint {
    protected String m_lowerBound;
    protected VersionPackageConstraint.VersionComparison m_lowerConstraint;
    protected String m_upperBound;
    protected VersionPackageConstraint.VersionComparison m_upperConstraint;
    protected boolean m_boundOr;

    public VersionRangePackageConstraint(Package package_) {
        this.setPackage(package_);
    }

    public void setRangeConstraint(String string, VersionPackageConstraint.VersionComparison versionComparison, String string2, VersionPackageConstraint.VersionComparison versionComparison2) throws Exception {
        if (versionComparison == VersionPackageConstraint.VersionComparison.EQUAL || versionComparison2 == VersionPackageConstraint.VersionComparison.EQUAL) {
            throw new Exception("[VersionRangePackageConstraint] malformed version range constraint (= not allowed)!");
        }
        if (versionComparison.compatibleWith(versionComparison2)) {
            throw new Exception("[VersionRangePackageConstraint] malformed version range constraint!");
        }
        VersionPackageConstraint.VersionComparison versionComparison3 = VersionPackageConstraint.compare(string, string2);
        if (versionComparison3 == VersionPackageConstraint.VersionComparison.EQUAL) {
            throw new Exception("[VersionRangePackageConstraint] malformed version range - both bounds are equal!");
        }
        if (versionComparison == VersionPackageConstraint.VersionComparison.GREATERTHAN || versionComparison == VersionPackageConstraint.VersionComparison.GREATERTHANOREQUAL) {
            if (versionComparison3 == VersionPackageConstraint.VersionComparison.GREATERTHAN) {
                this.m_boundOr = true;
            }
        } else if (versionComparison3 == VersionPackageConstraint.VersionComparison.LESSTHAN) {
            this.m_boundOr = true;
        }
        if (versionComparison3 == VersionPackageConstraint.VersionComparison.LESSTHAN) {
            this.m_lowerBound = string;
            this.m_lowerConstraint = versionComparison;
            this.m_upperBound = string2;
            this.m_upperConstraint = versionComparison2;
        } else {
            this.m_lowerBound = string2;
            this.m_lowerConstraint = versionComparison2;
            this.m_upperBound = string;
            this.m_upperConstraint = versionComparison;
        }
    }

    public String getLowerBound() {
        return this.m_lowerBound;
    }

    public String getUpperBound() {
        return this.m_upperBound;
    }

    public VersionPackageConstraint.VersionComparison getLowerComparison() {
        return this.m_lowerConstraint;
    }

    public VersionPackageConstraint.VersionComparison getUpperComparison() {
        return this.m_upperConstraint;
    }

    public boolean isBoundOR() {
        return this.m_boundOr;
    }

    protected static boolean checkConstraint(String string, VersionPackageConstraint.VersionComparison versionComparison, String string2, VersionPackageConstraint.VersionComparison versionComparison2, String string3, boolean bl) {
        boolean bl2 = VersionPackageConstraint.checkConstraint(string, versionComparison, string2);
        boolean bl3 = VersionPackageConstraint.checkConstraint(string, versionComparison2, string3);
        if (bl) {
            return bl2 || bl3;
        }
        return bl2 && bl3;
    }

    public boolean checkConstraint(Package package_) throws Exception {
        if (this.m_lowerConstraint == null || this.m_upperConstraint == null) {
            throw new Exception("[VersionRangePackageConstraint] No constraint has been set!");
        }
        String string = package_.getPackageMetaDataElement(VersionPackageConstraint.VERSION_KEY).toString();
        return VersionRangePackageConstraint.checkConstraint(string, this.m_lowerConstraint, this.m_lowerBound, this.m_upperConstraint, this.m_upperBound, this.m_boundOr);
    }

    protected PackageConstraint checkTargetVersionRangePackageConstraint(VersionRangePackageConstraint versionRangePackageConstraint) throws Exception {
        VersionPackageConstraint.VersionComparison versionComparison;
        String string = versionRangePackageConstraint.getLowerBound();
        String string2 = versionRangePackageConstraint.getUpperBound();
        VersionPackageConstraint.VersionComparison versionComparison2 = versionRangePackageConstraint.getLowerComparison();
        VersionPackageConstraint.VersionComparison versionComparison3 = versionRangePackageConstraint.getUpperComparison();
        if (!this.m_boundOr) {
            VersionPackageConstraint.VersionComparison versionComparison4;
            VersionPackageConstraint.VersionComparison versionComparison5;
            if (versionRangePackageConstraint.isBoundOR()) {
                Package package_ = (Package)versionRangePackageConstraint.getPackage().clone();
                package_.setPackageMetaDataElement(VersionPackageConstraint.VERSION_KEY, versionRangePackageConstraint.getLowerBound());
                VersionPackageConstraint versionPackageConstraint = new VersionPackageConstraint(package_);
                versionPackageConstraint.setVersionConstraint(versionRangePackageConstraint.getLowerComparison());
                package_ = (Package)package_.clone();
                package_.setPackageMetaDataElement(VersionPackageConstraint.VERSION_KEY, versionRangePackageConstraint.getUpperBound());
                VersionPackageConstraint versionPackageConstraint2 = new VersionPackageConstraint(package_);
                versionPackageConstraint2.setVersionConstraint(versionRangePackageConstraint.getUpperComparison());
                PackageConstraint packageConstraint = this.checkTargetVersionPackageConstraint(versionPackageConstraint);
                if (packageConstraint != null) {
                    return packageConstraint;
                }
                PackageConstraint packageConstraint2 = this.checkTargetVersionPackageConstraint(versionPackageConstraint2);
                return packageConstraint2;
            }
            String string3 = null;
            String string4 = null;
            VersionPackageConstraint.VersionComparison versionComparison6 = null;
            VersionPackageConstraint.VersionComparison versionComparison7 = null;
            VersionPackageConstraint.VersionComparison versionComparison8 = VersionPackageConstraint.compare(this.m_lowerBound, string);
            if (versionComparison8 == VersionPackageConstraint.VersionComparison.EQUAL) {
                string3 = this.m_lowerBound;
                versionComparison6 = VersionPackageConstraint.VersionComparison.GREATERTHANOREQUAL;
                if (versionComparison2 == VersionPackageConstraint.VersionComparison.GREATERTHAN || this.m_lowerConstraint == VersionPackageConstraint.VersionComparison.GREATERTHAN) {
                    versionComparison6 = VersionPackageConstraint.VersionComparison.GREATERTHAN;
                }
            } else if (versionComparison8 == VersionPackageConstraint.VersionComparison.GREATERTHAN) {
                string3 = this.m_lowerBound;
                versionComparison6 = this.m_lowerConstraint;
            } else {
                string3 = string;
                versionComparison6 = versionComparison2;
            }
            if ((versionComparison5 = VersionPackageConstraint.compare(this.m_upperBound, string2)) == VersionPackageConstraint.VersionComparison.EQUAL) {
                string4 = this.m_upperBound;
                versionComparison7 = VersionPackageConstraint.VersionComparison.LESSTHANOREQUAL;
                if (versionComparison3 == VersionPackageConstraint.VersionComparison.LESSTHAN || this.m_upperConstraint == VersionPackageConstraint.VersionComparison.LESSTHAN) {
                    versionComparison7 = VersionPackageConstraint.VersionComparison.LESSTHAN;
                }
            } else if (versionComparison5 == VersionPackageConstraint.VersionComparison.LESSTHAN) {
                string4 = this.m_upperBound;
                versionComparison7 = this.m_upperConstraint;
            } else {
                string4 = string2;
                versionComparison7 = versionComparison3;
            }
            if ((versionComparison4 = VersionPackageConstraint.compare(string4, string3)) == VersionPackageConstraint.VersionComparison.LESSTHAN || versionComparison4 == VersionPackageConstraint.VersionComparison.EQUAL) {
                return null;
            }
            VersionRangePackageConstraint versionRangePackageConstraint2 = new VersionRangePackageConstraint(this.getPackage());
            versionRangePackageConstraint2.setRangeConstraint(string3, versionComparison6, string4, versionComparison7);
            return versionRangePackageConstraint2;
        }
        if (!versionRangePackageConstraint.isBoundOR()) {
            Package package_ = (Package)this.getPackage().clone();
            package_.setPackageMetaDataElement(VersionPackageConstraint.VERSION_KEY, this.m_lowerBound);
            VersionPackageConstraint versionPackageConstraint = new VersionPackageConstraint(package_);
            versionPackageConstraint.setVersionConstraint(this.m_lowerConstraint);
            package_ = (Package)package_.clone();
            package_.setPackageMetaDataElement(VersionPackageConstraint.VERSION_KEY, this.m_upperBound);
            VersionPackageConstraint versionPackageConstraint3 = new VersionPackageConstraint(package_);
            versionPackageConstraint3.setVersionConstraint(this.m_upperConstraint);
            PackageConstraint packageConstraint = versionRangePackageConstraint.checkTargetVersionPackageConstraint(versionPackageConstraint);
            if (packageConstraint != null) {
                return packageConstraint;
            }
            PackageConstraint packageConstraint3 = this.checkTargetVersionPackageConstraint(versionPackageConstraint3);
            return packageConstraint3;
        }
        String string5 = null;
        String string6 = null;
        VersionPackageConstraint.VersionComparison versionComparison9 = null;
        VersionPackageConstraint.VersionComparison versionComparison10 = null;
        VersionPackageConstraint.VersionComparison versionComparison11 = VersionPackageConstraint.compare(this.m_lowerBound, string);
        if (versionComparison11 == VersionPackageConstraint.VersionComparison.EQUAL) {
            string5 = this.m_lowerBound;
            versionComparison9 = VersionPackageConstraint.VersionComparison.LESSTHANOREQUAL;
            if (versionComparison2 == VersionPackageConstraint.VersionComparison.LESSTHAN || this.m_lowerConstraint == VersionPackageConstraint.VersionComparison.LESSTHAN) {
                versionComparison9 = VersionPackageConstraint.VersionComparison.LESSTHAN;
            }
        } else if (versionComparison11 == VersionPackageConstraint.VersionComparison.LESSTHAN) {
            string5 = this.m_lowerBound;
            versionComparison9 = this.m_lowerConstraint;
        } else {
            string5 = string;
            versionComparison9 = versionComparison2;
        }
        if ((versionComparison = VersionPackageConstraint.compare(this.m_upperBound, string2)) == VersionPackageConstraint.VersionComparison.EQUAL) {
            string6 = this.m_upperBound;
            versionComparison10 = VersionPackageConstraint.VersionComparison.GREATERTHANOREQUAL;
            if (versionComparison3 == VersionPackageConstraint.VersionComparison.GREATERTHAN || this.m_upperConstraint == VersionPackageConstraint.VersionComparison.GREATERTHAN) {
                versionComparison10 = VersionPackageConstraint.VersionComparison.GREATERTHAN;
            }
        } else if (versionComparison == VersionPackageConstraint.VersionComparison.GREATERTHAN) {
            string6 = this.m_upperBound;
            versionComparison10 = this.m_upperConstraint;
        } else {
            string6 = string2;
            versionComparison10 = versionComparison3;
        }
        VersionRangePackageConstraint versionRangePackageConstraint3 = new VersionRangePackageConstraint(this.getPackage());
        versionRangePackageConstraint3.setRangeConstraint(string5, versionComparison9, string6, versionComparison10);
        return versionRangePackageConstraint3;
    }

    protected PackageConstraint checkTargetVersionPackageConstraint(VersionPackageConstraint versionPackageConstraint) throws Exception {
        VersionPackageConstraint.VersionComparison versionComparison = versionPackageConstraint.getVersionComparison();
        String string = versionPackageConstraint.getPackage().getPackageMetaDataElement(VersionPackageConstraint.VERSION_KEY).toString();
        VersionPackageConstraint.VersionComparison versionComparison2 = VersionPackageConstraint.compare(string, this.m_lowerBound);
        VersionPackageConstraint.VersionComparison versionComparison3 = VersionPackageConstraint.compare(string, this.m_upperBound);
        boolean bl = false;
        boolean bl2 = false;
        String string2 = null;
        String string3 = null;
        VersionPackageConstraint.VersionComparison versionComparison4 = null;
        VersionPackageConstraint.VersionComparison versionComparison5 = null;
        if (versionComparison == VersionPackageConstraint.VersionComparison.EQUAL) {
            if (this.checkConstraint(versionPackageConstraint.getPackage())) {
                return versionPackageConstraint;
            }
            return null;
        }
        if (this.m_boundOr) {
            if (this.m_lowerConstraint == VersionPackageConstraint.VersionComparison.LESSTHAN) {
                if (versionComparison2 == VersionPackageConstraint.VersionComparison.EQUAL || versionComparison2 == VersionPackageConstraint.VersionComparison.GREATERTHAN) {
                    if (versionComparison == VersionPackageConstraint.VersionComparison.GREATERTHAN || versionComparison == VersionPackageConstraint.VersionComparison.GREATERTHANOREQUAL) {
                        bl = false;
                    } else {
                        bl = true;
                        string2 = this.m_lowerBound;
                        versionComparison4 = this.m_lowerConstraint;
                    }
                } else if (versionComparison2 == VersionPackageConstraint.VersionComparison.LESSTHAN) {
                    bl = true;
                    string2 = string;
                    versionComparison4 = versionComparison;
                    if (versionComparison == VersionPackageConstraint.VersionComparison.LESSTHAN || versionComparison == VersionPackageConstraint.VersionComparison.LESSTHANOREQUAL) {
                        string3 = null;
                    } else {
                        string3 = this.m_lowerBound;
                        versionComparison5 = this.m_lowerConstraint;
                    }
                }
            } else if (versionComparison2 == VersionPackageConstraint.VersionComparison.GREATERTHAN) {
                if (versionComparison == VersionPackageConstraint.VersionComparison.GREATERTHAN || versionComparison == VersionPackageConstraint.VersionComparison.GREATERTHANOREQUAL) {
                    bl = false;
                } else {
                    bl = true;
                    string2 = this.m_lowerBound;
                    versionComparison4 = this.m_lowerConstraint;
                }
            } else if (versionComparison2 == VersionPackageConstraint.VersionComparison.EQUAL) {
                if (versionComparison == VersionPackageConstraint.VersionComparison.GREATERTHAN) {
                    bl = false;
                } else {
                    bl = true;
                    string2 = string;
                    versionComparison4 = versionComparison;
                    string3 = null;
                }
            } else {
                bl = true;
                string2 = string;
                versionComparison4 = versionComparison;
                if (versionComparison == VersionPackageConstraint.VersionComparison.LESSTHAN || versionComparison == VersionPackageConstraint.VersionComparison.LESSTHANOREQUAL) {
                    string3 = null;
                } else {
                    string3 = this.m_lowerBound;
                    versionComparison5 = this.m_lowerConstraint;
                }
            }
            if (!bl) {
                if (this.m_upperConstraint == VersionPackageConstraint.VersionComparison.GREATERTHAN) {
                    if (versionComparison3 == VersionPackageConstraint.VersionComparison.EQUAL || versionComparison3 == VersionPackageConstraint.VersionComparison.LESSTHAN) {
                        if (versionComparison == VersionPackageConstraint.VersionComparison.LESSTHAN || versionComparison == VersionPackageConstraint.VersionComparison.LESSTHANOREQUAL) {
                            bl2 = false;
                        } else {
                            bl = true;
                            string3 = this.m_upperBound;
                            versionComparison5 = this.m_upperConstraint;
                        }
                    } else if (versionComparison3 == VersionPackageConstraint.VersionComparison.GREATERTHAN) {
                        bl2 = true;
                        string3 = string;
                        versionComparison5 = versionComparison;
                        if (versionComparison == VersionPackageConstraint.VersionComparison.GREATERTHAN || versionComparison == VersionPackageConstraint.VersionComparison.GREATERTHANOREQUAL) {
                            string2 = null;
                        } else {
                            string2 = this.m_upperBound;
                            versionComparison4 = this.m_upperConstraint;
                        }
                    }
                } else if (versionComparison3 == VersionPackageConstraint.VersionComparison.LESSTHAN) {
                    if (versionComparison == VersionPackageConstraint.VersionComparison.LESSTHAN || versionComparison == VersionPackageConstraint.VersionComparison.LESSTHANOREQUAL) {
                        bl2 = false;
                    } else {
                        bl2 = true;
                        string3 = this.m_upperBound;
                        versionComparison5 = this.m_upperConstraint;
                    }
                } else if (versionComparison3 == VersionPackageConstraint.VersionComparison.EQUAL) {
                    if (versionComparison == VersionPackageConstraint.VersionComparison.LESSTHAN) {
                        bl2 = false;
                    } else {
                        bl2 = true;
                        string3 = string;
                        versionComparison5 = versionComparison;
                        string2 = null;
                    }
                } else {
                    bl2 = true;
                    string3 = string;
                    versionComparison5 = versionComparison;
                    if (versionComparison == VersionPackageConstraint.VersionComparison.GREATERTHAN || versionComparison == VersionPackageConstraint.VersionComparison.GREATERTHANOREQUAL) {
                        string2 = null;
                    } else {
                        string2 = this.m_upperBound;
                        versionComparison4 = this.m_upperConstraint;
                    }
                }
            }
            if (!bl && !bl2) {
                throw new Exception("[VersionRangePackageConstraint] This shouldn't be possible!!");
            }
            if (string2 != null && string3 != null) {
                VersionRangePackageConstraint versionRangePackageConstraint = new VersionRangePackageConstraint(this.getPackage());
                versionRangePackageConstraint.setRangeConstraint(string2, versionComparison4, string3, versionComparison5);
                return versionRangePackageConstraint;
            }
            String string4 = string2 != null ? string2 : string3;
            VersionPackageConstraint.VersionComparison versionComparison6 = versionComparison4 != null ? versionComparison4 : versionComparison5;
            Package package_ = (Package)this.getPackage().clone();
            package_.setPackageMetaDataElement(VersionPackageConstraint.VERSION_KEY, string4);
            VersionPackageConstraint versionPackageConstraint2 = new VersionPackageConstraint(package_);
            versionPackageConstraint2.setVersionConstraint(versionComparison6);
            return versionPackageConstraint2;
        }
        if (versionComparison2 == VersionPackageConstraint.VersionComparison.LESSTHAN) {
            if (versionComparison == VersionPackageConstraint.VersionComparison.LESSTHAN || versionComparison == VersionPackageConstraint.VersionComparison.LESSTHANOREQUAL || versionComparison == VersionPackageConstraint.VersionComparison.EQUAL) {
                bl = false;
            } else {
                bl = true;
                string2 = this.m_lowerBound;
                versionComparison4 = this.m_lowerConstraint;
                string3 = this.m_upperBound;
                versionComparison5 = this.m_upperConstraint;
            }
        } else if (versionComparison2 == VersionPackageConstraint.VersionComparison.EQUAL) {
            if (versionComparison == VersionPackageConstraint.VersionComparison.GREATERTHANOREQUAL || versionComparison == VersionPackageConstraint.VersionComparison.GREATERTHAN) {
                bl = true;
                string2 = this.m_lowerBound;
                versionComparison4 = this.m_lowerConstraint == VersionPackageConstraint.VersionComparison.GREATERTHAN || versionComparison == VersionPackageConstraint.VersionComparison.GREATERTHAN ? VersionPackageConstraint.VersionComparison.GREATERTHAN : VersionPackageConstraint.VersionComparison.GREATERTHANOREQUAL;
                string3 = this.m_upperBound;
                versionComparison5 = this.m_upperConstraint;
            } else if (versionComparison == VersionPackageConstraint.VersionComparison.LESSTHANOREQUAL && this.m_lowerConstraint == VersionPackageConstraint.VersionComparison.GREATERTHANOREQUAL) {
                VersionPackageConstraint.VersionComparison versionComparison7 = VersionPackageConstraint.VersionComparison.EQUAL;
                VersionPackageConstraint versionPackageConstraint3 = new VersionPackageConstraint(versionPackageConstraint.getPackage());
                versionPackageConstraint3.setVersionConstraint(versionComparison7);
                return versionPackageConstraint3;
            }
        } else if (versionComparison2 == VersionPackageConstraint.VersionComparison.GREATERTHAN && versionComparison3 == VersionPackageConstraint.VersionComparison.LESSTHAN) {
            if (versionComparison == VersionPackageConstraint.VersionComparison.LESSTHAN || versionComparison == VersionPackageConstraint.VersionComparison.LESSTHANOREQUAL) {
                bl = true;
                bl2 = true;
                string2 = this.m_lowerBound;
                versionComparison4 = this.m_lowerConstraint;
                string3 = string;
                versionComparison5 = versionComparison;
            } else {
                string2 = string;
                versionComparison4 = versionComparison;
                string3 = this.m_upperBound;
                versionComparison5 = this.m_upperConstraint;
            }
        }
        if (string2 == null || string3 == null) {
            if (versionComparison3 == VersionPackageConstraint.VersionComparison.EQUAL) {
                if (versionComparison == VersionPackageConstraint.VersionComparison.LESSTHANOREQUAL || versionComparison == VersionPackageConstraint.VersionComparison.LESSTHAN) {
                    bl2 = true;
                    string3 = this.m_upperBound;
                    versionComparison5 = this.m_upperConstraint == VersionPackageConstraint.VersionComparison.LESSTHAN || versionComparison == VersionPackageConstraint.VersionComparison.LESSTHAN ? VersionPackageConstraint.VersionComparison.LESSTHAN : VersionPackageConstraint.VersionComparison.LESSTHANOREQUAL;
                    string2 = this.m_lowerBound;
                    versionComparison4 = this.m_lowerConstraint;
                } else if (versionComparison == VersionPackageConstraint.VersionComparison.GREATERTHANOREQUAL && this.m_upperConstraint == VersionPackageConstraint.VersionComparison.LESSTHANOREQUAL) {
                    VersionPackageConstraint.VersionComparison versionComparison8 = VersionPackageConstraint.VersionComparison.EQUAL;
                    VersionPackageConstraint versionPackageConstraint4 = new VersionPackageConstraint(versionPackageConstraint.getPackage());
                    versionPackageConstraint4.setVersionConstraint(versionComparison8);
                    return versionPackageConstraint4;
                }
            } else if (versionComparison3 == VersionPackageConstraint.VersionComparison.GREATERTHAN) {
                if (versionComparison == VersionPackageConstraint.VersionComparison.GREATERTHAN || versionComparison == VersionPackageConstraint.VersionComparison.GREATERTHANOREQUAL || versionComparison == VersionPackageConstraint.VersionComparison.EQUAL) {
                    bl2 = false;
                } else {
                    bl2 = true;
                    string3 = this.m_upperBound;
                    versionComparison5 = this.m_upperConstraint;
                    string2 = this.m_lowerBound;
                    versionComparison4 = this.m_lowerConstraint;
                }
            }
        }
        if (string3 == null && string2 == null) {
            return null;
        }
        if (string3 == null || string2 == null) {
            throw new Exception("[VersionRangePackageConstraint] This shouldn't be possible!!");
        }
        VersionRangePackageConstraint versionRangePackageConstraint = new VersionRangePackageConstraint(this.getPackage());
        versionRangePackageConstraint.setRangeConstraint(string2, versionComparison4, string3, versionComparison5);
        return versionRangePackageConstraint;
    }

    public PackageConstraint checkConstraint(PackageConstraint packageConstraint) throws Exception {
        if (this.m_lowerConstraint == null || this.m_upperConstraint == null) {
            throw new Exception("[VersionRangePackageConstraint] No constraint has been set!");
        }
        if (!(packageConstraint instanceof VersionRangePackageConstraint) && !(packageConstraint instanceof VersionPackageConstraint)) {
            throw new Exception("[VersionRangePackageConstraint] incompatible target constraint!");
        }
        if (packageConstraint instanceof VersionPackageConstraint) {
            PackageConstraint packageConstraint2 = this.checkTargetVersionPackageConstraint((VersionPackageConstraint)packageConstraint);
            return packageConstraint2;
        }
        if (packageConstraint instanceof VersionRangePackageConstraint) {
            PackageConstraint packageConstraint3 = this.checkTargetVersionRangePackageConstraint((VersionRangePackageConstraint)packageConstraint);
            return packageConstraint3;
        }
        return null;
    }
}

