/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.functions.neural.LinearUnit;
import weka.classifiers.functions.neural.NeuralConnection;
import weka.classifiers.functions.neural.NeuralNode;
import weka.classifiers.functions.neural.SigmoidUnit;
import weka.classifiers.rules.ZeroR;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Randomizable;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.NominalToBinary;

public class MultilayerPerceptron
extends AbstractClassifier
implements OptionHandler,
WeightedInstancesHandler,
Randomizable {
    private static final long serialVersionUID = -5990607817048210779L;
    private Classifier m_ZeroR;
    private boolean m_useDefaultModel = false;
    private Instances m_instances = null;
    private Instance m_currentInstance = null;
    private boolean m_numeric = false;
    private double[] m_attributeRanges;
    private double[] m_attributeBases;
    private NeuralEnd[] m_outputs = new NeuralEnd[0];
    private NeuralEnd[] m_inputs = new NeuralEnd[0];
    private NeuralConnection[] m_neuralNodes = new NeuralConnection[0];
    private int m_numClasses = 0;
    private int m_numAttributes = 0;
    private NodePanel m_nodePanel = null;
    private ControlPanel m_controlPanel = null;
    private int m_nextId = 0;
    private FastVector m_selected = new FastVector(4);
    private FastVector m_graphers = new FastVector(2);
    private int m_numEpochs = 500;
    private boolean m_stopIt = true;
    private boolean m_stopped = true;
    private boolean m_accepted = false;
    private JFrame m_win;
    private boolean m_autoBuild = true;
    private boolean m_gui = false;
    private int m_valSize = 0;
    private int m_driftThreshold = 20;
    private int m_randomSeed = 0;
    private Random m_random = null;
    private boolean m_useNomToBin = true;
    private NominalToBinary m_nominalToBinaryFilter = new NominalToBinary();
    private String m_hiddenLayers = "a";
    private boolean m_normalizeAttributes = true;
    private boolean m_decay = false;
    private double m_learningRate = 0.3;
    private double m_momentum = 0.2;
    private int m_epoch = 0;
    private double m_error = 0.0;
    private boolean m_reset = true;
    private boolean m_normalizeClass = true;
    private SigmoidUnit m_sigmoidUnit = new SigmoidUnit();
    private LinearUnit m_linearUnit = new LinearUnit();

    public static void main(String[] argv) {
        MultilayerPerceptron.runClassifier(new MultilayerPerceptron(), argv);
    }

    public void setDecay(boolean d) {
        this.m_decay = d;
    }

    public boolean getDecay() {
        return this.m_decay;
    }

    public void setReset(boolean r) {
        if (this.m_gui) {
            r = false;
        }
        this.m_reset = r;
    }

    public boolean getReset() {
        return this.m_reset;
    }

    public void setNormalizeNumericClass(boolean c) {
        this.m_normalizeClass = c;
    }

    public boolean getNormalizeNumericClass() {
        return this.m_normalizeClass;
    }

    public void setNormalizeAttributes(boolean a) {
        this.m_normalizeAttributes = a;
    }

    public boolean getNormalizeAttributes() {
        return this.m_normalizeAttributes;
    }

    public void setNominalToBinaryFilter(boolean f) {
        this.m_useNomToBin = f;
    }

    public boolean getNominalToBinaryFilter() {
        return this.m_useNomToBin;
    }

    public void setSeed(int l) {
        if (l >= 0) {
            this.m_randomSeed = l;
        }
    }

    public int getSeed() {
        return this.m_randomSeed;
    }

    public void setValidationThreshold(int t) {
        if (t > 0) {
            this.m_driftThreshold = t;
        }
    }

    public int getValidationThreshold() {
        return this.m_driftThreshold;
    }

    public void setLearningRate(double l) {
        if (l > 0.0 && l <= 1.0) {
            this.m_learningRate = l;
            if (this.m_controlPanel != null) {
                this.m_controlPanel.m_changeLearning.setText("" + l);
            }
        }
    }

    public double getLearningRate() {
        return this.m_learningRate;
    }

    public void setMomentum(double m) {
        if (m >= 0.0 && m <= 1.0) {
            this.m_momentum = m;
            if (this.m_controlPanel != null) {
                this.m_controlPanel.m_changeMomentum.setText("" + m);
            }
        }
    }

    public double getMomentum() {
        return this.m_momentum;
    }

    public void setAutoBuild(boolean a) {
        if (!this.m_gui) {
            a = true;
        }
        this.m_autoBuild = a;
    }

    public boolean getAutoBuild() {
        return this.m_autoBuild;
    }

    public void setHiddenLayers(String h) {
        String tmp = "";
        StringTokenizer tok = new StringTokenizer(h, ",");
        if (tok.countTokens() == 0) {
            return;
        }
        boolean first = true;
        while (tok.hasMoreTokens()) {
            String c = tok.nextToken().trim();
            if (c.equals("a") || c.equals("i") || c.equals("o") || c.equals("t")) {
                tmp = tmp + c;
            } else {
                double dval = Double.valueOf(c);
                int val = (int)dval;
                if ((double)val == dval && (val != 0 || tok.countTokens() == 0 && first) && val >= 0) {
                    tmp = tmp + val;
                } else {
                    return;
                }
            }
            first = false;
            if (!tok.hasMoreTokens()) continue;
            tmp = tmp + ", ";
        }
        this.m_hiddenLayers = tmp;
    }

    public String getHiddenLayers() {
        return this.m_hiddenLayers;
    }

    public void setGUI(boolean a) {
        this.m_gui = a;
        if (!a) {
            this.setAutoBuild(true);
        } else {
            this.setReset(false);
        }
    }

    public boolean getGUI() {
        return this.m_gui;
    }

    public void setValidationSetSize(int a) {
        if (a < 0 || a > 99) {
            return;
        }
        this.m_valSize = a;
    }

    public int getValidationSetSize() {
        return this.m_valSize;
    }

    public void setTrainingTime(int n) {
        if (n > 0) {
            this.m_numEpochs = n;
        }
    }

    public int getTrainingTime() {
        return this.m_numEpochs;
    }

    private void addNode(NeuralConnection n) {
        NeuralConnection[] temp1 = new NeuralConnection[this.m_neuralNodes.length + 1];
        for (int noa = 0; noa < this.m_neuralNodes.length; ++noa) {
            temp1[noa] = this.m_neuralNodes[noa];
        }
        temp1[temp1.length - 1] = n;
        this.m_neuralNodes = temp1;
    }

    private boolean removeNode(NeuralConnection n) {
        NeuralConnection[] temp1 = new NeuralConnection[this.m_neuralNodes.length - 1];
        int skip = 0;
        for (int noa = 0; noa < this.m_neuralNodes.length; ++noa) {
            if (n == this.m_neuralNodes[noa]) {
                ++skip;
                continue;
            }
            if (noa - skip < temp1.length) {
                temp1[noa - skip] = this.m_neuralNodes[noa];
                continue;
            }
            return false;
        }
        this.m_neuralNodes = temp1;
        return true;
    }

    private Instances setClassType(Instances inst) throws Exception {
        if (inst != null) {
            double min = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            this.m_attributeRanges = new double[inst.numAttributes()];
            this.m_attributeBases = new double[inst.numAttributes()];
            for (int noa = 0; noa < inst.numAttributes(); ++noa) {
                int i;
                min = Double.POSITIVE_INFINITY;
                max = Double.NEGATIVE_INFINITY;
                for (i = 0; i < inst.numInstances(); ++i) {
                    if (inst.instance(i).isMissing(noa)) continue;
                    double value = inst.instance(i).value(noa);
                    if (value < min) {
                        min = value;
                    }
                    if (!(value > max)) continue;
                    max = value;
                }
                this.m_attributeRanges[noa] = (max - min) / 2.0;
                this.m_attributeBases[noa] = (max + min) / 2.0;
                if (noa == inst.classIndex() || !this.m_normalizeAttributes) continue;
                for (i = 0; i < inst.numInstances(); ++i) {
                    if (this.m_attributeRanges[noa] != 0.0) {
                        inst.instance(i).setValue(noa, (inst.instance(i).value(noa) - this.m_attributeBases[noa]) / this.m_attributeRanges[noa]);
                        continue;
                    }
                    inst.instance(i).setValue(noa, inst.instance(i).value(noa) - this.m_attributeBases[noa]);
                }
            }
            this.m_numeric = inst.classAttribute().isNumeric();
        }
        return inst;
    }

    public synchronized void blocker(boolean tf) {
        if (tf) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.notifyAll();
        }
    }

    private void updateDisplay() {
        if (this.m_gui) {
            this.m_controlPanel.m_errorLabel.repaint();
            this.m_controlPanel.m_epochsLabel.repaint();
        }
    }

    private void resetNetwork() {
        for (int noc = 0; noc < this.m_numClasses; ++noc) {
            this.m_outputs[noc].reset();
        }
    }

    private void calculateOutputs() {
        for (int noc = 0; noc < this.m_numClasses; ++noc) {
            this.m_outputs[noc].outputValue(true);
        }
    }

    private double calculateErrors() throws Exception {
        int noc;
        double ret = 0.0;
        double temp = 0.0;
        for (noc = 0; noc < this.m_numAttributes; ++noc) {
            this.m_inputs[noc].errorValue(true);
        }
        for (noc = 0; noc < this.m_numClasses; ++noc) {
            temp = this.m_outputs[noc].errorValue(false);
            ret += temp * temp;
        }
        return ret;
    }

    private void updateNetworkWeights(double l, double m) {
        for (int noc = 0; noc < this.m_numClasses; ++noc) {
            this.m_outputs[noc].updateWeights(l, m);
        }
    }

    private void setupInputs() throws Exception {
        this.m_inputs = new NeuralEnd[this.m_numAttributes];
        int now = 0;
        for (int noa = 0; noa < this.m_numAttributes + 1; ++noa) {
            if (this.m_instances.classIndex() != noa) {
                this.m_inputs[noa - now] = new NeuralEnd(this.m_instances.attribute(noa).name());
                this.m_inputs[noa - now].setX(0.1);
                this.m_inputs[noa - now].setY(((double)(noa - now) + 1.0) / (double)(this.m_numAttributes + 1));
                this.m_inputs[noa - now].setLink(true, noa);
                continue;
            }
            now = 1;
        }
    }

    private void setupOutputs() throws Exception {
        this.m_outputs = new NeuralEnd[this.m_numClasses];
        for (int noa = 0; noa < this.m_numClasses; ++noa) {
            this.m_outputs[noa] = this.m_numeric ? new NeuralEnd(this.m_instances.classAttribute().name()) : new NeuralEnd(this.m_instances.classAttribute().value(noa));
            this.m_outputs[noa].setX(0.9);
            this.m_outputs[noa].setY(((double)noa + 1.0) / (double)(this.m_numClasses + 1));
            this.m_outputs[noa].setLink(false, noa);
            NeuralNode temp = new NeuralNode(String.valueOf(this.m_nextId), this.m_random, this.m_sigmoidUnit);
            ++this.m_nextId;
            temp.setX(0.75);
            temp.setY(((double)noa + 1.0) / (double)(this.m_numClasses + 1));
            this.addNode(temp);
            NeuralConnection.connect(temp, this.m_outputs[noa]);
        }
    }

    private void setupHiddenLayer() {
        int nob;
        String c;
        int noa;
        StringTokenizer tok = new StringTokenizer(this.m_hiddenLayers, ",");
        int val = 0;
        int prev = 0;
        int num = tok.countTokens();
        for (noa = 0; noa < num; ++noa) {
            c = tok.nextToken().trim();
            val = c.equals("a") ? (this.m_numAttributes + this.m_numClasses) / 2 : (c.equals("i") ? this.m_numAttributes : (c.equals("o") ? this.m_numClasses : (c.equals("t") ? this.m_numAttributes + this.m_numClasses : Double.valueOf(c).intValue())));
            for (nob = 0; nob < val; ++nob) {
                NeuralNode temp = new NeuralNode(String.valueOf(this.m_nextId), this.m_random, this.m_sigmoidUnit);
                ++this.m_nextId;
                temp.setX(0.5 / (double)num * (double)noa + 0.25);
                temp.setY(((double)nob + 1.0) / (double)(val + 1));
                this.addNode(temp);
                if (noa <= 0) continue;
                for (int noc = this.m_neuralNodes.length - nob - 1 - prev; noc < this.m_neuralNodes.length - nob - 1; ++noc) {
                    NeuralConnection.connect(this.m_neuralNodes[noc], temp);
                }
            }
            prev = val;
        }
        tok = new StringTokenizer(this.m_hiddenLayers, ",");
        c = tok.nextToken();
        val = c.equals("a") ? (this.m_numAttributes + this.m_numClasses) / 2 : (c.equals("i") ? this.m_numAttributes : (c.equals("o") ? this.m_numClasses : (c.equals("t") ? this.m_numAttributes + this.m_numClasses : Double.valueOf(c).intValue())));
        if (val == 0) {
            for (noa = 0; noa < this.m_numAttributes; ++noa) {
                for (nob = 0; nob < this.m_numClasses; ++nob) {
                    NeuralConnection.connect(this.m_inputs[noa], this.m_neuralNodes[nob]);
                }
            }
        } else {
            for (noa = 0; noa < this.m_numAttributes; ++noa) {
                for (nob = this.m_numClasses; nob < this.m_numClasses + val; ++nob) {
                    NeuralConnection.connect(this.m_inputs[noa], this.m_neuralNodes[nob]);
                }
            }
            for (noa = this.m_neuralNodes.length - prev; noa < this.m_neuralNodes.length; ++noa) {
                for (nob = 0; nob < this.m_numClasses; ++nob) {
                    NeuralConnection.connect(this.m_neuralNodes[noa], this.m_neuralNodes[nob]);
                }
            }
        }
    }

    private void setEndsToLinear() {
        for (int noa = 0; noa < this.m_neuralNodes.length; ++noa) {
            if ((this.m_neuralNodes[noa].getType() & 8) == 8) {
                ((NeuralNode)this.m_neuralNodes[noa]).setMethod(this.m_linearUnit);
                continue;
            }
            ((NeuralNode)this.m_neuralNodes[noa]).setMethod(this.m_sigmoidUnit);
        }
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    public void buildClassifier(Instances i) throws Exception {
        int noa;
        this.getCapabilities().testWithFail(i);
        i = new Instances(i);
        i.deleteWithMissingClass();
        this.m_ZeroR = new ZeroR();
        this.m_ZeroR.buildClassifier(i);
        if (i.numAttributes() == 1) {
            System.err.println("Cannot build model (only class attribute present in data!), using ZeroR model instead!");
            this.m_useDefaultModel = true;
            return;
        }
        this.m_useDefaultModel = false;
        this.m_epoch = 0;
        this.m_error = 0.0;
        this.m_instances = null;
        this.m_currentInstance = null;
        this.m_controlPanel = null;
        this.m_nodePanel = null;
        this.m_outputs = new NeuralEnd[0];
        this.m_inputs = new NeuralEnd[0];
        this.m_numAttributes = 0;
        this.m_numClasses = 0;
        this.m_neuralNodes = new NeuralConnection[0];
        this.m_selected = new FastVector(4);
        this.m_graphers = new FastVector(2);
        this.m_nextId = 0;
        this.m_stopIt = true;
        this.m_stopped = true;
        this.m_accepted = false;
        this.m_instances = new Instances(i);
        this.m_random = new Random(this.m_randomSeed);
        this.m_instances.randomize(this.m_random);
        if (this.m_useNomToBin) {
            this.m_nominalToBinaryFilter = new NominalToBinary();
            this.m_nominalToBinaryFilter.setInputFormat(this.m_instances);
            this.m_instances = Filter.useFilter(this.m_instances, this.m_nominalToBinaryFilter);
        }
        this.m_numAttributes = this.m_instances.numAttributes() - 1;
        this.m_numClasses = this.m_instances.numClasses();
        this.setClassType(this.m_instances);
        Instances valSet = null;
        int numInVal = (int)((double)this.m_valSize / 100.0 * (double)this.m_instances.numInstances());
        if (this.m_valSize > 0) {
            if (numInVal == 0) {
                numInVal = 1;
            }
            valSet = new Instances(this.m_instances, 0, numInVal);
        }
        this.setupInputs();
        this.setupOutputs();
        if (this.m_autoBuild) {
            this.setupHiddenLayer();
        }
        if (this.m_gui) {
            this.m_win = new JFrame();
            this.m_win.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    boolean k = MultilayerPerceptron.this.m_stopIt;
                    MultilayerPerceptron.this.m_stopIt = true;
                    int well = JOptionPane.showConfirmDialog(MultilayerPerceptron.this.m_win, "Are You Sure...\nClick Yes To Accept The Neural Network\n Click No To Return", "Accept Neural Network", 0);
                    if (well == 0) {
                        MultilayerPerceptron.this.m_win.setDefaultCloseOperation(2);
                        MultilayerPerceptron.this.m_accepted = true;
                        MultilayerPerceptron.this.blocker(false);
                    } else {
                        MultilayerPerceptron.this.m_win.setDefaultCloseOperation(0);
                    }
                    MultilayerPerceptron.this.m_stopIt = k;
                }
            });
            this.m_win.getContentPane().setLayout(new BorderLayout());
            this.m_win.setTitle("Neural Network");
            this.m_nodePanel = new NodePanel();
            this.m_nodePanel.setPreferredSize(new Dimension(640, 480));
            this.m_nodePanel.revalidate();
            JScrollPane sp = new JScrollPane(this.m_nodePanel, 22, 31);
            this.m_controlPanel = new ControlPanel();
            this.m_win.getContentPane().add((Component)sp, "Center");
            this.m_win.getContentPane().add((Component)this.m_controlPanel, "South");
            this.m_win.setSize(640, 480);
            this.m_win.setVisible(true);
        }
        if (this.m_gui) {
            this.blocker(true);
            this.m_controlPanel.m_changeEpochs.setEnabled(false);
            this.m_controlPanel.m_changeLearning.setEnabled(false);
            this.m_controlPanel.m_changeMomentum.setEnabled(false);
        }
        if (this.m_numeric) {
            this.setEndsToLinear();
        }
        if (this.m_accepted) {
            this.m_win.dispose();
            this.m_controlPanel = null;
            this.m_nodePanel = null;
            this.m_instances = new Instances(this.m_instances, 0);
            return;
        }
        double right = 0.0;
        double driftOff = 0.0;
        double lastRight = Double.POSITIVE_INFINITY;
        double bestError = Double.POSITIVE_INFINITY;
        double totalWeight = 0.0;
        double totalValWeight = 0.0;
        double origRate = this.m_learningRate;
        if (numInVal == this.m_instances.numInstances()) {
            --numInVal;
        }
        if (numInVal < 0) {
            numInVal = 0;
        }
        for (noa = numInVal; noa < this.m_instances.numInstances(); ++noa) {
            if (this.m_instances.instance(noa).classIsMissing()) continue;
            totalWeight += this.m_instances.instance(noa).weight();
        }
        if (this.m_valSize != 0) {
            for (noa = 0; noa < valSet.numInstances(); ++noa) {
                if (valSet.instance(noa).classIsMissing()) continue;
                totalValWeight += valSet.instance(noa).weight();
            }
        }
        this.m_stopped = false;
        for (noa = 1; noa < this.m_numEpochs + 1; ++noa) {
            int nob;
            right = 0.0;
            for (nob = numInVal; nob < this.m_instances.numInstances(); ++nob) {
                this.m_currentInstance = this.m_instances.instance(nob);
                if (this.m_currentInstance.classIsMissing()) continue;
                this.resetNetwork();
                this.calculateOutputs();
                double tempRate = this.m_learningRate * this.m_currentInstance.weight();
                if (this.m_decay) {
                    tempRate /= (double)noa;
                }
                right += this.calculateErrors() / (double)this.m_instances.numClasses() * this.m_currentInstance.weight();
                this.updateNetworkWeights(tempRate, this.m_momentum);
            }
            if (Double.isInfinite(right /= totalWeight) || Double.isNaN(right)) {
                if (!this.m_reset) {
                    this.m_instances = null;
                    throw new Exception("Network cannot train. Try restarting with a smaller learning rate.");
                }
                if (this.m_learningRate <= Utils.SMALL) {
                    throw new IllegalStateException("Learning rate got too small (" + this.m_learningRate + " <= " + Utils.SMALL + ")!");
                }
                this.m_learningRate /= 2.0;
                this.buildClassifier(i);
                this.m_learningRate = origRate;
                this.m_instances = new Instances(this.m_instances, 0);
                return;
            }
            if (this.m_valSize != 0) {
                int noc;
                right = 0.0;
                for (nob = 0; nob < valSet.numInstances(); ++nob) {
                    this.m_currentInstance = valSet.instance(nob);
                    if (this.m_currentInstance.classIsMissing()) continue;
                    this.resetNetwork();
                    this.calculateOutputs();
                    right += this.calculateErrors() / (double)valSet.numClasses() * this.m_currentInstance.weight();
                }
                if (right < lastRight) {
                    if (right < bestError) {
                        bestError = right;
                        for (noc = 0; noc < this.m_numClasses; ++noc) {
                            this.m_outputs[noc].saveWeights();
                        }
                        driftOff = 0.0;
                    }
                } else {
                    driftOff += 1.0;
                }
                lastRight = right;
                if (driftOff > (double)this.m_driftThreshold || noa + 1 >= this.m_numEpochs) {
                    for (noc = 0; noc < this.m_numClasses; ++noc) {
                        this.m_outputs[noc].restoreWeights();
                    }
                    this.m_accepted = true;
                }
                right /= totalValWeight;
            }
            this.m_epoch = noa;
            this.m_error = right;
            this.updateDisplay();
            if (this.m_gui) {
                while ((this.m_stopIt || this.m_epoch >= this.m_numEpochs && this.m_valSize == 0) && !this.m_accepted) {
                    this.m_stopIt = true;
                    this.m_stopped = true;
                    if (this.m_epoch >= this.m_numEpochs && this.m_valSize == 0) {
                        this.m_controlPanel.m_startStop.setEnabled(false);
                    } else {
                        this.m_controlPanel.m_startStop.setEnabled(true);
                    }
                    this.m_controlPanel.m_startStop.setText("Start");
                    this.m_controlPanel.m_startStop.setActionCommand("Start");
                    this.m_controlPanel.m_changeEpochs.setEnabled(true);
                    this.m_controlPanel.m_changeLearning.setEnabled(true);
                    this.m_controlPanel.m_changeMomentum.setEnabled(true);
                    this.blocker(true);
                    if (!this.m_numeric) continue;
                    this.setEndsToLinear();
                }
                this.m_controlPanel.m_changeEpochs.setEnabled(false);
                this.m_controlPanel.m_changeLearning.setEnabled(false);
                this.m_controlPanel.m_changeMomentum.setEnabled(false);
                this.m_stopped = false;
                if (this.m_accepted) {
                    this.m_win.dispose();
                    this.m_controlPanel = null;
                    this.m_nodePanel = null;
                    this.m_instances = new Instances(this.m_instances, 0);
                    return;
                }
            }
            if (!this.m_accepted) continue;
            this.m_instances = new Instances(this.m_instances, 0);
            return;
        }
        if (this.m_gui) {
            this.m_win.dispose();
            this.m_controlPanel = null;
            this.m_nodePanel = null;
        }
        this.m_instances = new Instances(this.m_instances, 0);
    }

    public double[] distributionForInstance(Instance i) throws Exception {
        int noa;
        if (this.m_useDefaultModel) {
            return this.m_ZeroR.distributionForInstance(i);
        }
        if (this.m_useNomToBin) {
            this.m_nominalToBinaryFilter.input(i);
            this.m_currentInstance = this.m_nominalToBinaryFilter.output();
        } else {
            this.m_currentInstance = i;
        }
        if (this.m_normalizeAttributes) {
            for (int noa2 = 0; noa2 < this.m_instances.numAttributes(); ++noa2) {
                if (noa2 == this.m_instances.classIndex()) continue;
                if (this.m_attributeRanges[noa2] != 0.0) {
                    this.m_currentInstance.setValue(noa2, (this.m_currentInstance.value(noa2) - this.m_attributeBases[noa2]) / this.m_attributeRanges[noa2]);
                    continue;
                }
                this.m_currentInstance.setValue(noa2, this.m_currentInstance.value(noa2) - this.m_attributeBases[noa2]);
            }
        }
        this.resetNetwork();
        double[] theArray = new double[this.m_numClasses];
        for (int noa3 = 0; noa3 < this.m_numClasses; ++noa3) {
            theArray[noa3] = this.m_outputs[noa3].outputValue(true);
        }
        if (this.m_instances.classAttribute().isNumeric()) {
            return theArray;
        }
        double count = 0.0;
        for (noa = 0; noa < this.m_numClasses; ++noa) {
            count += theArray[noa];
        }
        if (count <= 0.0) {
            return this.m_ZeroR.distributionForInstance(i);
        }
        noa = 0;
        while (noa < this.m_numClasses) {
            int n = noa++;
            theArray[n] = theArray[n] / count;
        }
        return theArray;
    }

    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(14);
        newVector.addElement(new Option("\tLearning Rate for the backpropagation algorithm.\n\t(Value should be between 0 - 1, Default = 0.3).", "L", 1, "-L <learning rate>"));
        newVector.addElement(new Option("\tMomentum Rate for the backpropagation algorithm.\n\t(Value should be between 0 - 1, Default = 0.2).", "M", 1, "-M <momentum>"));
        newVector.addElement(new Option("\tNumber of epochs to train through.\n\t(Default = 500).", "N", 1, "-N <number of epochs>"));
        newVector.addElement(new Option("\tPercentage size of validation set to use to terminate\n\ttraining (if this is non zero it can pre-empt num of epochs.\n\t(Value should be between 0 - 100, Default = 0).", "V", 1, "-V <percentage size of validation set>"));
        newVector.addElement(new Option("\tThe value used to seed the random number generator\n\t(Value should be >= 0 and and a long, Default = 0).", "S", 1, "-S <seed>"));
        newVector.addElement(new Option("\tThe consequetive number of errors allowed for validation\n\ttesting before the netwrok terminates.\n\t(Value should be > 0, Default = 20).", "E", 1, "-E <threshold for number of consequetive errors>"));
        newVector.addElement(new Option("\tGUI will be opened.\n\t(Use this to bring up a GUI).", "G", 0, "-G"));
        newVector.addElement(new Option("\tAutocreation of the network connections will NOT be done.\n\t(This will be ignored if -G is NOT set)", "A", 0, "-A"));
        newVector.addElement(new Option("\tA NominalToBinary filter will NOT automatically be used.\n\t(Set this to not use a NominalToBinary filter).", "B", 0, "-B"));
        newVector.addElement(new Option("\tThe hidden layers to be created for the network.\n\t(Value should be a list of comma separated Natural \n\tnumbers or the letters 'a' = (attribs + classes) / 2, \n\t'i' = attribs, 'o' = classes, 't' = attribs .+ classes)\n\tfor wildcard values, Default = a).", "H", 1, "-H <comma seperated numbers for nodes on each layer>"));
        newVector.addElement(new Option("\tNormalizing a numeric class will NOT be done.\n\t(Set this to not normalize the class if it's numeric).", "C", 0, "-C"));
        newVector.addElement(new Option("\tNormalizing the attributes will NOT be done.\n\t(Set this to not normalize the attributes).", "I", 0, "-I"));
        newVector.addElement(new Option("\tReseting the network will NOT be allowed.\n\t(Set this to not allow the network to reset).", "R", 0, "-R"));
        newVector.addElement(new Option("\tLearning rate decay will occur.\n\t(Set this to cause the learning rate to decay).", "D", 0, "-D"));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String learningString = Utils.getOption('L', options);
        if (learningString.length() != 0) {
            this.setLearningRate(new Double(learningString));
        } else {
            this.setLearningRate(0.3);
        }
        String momentumString = Utils.getOption('M', options);
        if (momentumString.length() != 0) {
            this.setMomentum(new Double(momentumString));
        } else {
            this.setMomentum(0.2);
        }
        String epochsString = Utils.getOption('N', options);
        if (epochsString.length() != 0) {
            this.setTrainingTime(Integer.parseInt(epochsString));
        } else {
            this.setTrainingTime(500);
        }
        String valSizeString = Utils.getOption('V', options);
        if (valSizeString.length() != 0) {
            this.setValidationSetSize(Integer.parseInt(valSizeString));
        } else {
            this.setValidationSetSize(0);
        }
        String seedString = Utils.getOption('S', options);
        if (seedString.length() != 0) {
            this.setSeed(Integer.parseInt(seedString));
        } else {
            this.setSeed(0);
        }
        String thresholdString = Utils.getOption('E', options);
        if (thresholdString.length() != 0) {
            this.setValidationThreshold(Integer.parseInt(thresholdString));
        } else {
            this.setValidationThreshold(20);
        }
        String hiddenLayers = Utils.getOption('H', options);
        if (hiddenLayers.length() != 0) {
            this.setHiddenLayers(hiddenLayers);
        } else {
            this.setHiddenLayers("a");
        }
        if (Utils.getFlag('G', options)) {
            this.setGUI(true);
        } else {
            this.setGUI(false);
        }
        if (Utils.getFlag('A', options)) {
            this.setAutoBuild(false);
        } else {
            this.setAutoBuild(true);
        }
        if (Utils.getFlag('B', options)) {
            this.setNominalToBinaryFilter(false);
        } else {
            this.setNominalToBinaryFilter(true);
        }
        if (Utils.getFlag('C', options)) {
            this.setNormalizeNumericClass(false);
        } else {
            this.setNormalizeNumericClass(true);
        }
        if (Utils.getFlag('I', options)) {
            this.setNormalizeAttributes(false);
        } else {
            this.setNormalizeAttributes(true);
        }
        if (Utils.getFlag('R', options)) {
            this.setReset(false);
        } else {
            this.setReset(true);
        }
        if (Utils.getFlag('D', options)) {
            this.setDecay(true);
        } else {
            this.setDecay(false);
        }
        Utils.checkForRemainingOptions(options);
    }

    public String[] getOptions() {
        String[] options = new String[21];
        int current = 0;
        options[current++] = "-L";
        options[current++] = "" + this.getLearningRate();
        options[current++] = "-M";
        options[current++] = "" + this.getMomentum();
        options[current++] = "-N";
        options[current++] = "" + this.getTrainingTime();
        options[current++] = "-V";
        options[current++] = "" + this.getValidationSetSize();
        options[current++] = "-S";
        options[current++] = "" + this.getSeed();
        options[current++] = "-E";
        options[current++] = "" + this.getValidationThreshold();
        options[current++] = "-H";
        options[current++] = this.getHiddenLayers();
        if (this.getGUI()) {
            options[current++] = "-G";
        }
        if (!this.getAutoBuild()) {
            options[current++] = "-A";
        }
        if (!this.getNominalToBinaryFilter()) {
            options[current++] = "-B";
        }
        if (!this.getNormalizeNumericClass()) {
            options[current++] = "-C";
        }
        if (!this.getNormalizeAttributes()) {
            options[current++] = "-I";
        }
        if (!this.getReset()) {
            options[current++] = "-R";
        }
        if (this.getDecay()) {
            options[current++] = "-D";
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public String toString() {
        int nob;
        NeuralConnection[] inputs;
        int noa;
        if (this.m_useDefaultModel) {
            StringBuffer buf = new StringBuffer();
            buf.append(this.getClass().getName().replaceAll(".*\\.", "") + "\n");
            buf.append(this.getClass().getName().replaceAll(".*\\.", "").replaceAll(".", "=") + "\n\n");
            buf.append("Warning: No model could be built, hence ZeroR model is used:\n\n");
            buf.append(this.m_ZeroR.toString());
            return buf.toString();
        }
        StringBuffer model = new StringBuffer(this.m_neuralNodes.length * 100);
        for (noa = 0; noa < this.m_neuralNodes.length; ++noa) {
            NeuralNode con = (NeuralNode)this.m_neuralNodes[noa];
            double[] weights = con.getWeights();
            inputs = con.getInputs();
            if (con.getMethod() instanceof SigmoidUnit) {
                model.append("Sigmoid ");
            } else if (con.getMethod() instanceof LinearUnit) {
                model.append("Linear ");
            }
            model.append("Node " + con.getId() + "\n    Inputs    Weights\n");
            model.append("    Threshold    " + weights[0] + "\n");
            for (nob = 1; nob < con.getNumInputs() + 1; ++nob) {
                if ((inputs[nob - 1].getType() & 1) == 1) {
                    model.append("    Attrib " + this.m_instances.attribute(((NeuralEnd)inputs[nob - 1]).getLink()).name() + "    " + weights[nob] + "\n");
                    continue;
                }
                model.append("    Node " + inputs[nob - 1].getId() + "    " + weights[nob] + "\n");
            }
        }
        for (noa = 0; noa < this.m_outputs.length; ++noa) {
            inputs = this.m_outputs[noa].getInputs();
            model.append("Class " + this.m_instances.classAttribute().value(this.m_outputs[noa].getLink()) + "\n    Input\n");
            for (nob = 0; nob < this.m_outputs[noa].getNumInputs(); ++nob) {
                if ((inputs[nob].getType() & 1) == 1) {
                    model.append("    Attrib " + this.m_instances.attribute(((NeuralEnd)inputs[nob]).getLink()).name() + "\n");
                    continue;
                }
                model.append("    Node " + inputs[nob].getId() + "\n");
            }
        }
        return model.toString();
    }

    public String globalInfo() {
        return "A Classifier that uses backpropagation to classify instances.\nThis network can be built by hand, created by an algorithm or both. The network can also be monitored and modified during training time. The nodes in this network are all sigmoid (except for when the class is numeric in which case the the output nodes become unthresholded linear units).";
    }

    public String learningRateTipText() {
        return "The amount the weights are updated.";
    }

    public String momentumTipText() {
        return "Momentum applied to the weights during updating.";
    }

    public String autoBuildTipText() {
        return "Adds and connects up hidden layers in the network.";
    }

    public String seedTipText() {
        return "Seed used to initialise the random number generator.Random numbers are used for setting the initial weights of the connections betweem nodes, and also for shuffling the training data.";
    }

    public String validationThresholdTipText() {
        return "Used to terminate validation testing.The value here dictates how many times in a row the validation set error can get worse before training is terminated.";
    }

    public String GUITipText() {
        return "Brings up a gui interface. This will allow the pausing and altering of the nueral network during training.\n\n* To add a node left click (this node will be automatically selected, ensure no other nodes were selected).\n* To select a node left click on it either while no other node is selected or while holding down the control key (this toggles that node as being selected and not selected.\n* To connect a node, first have the start node(s) selected, then click either the end node or on an empty space (this will create a new node that is connected with the selected nodes). The selection status of nodes will stay the same after the connection. (Note these are directed connections, also a connection between two nodes will not be established more than once and certain connections that are deemed to be invalid will not be made).\n* To remove a connection select one of the connected node(s) in the connection and then right click the other node (it does not matter whether the node is the start or end the connection will be removed).\n* To remove a node right click it while no other nodes (including it) are selected. (This will also remove all connections to it)\n.* To deselect a node either left click it while holding down control, or right click on empty space.\n* The raw inputs are provided from the labels on the left.\n* The red nodes are hidden layers.\n* The orange nodes are the output nodes.\n* The labels on the right show the class the output node represents. Note that with a numeric class the output node will automatically be made into an unthresholded linear unit.\n\nAlterations to the neural network can only be done while the network is not running, This also applies to the learning rate and other fields on the control panel.\n\n* You can accept the network as being finished at any time.\n* The network is automatically paused at the beginning.\n* There is a running indication of what epoch the network is up to and what the (rough) error for that epoch was (or for the validation if that is being used). Note that this error value is based on a network that changes as the value is computed. (also depending on whether the class is normalized will effect the error reported for numeric classes.\n* Once the network is done it will pause again and either wait to be accepted or trained more.\n\nNote that if the gui is not set the network will not require any interaction.\n";
    }

    public String validationSetSizeTipText() {
        return "The percentage size of the validation set.(The training will continue until it is observed that the error on the validation set has been consistently getting worse, or if the training time is reached).\nIf This is set to zero no validation set will be used and instead the network will train for the specified number of epochs.";
    }

    public String trainingTimeTipText() {
        return "The number of epochs to train through. If the validation set is non-zero then it can terminate the network early";
    }

    public String nominalToBinaryFilterTipText() {
        return "This will preprocess the instances with the filter. This could help improve performance if there are nominal attributes in the data.";
    }

    public String hiddenLayersTipText() {
        return "This defines the hidden layers of the neural network. This is a list of positive whole numbers. 1 for each hidden layer. Comma seperated. To have no hidden layers put a single 0 here. This will only be used if autobuild is set. There are also wildcard values 'a' = (attribs + classes) / 2, 'i' = attribs, 'o' = classes , 't' = attribs + classes.";
    }

    public String normalizeNumericClassTipText() {
        return "This will normalize the class if it's numeric. This could help improve performance of the network, It normalizes the class to be between -1 and 1. Note that this is only internally, the output will be scaled back to the original range.";
    }

    public String normalizeAttributesTipText() {
        return "This will normalize the attributes. This could help improve performance of the network. This is not reliant on the class being numeric. This will also normalize nominal attributes as well (after they have been run through the nominal to binary filter if that is in use) so that the nominal values are between -1 and 1";
    }

    public String resetTipText() {
        return "This will allow the network to reset with a lower learning rate. If the network diverges from the answer this will automatically reset the network with a lower learning rate and begin training again. This option is only available if the gui is not set. Note that if the network diverges but isn't allowed to reset it will fail the training process and return an error message.";
    }

    public String decayTipText() {
        return "This will cause the learning rate to decrease. This will divide the starting learning rate by the epoch number, to determine what the current learning rate should be. This may help to stop the network from diverging from the target output, as well as improve general performance. Note that the decaying learning rate will not be shown in the gui, only the original learning rate. If the learning rate is changed in the gui, this is treated as the starting learning rate.";
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    class ControlPanel
    extends JPanel
    implements RevisionHandler {
        static final long serialVersionUID = 7393543302294142271L;
        public JButton m_startStop;
        public JButton m_acceptButton;
        public JPanel m_epochsLabel;
        public JLabel m_totalEpochsLabel;
        public JTextField m_changeEpochs;
        public JLabel m_learningLabel;
        public JLabel m_momentumLabel;
        public JTextField m_changeLearning;
        public JTextField m_changeMomentum;
        public JPanel m_errorLabel;

        public ControlPanel() {
            this.setBorder(BorderFactory.createTitledBorder("Controls"));
            this.m_totalEpochsLabel = new JLabel("Num Of Epochs  ");
            this.m_epochsLabel = new JPanel(){
                private static final long serialVersionUID = 2562773937093221399L;

                public void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    g.setColor(((MultilayerPerceptron)MultilayerPerceptron.this).m_controlPanel.m_totalEpochsLabel.getForeground());
                    g.drawString("Epoch  " + MultilayerPerceptron.this.m_epoch, 0, 10);
                }
            };
            this.m_epochsLabel.setFont(this.m_totalEpochsLabel.getFont());
            this.m_changeEpochs = new JTextField();
            this.m_changeEpochs.setText("" + MultilayerPerceptron.this.m_numEpochs);
            this.m_errorLabel = new JPanel(){
                private static final long serialVersionUID = 4390239056336679189L;

                public void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    g.setColor(((MultilayerPerceptron)MultilayerPerceptron.this).m_controlPanel.m_totalEpochsLabel.getForeground());
                    if (MultilayerPerceptron.this.m_valSize == 0) {
                        g.drawString("Error per Epoch = " + Utils.doubleToString(MultilayerPerceptron.this.m_error, 7), 0, 10);
                    } else {
                        g.drawString("Validation Error per Epoch = " + Utils.doubleToString(MultilayerPerceptron.this.m_error, 7), 0, 10);
                    }
                }
            };
            this.m_errorLabel.setFont(this.m_epochsLabel.getFont());
            this.m_learningLabel = new JLabel("Learning Rate = ");
            this.m_momentumLabel = new JLabel("Momentum = ");
            this.m_changeLearning = new JTextField();
            this.m_changeMomentum = new JTextField();
            this.m_changeLearning.setText("" + MultilayerPerceptron.this.m_learningRate);
            this.m_changeMomentum.setText("" + MultilayerPerceptron.this.m_momentum);
            this.setLayout(new BorderLayout(15, 10));
            MultilayerPerceptron.this.m_stopIt = true;
            MultilayerPerceptron.this.m_accepted = false;
            this.m_startStop = new JButton("Start");
            this.m_startStop.setActionCommand("Start");
            this.m_acceptButton = new JButton("Accept");
            this.m_acceptButton.setActionCommand("Accept");
            JPanel buttons = new JPanel();
            buttons.setLayout(new BoxLayout(buttons, 1));
            buttons.add(this.m_startStop);
            buttons.add(this.m_acceptButton);
            this.add((Component)buttons, "West");
            JPanel data = new JPanel();
            data.setLayout(new BoxLayout(data, 1));
            Box ab = new Box(0);
            ab.add(this.m_epochsLabel);
            data.add(ab);
            ab = new Box(0);
            Component b = Box.createGlue();
            ab.add(this.m_totalEpochsLabel);
            ab.add(this.m_changeEpochs);
            this.m_changeEpochs.setMaximumSize(new Dimension(200, 20));
            ab.add(b);
            data.add(ab);
            ab = new Box(0);
            ab.add(this.m_errorLabel);
            data.add(ab);
            this.add((Component)data, "Center");
            data = new JPanel();
            data.setLayout(new BoxLayout(data, 1));
            ab = new Box(0);
            b = Box.createGlue();
            ab.add(this.m_learningLabel);
            ab.add(this.m_changeLearning);
            this.m_changeLearning.setMaximumSize(new Dimension(200, 20));
            ab.add(b);
            data.add(ab);
            ab = new Box(0);
            b = Box.createGlue();
            ab.add(this.m_momentumLabel);
            ab.add(this.m_changeMomentum);
            this.m_changeMomentum.setMaximumSize(new Dimension(200, 20));
            ab.add(b);
            data.add(ab);
            this.add((Component)data, "East");
            this.m_startStop.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equals("Start")) {
                        MultilayerPerceptron.this.m_stopIt = false;
                        ControlPanel.this.m_startStop.setText("Stop");
                        ControlPanel.this.m_startStop.setActionCommand("Stop");
                        int n = Integer.valueOf(ControlPanel.this.m_changeEpochs.getText());
                        MultilayerPerceptron.this.m_numEpochs = n;
                        ControlPanel.this.m_changeEpochs.setText("" + MultilayerPerceptron.this.m_numEpochs);
                        double m = Double.valueOf(ControlPanel.this.m_changeLearning.getText());
                        MultilayerPerceptron.this.setLearningRate(m);
                        ControlPanel.this.m_changeLearning.setText("" + MultilayerPerceptron.this.m_learningRate);
                        m = Double.valueOf(ControlPanel.this.m_changeMomentum.getText());
                        MultilayerPerceptron.this.setMomentum(m);
                        ControlPanel.this.m_changeMomentum.setText("" + MultilayerPerceptron.this.m_momentum);
                        MultilayerPerceptron.this.blocker(false);
                    } else if (e.getActionCommand().equals("Stop")) {
                        MultilayerPerceptron.this.m_stopIt = true;
                        ControlPanel.this.m_startStop.setText("Start");
                        ControlPanel.this.m_startStop.setActionCommand("Start");
                    }
                }
            });
            this.m_acceptButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MultilayerPerceptron.this.m_accepted = true;
                    MultilayerPerceptron.this.blocker(false);
                }
            });
            this.m_changeEpochs.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int n = Integer.valueOf(ControlPanel.this.m_changeEpochs.getText());
                    if (n > 0) {
                        MultilayerPerceptron.this.m_numEpochs = n;
                        MultilayerPerceptron.this.blocker(false);
                    }
                }
            });
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 8034 $");
        }
    }

    private class NodePanel
    extends JPanel
    implements RevisionHandler {
        static final long serialVersionUID = -3067621833388149984L;

        public NodePanel() {
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    if (!MultilayerPerceptron.this.m_stopped) {
                        return;
                    }
                    if ((e.getModifiers() & 0x10) == 16 && !e.isAltDown()) {
                        int noa;
                        Graphics g = NodePanel.this.getGraphics();
                        int x = e.getX();
                        int y = e.getY();
                        int w = NodePanel.this.getWidth();
                        int h = NodePanel.this.getHeight();
                        FastVector<NeuralConnection> tmp = new FastVector<NeuralConnection>(4);
                        for (noa = 0; noa < MultilayerPerceptron.this.m_numAttributes; ++noa) {
                            if (!MultilayerPerceptron.this.m_inputs[noa].onUnit(g, x, y, w, h)) continue;
                            tmp.addElement(MultilayerPerceptron.this.m_inputs[noa]);
                            NodePanel.this.selection(tmp, (e.getModifiers() & 2) == 2, true);
                            return;
                        }
                        for (noa = 0; noa < MultilayerPerceptron.this.m_numClasses; ++noa) {
                            if (!MultilayerPerceptron.this.m_outputs[noa].onUnit(g, x, y, w, h)) continue;
                            tmp.addElement(MultilayerPerceptron.this.m_outputs[noa]);
                            NodePanel.this.selection(tmp, (e.getModifiers() & 2) == 2, true);
                            return;
                        }
                        for (noa = 0; noa < MultilayerPerceptron.this.m_neuralNodes.length; ++noa) {
                            if (!MultilayerPerceptron.this.m_neuralNodes[noa].onUnit(g, x, y, w, h)) continue;
                            tmp.addElement(MultilayerPerceptron.this.m_neuralNodes[noa]);
                            NodePanel.this.selection(tmp, (e.getModifiers() & 2) == 2, true);
                            return;
                        }
                        NeuralNode temp = new NeuralNode(String.valueOf(MultilayerPerceptron.this.m_nextId), MultilayerPerceptron.this.m_random, MultilayerPerceptron.this.m_sigmoidUnit);
                        MultilayerPerceptron.this.m_nextId++;
                        temp.setX((double)e.getX() / (double)w);
                        temp.setY((double)e.getY() / (double)h);
                        tmp.addElement(temp);
                        MultilayerPerceptron.this.addNode(temp);
                        NodePanel.this.selection(tmp, (e.getModifiers() & 2) == 2, true);
                    } else {
                        int noa;
                        Graphics g = NodePanel.this.getGraphics();
                        int x = e.getX();
                        int y = e.getY();
                        int w = NodePanel.this.getWidth();
                        int h = NodePanel.this.getHeight();
                        FastVector<NeuralConnection> tmp = new FastVector<NeuralConnection>(4);
                        for (noa = 0; noa < MultilayerPerceptron.this.m_numAttributes; ++noa) {
                            if (!MultilayerPerceptron.this.m_inputs[noa].onUnit(g, x, y, w, h)) continue;
                            tmp.addElement(MultilayerPerceptron.this.m_inputs[noa]);
                            NodePanel.this.selection(tmp, (e.getModifiers() & 2) == 2, false);
                            return;
                        }
                        for (noa = 0; noa < MultilayerPerceptron.this.m_numClasses; ++noa) {
                            if (!MultilayerPerceptron.this.m_outputs[noa].onUnit(g, x, y, w, h)) continue;
                            tmp.addElement(MultilayerPerceptron.this.m_outputs[noa]);
                            NodePanel.this.selection(tmp, (e.getModifiers() & 2) == 2, false);
                            return;
                        }
                        for (noa = 0; noa < MultilayerPerceptron.this.m_neuralNodes.length; ++noa) {
                            if (!MultilayerPerceptron.this.m_neuralNodes[noa].onUnit(g, x, y, w, h)) continue;
                            tmp.addElement(MultilayerPerceptron.this.m_neuralNodes[noa]);
                            NodePanel.this.selection(tmp, (e.getModifiers() & 2) == 2, false);
                            return;
                        }
                        NodePanel.this.selection(null, (e.getModifiers() & 2) == 2, false);
                    }
                }
            });
        }

        private void selection(FastVector v, boolean ctrl, boolean left) {
            if (v == null) {
                MultilayerPerceptron.this.m_selected.removeAllElements();
                this.repaint();
                return;
            }
            if ((ctrl || MultilayerPerceptron.this.m_selected.size() == 0) && left) {
                boolean removed = false;
                for (int noa = 0; noa < v.size(); ++noa) {
                    removed = false;
                    for (int nob = 0; nob < MultilayerPerceptron.this.m_selected.size(); ++nob) {
                        if (v.elementAt(noa) != MultilayerPerceptron.this.m_selected.elementAt(nob)) continue;
                        MultilayerPerceptron.this.m_selected.removeElementAt(nob);
                        removed = true;
                        break;
                    }
                    if (removed) continue;
                    MultilayerPerceptron.this.m_selected.addElement(v.elementAt(noa));
                }
                this.repaint();
                return;
            }
            if (left) {
                for (int noa = 0; noa < MultilayerPerceptron.this.m_selected.size(); ++noa) {
                    for (int nob = 0; nob < v.size(); ++nob) {
                        NeuralConnection.connect((NeuralConnection)MultilayerPerceptron.this.m_selected.elementAt(noa), (NeuralConnection)v.elementAt(nob));
                    }
                }
            } else if (MultilayerPerceptron.this.m_selected.size() > 0) {
                for (int noa = 0; noa < MultilayerPerceptron.this.m_selected.size(); ++noa) {
                    for (int nob = 0; nob < v.size(); ++nob) {
                        NeuralConnection.disconnect((NeuralConnection)MultilayerPerceptron.this.m_selected.elementAt(noa), (NeuralConnection)v.elementAt(nob));
                        NeuralConnection.disconnect((NeuralConnection)v.elementAt(nob), (NeuralConnection)MultilayerPerceptron.this.m_selected.elementAt(noa));
                    }
                }
            } else {
                for (int noa = 0; noa < v.size(); ++noa) {
                    ((NeuralConnection)v.elementAt(noa)).removeAllInputs();
                    ((NeuralConnection)v.elementAt(noa)).removeAllOutputs();
                    MultilayerPerceptron.this.removeNode((NeuralConnection)v.elementAt(noa));
                }
            }
            this.repaint();
        }

        public void paintComponent(Graphics g) {
            int noa;
            super.paintComponent(g);
            int x = this.getWidth();
            int y = this.getHeight();
            if (25 * MultilayerPerceptron.this.m_numAttributes > 25 * MultilayerPerceptron.this.m_numClasses && 25 * MultilayerPerceptron.this.m_numAttributes > y) {
                this.setSize(x, 25 * MultilayerPerceptron.this.m_numAttributes);
            } else if (25 * MultilayerPerceptron.this.m_numClasses > y) {
                this.setSize(x, 25 * MultilayerPerceptron.this.m_numClasses);
            } else {
                this.setSize(x, y);
            }
            y = this.getHeight();
            for (noa = 0; noa < MultilayerPerceptron.this.m_numAttributes; ++noa) {
                MultilayerPerceptron.this.m_inputs[noa].drawInputLines(g, x, y);
            }
            for (noa = 0; noa < MultilayerPerceptron.this.m_numClasses; ++noa) {
                MultilayerPerceptron.this.m_outputs[noa].drawInputLines(g, x, y);
                MultilayerPerceptron.this.m_outputs[noa].drawOutputLines(g, x, y);
            }
            for (noa = 0; noa < MultilayerPerceptron.this.m_neuralNodes.length; ++noa) {
                MultilayerPerceptron.this.m_neuralNodes[noa].drawInputLines(g, x, y);
            }
            for (noa = 0; noa < MultilayerPerceptron.this.m_numAttributes; ++noa) {
                MultilayerPerceptron.this.m_inputs[noa].drawNode(g, x, y);
            }
            for (noa = 0; noa < MultilayerPerceptron.this.m_numClasses; ++noa) {
                MultilayerPerceptron.this.m_outputs[noa].drawNode(g, x, y);
            }
            for (noa = 0; noa < MultilayerPerceptron.this.m_neuralNodes.length; ++noa) {
                MultilayerPerceptron.this.m_neuralNodes[noa].drawNode(g, x, y);
            }
            for (noa = 0; noa < MultilayerPerceptron.this.m_selected.size(); ++noa) {
                ((NeuralConnection)MultilayerPerceptron.this.m_selected.elementAt(noa)).drawHighlight(g, x, y);
            }
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 8034 $");
        }
    }

    protected class NeuralEnd
    extends NeuralConnection {
        static final long serialVersionUID = 7305185603191183338L;
        private int m_link;
        private boolean m_input;

        public NeuralEnd(String id) {
            super(id);
            this.m_link = 0;
            this.m_input = true;
        }

        public boolean onUnit(Graphics g, int x, int y, int w, int h) {
            FontMetrics fm = g.getFontMetrics();
            int l = (int)(this.m_x * (double)w) - fm.stringWidth(this.m_id) / 2;
            int t = (int)(this.m_y * (double)h) - fm.getHeight() / 2;
            return x >= l && x <= l + fm.stringWidth(this.m_id) + 4 && y >= t && y <= t + fm.getHeight() + fm.getDescent() + 4;
        }

        public void drawNode(Graphics g, int w, int h) {
            if ((this.m_type & 1) == 1) {
                g.setColor(Color.green);
            } else {
                g.setColor(Color.orange);
            }
            FontMetrics fm = g.getFontMetrics();
            int l = (int)(this.m_x * (double)w) - fm.stringWidth(this.m_id) / 2;
            int t = (int)(this.m_y * (double)h) - fm.getHeight() / 2;
            g.fill3DRect(l, t, fm.stringWidth(this.m_id) + 4, fm.getHeight() + fm.getDescent() + 4, true);
            g.setColor(Color.black);
            g.drawString(this.m_id, l + 2, t + fm.getHeight() + 2);
        }

        public void drawHighlight(Graphics g, int w, int h) {
            g.setColor(Color.black);
            FontMetrics fm = g.getFontMetrics();
            int l = (int)(this.m_x * (double)w) - fm.stringWidth(this.m_id) / 2;
            int t = (int)(this.m_y * (double)h) - fm.getHeight() / 2;
            g.fillRect(l - 2, t - 2, fm.stringWidth(this.m_id) + 8, fm.getHeight() + fm.getDescent() + 8);
            this.drawNode(g, w, h);
        }

        public double outputValue(boolean calculate) {
            if (Double.isNaN(this.m_unitValue) && calculate) {
                if (this.m_input) {
                    this.m_unitValue = MultilayerPerceptron.this.m_currentInstance.isMissing(this.m_link) ? 0.0 : MultilayerPerceptron.this.m_currentInstance.value(this.m_link);
                } else {
                    this.m_unitValue = 0.0;
                    for (int noa = 0; noa < this.m_numInputs; ++noa) {
                        this.m_unitValue += this.m_inputList[noa].outputValue(true);
                    }
                    if (MultilayerPerceptron.this.m_numeric && MultilayerPerceptron.this.m_normalizeClass) {
                        this.m_unitValue = this.m_unitValue * MultilayerPerceptron.this.m_attributeRanges[MultilayerPerceptron.this.m_instances.classIndex()] + MultilayerPerceptron.this.m_attributeBases[MultilayerPerceptron.this.m_instances.classIndex()];
                    }
                }
            }
            return this.m_unitValue;
        }

        public double errorValue(boolean calculate) {
            if (!Double.isNaN(this.m_unitValue) && Double.isNaN(this.m_unitError) && calculate) {
                if (this.m_input) {
                    this.m_unitError = 0.0;
                    for (int noa = 0; noa < this.m_numOutputs; ++noa) {
                        this.m_unitError += this.m_outputList[noa].errorValue(true);
                    }
                } else if (MultilayerPerceptron.this.m_currentInstance.classIsMissing()) {
                    this.m_unitError = 0.1;
                } else if (MultilayerPerceptron.this.m_instances.classAttribute().isNominal()) {
                    this.m_unitError = MultilayerPerceptron.this.m_currentInstance.classValue() == (double)this.m_link ? 1.0 - this.m_unitValue : 0.0 - this.m_unitValue;
                } else if (MultilayerPerceptron.this.m_numeric) {
                    this.m_unitError = MultilayerPerceptron.this.m_normalizeClass ? (MultilayerPerceptron.this.m_attributeRanges[MultilayerPerceptron.this.m_instances.classIndex()] == 0.0 ? 0.0 : (MultilayerPerceptron.this.m_currentInstance.classValue() - this.m_unitValue) / MultilayerPerceptron.this.m_attributeRanges[MultilayerPerceptron.this.m_instances.classIndex()]) : MultilayerPerceptron.this.m_currentInstance.classValue() - this.m_unitValue;
                }
            }
            return this.m_unitError;
        }

        public void reset() {
            if (!Double.isNaN(this.m_unitValue) || !Double.isNaN(this.m_unitError)) {
                this.m_unitValue = Double.NaN;
                this.m_unitError = Double.NaN;
                this.m_weightsUpdated = false;
                for (int noa = 0; noa < this.m_numInputs; ++noa) {
                    this.m_inputList[noa].reset();
                }
            }
        }

        public void saveWeights() {
            for (int i = 0; i < this.m_numInputs; ++i) {
                this.m_inputList[i].saveWeights();
            }
        }

        public void restoreWeights() {
            for (int i = 0; i < this.m_numInputs; ++i) {
                this.m_inputList[i].restoreWeights();
            }
        }

        public void setLink(boolean input, int val) throws Exception {
            this.m_input = input;
            this.m_type = input ? 1 : 2;
            this.m_link = val < 0 || input && val > MultilayerPerceptron.this.m_instances.numAttributes() || !input && MultilayerPerceptron.this.m_instances.classAttribute().isNominal() && val > MultilayerPerceptron.this.m_instances.classAttribute().numValues() ? 0 : val;
        }

        public int getLink() {
            return this.m_link;
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 8034 $");
        }
    }
}

