/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.m5;

import weka.classifiers.trees.m5.Values;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public final class Impurity
implements RevisionHandler {
    double n;
    int attr;
    double nl;
    double nr;
    double sl;
    double sr;
    double s2l;
    double s2r;
    double sdl;
    double sdr;
    double vl;
    double vr;
    double sd;
    double va;
    double impurity;
    int order;

    public Impurity(int partition, int attribute, Instances inst, int k) {
        Values values = new Values(0, inst.numInstances() - 1, inst.classIndex(), inst);
        this.attr = attribute;
        this.n = inst.numInstances();
        this.sd = values.sd;
        this.va = values.va;
        values = new Values(0, partition, inst.classIndex(), inst);
        this.nl = partition + 1;
        this.sl = values.sum;
        this.s2l = values.sqrSum;
        values = new Values(partition + 1, inst.numInstances() - 1, inst.classIndex(), inst);
        this.nr = inst.numInstances() - partition - 1;
        this.sr = values.sum;
        this.s2r = values.sqrSum;
        this.order = k;
        this.incremental(0.0, 0);
    }

    public final String toString() {
        StringBuffer text = new StringBuffer();
        text.append("Print impurity values:\n");
        text.append("    Number of total instances:\t" + this.n + "\n");
        text.append("    Splitting attribute:\t\t" + this.attr + "\n");
        text.append("    Number of the instances in the left:\t" + this.nl + "\n");
        text.append("    Number of the instances in the right:\t" + this.nr + "\n");
        text.append("    Sum of the left:\t\t\t" + this.sl + "\n");
        text.append("    Sum of the right:\t\t\t" + this.sr + "\n");
        text.append("    Squared sum of the left:\t\t" + this.s2l + "\n");
        text.append("    Squared sum of the right:\t\t" + this.s2r + "\n");
        text.append("    Standard deviation of the left:\t" + this.sdl + "\n");
        text.append("    Standard deviation of the right:\t" + this.sdr + "\n");
        text.append("    Variance of the left:\t\t" + this.vr + "\n");
        text.append("    Variance of the right:\t\t" + this.vr + "\n");
        text.append("    Overall standard deviation:\t\t" + this.sd + "\n");
        text.append("    Overall variance:\t\t\t" + this.va + "\n");
        text.append("    Impurity (order " + this.order + "):\t\t" + this.impurity + "\n");
        return text.toString();
    }

    public final void incremental(double value, int type) {
        double y = 0.0;
        double yl = 0.0;
        double yr = 0.0;
        switch (type) {
            case 1: {
                this.nl += 1.0;
                this.nr -= 1.0;
                this.sl += value;
                this.sr -= value;
                this.s2l += value * value;
                this.s2r -= value * value;
                break;
            }
            case -1: {
                this.nl -= 1.0;
                this.nr += 1.0;
                this.sl -= value;
                this.sr += value;
                this.s2l -= value * value;
                this.s2r += value * value;
                break;
            }
            case 0: {
                break;
            }
            default: {
                System.err.println("wrong type in Impurity.incremental().");
            }
        }
        if (this.nl <= 0.0) {
            this.vl = 0.0;
            this.sdl = 0.0;
        } else {
            this.vl = (this.nl * this.s2l - this.sl * this.sl) / (this.nl * this.nl);
            this.vl = Math.abs(this.vl);
            this.sdl = Math.sqrt(this.vl);
        }
        if (this.nr <= 0.0) {
            this.vr = 0.0;
            this.sdr = 0.0;
        } else {
            this.vr = (this.nr * this.s2r - this.sr * this.sr) / (this.nr * this.nr);
            this.vr = Math.abs(this.vr);
            this.sdr = Math.sqrt(this.vr);
        }
        if (this.order <= 0) {
            System.err.println("Impurity order less than zero in Impurity.incremental()");
        } else if (this.order == 1) {
            y = this.va;
            yl = this.vl;
            yr = this.vr;
        } else {
            y = Math.pow(this.va, 1.0 / (double)this.order);
            yl = Math.pow(this.vl, 1.0 / (double)this.order);
            yr = Math.pow(this.vr, 1.0 / (double)this.order);
        }
        this.impurity = this.nl <= 0.0 || this.nr <= 0.0 ? 0.0 : y - this.nl / this.n * yl - this.nr / this.n * yr;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }
}

