/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import weka.core.pmml.Array;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseArray
extends Array
implements Serializable {
    private static final long serialVersionUID = 8129550573612673674L;
    protected int m_numValues;
    protected int m_numNonZero;
    protected List<Integer> m_indices;

    @Override
    protected void initialize(Element arrayE) throws Exception {
        NodeList v;
        this.m_indices = new ArrayList<Integer>();
        String arrayS = arrayE.getTagName();
        String entriesName = null;
        if (arrayS.equals(Array.ArrayType.REAL_SPARSE.toString())) {
            this.m_type = Array.ArrayType.REAL_SPARSE;
            entriesName = "REAL-Entries";
        } else {
            this.m_type = Array.ArrayType.INT_SPARSE;
            entriesName = "INT-Entries";
        }
        String N = arrayE.getAttribute("n");
        if (N != null && N.length() > 0) {
            this.m_numValues = Integer.parseInt(N);
        }
        if ((v = arrayE.getElementsByTagName(entriesName)) == null || v.getLength() == 0) {
            this.m_numNonZero = 0;
        } else {
            Element entries = (Element)v.item(0);
            String contents = entries.getChildNodes().item(0).getNodeValue();
            StringReader sr = new StringReader(contents);
            StreamTokenizer st = new StreamTokenizer(sr);
            st.resetSyntax();
            st.whitespaceChars(0, 32);
            st.wordChars(33, 255);
            st.whitespaceChars(32, 32);
            st.quoteChar(34);
            st.quoteChar(39);
            st.nextToken();
            while (st.ttype != -1 && st.ttype != 10) {
                this.m_values.add(st.sval);
                st.nextToken();
            }
            NodeList i = arrayE.getElementsByTagName("Indices");
            Element indices = (Element)i.item(0);
            contents = indices.getChildNodes().item(0).getNodeValue();
            sr = new StringReader(contents);
            st = new StreamTokenizer(sr);
            st.resetSyntax();
            st.whitespaceChars(0, 32);
            st.wordChars(33, 255);
            st.whitespaceChars(32, 32);
            st.quoteChar(34);
            st.quoteChar(39);
            st.nextToken();
            while (st.ttype != -1 && st.ttype != 10) {
                Integer newInt = new Integer(Integer.parseInt(st.sval) - 1);
                this.m_indices.add(newInt);
                st.nextToken();
            }
            this.m_numNonZero = this.m_indices.size();
        }
    }

    protected SparseArray(Element arrayE) throws Exception {
        super(arrayE);
    }

    protected SparseArray(Array.ArrayType type, List<Object> values, List<Integer> indices) {
        super(type, values);
        this.m_indices = indices;
    }

    @Override
    public boolean isSparse() {
        return true;
    }

    @Override
    public int numValues() {
        return this.m_numValues;
    }

    public int numNonZero() {
        return this.m_numNonZero;
    }

    @Override
    public int index(int position) {
        return this.m_indices.get(position);
    }

    public int locateIndex(int index) {
        int min = 0;
        int max = this.m_indices.size() - 1;
        if (max == -1) {
            return -1;
        }
        while (this.m_indices.get(min) <= index && this.m_indices.get(max) >= index) {
            int current = (max + min) / 2;
            if (this.m_indices.get(current) > index) {
                max = current - 1;
                continue;
            }
            if (this.m_indices.get(current) < index) {
                min = current + 1;
                continue;
            }
            return current;
        }
        if (this.m_indices.get(max) < index) {
            return max;
        }
        return min - 1;
    }

    @Override
    public String value(int arrIndex) throws Exception {
        int index = this.locateIndex(arrIndex);
        if (index >= 0 && this.m_indices.get(index) == arrIndex) {
            return (String)this.m_values.get(index);
        }
        return "0";
    }

    @Override
    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append("<");
        for (int i = 0; i < this.m_indices.size(); ++i) {
            text.append(this.m_indices.get(i).toString() + " ");
            text.append((String)this.m_values.get(i));
            if (i >= this.m_indices.size() - 1) continue;
            text.append(",");
        }
        text.append(">");
        return text.toString();
    }
}

