/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import weka.core.Environment;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.Settings;
import weka.core.Utils;
import weka.core.WekaException;
import weka.gui.Logger;
import weka.gui.beans.StreamThroughput;
import weka.gui.knowledgeflow.StepVisual;
import weka.knowledgeflow.BaseExecutionEnvironment;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.ExecutionEnvironment;
import weka.knowledgeflow.Flow;
import weka.knowledgeflow.LogManager;
import weka.knowledgeflow.LoggingLevel;
import weka.knowledgeflow.SingleThreadedExecution;
import weka.knowledgeflow.StepManager;
import weka.knowledgeflow.StepOutputListener;
import weka.knowledgeflow.steps.KFStep;
import weka.knowledgeflow.steps.Step;
import weka.knowledgeflow.steps.WekaAlgorithmWrapper;

public class StepManagerImpl
implements StepManager {
    protected Step m_managedStep;
    protected boolean m_stopRequested;
    protected boolean m_stepIsBusy;
    protected Map<String, Object> m_stepProperties = new HashMap<String, Object>();
    protected String m_managedStepEditor;
    protected Map<String, List<StepManager>> m_connectedByTypeIncoming = new LinkedHashMap<String, List<StepManager>>();
    protected Map<String, List<StepManager>> m_connectedByTypeOutgoing = new LinkedHashMap<String, List<StepManager>>();
    protected Map<String, List<StepOutputListener>> m_outputListeners = new LinkedHashMap<String, List<StepOutputListener>>();
    protected StepVisual m_stepVisual;
    protected int m_x = -1;
    protected int m_y = -1;
    protected BaseExecutionEnvironment m_executionEnvironment;
    protected LogManager m_log;
    protected transient StreamThroughput m_throughput;
    protected boolean m_adjustForGraphicalRendering;
    protected boolean m_stepIsResourceIntensive;
    protected boolean m_stepMustRunSingleThreaded;

    public StepManagerImpl(Step step) {
        this.setManagedStep(step);
    }

    @Override
    public String getName() {
        return this.m_managedStep.getName();
    }

    @Override
    public Step getManagedStep() {
        return this.m_managedStep;
    }

    public void setManagedStep(Step step) {
        this.m_managedStep = step;
        step.setStepManager(this);
        this.setManagedStepEditorClass(step.getCustomEditorForStep());
        Annotation a = step.getClass().getAnnotation(KFStep.class);
        this.m_stepIsResourceIntensive = a != null && a.resourceIntensive();
        a = step.getClass().getAnnotation(SingleThreadedExecution.class);
        this.m_stepMustRunSingleThreaded = a != null;
    }

    @Override
    public void setStepIsResourceIntensive(boolean resourceIntensive) {
        this.m_stepIsResourceIntensive = resourceIntensive;
    }

    @Override
    public boolean stepIsResourceIntensive() {
        return this.m_stepIsResourceIntensive;
    }

    @Override
    public void setStepMustRunSingleThreaded(boolean mustRunSingleThreaded) {
        this.m_stepMustRunSingleThreaded = mustRunSingleThreaded;
    }

    @Override
    public boolean getStepMustRunSingleThreaded() {
        return this.m_stepMustRunSingleThreaded;
    }

    public StepVisual getStepVisual() {
        return this.m_stepVisual;
    }

    public void setStepVisual(StepVisual visual) {
        this.m_stepVisual = visual;
        if (this.m_x != -1 && this.m_y != -1) {
            this.m_stepVisual.setX(this.m_x);
            this.m_stepVisual.setY(this.m_y);
        }
    }

    public void setStepProperty(String name, Object value) {
        this.m_stepProperties.put(name, value);
    }

    public Object getStepProperty(String name) {
        return this.m_stepProperties.get(name);
    }

    protected String getManagedStepEditorClass() {
        return this.m_managedStepEditor;
    }

    protected void setManagedStepEditorClass(String editor) {
        this.m_managedStepEditor = editor;
    }

    @Override
    public ExecutionEnvironment getExecutionEnvironment() {
        return this.m_executionEnvironment;
    }

    @Override
    public Settings getSettings() {
        if (this.getExecutionEnvironment() == null) {
            throw new IllegalStateException("There is no execution environment available!");
        }
        return this.getExecutionEnvironment().getSettings();
    }

    protected void setExecutionEnvironment(ExecutionEnvironment env) throws WekaException {
        if (!(env instanceof BaseExecutionEnvironment)) {
            throw new WekaException("Execution environments need to be BaseExecutionEnvironment (or subclass thereof)");
        }
        this.m_executionEnvironment = (BaseExecutionEnvironment)env;
        this.setLog(this.m_executionEnvironment.getLog());
        this.setLoggingLevel(this.m_executionEnvironment.getLoggingLevel());
    }

    @Override
    public LoggingLevel getLoggingLevel() {
        return this.m_log != null ? this.m_log.getLoggingLevel() : LoggingLevel.BASIC;
    }

    public void setLoggingLevel(LoggingLevel newLevel) {
        if (this.m_log == null) {
            this.m_log = new LogManager(this.getManagedStep());
        }
        this.m_log.setLoggingLevel(newLevel);
    }

    @Override
    public Logger getLog() {
        return this.m_log != null ? this.m_log.getLog() : null;
    }

    public void setLog(Logger log) {
        this.m_log = new LogManager(this.getManagedStep());
        this.m_log.setLog(log);
    }

    protected boolean initStep() {
        boolean initializedOK = false;
        this.m_stepIsBusy = false;
        this.m_stopRequested = false;
        try {
            this.getManagedStep().stepInit();
            initializedOK = true;
        }
        catch (WekaException ex) {
            this.logError(ex.getMessage(), ex);
        }
        catch (Throwable ex) {
            this.logError(ex.getMessage(), ex);
        }
        this.m_throughput = null;
        return initializedOK;
    }

    @Override
    public boolean isStepBusy() {
        return this.m_stepIsBusy;
    }

    @Override
    public boolean isStopRequested() {
        return this.m_stopRequested;
    }

    public void setStopRequested(boolean stopRequested) {
        this.m_stopRequested = stopRequested;
    }

    @Override
    public void processing() {
        this.m_stepIsBusy = true;
    }

    @Override
    public void finished() {
        this.m_stepIsBusy = false;
        if (!this.isStopRequested()) {
            this.statusMessage("Finished.");
        }
    }

    @Override
    public void interrupted() {
        this.m_stepIsBusy = false;
    }

    @Override
    public boolean isStreamFinished(Data data) {
        return data.getPayloadElement("incremental_stream_end", false);
    }

    @Override
    public void throughputUpdateStart() {
        if (this.m_throughput == null) {
            this.m_throughput = new StreamThroughput(this.stepStatusMessagePrefix());
        }
        this.processing();
        this.m_throughput.updateStart();
    }

    @Override
    public void throughputUpdateEnd() {
        if (this.m_throughput != null) {
            this.m_throughput.updateEnd(this.m_log.getLog());
            if (this.isStopRequested()) {
                this.finished();
            }
        }
    }

    @Override
    public void throughputFinished(Data ... data) throws WekaException {
        this.finished();
        if (data.length > 0) {
            for (Data d : data) {
                d.setPayloadElement("incremental_stream_end", true);
            }
            this.outputData(data);
        }
        if (this.m_throughput != null) {
            this.m_throughput.finished(this.m_log.getLog());
        }
        this.interrupted();
    }

    private void disconnectStep(List<StepManager> connList, Step toDisconnect) {
        Iterator<StepManager> iter = connList.iterator();
        while (iter.hasNext()) {
            StepManagerImpl candidate = (StepManagerImpl)iter.next();
            if (toDisconnect != candidate.getManagedStep()) continue;
            iter.remove();
            break;
        }
    }

    public void disconnectStepWithConnection(Step toDisconnect, String connType) {
        List<StepManager> connectedWithType = this.m_connectedByTypeIncoming.get(connType);
        if (connectedWithType != null) {
            this.disconnectStep(connectedWithType, toDisconnect);
            if (connectedWithType.size() == 0) {
                this.m_connectedByTypeIncoming.remove(connType);
            }
        }
        if ((connectedWithType = this.m_connectedByTypeOutgoing.get(connType)) != null) {
            this.disconnectStep(connectedWithType, toDisconnect);
            if (connectedWithType.size() == 0) {
                this.m_connectedByTypeOutgoing.remove(connType);
            }
        }
    }

    public void disconnectStep(Step toDisconnect) {
        List<StepManager> sList;
        ArrayList<String> emptyCons = new ArrayList<String>();
        for (Map.Entry<String, List<StepManager>> e : this.m_connectedByTypeIncoming.entrySet()) {
            sList = e.getValue();
            this.disconnectStep(sList, toDisconnect);
            if (sList.size() != 0) continue;
            emptyCons.add(e.getKey());
        }
        for (String conn : emptyCons) {
            this.m_connectedByTypeIncoming.remove(conn);
        }
        emptyCons.clear();
        for (Map.Entry<String, List<StepManager>> e : this.m_connectedByTypeOutgoing.entrySet()) {
            sList = e.getValue();
            this.disconnectStep(sList, toDisconnect);
            if (sList.size() != 0) continue;
            emptyCons.add(e.getKey());
        }
        for (String conn : emptyCons) {
            this.m_connectedByTypeOutgoing.remove(conn);
        }
    }

    public void clearAllConnections() {
        this.m_connectedByTypeIncoming.clear();
        this.m_connectedByTypeOutgoing.clear();
    }

    public void addIncomingConnection(String connectionName, StepManagerImpl step) {
        List<StepManager> steps = this.m_connectedByTypeIncoming.get(connectionName);
        if (steps == null) {
            steps = new ArrayList<StepManager>();
            this.m_connectedByTypeIncoming.put(connectionName, steps);
        }
        steps.add(step);
    }

    public void removeIncomingConnection(String connectionName, StepManagerImpl step) {
        List<StepManager> steps = this.m_connectedByTypeIncoming.get(connectionName);
        steps.remove(step);
    }

    public boolean addOutgoingConnection(String connectionName, StepManagerImpl step) {
        return this.addOutgoingConnection(connectionName, step, false);
    }

    public boolean addOutgoingConnection(String connectionName, StepManagerImpl step, boolean force) {
        boolean connSuccessful = false;
        List<String> targetCanAccept = step.getManagedStep().getIncomingConnectionTypes();
        if (targetCanAccept.contains(connectionName) || force) {
            List<StepManager> steps = this.m_connectedByTypeOutgoing.get(connectionName);
            if (steps == null) {
                steps = new ArrayList<StepManager>();
                this.m_connectedByTypeOutgoing.put(connectionName, steps);
            }
            step.addIncomingConnection(connectionName, this);
            steps.add(step);
            connSuccessful = true;
        }
        return connSuccessful;
    }

    public void removeOutgoingConnection(String connectionName, StepManagerImpl step) {
        List<StepManager> steps = this.m_connectedByTypeOutgoing.get(connectionName);
        steps.remove(step);
        step.removeIncomingConnection(connectionName, this);
    }

    @Override
    public List<StepManager> getIncomingConnectedStepsOfConnectionType(String connectionName) {
        return this.m_connectedByTypeIncoming.get(connectionName) != null ? this.m_connectedByTypeIncoming.get(connectionName) : new ArrayList<StepManager>();
    }

    @Override
    public List<StepManager> getOutgoingConnectedStepsOfConnectionType(String connectionName) {
        return this.m_connectedByTypeOutgoing.get(connectionName) != null ? this.m_connectedByTypeOutgoing.get(connectionName) : new ArrayList<StepManager>();
    }

    private StepManager getConnectedStepWithName(String stepName, Map<String, List<StepManager>> connectedSteps) {
        StepManager result = null;
        block0: for (Map.Entry<String, List<StepManager>> e : connectedSteps.entrySet()) {
            List<StepManager> stepsOfConnType = e.getValue();
            for (StepManager s : stepsOfConnType) {
                if (!((StepManagerImpl)s).getManagedStep().getName().equals(stepName)) continue;
                result = s;
                continue block0;
            }
        }
        return result;
    }

    @Override
    public StepManager getIncomingConnectedStepWithName(String stepName) {
        return this.getConnectedStepWithName(stepName, this.m_connectedByTypeIncoming);
    }

    @Override
    public StepManager getOutgoingConnectedStepWithName(String stepName) {
        return this.getConnectedStepWithName(stepName, this.m_connectedByTypeOutgoing);
    }

    @Override
    public Map<String, List<StepManager>> getOutgoingConnections() {
        return this.m_connectedByTypeOutgoing;
    }

    @Override
    public Map<String, List<StepManager>> getIncomingConnections() {
        return this.m_connectedByTypeIncoming;
    }

    public void addStepOutputListener(StepOutputListener listener, String outputConnectionName) {
        List<StepOutputListener> listenersForConnectionType = this.m_outputListeners.get(outputConnectionName);
        if (listenersForConnectionType == null) {
            listenersForConnectionType = new ArrayList<StepOutputListener>();
            this.m_outputListeners.put(outputConnectionName, listenersForConnectionType);
        }
        if (!listenersForConnectionType.contains(listener)) {
            listenersForConnectionType.add(listener);
        }
    }

    public void removeStepOutputListener(StepOutputListener listener, String outputConnectionName) {
        List<StepOutputListener> listenersForConnectionType = this.m_outputListeners.get(outputConnectionName);
        if (listenersForConnectionType != null) {
            listenersForConnectionType.remove(listener);
        }
    }

    public void clearAllStepOutputListeners() {
        this.m_outputListeners.clear();
    }

    public void clearStepOutputListeners(String outputConnectionName) {
        List<StepOutputListener> listenersForConnectionType = this.m_outputListeners.get(outputConnectionName);
        if (listenersForConnectionType != null) {
            listenersForConnectionType.clear();
        }
    }

    protected void notifyOutputListeners(Data data) throws WekaException {
        List<StepOutputListener> listenersForType = this.m_outputListeners.get(data.getConnectionName());
        if (listenersForType != null) {
            for (StepOutputListener l : listenersForType) {
                if (l.dataFromStep(data)) continue;
                this.logWarning("StepOutputListener '" + l.getClass().getCanonicalName() + "' did not process data '" + data.getConnectionName() + "' successfully'");
            }
        }
    }

    @Override
    public void outputData(String outgoingConnectionName, Data data) throws WekaException {
        if (!this.isStopRequested()) {
            data.setConnectionName(outgoingConnectionName);
            data.setSourceStep(this.m_managedStep);
            List<StepManager> toNotify = this.m_connectedByTypeOutgoing.get(outgoingConnectionName);
            if (toNotify != null) {
                for (StepManager s : toNotify) {
                    if (this.isStopRequested()) continue;
                    this.m_executionEnvironment.sendDataToStep((StepManagerImpl)s, data);
                }
            }
            this.notifyOutputListeners(data);
        }
    }

    @Override
    public void outputData(Data ... data) throws WekaException {
        if (!this.isStopRequested()) {
            LinkedHashMap<StepManagerImpl, ArrayList<Data>> stepsToSendTo = new LinkedHashMap<StepManagerImpl, ArrayList<Data>>();
            for (Data d : data) {
                d.setSourceStep(this.m_managedStep);
                if (d.getConnectionName() == null || d.getConnectionName().length() == 0) {
                    throw new WekaException("Data does not have a connection name set.");
                }
                List<StepManager> candidates = this.m_connectedByTypeOutgoing.get(d.getConnectionName());
                if (candidates != null) {
                    for (StepManager s : candidates) {
                        ArrayList<Data> toReceive = (ArrayList<Data>)stepsToSendTo.get(s);
                        if (toReceive == null) {
                            toReceive = new ArrayList<Data>();
                            stepsToSendTo.put((StepManagerImpl)s, toReceive);
                        }
                        toReceive.add(d);
                    }
                }
                this.notifyOutputListeners(d);
            }
            for (Map.Entry entry : stepsToSendTo.entrySet()) {
                if (((StepManagerImpl)entry.getKey()).isStopRequested()) continue;
                this.m_executionEnvironment.sendDataToStep((StepManagerImpl)entry.getKey(), ((List)entry.getValue()).toArray(new Data[((List)entry.getValue()).size()]));
            }
        }
    }

    @Override
    public void outputData(String outgoingConnectionName, String stepName, Data data) throws WekaException {
        if (!this.isStopRequested()) {
            data.setConnectionName(outgoingConnectionName);
            data.setSourceStep(this.m_managedStep);
            List<StepManager> outConnsOfType = this.m_connectedByTypeOutgoing.get(outgoingConnectionName);
            StepManagerImpl namedTarget = null;
            for (StepManager c : outConnsOfType) {
                if (!((StepManagerImpl)c).getManagedStep().getName().equals(stepName)) continue;
                namedTarget = (StepManagerImpl)c;
            }
            if (namedTarget != null && !namedTarget.isStopRequested()) {
                this.m_executionEnvironment.sendDataToStep(namedTarget, data);
            }
            this.notifyOutputListeners(data);
        }
    }

    protected void startStep() {
        try {
            this.getManagedStep().start();
        }
        catch (WekaException ex) {
            this.interrupted();
            this.logError(ex.getMessage(), ex);
        }
        catch (Throwable ex) {
            this.interrupted();
            this.logError(ex.getMessage(), ex);
        }
    }

    protected void stopStep() {
        this.m_stopRequested = true;
        this.getManagedStep().stop();
    }

    protected void processIncoming(Data data) {
        try {
            this.getManagedStep().processIncoming(data);
        }
        catch (WekaException ex) {
            this.interrupted();
            this.logError(ex.getMessage(), ex);
        }
        catch (Throwable e) {
            this.interrupted();
            this.logError(e.getMessage(), e);
        }
    }

    public List<String> getStepOutgoingConnectionTypes() {
        this.m_adjustForGraphicalRendering = true;
        List<String> results = this.getManagedStep().getOutgoingConnectionTypes();
        this.m_adjustForGraphicalRendering = false;
        return results;
    }

    @Override
    public int numIncomingConnections() {
        int size = 0;
        for (Map.Entry<String, List<StepManager>> e : this.m_connectedByTypeIncoming.entrySet()) {
            if (this.m_adjustForGraphicalRendering) {
                size += this.numIncomingConnectionsOfType(e.getKey());
                continue;
            }
            size += e.getValue().size();
        }
        return size;
    }

    @Override
    public int numIncomingConnectionsOfType(String connectionName) {
        int num = 0;
        List<StepManager> inOfType = this.m_connectedByTypeIncoming.get(connectionName);
        if (inOfType != null) {
            if (this.m_adjustForGraphicalRendering) {
                for (StepManager connS : inOfType) {
                    List<String> generatableOutputCons = ((StepManagerImpl)connS).getStepOutgoingConnectionTypes();
                    if (!generatableOutputCons.contains(connectionName)) continue;
                    ++num;
                }
            } else {
                num = inOfType.size();
            }
        }
        return num;
    }

    @Override
    public int numOutgoingConnections() {
        int size = 0;
        for (Map.Entry<String, List<StepManager>> e : this.m_connectedByTypeOutgoing.entrySet()) {
            size += e.getValue().size() - (this.m_adjustForGraphicalRendering ? 1 : 0);
        }
        if (size < 0) {
            size = 0;
        }
        return size;
    }

    @Override
    public int numOutgoingConnectionsOfType(String connectionName) {
        int num = 0;
        List<StepManager> outOfType = this.m_connectedByTypeOutgoing.get(connectionName);
        if (outOfType != null) {
            num = outOfType.size();
            if (this.m_adjustForGraphicalRendering) {
                --num;
            }
        }
        return num;
    }

    @Override
    public Instances getIncomingStructureForConnectionType(String connectionName) throws WekaException {
        if (this.getIncomingConnectedStepsOfConnectionType(connectionName).size() == 1) {
            return ((StepManagerImpl)this.getIncomingConnectedStepsOfConnectionType(connectionName).get(0)).getManagedStep().outputStructureForConnectionType(connectionName);
        }
        return null;
    }

    @Override
    public Instances getIncomingStructureFromStep(StepManager sourceStep, String connectionName) throws WekaException {
        return ((StepManagerImpl)sourceStep).getManagedStep().outputStructureForConnectionType(connectionName);
    }

    @Override
    public void logLow(String message) {
        if (this.m_log != null) {
            this.m_log.logLow(message);
        }
    }

    @Override
    public void logBasic(String message) {
        if (this.m_log != null) {
            this.m_log.logBasic(message);
        }
    }

    @Override
    public void logDetailed(String message) {
        if (this.m_log != null) {
            this.m_log.logDetailed(message);
        }
    }

    @Override
    public void logDebug(String message) {
        if (this.m_log != null) {
            this.m_log.logDebug(message);
        }
    }

    @Override
    public void logWarning(String message) {
        if (this.m_log != null) {
            this.m_log.logWarning(message);
            this.m_log.statusMessage("WARNING: " + message);
        }
    }

    @Override
    public void logError(String message, Throwable cause) {
        if (this.m_log != null) {
            this.m_log.log(message, LoggingLevel.ERROR, cause);
            this.m_log.statusMessage("ERROR: " + message);
        }
        if (this.m_executionEnvironment != null) {
            this.m_executionEnvironment.stopProcessing();
        }
    }

    @Override
    public void statusMessage(String message) {
        if (this.m_log != null) {
            this.m_log.statusMessage(message);
        }
    }

    @Override
    public void log(String message, LoggingLevel level) {
        if (this.m_log != null) {
            this.m_log.log(message, level, null);
        }
    }

    @Override
    public String environmentSubstitute(String source) {
        Environment toUse = Environment.getSystemWide();
        if (this.getExecutionEnvironment() != null) {
            toUse = this.getExecutionEnvironment().getEnvironmentVariables();
        }
        String result = source;
        if (source != null) {
            try {
                result = toUse.substitute(source);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public Step getInfoStep(Class stepClass) throws WekaException {
        Step info = this.getInfoStep();
        if (info.getClass() != stepClass) {
            throw new WekaException("The managed step (" + info.getClass().getCanonicalName() + ") is not not an instance of the required class: " + stepClass.getCanonicalName());
        }
        return info;
    }

    @Override
    public Step getInfoStep() throws WekaException {
        if (this.numOutgoingConnectionsOfType("info") > 0) {
            return this.getManagedStep();
        }
        throw new WekaException("There are no outgoing info connections from this step!");
    }

    @Override
    public StepManager findStepInFlow(String stepNameToFind) {
        Flow flow = this.m_executionEnvironment.getFlowExecutor().getFlow();
        return flow.findStep(stepNameToFind);
    }

    public String stepStatusMessagePrefix() {
        Object wrappedAlgo;
        String prefix = (this.getManagedStep() != null ? this.getManagedStep().getName() : "Unknown") + "$";
        prefix = prefix + (this.getManagedStep() != null ? this.getManagedStep().hashCode() : 1) + "|";
        if (this.getManagedStep() instanceof WekaAlgorithmWrapper && (wrappedAlgo = ((WekaAlgorithmWrapper)this.getManagedStep()).getWrappedAlgorithm()) instanceof OptionHandler) {
            prefix = prefix + Utils.joinOptions(((OptionHandler)wrappedAlgo).getOptions()) + "|";
        }
        return prefix;
    }

    protected static boolean connectionIsIncremental(Data conn) {
        return conn.getConnectionName().equalsIgnoreCase("instance") || conn.getConnectionName().equalsIgnoreCase("incrementalClassifier") || conn.getConnectionName().equalsIgnoreCase("chart") || conn.getPayloadElement("incremental_stream", false) != false;
    }
}

