/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import weka.core.ClassDiscovery;
import weka.core.Environment;
import weka.core.PluginManager;
import weka.core.Utils;
import weka.core.Version;
import weka.core.WekaPackageClassLoaderManager;
import weka.core.WekaPackageLibIsolatingClassLoader;
import weka.core.converters.ConverterUtils;
import weka.core.logging.Logger;
import weka.core.packageManagement.DefaultPackageManager;
import weka.core.packageManagement.Dependency;
import weka.core.packageManagement.Package;
import weka.core.packageManagement.PackageConstraint;
import weka.core.packageManagement.PackageManager;
import weka.core.packageManagement.VersionPackageConstraint;
import weka.gui.GenericObjectEditor;
import weka.gui.GenericPropertiesCreator;
import weka.gui.beans.BeansProperties;
import weka.gui.beans.KnowledgeFlowApp;
import weka.gui.explorer.ExplorerDefaults;

public class WekaPackageManager {
    public static final String INJECT_DEPENDENCY_KEY = "InjectDependencies";
    public static final String VERSION_KEY = "Version";
    public static final String DISABLE_KEY = "Disable";
    public static final String DISABLED_KEY = "Disabled";
    public static final String PRECLUDES_KEY = "Precludes";
    public static final String DO_NOT_LOAD_IF_ENV_VAR_NOT_SET_KEY = "DoNotLoadIfEnvVarNotSet";
    public static final String DO_NOT_LOAD_IF_ENV_VAR_NOT_SET_MESSAGE_KEY = "DoNotLoadIfEnvVarNotSetMessage";
    public static final String DO_NOT_LOAD_IF_CLASS_NOT_PRESENT_KEY = "DoNotLoadIfClassNotPresent";
    public static final String DO_NOT_LOAD_IF_CLASS_NOT_PRESENT_MESSAGE_KEY = "DoNotLoadIfClassNotPresentMessage";
    public static final String DO_NOT_LOAD_IF_FILE_NOT_PRESENT_KEY = "DoNotLoadIfFileNotPresent";
    public static final String DO_NOT_LOAD_IF_FILE_NOT_PRESENT_MESSAGE_KEY = "DoNotLoadIfFileNotPresentMessage";
    public static final String MESSAGE_TO_DISPLAY_ON_INSTALLATION_KEY = "MessageToDisplayOnInstallation";
    public static final String SET_SYSTEM_PROPERTIES_KEY = "SetSystemProperties";
    private static String WEKAFILES_DIR_NAME = "wekafiles";
    public static File WEKA_HOME = new File(System.getProperty("user.home") + File.separator + WEKAFILES_DIR_NAME);
    public static File PACKAGES_DIR = new File(WEKA_HOME.toString() + File.separator + "packages");
    private static String PROPERTIES_DIR_NAME = "props";
    public static File PROPERTIES_DIR = new File(WEKA_HOME.toString() + File.separator + PROPERTIES_DIR_NAME);
    public static String NATIVE_LIBS_DIR_NAME = "native";
    public static File NATIVE_LIBS_DIR = new File(WEKA_HOME.toString() + File.separator + NATIVE_LIBS_DIR_NAME);
    private static PackageManager PACKAGE_MANAGER = PackageManager.create();
    private static URL REP_URL;
    private static URL CACHE_URL;
    private static boolean INITIAL_CACHE_BUILD_NEEDED;
    private static String PACKAGE_LIST_FILENAME;
    private static String PRIMARY_REPOSITORY;
    private static String REP_MIRROR;
    private static boolean USER_SET_REPO;
    private static String PACKAGE_MANAGER_PROPS_FILE_NAME;
    public static boolean m_offline;
    private static boolean m_loadPackages;
    protected static boolean m_wekaHomeEstablished;
    protected static boolean m_packagesLoaded;
    protected static final String PACKAGE_LIST_WITH_VERSION_FILE = "packageListWithVersion.txt";
    protected static final String FORCED_REFRESH_COUNT_FILE = "forcedRefreshCount.txt";
    public static boolean m_initialPackageLoadingInProcess;
    public static boolean m_noPackageMetaDataAvailable;
    public static Set<String> m_doNotLoadList;

    protected static boolean establishWekaHome() {
        File generalProps;
        String loadPackages;
        String offline;
        if (m_wekaHomeEstablished) {
            return true;
        }
        try {
            PluginManager.addFromProperties(WekaPackageManager.class.getClassLoader().getResourceAsStream("weka/PluginManager.props"), true);
        }
        catch (Exception ex) {
            WekaPackageManager.log(Logger.Level.WARNING, "[WekaPackageManager] unable to read weka/PluginManager.props");
        }
        Environment env = Environment.getSystemWide();
        String wh = env.getVariableValue("WEKA_HOME");
        if (wh != null) {
            WEKA_HOME = new File(wh);
            PACKAGES_DIR = new File(wh + File.separator + "packages");
            PROPERTIES_DIR = new File(wh + File.separator + PROPERTIES_DIR_NAME);
            NATIVE_LIBS_DIR = new File(wh + File.separator + NATIVE_LIBS_DIR_NAME);
        } else {
            env.addVariableSystemWide("WEKA_HOME", WEKA_HOME.toString());
        }
        String nativePath = System.getProperty("java.library.path", "");
        if (!nativePath.contains(NATIVE_LIBS_DIR.toString())) {
            nativePath = nativePath + File.pathSeparator + NATIVE_LIBS_DIR.toString();
            System.setProperty("java.library.path", nativePath);
        }
        boolean ok = true;
        if (!WEKA_HOME.exists() && !WEKA_HOME.mkdir()) {
            System.err.println("Unable to create WEKA_HOME (" + WEKA_HOME.getAbsolutePath() + ")");
            ok = false;
        }
        if (!PACKAGES_DIR.exists() && !PACKAGES_DIR.mkdir()) {
            System.err.println("Unable to create packages directory (" + PACKAGES_DIR.getAbsolutePath() + ")");
            ok = false;
        }
        if (!NATIVE_LIBS_DIR.exists() && !NATIVE_LIBS_DIR.mkdir()) {
            System.err.println("Unable to create native libs directory (" + NATIVE_LIBS_DIR.getAbsolutePath() + ")");
        }
        m_wekaHomeEstablished = ok;
        PACKAGE_MANAGER.setPackageHome(PACKAGES_DIR);
        m_doNotLoadList = WekaPackageManager.getDoNotLoadList();
        try {
            File repPropsFile;
            String repURL = env.getVariableValue("weka.core.wekaPackageRepositoryURL");
            if ((repURL == null || repURL.length() == 0) && (repPropsFile = new File(PROPERTIES_DIR.toString() + File.separator + "PackageRepository.props")).exists()) {
                Properties repProps = new Properties();
                repProps.load(new FileInputStream(repPropsFile));
                repURL = repProps.getProperty("weka.core.wekaPackageRepositoryURL");
            }
            if (repURL == null || repURL.length() == 0) {
                repURL = PRIMARY_REPOSITORY;
            } else {
                WekaPackageManager.log(Logger.Level.INFO, "[WekaPackageManager] weka.core.WekaPackageRepositoryURL = " + repURL);
                USER_SET_REPO = true;
            }
            REP_URL = new URL(repURL);
            PACKAGE_MANAGER.setPackageRepositoryURL(REP_URL);
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        PACKAGE_MANAGER.setBaseSystemName("weka");
        PACKAGE_MANAGER.setBaseSystemVersion(Version.VERSION);
        File cacheDir = new File(WEKA_HOME.toString() + File.separator + "repCache");
        try {
            String tempCacheString = "file://" + cacheDir.toString();
            tempCacheString = tempCacheString.replace(" ", "%20");
            tempCacheString = tempCacheString.replace('\\', '/');
            if (tempCacheString.startsWith("file://") && !tempCacheString.startsWith("file:///")) {
                tempCacheString = tempCacheString.substring(7);
                tempCacheString = "file:///" + tempCacheString;
            }
            URI tempURI = new URI(tempCacheString);
            CACHE_URL = tempURI.toURL();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        File packagesList = new File(cacheDir.getAbsolutePath() + File.separator + PACKAGE_LIST_FILENAME);
        if (!cacheDir.exists()) {
            if (!cacheDir.mkdir()) {
                System.err.println("Unable to create repository cache directory (" + cacheDir.getAbsolutePath() + ")");
                WekaPackageManager.log(Logger.Level.WARNING, "Unable to create repository cache directory (" + cacheDir.getAbsolutePath() + ")");
                CACHE_URL = null;
            } else {
                INITIAL_CACHE_BUILD_NEEDED = true;
            }
        }
        if (!packagesList.exists()) {
            INITIAL_CACHE_BUILD_NEEDED = true;
        }
        if ((offline = env.getVariableValue("weka.packageManager.offline")) != null) {
            m_offline = offline.equalsIgnoreCase("true");
        }
        if ((loadPackages = env.getVariableValue("weka.packageManager.loadPackages")) == null) {
            loadPackages = env.getVariableValue("weka.core.loadPackages");
        }
        if (loadPackages != null) {
            m_loadPackages = loadPackages.equalsIgnoreCase("true");
        }
        if ((generalProps = new File(PROPERTIES_DIR.toString() + File.separator + PACKAGE_MANAGER_PROPS_FILE_NAME)).exists()) {
            Properties gProps = new Properties();
            try {
                String pluginManagerDisableList;
                gProps.load(new FileInputStream(generalProps));
                String repURL = gProps.getProperty("weka.core.wekaPackageRepositoryURL");
                if (repURL != null && repURL.length() > 0) {
                    REP_URL = new URL(repURL);
                    PACKAGE_MANAGER.setPackageRepositoryURL(REP_URL);
                }
                if ((offline = gProps.getProperty("weka.packageManager.offline")) != null && offline.length() > 0) {
                    m_offline = offline.equalsIgnoreCase("true");
                }
                if ((loadPackages = gProps.getProperty("weka.packageManager.loadPackages")) == null) {
                    loadPackages = env.getVariableValue("weka.core.loadPackages");
                }
                if (loadPackages != null) {
                    m_loadPackages = loadPackages.equalsIgnoreCase("true");
                }
                if ((pluginManagerDisableList = gProps.getProperty("weka.pluginManager.disable")) != null && pluginManagerDisableList.length() > 0) {
                    String[] parts;
                    ArrayList<String> disable = new ArrayList<String>();
                    for (String s : parts = pluginManagerDisableList.split(",")) {
                        disable.add(s.trim());
                    }
                    PluginManager.addToDisabledList(disable);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (INITIAL_CACHE_BUILD_NEEDED && m_offline) {
            m_noPackageMetaDataAvailable = true;
        }
        PACKAGE_MANAGER.setPackageRepositoryURL(REP_URL);
        PACKAGE_MANAGER.setProxyAuthentication(REP_URL);
        return ok;
    }

    protected static void establishMirror() {
        if (m_offline) {
            return;
        }
        try {
            String mirrorListURL = "http://www.cs.waikato.ac.nz/ml/weka/packageMetaDataMirror.txt";
            URLConnection conn = null;
            URL connURL = new URL(mirrorListURL);
            conn = PACKAGE_MANAGER.setProxyAuthentication(connURL) ? connURL.openConnection(PACKAGE_MANAGER.getProxy()) : connURL.openConnection();
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            BufferedReader bi = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            REP_MIRROR = bi.readLine();
            bi.close();
            if (REP_MIRROR != null && REP_MIRROR.length() > 0 && !REP_MIRROR.equals(PRIMARY_REPOSITORY) && !USER_SET_REPO) {
                WekaPackageManager.log(Logger.Level.INFO, "[WekaPackageManager] Package manager using repository mirror: " + REP_MIRROR);
                REP_URL = new URL(REP_MIRROR);
            }
        }
        catch (Exception ex) {
            WekaPackageManager.log(Logger.Level.WARNING, "[WekaPackageManager] The repository meta data mirror file seems to be unavailable (" + ex.getMessage() + ")");
        }
    }

    protected static void log(Logger.Level level, String message) {
        try {
            File logFile = new File(WEKA_HOME.toString() + File.separator + "weka.log");
            BufferedWriter writer = new BufferedWriter(new FileWriter(logFile, true));
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String linefeed = System.getProperty("line.separator");
            String m = format.format(new Date()) + " " + (Object)((Object)level) + ": " + message + linefeed;
            writer.write(m);
            writer.flush();
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void removeExplorerProps(String installedPackageName) {
        try {
            Properties expProps = new Properties();
            String explorerProps = WekaPackageManager.getPackageHome().getAbsolutePath() + File.separator + installedPackageName + File.separator + "Explorer.props";
            BufferedInputStream bi = new BufferedInputStream(new FileInputStream(explorerProps));
            expProps.load(bi);
            bi.close();
            bi = null;
            Set<Object> keys = expProps.keySet();
            for (String string : keys) {
                if (string.endsWith("Policy")) continue;
                String existingVal = ExplorerDefaults.get(string, "");
                String toRemove = expProps.getProperty(string);
                if (existingVal.length() <= 0) continue;
                existingVal = existingVal.replace(toRemove + ",", "");
                existingVal = existingVal.replace("," + toRemove, "");
                ExplorerDefaults.set(string, existingVal);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static void processGenericPropertiesCreatorProps(File propsFile) {
        try {
            Properties expProps = new Properties();
            BufferedInputStream bi = new BufferedInputStream(new FileInputStream(propsFile));
            expProps.load(bi);
            bi.close();
            bi = null;
            Properties GPCInputProps = GenericPropertiesCreator.getGlobalInputProperties();
            Set<Object> keys = expProps.keySet();
            for (String string : keys) {
                String newVal;
                String existingVal = GPCInputProps.getProperty(string, "");
                if (existingVal.length() > 0) {
                    newVal = expProps.getProperty(string);
                    if (existingVal.indexOf(newVal) >= 0) continue;
                    newVal = existingVal + "," + newVal;
                    GPCInputProps.put(string, newVal);
                    continue;
                }
                newVal = expProps.getProperty(string);
                GPCInputProps.put(string, newVal);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static void processExplorerProps(File propsFile) {
        try {
            Properties expProps = new Properties();
            BufferedInputStream bi = new BufferedInputStream(new FileInputStream(propsFile));
            expProps.load(bi);
            bi.close();
            bi = null;
            Set<Object> keys = expProps.keySet();
            for (String string : keys) {
                if (string.endsWith("Policy")) continue;
                String existingVal = ExplorerDefaults.get(string, "");
                if (existingVal.length() > 0) {
                    String newVal;
                    String replacePolicy = expProps.getProperty(string + "Policy");
                    if (replacePolicy != null && replacePolicy.length() > 0) {
                        if (replacePolicy.equalsIgnoreCase("replace")) {
                            newVal = expProps.getProperty(string);
                            ExplorerDefaults.set(string, newVal);
                            continue;
                        }
                        newVal = expProps.getProperty(string);
                        if (existingVal.indexOf(newVal) >= 0) continue;
                        newVal = existingVal + "," + newVal;
                        ExplorerDefaults.set(string, newVal);
                        continue;
                    }
                    newVal = expProps.getProperty(string);
                    if (existingVal.indexOf(newVal) >= 0) continue;
                    newVal = existingVal + "," + newVal;
                    ExplorerDefaults.set(string, newVal);
                    continue;
                }
                String newVal = expProps.getProperty(string);
                ExplorerDefaults.set(string, newVal);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static void processGUIEditorsProps(File propsFile, boolean verbose) {
        GenericObjectEditor.registerEditors();
        try {
            Properties editorProps = new Properties();
            BufferedInputStream bi = new BufferedInputStream(new FileInputStream(propsFile));
            editorProps.load(bi);
            bi.close();
            bi = null;
            Enumeration<?> enm = editorProps.propertyNames();
            while (enm.hasMoreElements()) {
                String name = enm.nextElement().toString();
                String value = editorProps.getProperty(name, "");
                if (verbose) {
                    System.err.println("Registering " + name + " " + value);
                }
                GenericObjectEditor.registerEditor(name, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static void processPluginManagerProps(String packageName, File propsFile) {
        try {
            PluginManager.addFromProperties(packageName, propsFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected static void processPackageDirectory(File directory, boolean verbose, List<File> goePropsFiles, boolean avoidTriggeringFullClassDiscovery) throws Exception {
        File[] contents = directory.listFiles();
        if (contents != null) {
            for (File content : contents) {
                if (content.isFile() && content.getPath().endsWith("Beans.props")) {
                    BeansProperties.addToPluginBeanProps(content);
                    if (avoidTriggeringFullClassDiscovery) continue;
                    KnowledgeFlowApp.disposeSingleton();
                    continue;
                }
                if (content.isFile() && content.getPath().endsWith("Explorer.props") && !avoidTriggeringFullClassDiscovery) {
                    WekaPackageManager.processExplorerProps(content);
                    continue;
                }
                if (content.isFile() && content.getPath().endsWith("GUIEditors.props") && !avoidTriggeringFullClassDiscovery) {
                    WekaPackageManager.processGUIEditorsProps(content, verbose);
                    continue;
                }
                if (content.isFile() && content.getPath().endsWith("GenericPropertiesCreator.props") && !avoidTriggeringFullClassDiscovery) {
                    if (goePropsFiles != null) {
                        goePropsFiles.add(content);
                        continue;
                    }
                    WekaPackageManager.processGenericPropertiesCreatorProps(content);
                    continue;
                }
                if (!content.isFile() || !content.getPath().endsWith("PluginManager.props")) continue;
                WekaPackageManager.processPluginManagerProps(directory.getName(), content);
            }
        }
    }

    public static boolean hasBeenLoaded(Package toCheck) {
        return WekaPackageClassLoaderManager.getWekaPackageClassLoaderManager().getPackageClassLoader(toCheck.getName()) != null;
    }

    public static boolean loadCheck(Package toLoad, File packageRoot, PrintStream ... progress) {
        boolean load;
        try {
            load = toLoad.isCompatibleBaseSystem();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        if (!load) {
            for (PrintStream p : progress) {
                p.println("[WekaPackageManager] Skipping package " + toLoad.getName() + " because it is not compatible with Weka " + PACKAGE_MANAGER.getBaseSystemVersion().toString());
            }
            return false;
        }
        try {
            Package repoP = WekaPackageManager.getRepositoryPackageInfo(toLoad.getName(), toLoad.getPackageMetaDataElement(VERSION_KEY).toString());
            if (repoP != null) {
                Object disabled = repoP.getPackageMetaDataElement(DISABLED_KEY);
                if (disabled == null) {
                    disabled = repoP.getPackageMetaDataElement(DISABLE_KEY);
                }
                if (disabled != null && disabled.toString().equalsIgnoreCase("true")) {
                    for (PrintStream p : progress) {
                        p.println("[WekaPackageManager] Skipping package " + toLoad.getName() + " because it has been marked as disabled at the repository");
                    }
                    return false;
                }
            }
        }
        catch (Exception ex) {
            return true;
        }
        Object precludes = toLoad.getPackageMetaDataElement(PRECLUDES_KEY);
        if (precludes != null) {
            try {
                List<Package> installed = WekaPackageManager.getInstalledPackages();
                List<Package> preclusions = toLoad.getPrecludedPackages(installed);
                if (preclusions.size() > 0) {
                    for (PrintStream p : progress) {
                        p.println("[WekaPackageManager] Skipping package " + toLoad.getName() + " because it precludes one or more packages that are already installed: ");
                        for (Package prec : preclusions) {
                            p.println("\t" + prec);
                        }
                    }
                    return false;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        boolean bl = load = !m_doNotLoadList.contains(toLoad.getName());
        if (!load) {
            for (PrintStream p : progress) {
                p.println("[WekaPackageManager] Skipping package " + toLoad.getName() + " because it is has been marked as do not load");
            }
            return false;
        }
        if (m_offline) {
            return true;
        }
        try {
            List<Dependency> missing = toLoad.getMissingDependencies();
            if (missing.size() > 0) {
                for (PrintStream p : progress) {
                    p.println("[WekaPackageManager] " + toLoad.getName() + " can't be loaded because the following packages are missing:");
                    for (Dependency d : missing) {
                        p.println(d.getTarget());
                    }
                }
                return false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        try {
            List<Dependency> depends = toLoad.getDependencies();
            for (Dependency d : depends) {
                if (!d.getTarget().getPackage().isInstalled()) continue;
                if (!WekaPackageManager.loadCheck(d.getTarget().getPackage(), packageRoot, progress)) {
                    for (PrintStream p : progress) {
                        p.println("[WekaPackageManager] Can't load " + toLoad.getName() + " because " + d.getTarget() + " can't be loaded.");
                    }
                    return false;
                }
                Package installedD = WekaPackageManager.getInstalledPackageInfo(d.getTarget().getPackage().getName());
                if (d.getTarget().checkConstraint(installedD)) continue;
                for (PrintStream p : progress) {
                    p.println("[WekaPackageManager] Can't load " + toLoad.getName() + " because the installed " + d.getTarget().getPackage().getName() + " is not compatible (requires: " + d.getTarget() + ")");
                }
                return false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean checkForMissingFiles(Package toLoad, File packageRoot, PrintStream ... progress) {
        Object doNotLoadMessage;
        boolean result = true;
        Object doNotLoadIfFileMissing = toLoad.getPackageMetaDataElement(DO_NOT_LOAD_IF_FILE_NOT_PRESENT_KEY);
        String packageRootPath = packageRoot.getPath() + File.separator;
        if (doNotLoadIfFileMissing != null && doNotLoadIfFileMissing.toString().length() > 0) {
            StringTokenizer tok = new StringTokenizer(doNotLoadIfFileMissing.toString(), ",");
            while (tok.hasMoreTokens()) {
                String nextT = tok.nextToken().trim();
                File toCheck = new File(packageRootPath + nextT);
                if (toCheck.exists()) continue;
                PrintStream[] printStreamArray = progress;
                int n = printStreamArray.length;
                for (int i = 0; i < n; ++i) {
                    PrintStream p = printStreamArray[i];
                    p.println("[WekaPackageManager] " + toLoad.getName() + " can't be loaded because " + toCheck.getPath() + " appears to be missing.");
                }
                result = false;
                break;
            }
        }
        if (!result && (doNotLoadMessage = toLoad.getPackageMetaDataElement(DO_NOT_LOAD_IF_FILE_NOT_PRESENT_MESSAGE_KEY)) != null && doNotLoadMessage.toString().length() > 0) {
            String dnlM = doNotLoadMessage.toString();
            try {
                dnlM = Environment.getSystemWide().substitute(dnlM);
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (PrintStream p : progress) {
                p.println("[WekaPackageManager] " + dnlM);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Set<String> getDoNotLoadList() {
        Set<String> doNotLoad = new HashSet<String>();
        File doNotLoadList = new File(PACKAGES_DIR.toString() + File.separator + "doNotLoad.ser");
        if (doNotLoadList.exists() && doNotLoadList.isFile()) {
            ObjectInputStream ois = null;
            try {
                ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(doNotLoadList)));
                doNotLoad = (Set)ois.readObject();
            }
            catch (FileNotFoundException ex) {
            }
            catch (IOException e) {
                System.err.println("An error occurred while reading the doNotLoad list: " + e.getMessage());
            }
            catch (ClassNotFoundException e) {
                System.err.println("An error occurred while reading the doNotLoad list: " + e.getMessage());
            }
            finally {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        return doNotLoad;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> toggleLoadStatus(List<String> packageNames) throws Exception {
        ArrayList<String> unknownPackages = new ArrayList<String>();
        boolean changeMade = false;
        for (String s : packageNames) {
            Package p = PACKAGE_MANAGER.getInstalledPackageInfo(s);
            if (p == null) {
                unknownPackages.add(s);
                continue;
            }
            if (m_doNotLoadList.contains(s)) {
                m_doNotLoadList.remove(s);
            } else if (WekaPackageManager.loadCheck(p, new File(WekaPackageManager.getPackageHome().toString() + File.separator + s), new PrintStream[0])) {
                m_doNotLoadList.add(s);
            }
            changeMade = true;
        }
        if (changeMade) {
            File doNotLoadList = new File(PACKAGES_DIR.toString() + File.separator + "doNotLoad.ser");
            ObjectOutputStream oos = null;
            try {
                oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(doNotLoadList)));
                oos.writeObject(m_doNotLoadList);
            }
            finally {
                if (oos != null) {
                    oos.flush();
                    oos.close();
                }
            }
        }
        return unknownPackages;
    }

    public static synchronized void loadPackages(boolean verbose) {
        WekaPackageManager.loadPackages(verbose, false, true);
    }

    public static synchronized void loadPackages(boolean verbose, boolean avoidTriggeringFullClassDiscovery, boolean refreshGOEProperties) {
        ArrayList<File> goePropsFiles = new ArrayList<File>();
        if (!m_loadPackages) {
            return;
        }
        if (m_packagesLoaded) {
            return;
        }
        m_packagesLoaded = true;
        m_initialPackageLoadingInProcess = true;
        if (WekaPackageManager.establishWekaHome()) {
            File[] contents = PACKAGES_DIR.listFiles();
            if (contents.length > 0) {
                WekaPackageManager.establishCacheIfNeeded(System.out);
            }
            HashMap<String, List<String>> injectDependencies = new HashMap<String, List<String>>();
            for (File content : contents) {
                if (!content.isDirectory()) continue;
                try {
                    boolean load;
                    Package toLoad = WekaPackageManager.getInstalledPackageInfo(content.getName());
                    WekaPackageManager.checkForInjectDependencies(toLoad, injectDependencies);
                    if (toLoad == null || !(load = WekaPackageManager.loadCheck(toLoad, content, System.err))) continue;
                    if (verbose) {
                        System.out.println("[WekaPackageManager] loading package " + content.getName());
                    }
                    WekaPackageClassLoaderManager.getWekaPackageClassLoaderManager().addPackageToClassLoader(content);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    System.err.println("[WekaPackageManager] Problem loading package " + content.getName() + " skipping...");
                }
            }
            WekaPackageManager.injectPackageDependencies(injectDependencies);
            WekaPackageClassLoaderManager.getWekaPackageClassLoaderManager().performIntegrityCheck();
            for (File content : contents) {
                try {
                    if (!content.isDirectory() || WekaPackageClassLoaderManager.getWekaPackageClassLoaderManager().getPackageClassLoader(content.getName()) == null) continue;
                    WekaPackageManager.processPackageDirectory(content, verbose, goePropsFiles, avoidTriggeringFullClassDiscovery);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    System.err.println("[WekaPackageManager] Problem loading package " + content.getName() + " skipping...");
                }
            }
        }
        m_initialPackageLoadingInProcess = false;
        if (!avoidTriggeringFullClassDiscovery) {
            for (File f : goePropsFiles) {
                WekaPackageManager.processGenericPropertiesCreatorProps(f);
            }
        }
        if (refreshGOEProperties) {
            if (verbose) {
                System.err.println("Refreshing GOE props...");
            }
            WekaPackageManager.refreshGOEProperties();
        }
    }

    protected static void checkForInjectDependencies(Package toLoad, Map<String, List<String>> injectDeps) {
        Object injectList = toLoad.getPackageMetaDataElement(INJECT_DEPENDENCY_KEY);
        if (injectList != null) {
            String[] deps;
            for (String dep : deps = injectList.toString().split(",")) {
                String[] sourceAndTarget = dep.split(":");
                if (sourceAndTarget.length != 2) continue;
                String depender = sourceAndTarget[0].trim();
                String dependee = sourceAndTarget[1].trim();
                List<String> depList = injectDeps.get(depender);
                if (depList == null) {
                    depList = new ArrayList<String>();
                    injectDeps.put(depender, depList);
                }
                depList.add(dependee);
            }
        }
    }

    protected static void injectPackageDependencies(Map<String, List<String>> injectDependencies) {
        for (Map.Entry<String, List<String>> e : injectDependencies.entrySet()) {
            String source = e.getKey();
            List<String> targets = e.getValue();
            WekaPackageLibIsolatingClassLoader sourceLoader = WekaPackageClassLoaderManager.getWekaPackageClassLoaderManager().getPackageClassLoader(source);
            if (sourceLoader == null) continue;
            for (String targetPackage : targets) {
                if (WekaPackageClassLoaderManager.getWekaPackageClassLoaderManager().getPackageClassLoader(targetPackage) == null) continue;
                System.out.println("[WekaPackageManager] Added a dependency between " + source + " and " + targetPackage);
                sourceLoader.addPackageDependency(targetPackage);
            }
        }
    }

    public static void refreshGOEProperties() {
        ClassDiscovery.clearClassCache();
        GenericPropertiesCreator.regenerateGlobalOutputProperties();
        GenericObjectEditor.determineClasses();
        ConverterUtils.initialize();
        KnowledgeFlowApp.disposeSingleton();
        KnowledgeFlowApp.reInitialize();
    }

    public static PackageManager getUnderlyingPackageManager() {
        return PACKAGE_MANAGER;
    }

    public static int repoZipArchiveSize() {
        int size = -1;
        try {
            PACKAGE_MANAGER.setPackageRepositoryURL(REP_URL);
            String numPackagesS = PACKAGE_MANAGER.getPackageRepositoryURL().toString() + "/repoSize.txt";
            URLConnection conn = null;
            URL connURL = new URL(numPackagesS);
            conn = PACKAGE_MANAGER.setProxyAuthentication(connURL) ? connURL.openConnection(PACKAGE_MANAGER.getProxy()) : connURL.openConnection();
            conn.setConnectTimeout(30000);
            BufferedReader bi = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String n = bi.readLine();
            try {
                size = Integer.parseInt(n);
            }
            catch (NumberFormatException ne) {
                System.err.println("[WekaPackageManager] problem parsing the size of repository zip archive from the server.");
            }
            bi.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return size;
    }

    public static int numRepositoryPackages() {
        if (m_offline) {
            return -1;
        }
        int numPackages = -1;
        try {
            PACKAGE_MANAGER.setPackageRepositoryURL(REP_URL);
            String numPackagesS = PACKAGE_MANAGER.getPackageRepositoryURL().toString() + "/numPackages.txt";
            URLConnection conn = null;
            URL connURL = new URL(numPackagesS);
            conn = PACKAGE_MANAGER.setProxyAuthentication(connURL) ? connURL.openConnection(PACKAGE_MANAGER.getProxy()) : connURL.openConnection();
            conn.setConnectTimeout(30000);
            BufferedReader bi = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String n = bi.readLine();
            try {
                numPackages = Integer.parseInt(n);
            }
            catch (NumberFormatException ne) {
                System.err.println("[WekaPackageManager] problem parsing number of packages from server.");
            }
            bi.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return numPackages;
    }

    public static Map<String, String> getPackageList(boolean local) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            WekaPackageManager.useCacheOrOnlineRepository();
            if (!local) {
                PACKAGE_MANAGER.setPackageRepositoryURL(REP_URL);
            }
            String packageListS = PACKAGE_MANAGER.getPackageRepositoryURL().toString() + "/" + PACKAGE_LIST_WITH_VERSION_FILE;
            URLConnection conn = null;
            URL connURL = new URL(packageListS);
            conn = PACKAGE_MANAGER.setProxyAuthentication(connURL) ? connURL.openConnection(PACKAGE_MANAGER.getProxy()) : connURL.openConnection();
            conn.setConnectTimeout(30000);
            BufferedReader bi = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String l = null;
            while ((l = bi.readLine()) != null) {
                String[] parts = l.split(":");
                if (parts.length != 2) continue;
                result.put(parts[0], parts[1]);
            }
            bi.close();
        }
        catch (Exception ex) {
            result = null;
        }
        return result;
    }

    public static Exception establishCacheIfNeeded(PrintStream ... progress) {
        if (m_offline) {
            return null;
        }
        if (REP_MIRROR == null) {
            WekaPackageManager.establishMirror();
        }
        Exception problem = null;
        if (INITIAL_CACHE_BUILD_NEEDED) {
            for (PrintStream p : progress) {
                p.println("Caching repository metadata, please wait...");
            }
            problem = WekaPackageManager.refreshCache(progress);
            INITIAL_CACHE_BUILD_NEEDED = false;
        } else {
            try {
                if (WekaPackageManager.checkForForcedCacheRefresh()) {
                    for (PrintStream p : progress) {
                        p.println("Forced repository metadata refresh, please wait...");
                    }
                    problem = WekaPackageManager.refreshCache(progress);
                }
            }
            catch (MalformedURLException ex) {
                problem = ex;
            }
        }
        return problem;
    }

    protected static boolean checkForForcedCacheRefresh() throws MalformedURLException {
        int refreshCountServer = WekaPackageManager.getForcedRefreshCount(false);
        if (refreshCountServer > 0) {
            int refreshCountLocal = WekaPackageManager.getForcedRefreshCount(true);
            return refreshCountServer > refreshCountLocal;
        }
        return false;
    }

    protected static int getForcedRefreshCount(boolean local) throws MalformedURLException {
        WekaPackageManager.useCacheOrOnlineRepository();
        if (!local) {
            PACKAGE_MANAGER.setPackageRepositoryURL(REP_URL);
        }
        String refreshCountS = PACKAGE_MANAGER.getPackageRepositoryURL().toString() + "/" + FORCED_REFRESH_COUNT_FILE;
        int refreshCount = -1;
        URLConnection conn = null;
        URL connURL = new URL(refreshCountS);
        try {
            conn = PACKAGE_MANAGER.setProxyAuthentication(connURL) ? connURL.openConnection(PACKAGE_MANAGER.getProxy()) : connURL.openConnection();
            conn.setConnectTimeout(30000);
            BufferedReader bi = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String countS = bi.readLine();
            if (countS != null && countS.length() > 0) {
                try {
                    refreshCount = Integer.parseInt(countS);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return refreshCount;
    }

    public static Exception checkForNewPackages(PrintStream ... progress) {
        Map<String, String> repositoryPackageNameList;
        if (m_offline) {
            return null;
        }
        Exception problem = null;
        Map<String, String> localPackageNameList = WekaPackageManager.getPackageList(true);
        if (localPackageNameList == null) {
            System.err.println("Local package list is missing, trying a cache refresh to restore...");
            WekaPackageManager.refreshCache(progress);
            localPackageNameList = WekaPackageManager.getPackageList(true);
            if (localPackageNameList == null) {
                return null;
            }
        }
        if ((repositoryPackageNameList = WekaPackageManager.getPackageList(false)) == null) {
            return null;
        }
        if (repositoryPackageNameList.keySet().size() != localPackageNameList.keySet().size()) {
            if (repositoryPackageNameList.keySet().size() < localPackageNameList.keySet().size()) {
                for (PrintStream p : progress) {
                    p.println("Some packages no longer exist at the repository. Refreshing cache...");
                }
            } else {
                for (PrintStream p : progress) {
                    p.println("There are new packages at the repository. Refreshing cache...");
                }
            }
            problem = WekaPackageManager.refreshCache(progress);
        } else {
            boolean refresh = false;
            for (String localPackage : localPackageNameList.keySet()) {
                String localVersion = localPackageNameList.get(localPackage);
                String repoVersion = repositoryPackageNameList.get(localPackage);
                if (repoVersion == null || localVersion.equals(repoVersion)) continue;
                refresh = true;
                break;
            }
            if (refresh) {
                for (PrintStream p : progress) {
                    p.println("There are newer versions of existing packages at the repository. Refreshing cache...");
                }
                problem = WekaPackageManager.refreshCache(progress);
            }
        }
        return problem;
    }

    protected static void cleanRepCacheDir() {
        File[] contents;
        String cacheDir = WEKA_HOME.toString() + File.separator + "repCache";
        File cacheDirF = new File(cacheDir);
        if (cacheDirF.exists() && (contents = cacheDirF.listFiles()) != null) {
            for (File f : contents) {
                File[] packageMetaDirContents;
                if (f.isDirectory() && (packageMetaDirContents = f.listFiles()) != null) {
                    for (File pf : packageMetaDirContents) {
                        pf.delete();
                    }
                }
                f.delete();
            }
        }
    }

    public static Exception refreshCache(PrintStream ... progress) {
        Exception problem = null;
        if (CACHE_URL == null) {
            return null;
        }
        PACKAGE_MANAGER.setPackageRepositoryURL(REP_URL);
        String cacheDir = WEKA_HOME.toString() + File.separator + "repCache";
        try {
            ZipEntry ze;
            for (PrintStream p : progress) {
                p.println("Refresh in progress. Please wait...");
            }
            byte[] zip = PACKAGE_MANAGER.getRepositoryPackageMetaDataOnlyAsZip(progress);
            WekaPackageManager.cleanRepCacheDir();
            ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(zip));
            byte[] buff = new byte[1024];
            while ((ze = zis.getNextEntry()) != null) {
                int amountRead;
                if (ze.isDirectory()) {
                    new File(cacheDir, ze.getName()).mkdir();
                    continue;
                }
                BufferedOutputStream bo = new BufferedOutputStream(new FileOutputStream(new File(cacheDir, ze.getName())));
                while ((amountRead = zis.read(buff)) != -1) {
                    bo.write(buff, 0, amountRead);
                }
                bo.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            CACHE_URL = null;
            try {
                DefaultPackageManager.deleteDir(new File(cacheDir), System.out);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            return e;
        }
        return problem;
    }

    public static boolean installedPackageResourceExists(String packageName, String resourceName) {
        String fullResourcePath = WekaPackageManager.getPackageHome().toString() + File.separator + packageName + File.separator + resourceName;
        return new File(fullResourcePath).exists();
    }

    private static void useCacheOrOnlineRepository() {
        if (REP_MIRROR == null) {
            WekaPackageManager.establishMirror();
        }
        if (CACHE_URL != null) {
            PACKAGE_MANAGER.setPackageRepositoryURL(CACHE_URL);
        } else if (REP_URL != null) {
            PACKAGE_MANAGER.setPackageRepositoryURL(REP_URL);
        }
    }

    public static File getPackageHome() {
        return PACKAGE_MANAGER.getPackageHome();
    }

    public static Package mostRecentVersionWithRespectToConstraint(PackageConstraint toCheck) throws Exception {
        Package target = toCheck.getPackage();
        Package result = null;
        List<Object> availableVersions = PACKAGE_MANAGER.getRepositoryPackageVersions(target.getName());
        for (Object version : availableVersions) {
            Package candidate = PACKAGE_MANAGER.getRepositoryPackageInfo(target.getName(), version);
            if (!toCheck.checkConstraint(candidate) || !candidate.isCompatibleBaseSystem()) continue;
            result = candidate;
            break;
        }
        if (result == null) {
            throw new Exception("[WekaPackageManager] unable to find a version of package " + target.getName() + " that meets constraint " + toCheck.toString());
        }
        return result;
    }

    public static boolean installPackages(List<Package> toInstall, PrintStream ... progress) throws Exception {
        WekaPackageManager.useCacheOrOnlineRepository();
        ArrayList<Boolean> upgrades = new ArrayList<Boolean>();
        for (Package p : toInstall) {
            if (p.isInstalled()) {
                upgrades.add(new Boolean(true));
                continue;
            }
            upgrades.add(new Boolean(false));
        }
        PACKAGE_MANAGER.installPackages(toInstall, progress);
        boolean atLeastOneUpgrade = false;
        ArrayList<File> gpcFiles = new ArrayList<File>();
        int i = 0;
        HashMap<String, List<String>> injectDependencies = new HashMap<String, List<String>>();
        for (Package p : toInstall) {
            boolean isAnUpgrade;
            if (isAnUpgrade = ((Boolean)upgrades.get(i++)).booleanValue()) {
                atLeastOneUpgrade = true;
            }
            String packageName = p.getName();
            File packageDir = new File(PACKAGE_MANAGER.getPackageHome().toString() + File.separator + packageName);
            WekaPackageManager.checkForInjectDependencies(p, injectDependencies);
            boolean loadIt = WekaPackageManager.loadCheck(p, packageDir, progress);
            if (!(loadIt & !isAnUpgrade)) continue;
            WekaPackageManager.processPackageDirectory(packageDir, false, gpcFiles, false);
        }
        WekaPackageManager.injectPackageDependencies(injectDependencies);
        WekaPackageClassLoaderManager.getWekaPackageClassLoaderManager().performIntegrityCheck();
        for (File f : gpcFiles) {
            WekaPackageManager.processGenericPropertiesCreatorProps(f);
        }
        return atLeastOneUpgrade;
    }

    public static List<Object> getRepositoryPackageVersions(String packageName) throws Exception {
        WekaPackageManager.useCacheOrOnlineRepository();
        return PACKAGE_MANAGER.getRepositoryPackageVersions(packageName);
    }

    public static URL getPackageRepositoryURL() {
        WekaPackageManager.useCacheOrOnlineRepository();
        return PACKAGE_MANAGER.getPackageRepositoryURL();
    }

    public static List<Package> getAllPackages() throws Exception {
        WekaPackageManager.useCacheOrOnlineRepository();
        return PACKAGE_MANAGER.getAllPackages(new PrintStream[0]);
    }

    public static List<Package> getAvailablePackages() throws Exception {
        WekaPackageManager.useCacheOrOnlineRepository();
        return PACKAGE_MANAGER.getAvailablePackages();
    }

    public static List<Package> getAvailableCompatiblePackages() throws Exception {
        List<Package> allAvail = WekaPackageManager.getAllPackages();
        ArrayList<Package> compatible = new ArrayList<Package>();
        block0: for (Package p : allAvail) {
            List<Object> availableVersions = PACKAGE_MANAGER.getRepositoryPackageVersions(p.getName());
            for (Object version : availableVersions) {
                Package versionedPackage = WekaPackageManager.getRepositoryPackageInfo(p.getName(), version.toString());
                if (!versionedPackage.isCompatibleBaseSystem()) continue;
                if (p.isInstalled()) {
                    Package installed = WekaPackageManager.getInstalledPackageInfo(p.getName());
                    String installedV = installed.getPackageMetaDataElement(VersionPackageConstraint.VERSION_KEY).toString();
                    String versionedV = versionedPackage.getPackageMetaDataElement(VersionPackageConstraint.VERSION_KEY).toString();
                    VersionPackageConstraint.VersionComparison v = VersionPackageConstraint.compare(versionedV, installedV);
                    if (v != VersionPackageConstraint.VersionComparison.GREATERTHAN) continue block0;
                    compatible.add(versionedPackage);
                    continue block0;
                }
                compatible.add(versionedPackage);
                continue block0;
            }
        }
        return compatible;
    }

    public static Package getLatestCompatibleVersion(String packageName) throws Exception {
        Package latest = null;
        List<Object> availableVersions = PACKAGE_MANAGER.getRepositoryPackageVersions(packageName);
        for (Object version : availableVersions) {
            Package versionedPackage = WekaPackageManager.getRepositoryPackageInfo(packageName, version.toString());
            if (!versionedPackage.isCompatibleBaseSystem()) continue;
            latest = versionedPackage;
            break;
        }
        return latest;
    }

    public static List<Package> getInstalledPackages() throws Exception {
        WekaPackageManager.useCacheOrOnlineRepository();
        return PACKAGE_MANAGER.getInstalledPackages();
    }

    public static List<Dependency> getAllDependenciesForPackage(Package target, Map<String, List<Dependency>> conflicts) throws Exception {
        WekaPackageManager.useCacheOrOnlineRepository();
        return PACKAGE_MANAGER.getAllDependenciesForPackage(target, conflicts);
    }

    public static Package getPackageArchiveInfo(String packageArchivePath) throws Exception {
        WekaPackageManager.useCacheOrOnlineRepository();
        return PACKAGE_MANAGER.getPackageArchiveInfo(packageArchivePath);
    }

    public static Package getInstalledPackageInfo(String packageName) throws Exception {
        WekaPackageManager.useCacheOrOnlineRepository();
        return PACKAGE_MANAGER.getInstalledPackageInfo(packageName);
    }

    public static Package getRepositoryPackageInfo(String packageName) throws Exception {
        WekaPackageManager.useCacheOrOnlineRepository();
        return PACKAGE_MANAGER.getRepositoryPackageInfo(packageName);
    }

    public static Package getRepositoryPackageInfo(String packageName, String version) throws Exception {
        WekaPackageManager.useCacheOrOnlineRepository();
        return PACKAGE_MANAGER.getRepositoryPackageInfo(packageName, version);
    }

    public static boolean installPackageFromRepository(String packageName, String version, PrintStream ... progress) throws Exception {
        WekaPackageManager.useCacheOrOnlineRepository();
        Package toLoad = WekaPackageManager.getRepositoryPackageInfo(packageName);
        boolean isAnUpgrade = toLoad.isInstalled();
        Object specialInstallMessage = toLoad.getPackageMetaDataElement(MESSAGE_TO_DISPLAY_ON_INSTALLATION_KEY);
        if (specialInstallMessage != null && specialInstallMessage.toString().length() > 0) {
            String siM = specialInstallMessage.toString();
            try {
                siM = Environment.getSystemWide().substitute(siM);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String message = "**** Special installation message ****\n" + siM + "\n**** Special installation message ****";
            for (PrintStream p : progress) {
                p.println(message);
            }
        }
        PACKAGE_MANAGER.installPackageFromRepository(packageName, version, progress);
        File packageDir = new File(PACKAGE_MANAGER.getPackageHome().toString() + File.separator + packageName);
        if (WekaPackageManager.loadCheck(WekaPackageManager.getInstalledPackageInfo(packageName), packageDir, progress)) {
            WekaPackageClassLoaderManager.getWekaPackageClassLoaderManager().addPackageToClassLoader(packageDir);
        }
        HashMap<String, List<String>> injectDependencies = new HashMap<String, List<String>>();
        WekaPackageManager.checkForInjectDependencies(toLoad, injectDependencies);
        WekaPackageManager.injectPackageDependencies(injectDependencies);
        WekaPackageClassLoaderManager.getWekaPackageClassLoaderManager().performIntegrityCheck();
        if (WekaPackageClassLoaderManager.getWekaPackageClassLoaderManager().getPackageClassLoader(packageName) != null) {
            WekaPackageManager.processPackageDirectory(packageDir, false, null, false);
        }
        return isAnUpgrade;
    }

    public static String installPackageFromArchive(String packageArchivePath, PrintStream ... progress) throws Exception {
        WekaPackageManager.useCacheOrOnlineRepository();
        Package toInstall = PACKAGE_MANAGER.getPackageArchiveInfo(packageArchivePath);
        Object specialInstallMessage = toInstall.getPackageMetaDataElement(MESSAGE_TO_DISPLAY_ON_INSTALLATION_KEY);
        if (specialInstallMessage != null && specialInstallMessage.toString().length() > 0) {
            String siM = specialInstallMessage.toString();
            try {
                siM = Environment.getSystemWide().substitute(siM);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String message = "**** Special installation message ****\n" + siM + "\n**** Special installation message ****";
            for (PrintStream p : progress) {
                p.println(message);
            }
        }
        PACKAGE_MANAGER.installPackageFromArchive(packageArchivePath, progress);
        return WekaPackageManager.initializeAndLoadUnofficialPackage(toInstall, progress);
    }

    private static String initializeAndLoadUnofficialPackage(Package toInstall, PrintStream ... progress) throws Exception {
        File packageDir = new File(PACKAGE_MANAGER.getPackageHome() + File.separator + toInstall.getName());
        Package toLoad = WekaPackageManager.getInstalledPackageInfo(toInstall.getName());
        WekaPackageClassLoaderManager.getWekaPackageClassLoaderManager().addPackageToClassLoader(packageDir);
        HashMap<String, List<String>> injectDependencies = new HashMap<String, List<String>>();
        WekaPackageManager.checkForInjectDependencies(toLoad, injectDependencies);
        WekaPackageManager.injectPackageDependencies(injectDependencies);
        WekaPackageClassLoaderManager.getWekaPackageClassLoaderManager().performIntegrityCheck();
        if (WekaPackageClassLoaderManager.getWekaPackageClassLoaderManager().getPackageClassLoader(toInstall.getName()) != null) {
            WekaPackageManager.processPackageDirectory(packageDir, false, null, false);
        }
        return toInstall.getName();
    }

    public static String installPackageFromURL(URL packageURL, PrintStream ... progress) throws Exception {
        WekaPackageManager.useCacheOrOnlineRepository();
        String packageName = PACKAGE_MANAGER.installPackageFromURL(packageURL, progress);
        Package installed = PACKAGE_MANAGER.getInstalledPackageInfo(packageName);
        Object specialInstallMessage = installed.getPackageMetaDataElement(MESSAGE_TO_DISPLAY_ON_INSTALLATION_KEY);
        if (specialInstallMessage != null && specialInstallMessage.toString().length() > 0) {
            String message = "**** Special installation message ****\n" + specialInstallMessage.toString() + "\n**** Special installation message ****";
            for (PrintStream p : progress) {
                p.println(message);
            }
        }
        return WekaPackageManager.initializeAndLoadUnofficialPackage(installed, progress);
    }

    public static void uninstallPackage(String packageName, boolean updateKnowledgeFlow, PrintStream ... progress) throws Exception {
        File packageToDel;
        if (updateKnowledgeFlow && (packageToDel = new File(PACKAGE_MANAGER.getPackageHome().toString() + File.separator + packageName)).exists() && packageToDel.isDirectory()) {
            File[] contents = packageToDel.listFiles();
            if (contents != null) {
                for (File content : contents) {
                    if (!content.isFile() || !content.getPath().endsWith("Beans.props")) continue;
                    KnowledgeFlowApp.removeFromPluginBeanProps(content);
                    KnowledgeFlowApp.disposeSingleton();
                    break;
                }
            }
            WekaPackageClassLoaderManager.getWekaPackageClassLoaderManager().removeClassLoaderForPackage(packageName);
        }
        PACKAGE_MANAGER.uninstallPackage(packageName, progress);
    }

    private static void printPackageInfo(Map<?, ?> packageProps) {
        Set<?> keys = packageProps.keySet();
        for (Object key : keys) {
            Object value = packageProps.get(key);
            System.out.println(Utils.padLeft(key.toString(), 11) + ":\t" + value.toString());
        }
    }

    protected static void printPackageArchiveInfo(String packagePath) throws Exception {
        Map<?, ?> packageProps = WekaPackageManager.getPackageArchiveInfo(packagePath).getPackageMetaData();
        WekaPackageManager.printPackageInfo(packageProps);
    }

    protected static void printInstalledPackageInfo(String packageName) throws Exception {
        Map<?, ?> packageProps = WekaPackageManager.getInstalledPackageInfo(packageName).getPackageMetaData();
        WekaPackageManager.printPackageInfo(packageProps);
    }

    protected static void printRepositoryPackageInfo(String packageName, String version) throws Exception {
        Map<?, ?> packageProps = WekaPackageManager.getRepositoryPackageInfo(packageName, version).getPackageMetaData();
        WekaPackageManager.printPackageInfo(packageProps);
    }

    private static String queryUser() {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String result = null;
        try {
            result = br.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private static void removeInstalledPackage(String packageName, boolean force, PrintStream ... progress) throws Exception {
        ArrayList<Package> compromised = new ArrayList<Package>();
        List<Package> installedPackages = null;
        if (!force) {
            installedPackages = WekaPackageManager.getInstalledPackages();
            block0: for (Package p : installedPackages) {
                List<Dependency> tempDeps = p.getDependencies();
                for (Dependency d : tempDeps) {
                    if (!d.getTarget().getPackage().getName().equals(packageName)) continue;
                    compromised.add(p);
                    continue block0;
                }
            }
            if (compromised.size() > 0) {
                System.out.println("The following installed packages depend on " + packageName + " :\n");
                for (Package p : compromised) {
                    System.out.println("\t" + p.getName());
                }
                System.out.println("\nDo you wish to proceed [y/n]?");
                String response = WekaPackageManager.queryUser();
                if (response != null && (response.equalsIgnoreCase("n") || response.equalsIgnoreCase("no"))) {
                    return;
                }
            }
        }
        if (force) {
            System.out.println("Forced uninstall.");
        }
        compromised = null;
        installedPackages = null;
        WekaPackageManager.uninstallPackage(packageName, false, progress);
    }

    private static void installPackageFromRepository(String packageName, String version, boolean force) throws Exception {
        if (version.equals("Latest")) {
            version = "none";
            List<Object> availableVersions = PACKAGE_MANAGER.getRepositoryPackageVersions(packageName);
            for (Object v : availableVersions) {
                Package versionedPackage = WekaPackageManager.getRepositoryPackageInfo(packageName, v.toString());
                if (!versionedPackage.isCompatibleBaseSystem()) continue;
                version = versionedPackage.getPackageMetaDataElement(VersionPackageConstraint.VERSION_KEY).toString();
                break;
            }
            if (version.equals("none")) {
                throw new Exception("Was unable to find a version of '" + packageName + "' that is compatible with Weka " + Version.VERSION);
            }
        }
        Package toInstall = null;
        try {
            toInstall = WekaPackageManager.getRepositoryPackageInfo(packageName, version);
        }
        catch (Exception ex) {
            System.err.println("[WekaPackageManager] Package " + packageName + " at version " + version + " doesn't seem to exist!");
            return;
        }
        if (!force) {
            String response;
            Object disabled = toInstall.getPackageMetaDataElement(DISABLE_KEY);
            if (disabled == null) {
                disabled = toInstall.getPackageMetaDataElement(DISABLED_KEY);
            }
            if (disabled != null && disabled.toString().equalsIgnoreCase("true")) {
                System.err.println("Can't install package " + packageName + " because it has been disabled at the repository.");
                return;
            }
            boolean ok = toInstall.isCompatibleBaseSystem();
            if (!ok) {
                List<Dependency> baseSysDep = toInstall.getBaseSystemDependency();
                StringBuffer depList = new StringBuffer();
                for (Dependency bd : baseSysDep) {
                    depList.append(bd.getTarget().toString() + " ");
                }
                System.err.println("Can't install package " + packageName + " because it requires " + depList.toString());
                return;
            }
            if (toInstall.isInstalled()) {
                String response2;
                Package installedVersion = WekaPackageManager.getInstalledPackageInfo(packageName);
                if (!toInstall.equals(installedVersion)) {
                    System.out.println("Package " + packageName + "[" + installedVersion + "] is already installed. Replace with " + toInstall + " [y/n]?");
                    response2 = WekaPackageManager.queryUser();
                    if (response2 != null && (response2.equalsIgnoreCase("n") || response2.equalsIgnoreCase("no"))) {
                        return;
                    }
                } else {
                    System.out.println("Package " + packageName + "[" + installedVersion + "] is already installed. Install again [y/n]?");
                    response2 = WekaPackageManager.queryUser();
                    if (response2 != null && (response2.equalsIgnoreCase("n") || response2.equalsIgnoreCase("no"))) {
                        return;
                    }
                }
            }
            HashMap<String, List<Dependency>> conflicts = new HashMap<String, List<Dependency>>();
            List<Dependency> dependencies = WekaPackageManager.getAllDependenciesForPackage(toInstall, conflicts);
            if (conflicts.size() > 0) {
                System.err.println("Package " + packageName + " requires the following packages:\n");
                for (Dependency d : dependencies) {
                    System.err.println("\t" + d);
                }
                System.err.println("\nThere are conflicting dependencies:\n");
                Set pNames = conflicts.keySet();
                for (String pName : pNames) {
                    System.err.println("Conflicts for " + pName);
                    List confsForPackage = (List)conflicts.get(pName);
                    for (Dependency problem : confsForPackage) {
                        System.err.println("\t" + problem);
                    }
                }
                System.err.println("Unable to continue with installation.");
                return;
            }
            ArrayList<PackageConstraint> needsUpgrade = new ArrayList<PackageConstraint>();
            ArrayList<Package> finalListToInstall = new ArrayList<Package>();
            for (Dependency toCheck : dependencies) {
                if (toCheck.getTarget().getPackage().isInstalled()) {
                    String toCheckName = toCheck.getTarget().getPackage().getPackageMetaDataElement("PackageName").toString();
                    Package installedVersion = PACKAGE_MANAGER.getInstalledPackageInfo(toCheckName);
                    if (toCheck.getTarget().checkConstraint(installedVersion)) continue;
                    needsUpgrade.add(toCheck.getTarget());
                    Package mostRecent = toCheck.getTarget().getPackage();
                    if (toCheck.getTarget() instanceof VersionPackageConstraint) {
                        mostRecent = WekaPackageManager.mostRecentVersionWithRespectToConstraint(toCheck.getTarget());
                    }
                    finalListToInstall.add(mostRecent);
                    continue;
                }
                Package mostRecent = toCheck.getTarget().getPackage();
                if (toCheck.getTarget() instanceof VersionPackageConstraint) {
                    mostRecent = WekaPackageManager.mostRecentVersionWithRespectToConstraint(toCheck.getTarget());
                }
                finalListToInstall.add(mostRecent);
            }
            if (toInstall.getPackageMetaDataElement(PRECLUDES_KEY) != null) {
                List<Package> installed = WekaPackageManager.getInstalledPackages();
                HashMap<String, Package> packageMap = new HashMap<String, Package>();
                for (Package p : installed) {
                    packageMap.put(p.getName(), p);
                }
                for (Package p : finalListToInstall) {
                    packageMap.put(p.getName(), p);
                }
                List<Package> precluded = toInstall.getPrecludedPackages(new ArrayList<Package>(packageMap.values()));
                if (precluded.size() > 0) {
                    ArrayList<Package> finalPrecluded = new ArrayList<Package>();
                    Set<String> doNotLoadList = WekaPackageManager.getDoNotLoadList();
                    for (Package p : precluded) {
                        if (doNotLoadList.contains(p.getName())) continue;
                        finalPrecluded.add(p);
                    }
                    if (finalPrecluded.size() > 0) {
                        System.out.println("\nPackage " + toInstall.getName() + " cannot be installed because it precludes the following packages:\n");
                        for (Package p : finalPrecluded) {
                            System.out.println("\n\t" + p.toString());
                        }
                        System.out.println("Either uninstall or disable these packages before continuing.");
                        return;
                    }
                }
            }
            if (needsUpgrade.size() > 0) {
                System.out.println("The following packages will be upgraded in order to install " + packageName);
                for (PackageConstraint tempC : needsUpgrade) {
                    System.out.println("\t" + tempC);
                }
                System.out.print("\nOK to continue [y/n]? > ");
                response = WekaPackageManager.queryUser();
                if (response != null && (response.equalsIgnoreCase("n") || response.equalsIgnoreCase("no"))) {
                    return;
                }
                boolean conflictsAfterUpgrade = false;
                List<Package> installed = WekaPackageManager.getInstalledPackages();
                ArrayList<Package> toUpgrade = new ArrayList<Package>();
                Iterator upI = needsUpgrade.iterator();
                while (upI.hasNext()) {
                    toUpgrade.add(((PackageConstraint)upI.next()).getPackage());
                }
                toUpgrade.add(toInstall);
                for (int i = 0; i < installed.size(); ++i) {
                    List<Dependency> problem;
                    Package tempP = installed.get(i);
                    String tempPName = tempP.getName();
                    boolean checkIt = true;
                    for (int j = 0; j < needsUpgrade.size(); ++j) {
                        if (!tempPName.equals(((PackageConstraint)needsUpgrade.get(j)).getPackage().getName())) continue;
                        checkIt = false;
                        break;
                    }
                    if (!checkIt || (problem = tempP.getIncompatibleDependencies(toUpgrade)).size() <= 0) continue;
                    conflictsAfterUpgrade = true;
                    System.err.println("Package " + tempP.getName() + " will have a compatibilityproblem with the following packages after upgrading them:");
                    Iterator<Dependency> dI = problem.iterator();
                    while (dI.hasNext()) {
                        System.err.println("\t" + dI.next().getTarget().getPackage());
                    }
                }
                if (conflictsAfterUpgrade) {
                    System.err.println("Unable to continue with installation.");
                    return;
                }
            }
            if (finalListToInstall.size() > 0) {
                System.out.println("To install " + packageName + " the following packages will be installed/upgraded:\n\n");
                Iterator i = finalListToInstall.iterator();
                while (i.hasNext()) {
                    System.out.println("\t" + i.next());
                }
                System.out.print("\nOK to proceed [y/n]? > ");
                response = WekaPackageManager.queryUser();
                if (response != null && (response.equalsIgnoreCase("n") || response.equalsIgnoreCase("no"))) {
                    return;
                }
            }
            WekaPackageManager.installPackages(finalListToInstall, System.out);
            WekaPackageManager.installPackageFromRepository(packageName, version, System.out);
        } else {
            WekaPackageManager.installPackageFromRepository(packageName, version, System.out);
        }
    }

    private static void listPackages(String arg) throws Exception {
        if (m_offline && (arg.equalsIgnoreCase("all") || arg.equalsIgnoreCase("available"))) {
            System.out.println("Running offline - unable to display available or all package information");
            return;
        }
        List<Package> packageList = null;
        WekaPackageManager.useCacheOrOnlineRepository();
        if (arg.equalsIgnoreCase("all")) {
            packageList = PACKAGE_MANAGER.getAllPackages(new PrintStream[0]);
        } else if (arg.equals("installed")) {
            packageList = PACKAGE_MANAGER.getInstalledPackages();
        } else if (arg.equals("available")) {
            packageList = PACKAGE_MANAGER.getAvailablePackages();
        } else {
            System.err.println("[WekaPackageManager] Unknown argument " + arg);
            WekaPackageManager.printUsage();
            return;
        }
        StringBuffer result = new StringBuffer();
        result.append("Installed\tRepository\tLoaded\tPackage\n");
        result.append("=========\t==========\t======\t=======\n");
        boolean userOptedNoLoad = false;
        for (Package p : packageList) {
            String installedV = "-----    ";
            String repositoryV = "-----     ";
            String loaded = "No";
            if (p.isInstalled()) {
                Package installedP = WekaPackageManager.getInstalledPackageInfo(p.getName());
                if (WekaPackageManager.loadCheck(installedP, new File(WekaPackageManager.getPackageHome().toString() + File.separator + p.getName()), new PrintStream[0])) {
                    loaded = "Yes";
                } else if (m_doNotLoadList.contains(installedP.getName())) {
                    loaded = "No*";
                    userOptedNoLoad = true;
                }
                installedV = installedP.getPackageMetaDataElement(VERSION_KEY).toString() + "    ";
                try {
                    if (!m_offline) {
                        Package repP = WekaPackageManager.getRepositoryPackageInfo(p.getName());
                        repositoryV = repP.getPackageMetaDataElement(VERSION_KEY).toString() + "     ";
                    }
                }
                catch (Exception exception) {}
            } else {
                repositoryV = p.getPackageMetaDataElement(VERSION_KEY).toString() + "     ";
            }
            String title = p.getPackageMetaDataElement("Title").toString();
            result.append(installedV + "\t" + repositoryV + "\t" + loaded + "\t" + p.getName() + ": " + title + "\n");
        }
        if (userOptedNoLoad) {
            result.append("* User flagged as no load\n");
        }
        System.out.println(result.toString());
    }

    private static void printUsage() {
        System.out.println("Usage: weka.core.WekaPackageManager [-offline] [option]");
        System.out.println("Options:\n\t-list-packages <all | installed | available>\n\t-package-info <repository | installed | archive> <packageName | packageZip>\n\t-install-package <packageName | packageZip | URL> [version]\n\t-uninstall-package packageName\n\t-toggle-load-status packageName [packageName packageName ...]\n\t-refresh-cache");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        Logger.log(Logger.Level.INFO, "Logging started");
        try {
            for (int i = 0; i < args.length; ++i) {
                if (!args[i].equals("-offline")) continue;
                m_offline = true;
                String[] temp = new String[args.length - 1];
                if (i > 0) {
                    System.arraycopy(args, 0, temp, 0, i);
                }
                System.arraycopy(args, i + 1, temp, i, args.length - (i + 1));
                args = temp;
            }
            WekaPackageManager.establishCacheIfNeeded(System.out);
            WekaPackageManager.checkForNewPackages(System.out);
            if (args.length == 0 || args[0].equalsIgnoreCase("-h") || args[0].equalsIgnoreCase("-help")) {
                WekaPackageManager.printUsage();
                return;
            }
            if (args[0].equals("-package-info")) {
                if (args.length < 3) {
                    WekaPackageManager.printUsage();
                    return;
                }
                if (args[1].equals("archive")) {
                    WekaPackageManager.printPackageArchiveInfo(args[2]);
                    return;
                }
                if (args[1].equals("installed")) {
                    WekaPackageManager.printInstalledPackageInfo(args[2]);
                    return;
                }
                if (!args[1].equals("repository")) {
                    System.err.println("[WekaPackageManager] Unknown argument " + args[2]);
                    WekaPackageManager.printUsage();
                    return;
                }
                String version = "Latest";
                if (args.length == 4) {
                    version = args[3];
                }
                try {
                    WekaPackageManager.printRepositoryPackageInfo(args[2], version);
                    return;
                }
                catch (Exception ex) {
                    System.out.println("[WekaPackageManager] Nothing known about package " + args[2] + " at the repository!");
                    return;
                }
            }
            if (args[0].equals("-install-package")) {
                String targetLowerCase = args[1].toLowerCase();
                if (targetLowerCase.startsWith("http://") || targetLowerCase.startsWith("https://")) {
                    URL packageURL = new URL(args[1]);
                    WekaPackageManager.installPackageFromURL(packageURL, System.out);
                    return;
                }
                if (targetLowerCase.endsWith(".zip")) {
                    WekaPackageManager.installPackageFromArchive(args[1], System.out);
                    return;
                }
                String version = "Latest";
                if (args.length == 3) {
                    version = args[2];
                }
                WekaPackageManager.installPackageFromRepository(args[1], version, false);
                return;
            }
            if (args[0].equals("-uninstall-package")) {
                if (args.length < 2) {
                    WekaPackageManager.printUsage();
                    return;
                }
                boolean force = false;
                if (args.length == 3 && args[2].equals("-force")) {
                    force = true;
                }
                WekaPackageManager.removeInstalledPackage(args[1], force, System.out);
                return;
            }
            if (args[0].equals("-list-packages")) {
                if (args.length < 2) {
                    WekaPackageManager.printUsage();
                    return;
                }
                WekaPackageManager.listPackages(args[1]);
                return;
            }
            if (args[0].equals("-toggle-load-status")) {
                if (args.length == 1) {
                    WekaPackageManager.printUsage();
                    return;
                }
                ArrayList<String> toToggle = new ArrayList<String>();
                int i = 1;
                while (true) {
                    if (i >= args.length) {
                        if (toToggle.size() < 1) return;
                        WekaPackageManager.toggleLoadStatus(toToggle);
                        return;
                    }
                    toToggle.add(args[i].trim());
                    ++i;
                }
            }
            if (args[0].equals("-refresh-cache")) {
                WekaPackageManager.refreshCache(System.out);
                return;
            }
            System.err.println("Unknown option: " + args[0]);
            WekaPackageManager.printUsage();
            return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        INITIAL_CACHE_BUILD_NEEDED = false;
        PACKAGE_LIST_FILENAME = PACKAGE_LIST_WITH_VERSION_FILE;
        PRIMARY_REPOSITORY = "http://weka.sourceforge.net/packageMetaData";
        USER_SET_REPO = false;
        PACKAGE_MANAGER_PROPS_FILE_NAME = "PackageManager.props";
        m_loadPackages = true;
        m_initialPackageLoadingInProcess = false;
        WekaPackageManager.establishWekaHome();
        WekaPackageClassLoaderManager.getWekaPackageClassLoaderManager().injectMTJCoreClasses();
    }
}

