/*
 * Decompiled with CFR 0.152.
 */
package weka.core.expressionlanguage.weka;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import weka.core.expressionlanguage.common.Primitives;
import weka.core.expressionlanguage.core.Node;
import weka.core.expressionlanguage.core.VariableDeclarations;
import weka.experiment.Stats;

public class StatsHelper
implements VariableDeclarations {
    private final Map<String, Node> variables = new HashMap<String, Node>();
    private Set<String> usedVariables = new HashSet<String>();
    private Stats stats;

    public StatsHelper() {
        this.variables.put("MAX", new Max());
        this.variables.put("MIN", new Min());
        this.variables.put("MEAN", new Mean());
        this.variables.put("SD", new StdDev());
        this.variables.put("COUNT", new Count());
        this.variables.put("SUM", new Sum());
        this.variables.put("SUMSQUARED", new SumSq());
    }

    public void setStats(Stats stats) {
        this.stats = stats;
    }

    public boolean used() {
        return this.usedVariables.isEmpty();
    }

    public boolean used(String name) {
        return this.usedVariables.contains(name);
    }

    @Override
    public boolean hasVariable(String name) {
        return this.variables.containsKey(name);
    }

    @Override
    public Node getVariable(String name) {
        if (this.variables.containsKey(name)) {
            this.usedVariables.add(name);
            return this.variables.get(name);
        }
        throw new RuntimeException("Variable '" + name + "' undefined!");
    }

    private class SumSq
    implements Primitives.DoubleExpression {
        private SumSq() {
        }

        @Override
        public double evaluate() {
            return ((StatsHelper)StatsHelper.this).stats.sumSq;
        }
    }

    private class Sum
    implements Primitives.DoubleExpression {
        private Sum() {
        }

        @Override
        public double evaluate() {
            return ((StatsHelper)StatsHelper.this).stats.sum;
        }
    }

    private class Count
    implements Primitives.DoubleExpression {
        private Count() {
        }

        @Override
        public double evaluate() {
            return ((StatsHelper)StatsHelper.this).stats.count;
        }
    }

    private class StdDev
    implements Primitives.DoubleExpression {
        private StdDev() {
        }

        @Override
        public double evaluate() {
            return ((StatsHelper)StatsHelper.this).stats.stdDev;
        }
    }

    private class Mean
    implements Primitives.DoubleExpression {
        private Mean() {
        }

        @Override
        public double evaluate() {
            return ((StatsHelper)StatsHelper.this).stats.mean;
        }
    }

    private class Min
    implements Primitives.DoubleExpression {
        private Min() {
        }

        @Override
        public double evaluate() {
            return ((StatsHelper)StatsHelper.this).stats.min;
        }
    }

    private class Max
    implements Primitives.DoubleExpression {
        private Max() {
        }

        @Override
        public double evaluate() {
            return ((StatsHelper)StatsHelper.this).stats.max;
        }
    }
}

