/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.UpdateableBatchProcessor;
import weka.classifiers.UpdateableClassifier;
import weka.core.Aggregateable;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.core.stemmers.NullStemmer;
import weka.core.stemmers.Stemmer;
import weka.core.stopwords.Null;
import weka.core.stopwords.StopwordsHandler;
import weka.core.tokenizers.Tokenizer;
import weka.core.tokenizers.WordTokenizer;

public class NaiveBayesMultinomialText
extends AbstractClassifier
implements UpdateableClassifier,
UpdateableBatchProcessor,
WeightedInstancesHandler,
Aggregateable<NaiveBayesMultinomialText> {
    private static final long serialVersionUID = 2139025532014821394L;
    protected Instances m_data;
    protected double[] m_probOfClass;
    protected double[] m_wordsPerClass;
    protected Map<Integer, LinkedHashMap<String, Count>> m_probOfWordGivenClass;
    protected transient LinkedHashMap<String, Count> m_inputVector;
    protected StopwordsHandler m_StopwordsHandler = new Null();
    protected Tokenizer m_tokenizer = new WordTokenizer();
    protected boolean m_lowercaseTokens;
    protected Stemmer m_stemmer = new NullStemmer();
    protected int m_periodicP = 0;
    protected double m_minWordP = 3.0;
    protected boolean m_wordFrequencies = false;
    protected boolean m_normalize = false;
    protected double m_norm = 1.0;
    protected double m_lnorm = 2.0;
    protected double m_leplace = 1.0;
    protected double m_t;
    protected int m_numModels = 0;

    public String globalInfo() {
        return "Multinomial naive bayes for text data. Operates directly (and only) on String attributes. Other types of input attributes are accepted but ignored during training and classification";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.STRING_ATTRIBUTES);
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.setMinimumNumberInstances(0);
        return result;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        int i;
        this.reset();
        this.getCapabilities().testWithFail(data);
        this.m_data = new Instances(data, 0);
        data = new Instances(data);
        this.m_wordsPerClass = new double[data.numClasses()];
        this.m_probOfClass = new double[data.numClasses()];
        this.m_probOfWordGivenClass = new HashMap<Integer, LinkedHashMap<String, Count>>();
        double laplace = 1.0;
        for (i = 0; i < data.numClasses(); ++i) {
            LinkedHashMap dict = new LinkedHashMap(10000 / data.numClasses());
            this.m_probOfWordGivenClass.put(i, dict);
            this.m_probOfClass[i] = laplace;
            this.m_wordsPerClass[i] = 0.0;
        }
        for (i = 0; i < data.numInstances(); ++i) {
            this.updateClassifier(data.instance(i));
        }
        if (data.numInstances() > 0) {
            this.pruneDictionary(true);
        }
    }

    @Override
    public void updateClassifier(Instance instance) throws Exception {
        this.updateClassifier(instance, true);
    }

    protected void updateClassifier(Instance instance, boolean updateDictionary) throws Exception {
        if (!instance.classIsMissing()) {
            int classIndex;
            int n = classIndex = (int)instance.classValue();
            this.m_probOfClass[n] = this.m_probOfClass[n] + instance.weight();
            this.tokenizeInstance(instance, updateDictionary);
            this.m_t += 1.0;
        }
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        this.tokenizeInstance(instance, false);
        double[] probOfClassGivenDoc = new double[this.m_data.numClasses()];
        double[] logDocGivenClass = new double[this.m_data.numClasses()];
        for (int i = 0; i < this.m_data.numClasses(); ++i) {
            boolean ok;
            String word;
            int n = i;
            logDocGivenClass[n] = logDocGivenClass[n] + Math.log(this.m_probOfClass[i]);
            LinkedHashMap<String, Count> dictForClass = this.m_probOfWordGivenClass.get(i);
            int allWords = 0;
            double iNorm = 0.0;
            double fv = 0.0;
            if (this.m_normalize) {
                for (Map.Entry<String, Count> feature : this.m_inputVector.entrySet()) {
                    word = feature.getKey();
                    Count c = feature.getValue();
                    ok = false;
                    for (int clss = 0; clss < this.m_data.numClasses(); ++clss) {
                        if (this.m_probOfWordGivenClass.get(clss).get(word) == null) continue;
                        ok = true;
                        break;
                    }
                    if (!ok) continue;
                    fv = this.m_wordFrequencies ? c.m_count : 1.0;
                    iNorm += Math.pow(Math.abs(fv), this.m_lnorm);
                }
                iNorm = Math.pow(iNorm, 1.0 / this.m_lnorm);
            }
            for (Map.Entry<String, Count> feature : this.m_inputVector.entrySet()) {
                double freq;
                word = feature.getKey();
                Count dictCount = dictForClass.get(word);
                ok = false;
                for (int clss = 0; clss < this.m_data.numClasses(); ++clss) {
                    if (this.m_probOfWordGivenClass.get(clss).get(word) == null) continue;
                    ok = true;
                    break;
                }
                if (!ok) continue;
                double d = freq = this.m_wordFrequencies ? feature.getValue().m_count : 1.0;
                if (this.m_normalize) {
                    freq *= this.m_norm / iNorm;
                }
                allWords = (int)((double)allWords + freq);
                if (dictCount != null) {
                    int n2 = i;
                    logDocGivenClass[n2] = logDocGivenClass[n2] + freq * Math.log(dictCount.m_count);
                    continue;
                }
                int n3 = i;
                logDocGivenClass[n3] = logDocGivenClass[n3] + freq * Math.log(this.m_leplace);
            }
            if (!(this.m_wordsPerClass[i] > 0.0)) continue;
            int n4 = i;
            logDocGivenClass[n4] = logDocGivenClass[n4] - (double)allWords * Math.log(this.m_wordsPerClass[i]);
        }
        double max = logDocGivenClass[Utils.maxIndex(logDocGivenClass)];
        for (int i = 0; i < this.m_data.numClasses(); ++i) {
            probOfClassGivenDoc[i] = Math.exp(logDocGivenClass[i] - max);
        }
        Utils.normalize(probOfClassGivenDoc);
        return probOfClassGivenDoc;
    }

    protected void tokenizeInstance(Instance instance, boolean updateDictionary) {
        if (this.m_inputVector == null) {
            this.m_inputVector = new LinkedHashMap();
        } else {
            this.m_inputVector.clear();
        }
        for (int i = 0; i < instance.numAttributes(); ++i) {
            if (!instance.attribute(i).isString() || instance.isMissing(i)) continue;
            this.m_tokenizer.tokenize(instance.stringValue(i));
            while (this.m_tokenizer.hasMoreElements()) {
                String word = this.m_tokenizer.nextElement();
                if (this.m_lowercaseTokens) {
                    word = word.toLowerCase();
                }
                if (this.m_StopwordsHandler.isStopword(word = this.m_stemmer.stem(word))) continue;
                Count docCount = this.m_inputVector.get(word);
                if (docCount == null) {
                    this.m_inputVector.put(word, new Count(instance.weight()));
                    continue;
                }
                docCount.m_count += instance.weight();
            }
        }
        if (updateDictionary) {
            int classValue = (int)instance.classValue();
            LinkedHashMap<String, Count> dictForClass = this.m_probOfWordGivenClass.get(classValue);
            double iNorm = 0.0;
            double fv = 0.0;
            if (this.m_normalize) {
                for (Count count : this.m_inputVector.values()) {
                    fv = this.m_wordFrequencies ? count.m_count : 1.0;
                    iNorm += Math.pow(Math.abs(fv), this.m_lnorm);
                }
                iNorm = Math.pow(iNorm, 1.0 / this.m_lnorm);
            }
            for (Map.Entry entry : this.m_inputVector.entrySet()) {
                double freq;
                String word = (String)entry.getKey();
                double d = freq = this.m_wordFrequencies ? ((Count)entry.getValue()).m_count : 1.0;
                if (this.m_normalize) {
                    freq *= this.m_norm / iNorm;
                }
                for (int i = 0; i < this.m_data.numClasses(); ++i) {
                    LinkedHashMap<String, Count> dict = this.m_probOfWordGivenClass.get(i);
                    if (dict.get(word) != null) continue;
                    dict.put(word, new Count(this.m_leplace));
                    int n = i;
                    this.m_wordsPerClass[n] = this.m_wordsPerClass[n] + this.m_leplace;
                }
                Count dictCount = dictForClass.get(word);
                dictCount.m_count += freq;
                int n = classValue;
                this.m_wordsPerClass[n] = this.m_wordsPerClass[n] + freq;
            }
            this.pruneDictionary(false);
        }
    }

    protected void pruneDictionary(boolean force) {
        if ((this.m_periodicP <= 0 || this.m_t % (double)this.m_periodicP > 0.0) && !force) {
            return;
        }
        Set<Integer> classesSet = this.m_probOfWordGivenClass.keySet();
        for (Integer classIndex : classesSet) {
            LinkedHashMap<String, Count> dictForClass = this.m_probOfWordGivenClass.get(classIndex);
            Iterator<Map.Entry<String, Count>> entries = dictForClass.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry<String, Count> entry = entries.next();
                if (!(entry.getValue().m_count < this.m_minWordP)) continue;
                int n = classIndex;
                this.m_wordsPerClass[n] = this.m_wordsPerClass[n] - entry.getValue().m_count;
                entries.remove();
            }
        }
    }

    public void reset() {
        this.m_t = 1.0;
        this.m_wordsPerClass = null;
        this.m_probOfWordGivenClass = null;
        this.m_probOfClass = null;
    }

    public void setStemmer(Stemmer value) {
        this.m_stemmer = value != null ? value : new NullStemmer();
    }

    public Stemmer getStemmer() {
        return this.m_stemmer;
    }

    public String stemmerTipText() {
        return "The stemming algorithm to use on the words.";
    }

    public void setTokenizer(Tokenizer value) {
        this.m_tokenizer = value;
    }

    public Tokenizer getTokenizer() {
        return this.m_tokenizer;
    }

    public String tokenizerTipText() {
        return "The tokenizing algorithm to use on the strings.";
    }

    public String useWordFrequenciesTipText() {
        return "Use word frequencies rather than binary bag of words representation";
    }

    public void setUseWordFrequencies(boolean u) {
        this.m_wordFrequencies = u;
    }

    public boolean getUseWordFrequencies() {
        return this.m_wordFrequencies;
    }

    public String lowercaseTokensTipText() {
        return "Whether to convert all tokens to lowercase";
    }

    public void setLowercaseTokens(boolean l) {
        this.m_lowercaseTokens = l;
    }

    public boolean getLowercaseTokens() {
        return this.m_lowercaseTokens;
    }

    public String periodicPruningTipText() {
        return "How often (number of instances) to prune the dictionary of low frequency terms. 0 means don't prune. Setting a positive integer n means prune after every n instances";
    }

    public void setPeriodicPruning(int p) {
        this.m_periodicP = p;
    }

    public int getPeriodicPruning() {
        return this.m_periodicP;
    }

    public String minWordFrequencyTipText() {
        return "Ignore any words that don't occur at least min frequency times in the training data. If periodic pruning is turned on, then the dictionary is pruned according to this value";
    }

    public void setMinWordFrequency(double minFreq) {
        this.m_minWordP = minFreq;
    }

    public double getMinWordFrequency() {
        return this.m_minWordP;
    }

    public String normalizeDocLengthTipText() {
        return "If true then document length is normalized according to the settings for norm and lnorm";
    }

    public void setNormalizeDocLength(boolean norm) {
        this.m_normalize = norm;
    }

    public boolean getNormalizeDocLength() {
        return this.m_normalize;
    }

    public String normTipText() {
        return "The norm of the instances after normalization.";
    }

    public double getNorm() {
        return this.m_norm;
    }

    public void setNorm(double newNorm) {
        this.m_norm = newNorm;
    }

    public String LNormTipText() {
        return "The LNorm to use for document length normalization.";
    }

    public double getLNorm() {
        return this.m_lnorm;
    }

    public void setLNorm(double newLNorm) {
        this.m_lnorm = newLNorm;
    }

    public void setStopwordsHandler(StopwordsHandler value) {
        this.m_StopwordsHandler = value != null ? value : new Null();
    }

    public StopwordsHandler getStopwordsHandler() {
        return this.m_StopwordsHandler;
    }

    public String stopwordsHandlerTipText() {
        return "The stopwords handler to use (Null means no stopwords are used).";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>();
        newVector.add(new Option("\tUse word frequencies instead of binary bag of words.", "W", 0, "-W"));
        newVector.add(new Option("\tHow often to prune the dictionary of low frequency words (default = 0, i.e. don't prune)", "P", 1, "-P <# instances>"));
        newVector.add(new Option("\tMinimum word frequency. Words with less than this frequence are ignored.\n\tIf periodic pruning is turned on then this is also used to determine which\n\twords to remove from the dictionary (default = 3).", "M", 1, "-M <double>"));
        newVector.addElement(new Option("\tNormalize document length (use in conjunction with -norm and -lnorm)", "normalize", 0, "-normalize"));
        newVector.addElement(new Option("\tSpecify the norm that each instance must have (default 1.0)", "norm", 1, "-norm <num>"));
        newVector.addElement(new Option("\tSpecify L-norm to use (default 2.0)", "lnorm", 1, "-lnorm <num>"));
        newVector.addElement(new Option("\tConvert all tokens to lowercase before adding to the dictionary.", "lowercase", 0, "-lowercase"));
        newVector.addElement(new Option("\tThe stopwords handler to use (default Null).", "-stopwords-handler", 1, "-stopwords-handler"));
        newVector.addElement(new Option("\tThe tokenizing algorihtm (classname plus parameters) to use.\n\t(default: " + WordTokenizer.class.getName() + ")", "tokenizer", 1, "-tokenizer <spec>"));
        newVector.addElement(new Option("\tThe stemmering algorihtm (classname plus parameters) to use.", "stemmer", 1, "-stemmer <spec>"));
        newVector.addAll(Collections.list(super.listOptions()));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String lnormFreqS;
        String minFreq;
        this.reset();
        super.setOptions(options);
        this.setUseWordFrequencies(Utils.getFlag("W", options));
        String pruneFreqS = Utils.getOption("P", options);
        if (pruneFreqS.length() > 0) {
            this.setPeriodicPruning(Integer.parseInt(pruneFreqS));
        }
        if ((minFreq = Utils.getOption("M", options)).length() > 0) {
            this.setMinWordFrequency(Double.parseDouble(minFreq));
        }
        this.setNormalizeDocLength(Utils.getFlag("normalize", options));
        String normFreqS = Utils.getOption("norm", options);
        if (normFreqS.length() > 0) {
            this.setNorm(Double.parseDouble(normFreqS));
        }
        if ((lnormFreqS = Utils.getOption("lnorm", options)).length() > 0) {
            this.setLNorm(Double.parseDouble(lnormFreqS));
        }
        this.setLowercaseTokens(Utils.getFlag("lowercase", options));
        String stemmerString = Utils.getOption("stemmer", options);
        if (stemmerString.length() == 0) {
            this.setStemmer(null);
        } else {
            String[] stemmerSpec = Utils.splitOptions(stemmerString);
            if (stemmerSpec.length == 0) {
                throw new Exception("Invalid stemmer specification string");
            }
            String stemmerName = stemmerSpec[0];
            stemmerSpec[0] = "";
            Stemmer stemmer = (Stemmer)Utils.forName(Class.forName("weka.core.stemmers.Stemmer"), stemmerName, stemmerSpec);
            this.setStemmer(stemmer);
        }
        String stopwordsHandlerString = Utils.getOption("stopwords-handler", options);
        if (stopwordsHandlerString.length() == 0) {
            this.setStopwordsHandler(null);
        } else {
            String[] stopwordsHandlerSpec = Utils.splitOptions(stopwordsHandlerString);
            if (stopwordsHandlerSpec.length == 0) {
                throw new Exception("Invalid StopwordsHandler specification string");
            }
            String stopwordsHandlerName = stopwordsHandlerSpec[0];
            stopwordsHandlerSpec[0] = "";
            StopwordsHandler stopwordsHandler = (StopwordsHandler)Utils.forName(Class.forName("weka.core.stopwords.StopwordsHandler"), stopwordsHandlerName, stopwordsHandlerSpec);
            this.setStopwordsHandler(stopwordsHandler);
        }
        String tokenizerString = Utils.getOption("tokenizer", options);
        if (tokenizerString.length() == 0) {
            this.setTokenizer(new WordTokenizer());
        } else {
            String[] tokenizerSpec = Utils.splitOptions(tokenizerString);
            if (tokenizerSpec.length == 0) {
                throw new Exception("Invalid tokenizer specification string");
            }
            String tokenizerName = tokenizerSpec[0];
            tokenizerSpec[0] = "";
            Tokenizer tokenizer = (Tokenizer)Utils.forName(Class.forName("weka.core.tokenizers.Tokenizer"), tokenizerName, tokenizerSpec);
            this.setTokenizer(tokenizer);
        }
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        String spec;
        ArrayList<String> options = new ArrayList<String>();
        if (this.getUseWordFrequencies()) {
            options.add("-W");
        }
        options.add("-P");
        options.add("" + this.getPeriodicPruning());
        options.add("-M");
        options.add("" + this.getMinWordFrequency());
        if (this.getNormalizeDocLength()) {
            options.add("-normalize");
        }
        options.add("-norm");
        options.add("" + this.getNorm());
        options.add("-lnorm");
        options.add("" + this.getLNorm());
        if (this.getLowercaseTokens()) {
            options.add("-lowercase");
        }
        if (this.getStopwordsHandler() != null) {
            options.add("-stopwords-handler");
            spec = this.getStopwordsHandler().getClass().getName();
            if (this.getStopwordsHandler() instanceof OptionHandler) {
                spec = spec + " " + Utils.joinOptions(((OptionHandler)((Object)this.getStopwordsHandler())).getOptions());
            }
            options.add(spec.trim());
        }
        options.add("-tokenizer");
        spec = this.getTokenizer().getClass().getName();
        if (this.getTokenizer() instanceof OptionHandler) {
            spec = spec + " " + Utils.joinOptions(this.getTokenizer().getOptions());
        }
        options.add(spec.trim());
        if (this.getStemmer() != null) {
            options.add("-stemmer");
            spec = this.getStemmer().getClass().getName();
            if (this.getStemmer() instanceof OptionHandler) {
                spec = spec + " " + Utils.joinOptions(((OptionHandler)((Object)this.getStemmer())).getOptions());
            }
            options.add(spec.trim());
        }
        Collections.addAll(options, super.getOptions());
        return options.toArray(new String[1]);
    }

    public String toString() {
        int i;
        if (this.m_probOfClass == null) {
            return "NaiveBayesMultinomialText: No model built yet.\n";
        }
        StringBuffer result = new StringBuffer();
        HashSet<String> master = new HashSet<String>();
        for (i = 0; i < this.m_data.numClasses(); ++i) {
            LinkedHashMap<String, Count> classDict = this.m_probOfWordGivenClass.get(i);
            for (String key : classDict.keySet()) {
                master.add(key);
            }
        }
        result.append("Dictionary size: " + master.size()).append("\n\n");
        result.append("The independent frequency of a class\n");
        result.append("--------------------------------------\n");
        for (i = 0; i < this.m_data.numClasses(); ++i) {
            result.append(this.m_data.classAttribute().value(i)).append("\t").append(Double.toString(this.m_probOfClass[i])).append("\n");
        }
        if (master.size() > 150000) {
            result.append("\nFrequency table ommitted due to size\n");
            return result.toString();
        }
        result.append("\nThe frequency of a word given the class\n");
        result.append("-----------------------------------------\n");
        for (i = 0; i < this.m_data.numClasses(); ++i) {
            result.append(Utils.padLeft(this.m_data.classAttribute().value(i), 11)).append("\t");
        }
        result.append("\n");
        for (String word : master) {
            for (int i2 = 0; i2 < this.m_data.numClasses(); ++i2) {
                LinkedHashMap<String, Count> classDict = this.m_probOfWordGivenClass.get(i2);
                Count c = classDict.get(word);
                if (c == null) {
                    result.append("<laplace=1>\t");
                    continue;
                }
                result.append(Utils.padLeft(Double.toString(c.m_count), 11)).append("\t");
            }
            result.append(word);
            result.append("\n");
        }
        return result.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 13279 $");
    }

    @Override
    public NaiveBayesMultinomialText aggregate(NaiveBayesMultinomialText toAggregate) throws Exception {
        if (this.m_numModels == Integer.MIN_VALUE) {
            throw new Exception("Can't aggregate further - model has already been aggregated and finalized");
        }
        if (this.m_probOfClass == null) {
            throw new Exception("No model built yet, can't aggregate");
        }
        if (!this.m_data.classAttribute().equals(toAggregate.m_data.classAttribute())) {
            throw new Exception("Can't aggregate - class attribute in data headers does not match: " + this.m_data.classAttribute().equalsMsg(toAggregate.m_data.classAttribute()));
        }
        for (int i = 0; i < this.m_probOfClass.length; ++i) {
            int n = i;
            this.m_probOfClass[n] = this.m_probOfClass[n] + (toAggregate.m_probOfClass[i] - 1.0);
            int n2 = i;
            this.m_wordsPerClass[n2] = this.m_wordsPerClass[n2] + toAggregate.m_wordsPerClass[i];
        }
        Map<Integer, LinkedHashMap<String, Count>> dicts = toAggregate.m_probOfWordGivenClass;
        for (Map.Entry<Integer, LinkedHashMap<String, Count>> currentClassDict : dicts.entrySet()) {
            LinkedHashMap<String, Count> masterDict = this.m_probOfWordGivenClass.get(currentClassDict.getKey());
            if (masterDict == null) {
                masterDict = new LinkedHashMap();
                this.m_probOfWordGivenClass.put(currentClassDict.getKey(), masterDict);
            }
            for (Map.Entry<String, Count> entry : currentClassDict.getValue().entrySet()) {
                Count masterCount = masterDict.get(entry.getKey());
                if (masterCount == null) {
                    masterCount = new Count(entry.getValue().m_count);
                    masterDict.put(entry.getKey(), masterCount);
                    continue;
                }
                masterCount.m_count += entry.getValue().m_count - 1.0;
            }
        }
        this.m_t += toAggregate.m_t;
        ++this.m_numModels;
        return this;
    }

    @Override
    public void finalizeAggregation() throws Exception {
        if (this.m_numModels == 0) {
            throw new Exception("Unable to finalize aggregation - haven't seen any models to aggregate");
        }
        if (this.m_periodicP > 0 && this.m_t > (double)this.m_periodicP) {
            this.pruneDictionary(true);
            this.m_t = 0.0;
        }
    }

    @Override
    public void batchFinished() throws Exception {
        this.pruneDictionary(true);
    }

    public static void main(String[] args) {
        NaiveBayesMultinomialText.runClassifier(new NaiveBayesMultinomialText(), args);
    }

    private static class Count
    implements Serializable {
        private static final long serialVersionUID = 2104201532017340967L;
        public double m_count;

        public Count(double c) {
            this.m_count = c;
        }
    }
}

