/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weka.core.Attribute;
import weka.core.Utils;
import weka.core.pmml.FieldMetaInfo;

public class TargetMetaInfo
extends FieldMetaInfo
implements Serializable {
    private static final long serialVersionUID = 863500462237904927L;
    protected double m_min = Double.NaN;
    protected double m_max = Double.NaN;
    protected double m_rescaleConstant = 0.0;
    protected double m_rescaleFactor = 1.0;
    protected String m_castInteger = "";
    protected double[] m_defaultValueOrPriorProbs;
    protected ArrayList<String> m_values = new ArrayList();
    protected ArrayList<String> m_displayValues = new ArrayList();

    protected TargetMetaInfo(Element target) throws Exception {
        super(target);
        NodeList vals;
        String cstI;
        String rsf;
        String rsc;
        String max;
        String min = target.getAttribute("min");
        if (min != null && min.length() > 0) {
            try {
                this.m_min = Double.parseDouble(min);
            }
            catch (IllegalArgumentException ex) {
                throw new Exception("[TargetMetaInfo] can't parse min value for target field " + this.m_fieldName);
            }
        }
        if ((max = target.getAttribute("max")) != null && max.length() > 0) {
            try {
                this.m_max = Double.parseDouble(max);
            }
            catch (IllegalArgumentException ex) {
                throw new Exception("[TargetMetaInfo] can't parse max value for target field " + this.m_fieldName);
            }
        }
        if ((rsc = target.getAttribute("rescaleConstant")) != null && rsc.length() > 0) {
            try {
                this.m_rescaleConstant = Double.parseDouble(rsc);
            }
            catch (IllegalArgumentException ex) {
                throw new Exception("[TargetMetaInfo] can't parse rescale constant value for target field " + this.m_fieldName);
            }
        }
        if ((rsf = target.getAttribute("rescaleFactor")) != null && rsf.length() > 0) {
            try {
                this.m_rescaleFactor = Double.parseDouble(rsf);
            }
            catch (IllegalArgumentException ex) {
                throw new Exception("[TargetMetaInfo] can't parse rescale factor value for target field " + this.m_fieldName);
            }
        }
        if ((cstI = target.getAttribute("castInteger")) != null && cstI.length() > 0) {
            this.m_castInteger = cstI;
        }
        if ((vals = target.getElementsByTagName("TargetValue")).getLength() > 0) {
            this.m_defaultValueOrPriorProbs = new double[vals.getLength()];
            for (int i = 0; i < vals.getLength(); ++i) {
                String defaultV;
                Node value = vals.item(i);
                if (value.getNodeType() != 1) continue;
                Element valueE = (Element)value;
                String valueName = valueE.getAttribute("value");
                if (valueName != null && valueName.length() > 0) {
                    if (this.m_optype != FieldMetaInfo.Optype.CATEGORICAL && this.m_optype != FieldMetaInfo.Optype.NONE) {
                        throw new Exception("[TargetMetaInfo] TargetValue element has categorical value but optype is not categorical!");
                    }
                    if (this.m_optype == FieldMetaInfo.Optype.NONE) {
                        this.m_optype = FieldMetaInfo.Optype.CATEGORICAL;
                    }
                    this.m_values.add(valueName);
                    String displayValue = valueE.getAttribute("displayValue");
                    if (displayValue != null && displayValue.length() > 0) {
                        this.m_displayValues.add(displayValue);
                    } else {
                        this.m_displayValues.add(valueName);
                    }
                    String prior = valueE.getAttribute("priorProbability");
                    if (prior != null && prior.length() > 0) {
                        try {
                            this.m_defaultValueOrPriorProbs[i] = Double.parseDouble(prior);
                            continue;
                        }
                        catch (IllegalArgumentException ex) {
                            throw new Exception("[TargetMetaInfo] Can't parse probability from TargetValue element.");
                        }
                    }
                    throw new Exception("[TargetMetaInfo] No prior probability defined for value " + valueName);
                }
                if (this.m_optype != FieldMetaInfo.Optype.CONTINUOUS && this.m_optype != FieldMetaInfo.Optype.NONE) {
                    throw new Exception("[TargetMetaInfo] TargetValue element has continuous value but optype is not continuous!");
                }
                if (this.m_optype == FieldMetaInfo.Optype.NONE) {
                    this.m_optype = FieldMetaInfo.Optype.CONTINUOUS;
                }
                if ((defaultV = valueE.getAttribute("defaultValue")) != null && defaultV.length() > 0) {
                    try {
                        this.m_defaultValueOrPriorProbs[i] = Double.parseDouble(defaultV);
                        continue;
                    }
                    catch (IllegalArgumentException ex) {
                        throw new Exception("[TargetMetaInfo] Can't parse default value from TargetValue element.");
                    }
                }
                throw new Exception("[TargetMetaInfo] No default value defined for target " + this.m_fieldName);
            }
        }
    }

    public double getPriorProbability(String value) throws Exception {
        if (this.m_defaultValueOrPriorProbs == null) {
            throw new Exception("[TargetMetaInfo] no TargetValues defined (getPriorProbability)");
        }
        double result = Double.NaN;
        boolean found = false;
        for (int i = 0; i < this.m_values.size(); ++i) {
            if (!value.equals(this.m_values.get(i))) continue;
            found = true;
            result = this.m_defaultValueOrPriorProbs[i];
            break;
        }
        if (!found) {
            throw new Exception("[TargetMetaInfo] couldn't find value " + value + "(getPriorProbability)");
        }
        return result;
    }

    public double getDefaultValue() throws Exception {
        if (this.m_defaultValueOrPriorProbs == null) {
            throw new Exception("[TargetMetaInfo] no TargetValues defined (getPriorProbability)");
        }
        return this.m_defaultValueOrPriorProbs[0];
    }

    public ArrayList<String> getValues() {
        return new ArrayList<String>(this.m_values);
    }

    public double applyMinMaxRescaleCast(double prediction) throws Exception {
        if (this.m_optype != FieldMetaInfo.Optype.CONTINUOUS) {
            throw new Exception("[TargetMetaInfo] target must be continuous!");
        }
        if (!Utils.isMissingValue(this.m_min) && prediction < this.m_min) {
            prediction = this.m_min;
        }
        if (!Utils.isMissingValue(this.m_max) && prediction > this.m_max) {
            prediction = this.m_max;
        }
        prediction *= this.m_rescaleFactor;
        prediction += this.m_rescaleConstant;
        if (this.m_castInteger.length() > 0) {
            if (this.m_castInteger.equals("round")) {
                prediction = Math.round(prediction);
            } else if (this.m_castInteger.equals("ceiling")) {
                prediction = Math.ceil(prediction);
            } else if (this.m_castInteger.equals("floor")) {
                prediction = Math.floor(prediction);
            } else {
                throw new Exception("[TargetMetaInfo] unknown castInteger value " + this.m_castInteger);
            }
        }
        return prediction;
    }

    @Override
    public Attribute getFieldAsAttribute() {
        if (this.m_optype == FieldMetaInfo.Optype.CONTINUOUS) {
            return new Attribute(this.m_fieldName);
        }
        if (this.m_values.size() == 0) {
            return new Attribute(this.m_fieldName, (List<String>)null);
        }
        ArrayList<String> values = new ArrayList<String>();
        for (String val : this.m_values) {
            values.add(val);
        }
        return new Attribute(this.m_fieldName, values);
    }
}

