% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_vers.R
\name{p_vers}
\alias{p_vers}
\alias{p_vers_deps}
\title{Package Version and Number of Dependencies}
\usage{
p_vers(..., char = NULL, ndeps = TRUE, split = FALSE, reserved = "")

p_vers_deps(..., char = NULL, ndeps = TRUE, subset = "compare < 4",
  crandb = get("crandb", envir = .GlobalEnv))
}
\arguments{
\item{...}{any format recognized by \code{\link{cnsc}}.
A (list of) vector of packages for \code{p_vers}.
A vector of packages for \code{p_vers_deps}}

\item{char}{(name to) a character vector. Use this argument if \code{...}
fails or if you call the function from another function.
If used, argument \code{...} is ignored.}

\item{ndeps}{logical. Calculate the number of recursive dependencies.
\code{crandb} in \code{.GlobalEnv} is required for this option.}

\item{split}{logical. Split the output in a list of data.frame with 
packages allocated in at most 6 sections : 
library, reserved, nsloaded, cran, source, binary.}

\item{reserved}{character. The packages in the reserved section.}

\item{subset}{character. Subset the output data.frame on some columns.
The default \code{"compare < 4"} does not subset. Usual values
are \code{"compare < 0"} or \code{"compare < 0 && nsloaded == TRUE"}}

\item{crandb}{data.frame \code{crandb}. The data.frame of CRAN packages.}
}
\description{
The information displayed by \code{p_vers} depends on the availability of
\code{crandb} and \code{binarydb} in \code{.GlobalEnv}.

If \code{crandb} is not loaded in \code{.GlobalEnv}, \code{p_vers} returns a
data.frame with two columns: first column \code{nsloaded} (TRUE/FALSE) detects
(with \code{base::isNamespaceLoaded}) if the package namespaces are loaded.
Second column \code{version} is the version number of the installed packages.

If \code{crandb} is loaded in \code{.GlobalEnv}, three columns are added.
Column \code{crandb} displays the version number of the source packages recorded
in the \code{crandb} file. Column \code{gcc} displays the nedd for a compilation.
Column \code{compare} compares this version number with the version installed
on the computer. Possible values are:
-2 for a package not installed on the computer (NA) but available in crandb ;
-1 for an installed package older than the source package available in CRAN ;
 0 for an installed package with the same version number than CRAN ;
+1 for a more recent package than the one available in CRAN ;
+2 for a package installed on the computer and not available in CRAN (NA) ;
+3 for a package not installed on the computer (NA) and not available in CRAN (NA).

If \code{binarydb} is loaded in \code{.GlobalEnv}, two or three columns are added.
Column \code{binary} displays the version number of the binary packages recorded
in the \code{binarydb = available.packages, type = "binary")} matrix.
Column \code{difvb} compares the installed version on the computer with this
binary version and column \code{difbc} compares (if crandb is in \code{.GlobalEnv})
the binary version with the source package available in CRAN (which can differ
for recently updated packages, a matter of 1 to 3 days).
The numbering is identical to the one used for \code{crandb}.

If \code{ndeps = TRUE}, two more columns are added with the number
of recursive dependencies per package. Column \code{tdeps} includes the base
and recommended packages. Column \code{ndeps} does not count them. This option
can take some time. Set it to \code{FALSE} if you need speed.

\code{p_vers_deps} calculates the same information but includes the recursive
dependencies. Subsetting by \code{"compare < 0"} returns a shorter data.frame
with the uninstalled (-2) and the outdated (-1) packages. Packages marked with
\code{nsloaded = TRUE} must be detached and unloaded before any reinstallation.
Using this instruction before running \code{install.packages} or \code{p_inst}
is very useful as it detects packages that are locked and cannot be reinstalled.
The order provided by \code{p_vers_deps} is the best one for the reinstallation
of outdated packages.
}
\examples{
pkgs <- cnsc(RWsearch, MASS, Matrix, NotAPkg, R)
p_vers(pkgs)

## Now with crandb and binarydb loaded in .GlobalEnv. In real life, use:
## crandb_down() ; binarydb_down()
crandb_load(system.file("data", "zcrandb.rda", package = "RWsearch"))
binarydb_load(system.file("data", "zbinarydb.rda", package = "RWsearch"))

p_vers(pkgs)
p_vers(p_deps(pkgs))
p_vers_deps(pkgs)    # Dependencies can be visualized with p_graphF(pkgs)
p_vers(char=c(p_depsrec(RWsearch)$RWsearch, "RWsearch"), split = TRUE)

}
