% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grabMzmlFunctions.R
\name{grabMzmlMS2}
\alias{grabMzmlMS2}
\title{Extract the MS2 data from an mzML nodeset}
\usage{
grabMzmlMS2(xml_data, rtrange, file_metadata)
}
\arguments{
\item{xml_data}{An `xml2` nodeset, usually created by applying `read_xml` to
an mzML file.}

\item{rtrange}{A vector of length 2 containing an upper and lower bound on
retention times of interest. Providing a range here can speed up load times
(although not enormously, as the entire file must still be read) and reduce
the final object's size.}

\item{file_metadata}{Information about the file used to decode the binary
arrays containing m/z and intensity information.}
}
\value{
A `data.table` with columns for retention time (rt),  precursor m/z
  (mz), fragment m/z (fragmz), collision energy (voltage), and intensity
  (int).
}
\description{
Extract the MS2 data from an mzML nodeset
}
