% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RaceID.R
\name{clustdiffgenes}
\alias{clustdiffgenes}
\title{Inference of differentially expressed genes in a cluster}
\usage{
clustdiffgenes(object, cl, pvalue = 0.01)
}
\arguments{
\item{object}{\code{SCseq} class object.}

\item{cl}{A valid cluster number from the final cluster partition stored in the \code{cpart} slot of the \code{SCseq} object.}

\item{pvalue}{Positive real number smaller than one. This is the p-value cutoff for the inference of differential gene expression. Default is 0.01.}
}
\value{
A data.frame of differentially expressed genes ordered by p-value in increasing order, with four columns:
  \item{mean.ncl}{mean expression across cells outside of cluster \code{cl}.}
  \item{mean.cl}{mean expression across cells within cluster \code{cl}.}
  \item{fc}{fold-change of mean expression in cluster \code{cl} versus the remaining cells.}
  \item{pv}{inferred p-value for differential expression.}
  \item{padj}{Benjamini-Hochberg corrected FDR.}
}
\description{
This functions computes differentially expressed genes in a cluster by comparing to all remaining cells outside of the cluster based on a negative binomial
model of gene expression
}
\examples{
sc <- SCseq(intestinalDataSmall)
sc <- filterdata(sc)
sc <- compdist(sc)
sc <- clustexp(sc)
sc <- findoutliers(sc)
x <- clustdiffgenes(sc,1)
head(x[x$fc>1,])
}
