% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RaceID.R
\name{plotdiffgenes}
\alias{plotdiffgenes}
\title{Barplot of differentially expressed genes}
\usage{
plotdiffgenes(z, gene)
}
\arguments{
\item{z}{Output of \code{diffgenes}}

\item{gene}{Valid gene name. Has to correspond to one of the rownames of the \code{ndata} slot of the \code{SCseq} object.}
}
\value{
None
}
\description{
This functions produces a barplot of differentially expressed genes derived by the function \code{diffgenes}
}
\examples{
sc <- SCseq(intestinalDataSmall)
sc <- filterdata(sc)
sc <- compdist(sc)
sc <- clustexp(sc)
sc <- findoutliers(sc)
x <- diffgenes(sc,1,2)
head(x$z)
plotdiffgenes(x,names(x$z)[1])
}
