% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RaceID.R
\name{rfcorrect}
\alias{rfcorrect}
\title{Random Forests-based Reclassification}
\usage{
rfcorrect(
  object,
  rfseed = 12345,
  nbtree = NULL,
  final = TRUE,
  nbfactor = 5,
  ...
)
}
\arguments{
\item{object}{\code{SCseq} class object.}

\item{rfseed}{Seed for enforcing reproducible results. Default is 12345.}

\item{nbtree}{Number of trees to be built. Default is \code{NULL} and the number of tree is given by the number of cells times \code{nbfactor}.}

\item{final}{logical. If \code{TRUE}, then reclassification of cell types using out-of-bag analysis is performed based on the final clusters
after outlier identification. If \code{FALSE}, then the cluster partition prior to outlier idenitifcation is used for reclassification.}

\item{nbfactor}{Positive integer number. See \code{nbtree}.}

\item{...}{additional input arguments to the \code{randomForest} function of the \pkg{randomForest} package.}
}
\value{
The function returns an updated \code{SCseq} object with random forests votes written to slot \code{out$rfvotes}. The clustering
partition prior or post outlier identification (slot \code{cluster$kpart} or \code{cpart}, if parameter \code{final} equals \code{FALSE}
or \code{TRUE}, respectively) is overwritten with the partition derived from  the reclassification.
}
\description{
This functions applies random forests-based reclassification of cell clusters to enhance robustness of the final clusters.
}
\examples{
sc <- SCseq(intestinalDataSmall)
sc <- filterdata(sc)
sc <- compdist(sc)
sc <- clustexp(sc)
sc <- findoutliers(sc)
sc <- rfcorrect(sc)
}
