% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bubbleRadviz.R
\name{bubbleRadviz}
\alias{bubbleRadviz}
\title{A Plotting Function for the Radviz Object}
\usage{
bubbleRadviz(
  x,
  main = NULL,
  group = NULL,
  color = NULL,
  size = c(3, 16),
  label.color,
  label.size,
  bubble.color,
  bubble.fg,
  bubble.size,
  scale,
  decreasing,
  add
)
}
\arguments{
\item{x}{a radviz object as produced by do.radviz}

\item{main}{[Optional] a title to the graph, displayed on top}

\item{group}{the name of the grouping variable used to aggregate the data}

\item{color}{[Optional] the name of the variable used to color the points}

\item{size}{the size range for the plot}

\item{label.color}{deprecated, see \code{\link{do.radviz}}}

\item{label.size}{deprecated, see \code{\link{do.radviz}}}

\item{bubble.color}{deprecated, use \code{\link{geom_point}} instead}

\item{bubble.fg}{deprecated, use \code{\link{geom_point}} instead}

\item{bubble.size}{deprecated, use \code{\link{geom_point}} instead}

\item{scale}{deprecated, use \code{\link{geom_point}} instead}

\item{decreasing}{deprecated, use \code{\link{geom_point}} instead}

\item{add}{deprecated, use \code{\link{geom_point}} instead}
}
\value{
the internal ggplot2 object plus added layers, allowing for extra geoms to be added
}
\description{
Plots the Dimensional Anchors and projected data points in a 2D space.
}
\details{
This function allows for the projection of clusters in Radviz (for example results of
           the SPADE algorithm), where the cluster size is derived from the number of events
           that fall into a specific cluster.
         If color is not specified the grouping variable is used.
}
\examples{
data(iris)
das <- c('Sepal.Length','Sepal.Width','Petal.Length','Petal.Width')
S <- make.S(das)
rv <- do.radviz(iris,S)
bubbleRadviz(rv, group='Species')

}
\author{
Yann Abraham
}
